/*
 * Decompiled with CFR 0.152.
 */
package view;

import blue.bExplore;
import java.util.Vector;
import model.FileObject;
import model.FolderObject;
import model.LocalFileHandler;
import model.ModelBTDownloadLocalFolder;
import model.ModelFile;
import model.Preference;
import model.UIFsm;
import view.BWAlert;
import view.Icon;
import view.RowItem;
import view.TabItem;

public class BTDownloadLocalFolderItem
extends TabItem {
    Preference prefs = Preference.getInstance();
    private Vector fileObjects;

    public BTDownloadLocalFolderItem(int width, int height, String formName) {
        super(width, height);
        this.formName = formName;
    }

    public void update(Vector fileObjects) {
        this.fileObjects = fileObjects;
        this.rowItems.removeAllElements();
        String path = LocalFileHandler.getCurrentFolder().getFullPath();
        this.formName = "Save to: " + path;
        int i = 0;
        while (i < fileObjects.size()) {
            RowItem rowItem = new RowItem(1);
            FileObject fo = (FileObject)fileObjects.elementAt(i);
            String name = fo.getName();
            rowItem.setItems(0, name, bExplore.plainFont.stringWidth(name));
            if (fo.isFolder()) {
                if (fo.getName().equals("..")) {
                    rowItem.setIcon(Icon.UP);
                } else {
                    rowItem.setIcon(Icon.FOLDER);
                }
            } else {
                rowItem.setIcon(Icon.FILE);
            }
            if (!fo.isFolder() && fo.isChecked()) {
                rowItem.setChecked(true);
            }
            this.rowItems.addElement(rowItem);
            ++i;
        }
    }

    public void fire() {
        if (this.focusIndex < 0 || this.fileObjects == null || this.focusIndex >= this.fileObjects.size()) {
            return;
        }
        FileObject fo = (FileObject)this.fileObjects.elementAt(this.focusIndex);
        String name = fo.getName();
        if (fo.isFolder()) {
            UIFsm fsm = BTDownloadLocalFolderItem.selectedTabForm.midlet.getUIFsm();
            FolderObject folder = null;
            folder = name.equals("..") ? LocalFileHandler.cd(name) : LocalFileHandler.cd(String.valueOf(LocalFileHandler.getCurrentFolder().getFullPath()) + name);
            if (folder != null) {
                ModelBTDownloadLocalFolder model = (ModelBTDownloadLocalFolder)fsm.getModel("BTDownloadLocalFolder");
                model.update(folder.getFileObjectList());
                ModelFile model1 = (ModelFile)fsm.getModel("File");
                model1.fileObjectUpdate(folder.getFileObjectList());
                fsm.inEvent("enter_bt_download_local_folder");
            } else {
                BWAlert.errorAlert("change folder failed!");
            }
        }
    }
}

