/*
 * Decompiled with CFR 0.152.
 */
package view;

import blue.bExplore;
import model.FileObject;
import model.ModelBTDownloadFolderProgress;
import view.Icon;
import view.RowItem;
import view.TabItem;

public class BTDownloadFileItem
extends TabItem {
    FileObject[] fileObjects;
    String remoteFolder = null;

    public BTDownloadFileItem(int width, int height, String formName) {
        super(width, height);
        this.formName = formName;
    }

    public void setLabel(String label) {
        this.formName = label;
    }

    public void update(FileObject[] fileObjects) {
        this.fileObjects = fileObjects;
        this.rowItems.removeAllElements();
        int i = 0;
        while (i < fileObjects.length) {
            RowItem rowItem = new RowItem(1);
            String name = fileObjects[i].getName();
            rowItem.setItems(0, name, bExplore.plainFont.stringWidth(name));
            if (fileObjects[i].isFolder()) {
                if (fileObjects[i].getName().equals("..")) {
                    rowItem.setIcon(Icon.UP);
                } else {
                    rowItem.setIcon(Icon.FOLDER);
                }
            } else {
                rowItem.setIcon(Icon.FILE);
            }
            if (!fileObjects[i].isFolder() && fileObjects[i].isChecked()) {
                rowItem.setChecked(true);
            }
            this.rowItems.addElement(rowItem);
            ++i;
        }
    }

    public void fire() {
        if (this.focusIndex < 0 || this.fileObjects == null || this.focusIndex >= this.fileObjects.length) {
            return;
        }
        bExplore midlet = bExplore.getInstance();
        FileObject fobj = this.fileObjects[this.focusIndex];
        if (fobj.isFolder()) {
            ModelBTDownloadFolderProgress model = (ModelBTDownloadFolderProgress)midlet.getUIFsm().getModel("BTDownloadFolderProgress");
            model.pushPath(fobj.getName());
            midlet.getUIFsm().outEvent("enter_bt_download_folder_progress");
        }
    }

    public void check() {
        if (this.focusIndex < 0) {
            return;
        }
        RowItem rowItem = (RowItem)this.rowItems.elementAt(this.focusIndex);
        if (this.fileObjects[this.focusIndex].isChecked()) {
            this.fileObjects[this.focusIndex].setChecked(false);
            rowItem.setChecked(false);
        } else {
            this.fileObjects[this.focusIndex].setChecked(true);
            rowItem.setChecked(true);
        }
        this.repaint();
    }

    public String getSelectedFileName() {
        if (this.focusIndex < 0) {
            return null;
        }
        return this.fileObjects[this.focusIndex].getName();
    }

    public FileObject[] getFileObjects() {
        return this.fileObjects;
    }

    public String getRemoteFolder() {
        return this.remoteFolder;
    }

    public void clearChecked() {
        int i = 0;
        while (i < this.fileObjects.length) {
            RowItem rowItem = (RowItem)this.rowItems.elementAt(i);
            this.fileObjects[i].setChecked(false);
            rowItem.setChecked(false);
            ++i;
        }
    }
}

