/*
 * Decompiled with CFR 0.152.
 */
package view;

import blue.bExplore;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import local.Local;
import model.FileObject;
import model.LocalFileHandler;
import model.ModelBTDownloadFile;
import model.ModelBTDownloadFolderProgress;
import model.ModelBTDownloadLocalFolder;
import model.UIFsm;
import view.BTDownloadFileItem;
import view.BWAlert;
import view.TabForm;

public class BTDownloadFileForm
extends TabForm {
    protected BTDownloadFileItem btDownloadFileItem;
    Command downloadCmd = new Command(Local.get("download"), 1, 2);
    Command refreshCmd = new Command(Local.get("refresh"), 1, 3);
    Command backCmd = new Command(Local.get("back"), 2, 1);

    public BTDownloadFileForm(bExplore midlet, String formName) {
        super(midlet, false);
        this.btDownloadFileItem = new BTDownloadFileItem(this.width, this.height, formName);
        this.form.append((Item)this.btDownloadFileItem);
        this.form.addCommand(this.downloadCmd);
        this.form.addCommand(this.refreshCmd);
        this.form.addCommand(this.backCmd);
    }

    public void commandAction(Command cmd, Displayable disp) {
        super.commandAction(cmd, disp);
        if (cmd == this.backCmd) {
            ModelBTDownloadFile model = (ModelBTDownloadFile)this.midlet.getUIFsm().getModel("BTDownloadFile");
            model.onLeave();
            this.midlet.getUIFsm().outEvent("enter_neighbor");
        } else if (cmd == this.refreshCmd) {
            ModelBTDownloadFolderProgress model = (ModelBTDownloadFolderProgress)this.midlet.getUIFsm().getModel("BTDownloadFolderProgress");
            model.setRefresh(true);
            this.midlet.getUIFsm().outEvent("enter_bt_download_folder_progress");
        } else if (cmd == this.downloadCmd) {
            FileObject[] fileObjects = this.btDownloadFileItem.getFileObjects();
            String fileName = this.btDownloadFileItem.getSelectedFileName();
            Vector<FileObject> remoteFiles = new Vector<FileObject>();
            int i = 0;
            while (i < fileObjects.length) {
                if (fileName != null && fileObjects[i].getName().equals(fileName)) {
                    fileObjects[i].setChecked(true);
                    fileName = null;
                }
                if (fileObjects[i].isChecked()) {
                    remoteFiles.addElement(fileObjects[i]);
                }
                ++i;
            }
            this.btDownloadFileItem.clearChecked();
            if (remoteFiles.size() == 0) {
                BWAlert.errorAlert("Please select at least one file.");
            } else {
                UIFsm fsm = this.midlet.getUIFsm();
                ModelBTDownloadLocalFolder model = (ModelBTDownloadLocalFolder)fsm.getModel("BTDownloadLocalFolder");
                ModelBTDownloadFolderProgress model1 = (ModelBTDownloadFolderProgress)fsm.getModel("BTDownloadFolderProgress");
                model.setRemoteFiles(remoteFiles);
                model.setRemoteFolder(model1.getFullPath());
                model.update(LocalFileHandler.getCurrentFolder().getFileObjectList());
                fsm.outEvent("enter_bt_download_local_folder");
            }
        }
    }

    public void update(FileObject[] fileObjects) {
        this.btDownloadFileItem.update(fileObjects);
    }

    public BTDownloadFileItem getBtDownloadFileItem() {
        return this.btDownloadFileItem;
    }
}

