/*
 * Decompiled with CFR 0.152.
 */
package model;

import blue.bExplore;
import helper.fsm.Fsm;
import helper.fsm.State;
import java.util.Hashtable;
import model.BTNeighborSearch;
import model.Model;
import model.ModelBTDownloadConnectProgress;
import model.ModelBTDownloadFile;
import model.ModelBTDownloadFileProgress;
import model.ModelBTDownloadFolderProgress;
import model.ModelBTDownloadLocalFolder;
import model.ModelBTDownloadProgress;
import model.ModelBTPush;
import model.ModelBTPushConnectProgress;
import model.ModelBTPushFileProgress;
import model.ModelBTPushProgress;
import model.ModelFile;
import model.ModelHelp;
import model.ModelNeighbor;
import view.ExitAlert;

public class UIFsm
extends Fsm {
    Hashtable models;
    bExplore midlet;

    public UIFsm(bExplore midlet) {
        this.midlet = midlet;
        this.models = new Hashtable();
        Hashtable<String, State> states = new Hashtable<String, State>();
        State startState = new State();
        State terminateState = new State();
        State neighborState = new State();
        State fileState = new State();
        State helpState = new State();
        State btNeighborProState = new State();
        State btDownloadConnectProgressState = new State();
        State btDownloadFileState = new State();
        State btDownloadFolderProgressState = new State();
        State btDownloadFileProgressState = new State();
        State btDownloadLocalFolderState = new State();
        State btPushState = new State();
        State btPushProgressState = new State();
        State btPushConnectProgressState = new State();
        State btPushFileProgressState = new State();
        startState.setName("Start");
        startState.addAction(State.ON_EXIT, "Leave", null, 2);
        startState.addTransition("enter_neighbor_progress", btNeighborProState);
        startState.addTransition("enter_neighbor", neighborState);
        states.put("Start", startState);
        terminateState.setName("Terminate");
        terminateState.addAction(State.ON_ENTER, "Enter", null, 5);
        terminateState.addAction(State.ON_EXIT, "Leave", null, 2);
        terminateState.addTransition("enter_neighbor", neighborState);
        terminateState.addTransition("enter_file", fileState);
        terminateState.addTransition("enter_help", helpState);
        states.put("Terminate", terminateState);
        btNeighborProState.setName("BTNeighborProgress");
        this.addDefaultEnterExitAction(btNeighborProState);
        btNeighborProState.addTransition("enter_neighbor", neighborState);
        states.put("BTNeighborProgress", btNeighborProState);
        neighborState.setName("Neighbor");
        this.addDefaultEnterExitAction(neighborState);
        neighborState.addTransition("exit", terminateState);
        neighborState.addTransition("enter_neighbor_progress", btNeighborProState);
        neighborState.addTransition("enter_help", helpState);
        neighborState.addTransition("enter_file", fileState);
        neighborState.addTransition("enter_bt_download_connect_progress", btDownloadConnectProgressState);
        states.put("Neighbor", neighborState);
        fileState.setName("File");
        this.addDefaultEnterExitAction(fileState);
        fileState.addTransition("exit", terminateState);
        fileState.addTransition("enter_neighbor", neighborState);
        fileState.addTransition("enter_bt_push", btPushState);
        fileState.addTransition("enter_help", helpState);
        states.put("File", fileState);
        helpState.setName("Help");
        this.addDefaultEnterExitAction(helpState);
        helpState.addTransition("exit", terminateState);
        helpState.addTransition("enter_file", fileState);
        helpState.addTransition("enter_neighbor", neighborState);
        states.put("Help", helpState);
        btDownloadConnectProgressState.setName("BTDownloadConnectProgress");
        this.addDefaultEnterExitAction(btDownloadConnectProgressState);
        btDownloadConnectProgressState.addTransition("enter_bt_download_folder_progress", btDownloadFolderProgressState);
        btDownloadConnectProgressState.addTransition("enter_neighbor", neighborState);
        states.put("BTDownloadConnectProgress", btDownloadConnectProgressState);
        btDownloadFolderProgressState.setName("BTDownloadFolderProgress");
        this.addDefaultEnterExitAction(btDownloadFolderProgressState);
        btDownloadFolderProgressState.addTransition("enter_bt_download_file", btDownloadFileState);
        btDownloadFolderProgressState.addTransition("enter_neighbor", neighborState);
        states.put("BTDownloadFolderProgress", btDownloadFolderProgressState);
        btDownloadFileState.setName("BTDownloadFile");
        this.addDefaultEnterExitAction(btDownloadFileState);
        btDownloadFileState.addTransition("enter_neighbor", neighborState);
        btDownloadFileState.addTransition("enter_bt_download_folder_progress", btDownloadFolderProgressState);
        btDownloadFileState.addTransition("enter_bt_download_local_folder", btDownloadLocalFolderState);
        states.put("BTDownloadFile", btDownloadFileState);
        btDownloadLocalFolderState.setName("BTDownloadLocalFolder");
        this.addDefaultEnterExitAction(btDownloadLocalFolderState);
        btDownloadLocalFolderState.addTransition("enter_bt_download_file", btDownloadFileState);
        btDownloadLocalFolderState.addTransition("enter_bt_download_file_progress", btDownloadFileProgressState);
        states.put("BTDownloadLocalFolder", btDownloadLocalFolderState);
        btDownloadFileProgressState.setName("BTDownloadFileProgress");
        this.addDefaultEnterExitAction(btDownloadFileProgressState);
        btDownloadFileProgressState.addTransition("enter_bt_download_file", btDownloadFileState);
        states.put("BTDownloadFileProgress", btDownloadFileProgressState);
        btPushState.setName("BTPush");
        this.addDefaultEnterExitAction(btPushState);
        btPushState.addTransition("enter_file", fileState);
        btPushState.addTransition("enter_bt_push_connect_progress", btPushConnectProgressState);
        btPushState.addTransition("enter_bt_push_progress", btPushProgressState);
        states.put("BTPush", btPushState);
        btPushProgressState.setName("BTPushProgress");
        this.addDefaultEnterExitAction(btPushProgressState);
        btPushProgressState.addTransition("enter_bt_push", btPushState);
        states.put("BTPushProgress", btPushProgressState);
        btPushConnectProgressState.setName("BTPushConnectProgress");
        this.addDefaultEnterExitAction(btPushConnectProgressState);
        btPushConnectProgressState.addTransition("enter_bt_push", btPushState);
        btPushConnectProgressState.addTransition("enter_bt_push_file_progress", btPushFileProgressState);
        btPushConnectProgressState.addTransition("enter_file", fileState);
        states.put("BTPushConnectProgress", btPushConnectProgressState);
        btPushFileProgressState.setName("BTPushFileProgress");
        this.addDefaultEnterExitAction(btPushFileProgressState);
        btPushFileProgressState.addTransition("enter_bt_push_connect_progress", btPushConnectProgressState);
        states.put("BTPushFileProgress", btPushFileProgressState);
        this.addStates(states, "Start");
    }

    private void addDefaultEnterExitAction(State state) {
        state.addAction(State.ON_ENTER, "Enter", null, 1);
        state.addAction(State.ON_EXIT, "Leave", null, 2);
    }

    public void addModel(String state, Model model) {
        this.models.put(state, model);
    }

    public Model getCurrentModel() {
        return (Model)this.models.get(this.currState.getName());
    }

    public Model getModel(String state) {
        return (Model)this.models.get(state);
    }

    public void doAction(int fun, Fsm fsm) {
        switch (fun) {
            case 5: {
                if (!this.currState.getName().equals("Terminate")) break;
                this.midlet.changeScreen(new ExitAlert(this.midlet));
                break;
            }
            case 1: {
                if (this.currState.getName().equals("BTDownloadProgress")) {
                    ModelBTDownloadProgress model = (ModelBTDownloadProgress)this.models.get(this.currState.getName());
                    model.onEnter();
                    break;
                }
                if (this.currState.getName().equals("BTDownloadConnectProgress")) {
                    ModelBTDownloadConnectProgress model = (ModelBTDownloadConnectProgress)this.models.get(this.currState.getName());
                    model.onEnter();
                    break;
                }
                if (this.currState.getName().equals("BTDownloadFolderProgress")) {
                    ModelBTDownloadFolderProgress model = (ModelBTDownloadFolderProgress)this.models.get(this.currState.getName());
                    model.onEnter();
                    break;
                }
                if (this.currState.getName().equals("BTDownloadFileProgress")) {
                    ModelBTDownloadFileProgress model = (ModelBTDownloadFileProgress)this.models.get(this.currState.getName());
                    model.onEnter();
                    break;
                }
                if (this.currState.getName().equals("BTDownloadFile")) {
                    ModelBTDownloadFile model = (ModelBTDownloadFile)this.models.get(this.currState.getName());
                    model.onEnter();
                    break;
                }
                if (this.currState.getName().equals("BTDownloadLocalFolder")) {
                    ModelBTDownloadLocalFolder model = (ModelBTDownloadLocalFolder)this.models.get(this.currState.getName());
                    model.onEnter();
                    break;
                }
                if (this.currState.getName().equals("BTNeighborProgress")) {
                    BTNeighborSearch model = (BTNeighborSearch)this.models.get("BTNeighborProgress");
                    model.onEnter();
                    break;
                }
                if (this.currState.getName().equals("BTPush")) {
                    ModelBTPush model = (ModelBTPush)this.models.get(this.currState.getName());
                    model.onEnter();
                    break;
                }
                if (this.currState.getName().equals("BTPushProgress")) {
                    ModelBTPushProgress model = (ModelBTPushProgress)this.models.get(this.currState.getName());
                    model.onEnter();
                    break;
                }
                if (this.currState.getName().equals("BTPushConnectProgress")) {
                    ModelBTPushConnectProgress model = (ModelBTPushConnectProgress)this.models.get(this.currState.getName());
                    model.onEnter();
                    break;
                }
                if (this.currState.getName().equals("BTPushFileProgress")) {
                    ModelBTPushFileProgress model = (ModelBTPushFileProgress)this.models.get(this.currState.getName());
                    model.onEnter();
                    break;
                }
                if (this.currState.getName().equals("Neighbor")) {
                    ModelNeighbor model = (ModelNeighbor)this.models.get("Neighbor");
                    model.onEnter();
                    break;
                }
                if (this.currState.getName().equals("File")) {
                    ModelFile model = (ModelFile)this.models.get("File");
                    model.onEnter();
                    break;
                }
                if (!this.currState.getName().equals("Help")) break;
                ModelHelp model = (ModelHelp)this.models.get("Help");
                model.onEnter();
                break;
            }
            case 2: {
                if (this.currState.getName().equals("BTNeighborProgress") || !this.currState.getName().equals("BTDownloadFileProgress")) break;
                ModelBTDownloadFileProgress model = (ModelBTDownloadFileProgress)this.models.get("BTDownloadFileProgress");
                model.onLeave();
            }
        }
    }
}

