/*
 * Decompiled with CFR 0.152.
 */
package model;

import blue.bExplore;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.obex.HeaderSet;
import javax.obex.Operation;
import local.Local;
import model.FileObject;
import model.ModelBTPushFileProgress;
import model.UIFsm;
import util.Kits;

class PutFile
extends Thread {
    private bExplore midlet;
    private boolean cancelled;
    int connectionCode;
    ModelBTPushFileProgress model;
    protected Operation op;

    PutFile(bExplore midlet, ModelBTPushFileProgress model) {
        this.midlet = midlet;
        this.model = model;
    }

    public void run() {
        while (this.model.localFiles.size() > 0) {
            FileObject fo = (FileObject)this.model.localFiles.elementAt(0);
            String fname = fo.getName();
            this.model.progressScreen.setLabel(String.valueOf(Local.get("push")) + " " + fname + " ...");
            this.model.progressScreen.setText("");
            this.model.localFiles.removeElementAt(0);
            this.putFile(this.model.localFolder, fo);
        }
        UIFsm fsm = this.midlet.getUIFsm();
        fsm.outEvent("enter_bt_push_connect_progress");
    }

    public void putFile(String filePath, FileObject fo) {
        block26: {
            if (fo.isFolder()) {
                this.putFolder(filePath, fo);
                return;
            }
            String fileName = fo.getName();
            this.model.progressScreen.setLabel(String.valueOf(Local.get("push")) + " file: " + filePath + fileName + " ...");
            byte[] data = null;
            try {
                FileConnection fc = (FileConnection)Connector.open((String)("file:///" + filePath + fileName), (int)1);
                InputStream is = fc.openInputStream();
                data = new byte[(int)fc.fileSize()];
                is.read(data);
                is.close();
                fc.close();
            }
            catch (SecurityException e) {
                this.model.progressScreen.setText(e.getMessage());
                Kits.sleep(2000);
            }
            catch (IOException e) {
                this.model.progressScreen.setText(e.getMessage());
                Kits.sleep(2000);
            }
            if (data == null) {
                this.model.progressScreen.insertTextField(String.valueOf(Local.get("file")) + " " + Local.get("notFound") + "!");
                Kits.sleep(2000);
                return;
            }
            try {
                try {
                    HeaderSet header = this.model.session.createHeaderSet();
                    header.setHeader(66, (Object)Kits.fileType(fileName));
                    header.setHeader(1, (Object)fileName);
                    header.setHeader(195, (Object)new Long(data.length));
                    this.op = this.model.session.put(header);
                    this.model.progressScreen.setText(String.valueOf(Local.get("pushing")) + " " + Local.get("files") + " ...");
                    DataOutputStream os = this.op.openDataOutputStream();
                    ByteArrayInputStream bais = new ByteArrayInputStream(data);
                    byte[] buf = new byte[4096];
                    int total = data.length;
                    int len = -1;
                    int sofar = 0;
                    while ((len = bais.read(buf, 0, 4096)) > 0) {
                        if (this.cancelled) break;
                        ((OutputStream)os).write(buf, 0, len);
                        this.model.progressUpdate(sofar += len, total);
                    }
                    if (this.cancelled) {
                        this.model.progressScreen.setText("Cancelled!");
                        this.op.abort();
                        this.model.progressScreen.setText(String.valueOf(Local.get("pushing")) + " " + fileName + " " + Local.get("to") + " " + this.model.btName + " " + Local.get("cancelled") + "!");
                        this.cancelled = false;
                        break block26;
                    }
                    this.model.progressScreen.setText(String.valueOf(Local.get("pushing")) + " " + fileName + " " + Local.get("to") + " " + this.model.btName + " " + Local.get("succeed") + "!");
                    ((OutputStream)os).flush();
                    ((OutputStream)os).close();
                }
                catch (IOException e) {
                    this.model.progressScreen.setText("IOException while pushing " + fileName + " to " + this.model.btName + ": " + e.toString());
                    Kits.sleep(3000);
                    try {
                        if (this.op != null) {
                            this.op.close();
                        }
                        this.op = null;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            finally {
                try {
                    if (this.op != null) {
                        this.op.close();
                    }
                    this.op = null;
                }
                catch (IOException iOException) {}
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void putFolder(String filePath, FileObject fo) {
        String folderName = fo.getName();
        this.model.progressScreen.setLabel(String.valueOf(Local.get("push")) + " folder: " + filePath + folderName + " ...");
        if (folderName.endsWith(FileObject.FILE_SEPARATOR)) {
            folderName = folderName.substring(0, folderName.length() - FileObject.FILE_SEPARATOR.length());
        }
        try {
            HeaderSet header = this.model.session.createHeaderSet();
            header.setHeader(1, (Object)folderName);
            this.model.session.setPath(header, false, true);
            this.model.progressScreen.setText(String.valueOf(Local.get("pushing")) + " " + folderName + " " + Local.get("to") + " " + this.model.btName + " " + Local.get("succeed") + "!");
            this.model.session.setPath(header, false, false);
            String currentPath = String.valueOf(filePath) + fo.getName();
            FileConnection fc = (FileConnection)Connector.open((String)("file:///" + currentPath), (int)1);
            Vector<FileObject> files = new Vector<FileObject>();
            if (fc.exists()) {
                Enumeration listOfFiles = fc.list();
                while (listOfFiles.hasMoreElements()) {
                    String name = (String)listOfFiles.nextElement();
                    FileObject fn = new FileObject(name);
                    files.addElement(fn);
                }
            }
            fc.close();
            int i = 0;
            while (i < files.size()) {
                fo = (FileObject)files.elementAt(i);
                this.putFile(currentPath, fo);
                ++i;
            }
            this.model.session.setPath(null, true, false);
        }
        catch (IOException e) {
            this.model.progressScreen.setText("IOException while pushing " + folderName + " to " + this.model.btName + ": " + e.toString());
            Kits.sleep(3000);
        }
    }

    void cancel() {
        this.cancelled = true;
    }
}

