/*
 * Decompiled with CFR 0.152.
 */
package model;

import blue.bExplore;
import java.util.Vector;
import model.FileObject;
import model.LocalFileHandler;
import model.Model;
import model.Preference;
import view.TabFormFile;

public class ModelFile
implements Model {
    Vector fileObjects;
    TabFormFile tabFile;
    bExplore midlet;

    public ModelFile(bExplore midlet, TabFormFile tabFile) {
        this.midlet = midlet;
        this.tabFile = tabFile;
        String focus = Preference.getInstance().get("fp_focus");
        if (focus == null || focus.length() == 0) {
            LocalFileHandler.setCurrentFocus(-1);
        } else {
            int focus_index = Integer.parseInt(focus);
            LocalFileHandler.setCurrentFocus(focus_index);
        }
        String path = Preference.getInstance().get("fp");
        this.loadFolder(path);
    }

    public void loadParentFolder() {
        this.fileObjects = LocalFileHandler.cd("..").getFileObjectList();
    }

    public void loadFolder(String path) {
        this.fileObjects = LocalFileHandler.cd(path).getFileObjectList();
    }

    public void clearChecked() {
        int i = 0;
        while (i < this.fileObjects.size()) {
            FileObject fo = (FileObject)this.fileObjects.elementAt(i);
            fo.setChecked(false);
            ++i;
        }
    }

    public FileObject find(FileObject fn) {
        int i = 0;
        while (i < this.fileObjects.size()) {
            FileObject fo = (FileObject)this.fileObjects.elementAt(i);
            if (fo.equals(fn)) {
                return fo;
            }
            ++i;
        }
        return null;
    }

    public void refresh() {
        if (!this.tabFile.isCurrentDisplayable()) {
            return;
        }
        this.loadFolder(LocalFileHandler.getCurrentFolder().getFullPath());
        this.fileObjects = LocalFileHandler.getCurrentFolder().getFileObjectList();
        this.onEnter();
    }

    public void fileObjectUpdate(Vector fileObjects) {
        this.fileObjects = fileObjects;
    }

    public void removeCheckedFile() {
        int i = 0;
        while (i < this.fileObjects.size()) {
            FileObject fo = (FileObject)this.fileObjects.elementAt(i);
            if (fo.isChecked()) {
                if (LocalFileHandler.removeFile(fo.getName())) {
                    this.fileObjects.removeElementAt(i);
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
    }

    public void onEnter() {
        this.tabFile.setTitle(LocalFileHandler.getCurrentFolder().getFullPath());
        this.tabFile.update(this.fileObjects);
        this.midlet.changeScreen(this.tabFile);
    }

    public void onUpdate() {
        this.tabFile.update(this.fileObjects);
    }

    public Vector getFileObjects() {
        return this.fileObjects;
    }
}

