/*
 * Decompiled with CFR 0.152.
 */
package model;

import blue.bExplore;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.obex.ClientSession;
import javax.obex.HeaderSet;
import local.Local;
import model.BTDesc;
import model.Model;
import model.ModelBTPush;
import model.ModelBTPushFileProgress;
import model.UIFsm;
import view.ProgressScreen;

public class ModelBTPushConnectProgress
implements Model {
    Vector bts;
    protected String btName;
    protected ClientSession session;
    protected bExplore midlet;
    protected ProgressScreen screen;

    public ModelBTPushConnectProgress(bExplore midlet, ProgressScreen progressScreen) {
        this.midlet = midlet;
        this.screen = progressScreen;
    }

    public void onEnter() {
        if (this.session != null) {
            this.close();
        }
        if (this.bts != null && this.bts.size() > 0) {
            BTDesc bt = (BTDesc)this.bts.elementAt(0);
            this.bts.removeElementAt(0);
            this.btName = bt.getBtName();
            this.screen.setLabel(String.valueOf(Local.get("conning")) + " " + bt.getBtName() + "," + bt.getOppURL() + " ...");
            this.screen.setMaxValue(-1);
            this.screen.setValue(2);
            this.midlet.changeScreen(this.screen);
            boolean ret = this.open(bt.getOppURL());
            this.onCompleted(ret);
        } else {
            UIFsm fsm = this.midlet.getUIFsm();
            fsm.outEvent("enter_file");
        }
    }

    public void onCompleted(boolean ret) {
        if (ret) {
            UIFsm fsm = this.midlet.getUIFsm();
            ModelBTPush model1 = (ModelBTPush)fsm.getModel("BTPush");
            ModelBTPushFileProgress model2 = (ModelBTPushFileProgress)fsm.getModel("BTPushFileProgress");
            model2.onUpdate(this.btName, this.session, model1.getLocalFilePath(), model1.getLocalFiles());
            fsm.outEvent("enter_bt_push_file_progress");
        } else {
            this.onCancelled();
        }
    }

    public void onCancelled() {
        UIFsm fsm = this.midlet.getUIFsm();
        fsm.inEvent("enter_bt_push_connect_progress");
    }

    protected boolean open(String url) {
        try {
            this.session = (ClientSession)Connector.open((String)url);
            HeaderSet response = this.session.connect(null);
            int rcode = response.getResponseCode();
            if (rcode != 160) {
                this.screen.setText(String.valueOf(Local.get("conn")) + " " + Local.get("rejected") + "/" + Local.get("failed"));
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    protected void close() {
        try {
            if (this.session != null) {
                this.session.disconnect(null);
                this.session.close();
            }
            this.session = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Vector getBts() {
        return this.bts;
    }

    public void setBts(Vector bts) {
        this.bts = bts;
    }

    public String getBtName() {
        return this.btName;
    }
}

