/*
 * Decompiled with CFR 0.152.
 */
package model;

import blue.bExplore;
import helper.fsm.State;
import java.io.IOException;
import local.Local;
import model.BTGetFolderProgress;
import model.FileObject;
import model.ModelBTDownloadFile;
import model.UIFsm;
import util.Kits;
import view.BWAlert;
import view.ProgressScreen;

public class ModelBTDownloadFolderProgress
extends BTGetFolderProgress {
    public ModelBTDownloadFolderProgress(bExplore midlet, ProgressScreen progressScreen) {
        super(midlet, progressScreen);
        this.setInstance(this);
    }

    public void onCompleted(int respCode, String folderName, FileObject[] folders) {
        UIFsm fsm = this.midlet.getUIFsm();
        if (respCode == 160) {
            ModelBTDownloadFile model = (ModelBTDownloadFile)fsm.getModel("BTDownloadFile");
            model.setFileNames(folders);
            model.getBtDownloadFileForm().getBtDownloadFileItem().setLabel(String.valueOf(Local.get("remote")) + " " + Local.get("folder") + ": " + folderName);
            fsm.outEvent("enter_bt_download_file");
        } else {
            if (respCode == 196) {
                BWAlert.infoAlert(String.valueOf(Local.get("remote")) + " " + Local.get("folder") + ": " + folderName + " " + Local.get("notExist"), 3000);
                Kits.sleep(3000);
            }
            this.cleanPath();
            ModelBTDownloadFile model = (ModelBTDownloadFile)fsm.getModel("BTDownloadFile");
            model.onLeave();
            fsm.outEvent("enter_neighbor");
        }
    }

    public void onCancelled() {
        UIFsm fsm = this.midlet.getUIFsm();
        State enteringState = fsm.getEnteringState();
        if (enteringState != null && enteringState.getName().equals("BTDownloadFile")) {
            fsm.outEvent("enter_bt_download_file");
        } else {
            if (this.obexSession != null) {
                try {
                    this.obexSession.disconnect(null);
                    this.obexSession.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.obexSession = null;
            }
            fsm.outEvent("enter_neighbor");
        }
    }
}

