/*
 * Decompiled with CFR 0.152.
 */
package model;

import blue.bExplore;
import comm.OBEXListener;
import comm.OBEXSession;
import java.util.Vector;
import local.Local;
import model.FileObject;
import model.FilesForDownload;
import model.FolderObject;
import model.GetFile;
import model.Model;
import model.UIFsm;
import util.Stack;
import view.ProgressScreen;

public class ModelBTDownloadFileProgress
implements Model,
OBEXListener {
    ProgressScreen progressScreen;
    bExplore midlet;
    String progressText;
    protected String btName;
    protected OBEXSession session;
    protected Stack downloadStack;
    GetFile thread;
    protected boolean cancelled = false;

    public ModelBTDownloadFileProgress(bExplore midlet, ProgressScreen progressScreen) {
        this.midlet = midlet;
        this.progressScreen = progressScreen;
        this.downloadStack = new Stack(10);
    }

    public void progressUpdate(int part, int total) {
        String text = "";
        text = total > 0 ? part / 1024 + "K of " + total / 1024 + "K copied" : part / 1024 + "K copied";
        this.progressScreen.progressUpdate(part, total, text);
    }

    public void progressCompleted(Object obj) {
    }

    public void remove(FileObject fo) {
        FilesForDownload ffd = (FilesForDownload)this.downloadStack.peek();
        FolderObject remoteFolder = ffd.getRemoteFolder();
        if (remoteFolder != null) {
            remoteFolder.removeFileObject(fo);
        }
    }

    public void onEnter() {
        if (this.downloadStack.size() == 0) {
            UIFsm fsm = this.midlet.getUIFsm();
            fsm.outEvent("enter_bt_download_file");
        } else {
            this.midlet.changeScreen(this.progressScreen);
            this.progressScreen.setLabel(String.valueOf(Local.get("downloading")) + " " + Local.get("files") + " " + Local.get("from") + " " + this.btName + " ...");
            this.progressScreen.setMaxValue(-1);
            this.progressScreen.setValue(2);
            this.session.setOBEXListener(this);
            this.thread = new GetFile(this.midlet, this);
            this.thread.start();
        }
    }

    public void onLeave() {
    }

    public void onRefresh() {
        this.onEnter();
    }

    public void onUpdate(String btName, OBEXSession session, String remoteFolder, Vector remoteFiles, String localFolder, Vector localFiles) {
        this.btName = btName;
        this.session = session;
        this.downloadStack.reset();
        this.push(remoteFolder, remoteFiles, localFolder, localFiles);
    }

    public FilesForDownload push(String remoteFolder, Vector remoteFiles, String localFolder, Vector localFiles) {
        FilesForDownload ffd = new FilesForDownload();
        FolderObject remoteFolderObject = new FolderObject(remoteFolder, remoteFiles);
        FolderObject localFolderObject = new FolderObject(localFolder, localFiles);
        ffd.setLocalFolder(localFolderObject);
        ffd.setRemoteFolder(remoteFolderObject);
        this.downloadStack.push(ffd);
        return ffd;
    }

    public void onCancel() {
        if (this.thread != null) {
            this.thread.cancel();
            this.thread = null;
        }
        this.cancelled = true;
    }
}

