/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import local.Local;
import model.FileObject;
import model.FolderObject;
import model.Preference;
import util.Kits;
import view.BWAlert;

public class LocalFileHandler {
    private static FolderObject currentFolder;
    private static int currentFocus;

    public static FileObject createFolder(String path, String name) {
        FileConnection fc = null;
        try {
            fc = (FileConnection)Connector.open((String)("file:///" + path + name), (int)3);
            if (!fc.exists()) {
                fc.mkdir();
                fc.setHidden(false);
                fc.setReadable(true);
                fc.setWritable(true);
            }
            fc.close();
            if (!name.endsWith(FileObject.FILE_SEPARATOR)) {
                name = String.valueOf(name) + FileObject.FILE_SEPARATOR;
            }
            return new FileObject(name);
        }
        catch (SecurityException e) {
            BWAlert.errorAlert("Security Exception: " + e.getMessage());
        }
        catch (IOException e) {
            BWAlert.errorAlert("IO Exception: " + e.getMessage());
        }
        return null;
    }

    public static FileObject createFolder(String name) {
        if (currentFolder != null) {
            return LocalFileHandler.createFolder(currentFolder.getFullPath(), name);
        }
        return null;
    }

    public static FolderObject loadFolder(String path) {
        if (path == null || path.equals("/")) {
            path = "";
        }
        FolderObject folder = new FolderObject(path);
        if (path.equals("")) {
            folder.setWritable(false);
            Enumeration roots = FileSystemRegistry.listRoots();
            while (roots.hasMoreElements()) {
                String name = (String)roots.nextElement();
                folder.addFileObject(new FileObject(name));
            }
        } else {
            try {
                FileConnection fc = (FileConnection)Connector.open((String)("file:///" + path), (int)1);
                if (!fc.exists()) {
                    fc.close();
                    BWAlert.errorAlert(String.valueOf(Local.get("folder")) + " " + path + " " + Local.get("notExist") + "!");
                    return LocalFileHandler.loadFolder(null);
                }
                folder.setWritable(fc.canWrite());
                FileObject fo = new FileObject("..");
                fo.setFolder(true);
                folder.addFileObject(fo);
                Enumeration listOfFiles = fc.list();
                while (listOfFiles.hasMoreElements()) {
                    String name = (String)listOfFiles.nextElement();
                    folder.addFileObject(new FileObject(name));
                }
                fc.close();
            }
            catch (SecurityException e) {
                BWAlert.errorAlert("SecurityException: loadFolder() - " + path + ", " + e.getMessage());
            }
            catch (IOException e) {
                BWAlert.errorAlert("IOException: loadFolder() - folder not found: " + path + ", " + e.getMessage());
                return LocalFileHandler.loadFolder(null);
            }
        }
        Preference.getInstance().set("fp", path);
        Preference.getInstance().save();
        currentFolder = folder;
        return folder;
    }

    public static byte[] readFile(String path, String name) {
        byte[] buf = null;
        try {
            FileConnection fc = (FileConnection)Connector.open((String)("file:///" + path + name), (int)1);
            InputStream is = fc.openInputStream();
            buf = new byte[(int)fc.fileSize()];
            is.read(buf);
            is.close();
            fc.close();
        }
        catch (SecurityException e) {
            BWAlert.errorAlert("readFile(): " + e.getMessage());
        }
        catch (IOException e) {
            BWAlert.errorAlert("readFile(): " + e.getMessage());
        }
        return buf;
    }

    public static boolean removeFile(String path, String name) {
        try {
            FileConnection fc = (FileConnection)Connector.open((String)("file:///" + path + name));
            if (fc.exists()) {
                String childPath = String.valueOf(path) + name;
                if (fc.isDirectory()) {
                    Enumeration listOfFiles = fc.list();
                    while (listOfFiles.hasMoreElements()) {
                        String child = (String)listOfFiles.nextElement();
                        LocalFileHandler.removeFile(childPath, child);
                    }
                }
                fc.delete();
            }
            fc.close();
            return true;
        }
        catch (SecurityException e) {
            BWAlert.errorAlert("remove(): " + e.getMessage());
            Kits.sleep(3000);
        }
        catch (IOException e) {
            BWAlert.errorAlert("remove(): " + e.getMessage());
            Kits.sleep(3000);
        }
        return false;
    }

    public static boolean removeFile(String name) {
        String path = currentFolder.getFullPath();
        return LocalFileHandler.removeFile(path, name);
    }

    public static FolderObject cd(String path) {
        if (path != null && path.equals("..")) {
            path = currentFolder.getFullPath();
            int r = path.lastIndexOf(47, path.length() - 2);
            path = r > 0 ? path.substring(0, r + 1) : "";
        }
        return LocalFileHandler.loadFolder(path);
    }

    public static int getCurrentFocus() {
        return currentFocus;
    }

    public static void setCurrentFocus(int focus) {
        currentFocus = focus;
        Preference.getInstance().set("fp_focus", "" + currentFocus);
        Preference.getInstance().save();
    }

    public static FolderObject getCurrentFolder() {
        return currentFolder;
    }

    public static void setCurrentFolder(FolderObject currentFolder) {
        LocalFileHandler.currentFolder = currentFolder;
    }
}

