/*
 * Decompiled with CFR 0.152.
 */
package model;

import comm.OBEXResponse;
import java.io.IOException;
import java.util.Vector;
import model.BTGetFolderProgress;
import model.FileObject;
import util.Kits;
import util.StringHelper;
import view.ProgressScreen;

class GetFolderThread
extends Thread {
    private boolean cancelled;
    BTGetFolderProgress progress;
    ProgressScreen progressScreen;

    GetFolderThread(BTGetFolderProgress progress, ProgressScreen progressScreen) {
        this.progress = progress;
        this.progressScreen = progressScreen;
    }

    public void run() {
        this.cancelled = false;
        try {
            String folderName = null;
            String folderPath = this.progress.peekPath();
            if (folderPath != null && folderPath.equals("..")) {
                this.progress.popPath();
                this.progress.popPath();
            }
            folderName = this.progress.getFullPath();
            if (this.progress.isRefresh()) {
                this.progress.setRefresh(false);
                folderPath = null;
            }
            OBEXResponse resp = this.progress.getObexSession().getFolder(folderPath);
            if (!this.cancelled) {
                FileObject[] fos = null;
                if (resp.getRespCode() == 160) {
                    byte[] result = resp.getBody();
                    fos = this.folderParser(folderName, result);
                }
                this.progress.onCompleted(resp.getRespCode(), folderName, fos);
            } else {
                this.progress.onCancelled();
            }
        }
        catch (IOException e) {
            this.progressScreen.setText("IOException: " + e.toString());
            Kits.sleep(2000);
            this.progress.onCancelled();
        }
    }

    FileObject[] folderParser(String parent, byte[] result) {
        if (result == null || result.length == 0) {
            return new FileObject[0];
        }
        String line = new String(result);
        Vector<FileObject> v = new Vector<FileObject>();
        if (!parent.endsWith("/")) {
            FileObject fo = new FileObject();
            fo.setFolder(true);
            fo.setName("..");
            v.addElement(fo);
        }
        String[] lines = StringHelper.split(line, '<');
        int i = 0;
        while (i < lines.length) {
            if (lines[i].startsWith("folder ") || lines[i].startsWith("file ")) {
                String size;
                FileObject fo = new FileObject();
                if (lines[i].startsWith("file ")) {
                    fo.setFolder(false);
                } else {
                    fo.setFolder(true);
                }
                String name = this.getAttribute(lines[i], "name=\"");
                if (name != null) {
                    fo.setName(name);
                }
                if ((size = this.getAttribute(lines[i], "size=\"")) != null && size.length() > 0) {
                    fo.setSize(Integer.parseInt(size));
                }
                v.addElement(fo);
            }
            ++i;
        }
        Object[] fos = new FileObject[v.size()];
        v.copyInto(fos);
        return fos;
    }

    String getAttribute(String src, String attr) {
        int t;
        int s;
        int r = src.indexOf(attr);
        if (r > 0 && (s = src.indexOf("\"", (t = r + attr.length()) + 1)) >= t) {
            return src.substring(t, s);
        }
        return null;
    }

    void cancel() {
        this.cancelled = true;
        this.progress.getObexSession().cancel();
    }
}

