/*
 * Decompiled with CFR 0.152.
 */
package model;

import blue.bExplore;
import comm.OBEXResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import local.Local;
import model.FileObject;
import model.FilesForDownload;
import model.FolderObject;
import model.LocalFileHandler;
import model.ModelBTDownloadFileProgress;
import model.RemoteData;
import model.UIFsm;
import util.Kits;
import view.BWAlert;
import view.LocalFileOverwriteConfirm;

class GetFile
extends Thread {
    private bExplore midlet;
    int connectionCode;
    ModelBTDownloadFileProgress progress;

    GetFile(bExplore midlet, ModelBTDownloadFileProgress progress) {
        this.midlet = midlet;
        this.progress = progress;
    }

    public void run() {
        while (this.progress.downloadStack.size() > 0) {
            FilesForDownload ffd = (FilesForDownload)this.progress.downloadStack.peek();
            FolderObject remoteFolderObject = ffd.getRemoteFolder();
            FolderObject localFolderObject = ffd.getLocalFolder();
            Vector remoteFiles = remoteFolderObject.getFileObjectList();
            Vector localFiles = localFolderObject.getFileObjectList();
            String remoteFolder = remoteFolderObject.getFullPath();
            if (!remoteFolder.endsWith(FileObject.FILE_SEPARATOR)) {
                remoteFolder = String.valueOf(remoteFolder) + FileObject.FILE_SEPARATOR;
            }
            String localFolder = localFolderObject.getFullPath();
            while (!remoteFiles.isEmpty()) {
                block28: {
                    FileObject fo = (FileObject)remoteFiles.elementAt(0);
                    String remoteFile = fo.getName();
                    this.progress.progressScreen.setLabel(String.valueOf(Local.get("download")) + " " + remoteFolder + remoteFile + " to " + localFolder);
                    this.progress.progressScreen.setText("");
                    if (fo.isFolder()) {
                        remoteFiles.removeElementAt(0);
                        String remoteChildFolder = String.valueOf(remoteFolder) + remoteFile;
                        try {
                            OBEXResponse resp = this.progress.session.getFolder(remoteFile);
                            if (resp.getOpCode() == -1) {
                                this.progress.progressScreen.setText("Download folder aborted: " + resp.getRespCode());
                                Kits.sleep(3000);
                            }
                            if (resp.getRespCode() == 160) {
                                String localChildFolder;
                                Vector remoteChildFiles = RemoteData.getInstance().getFileList(resp.getBody());
                                FileConnection fc = null;
                                Vector<FileObject> localChildFiles = new Vector<FileObject>();
                                if (!remoteFile.endsWith(FileObject.FILE_SEPARATOR)) {
                                    remoteFile = String.valueOf(remoteFile) + FileObject.FILE_SEPARATOR;
                                }
                                if (!(fc = (FileConnection)Connector.open((String)("file:///" + (localChildFolder = String.valueOf(localFolder) + remoteFile)), (int)3)).exists()) {
                                    fc.mkdir();
                                    FileObject fn = new FileObject(remoteFile);
                                    fn.setFolder(true);
                                    localFiles.addElement(fn);
                                } else {
                                    Enumeration listOfFiles = fc.list();
                                    while (listOfFiles.hasMoreElements()) {
                                        String name = (String)listOfFiles.nextElement();
                                        localChildFiles.addElement(new FileObject(name));
                                    }
                                }
                                fc.close();
                                ffd = this.progress.push(remoteChildFolder, remoteChildFiles, localChildFolder, localChildFiles);
                                ffd.setChild(true);
                                remoteFolderObject = ffd.getRemoteFolder();
                                localFolderObject = ffd.getLocalFolder();
                                remoteFiles = remoteFolderObject.getFileObjectList();
                                localFiles = localFolderObject.getFileObjectList();
                                remoteFolder = remoteFolderObject.getFullPath();
                                if (!remoteFolder.endsWith(FileObject.FILE_SEPARATOR)) {
                                    remoteFolder = String.valueOf(remoteFolder) + FileObject.FILE_SEPARATOR;
                                }
                                localFolder = localFolderObject.getFullPath();
                                continue;
                            }
                            this.progress.progressScreen.setText("Downalod folder failed: " + resp.getRespCode());
                            Kits.sleep(3000);
                        }
                        catch (SecurityException e) {
                            BWAlert.errorAlert("Security Exception: " + e.getMessage());
                        }
                        catch (IOException e) {
                            BWAlert.errorAlert("IO Exception: " + e.getMessage());
                        }
                        continue;
                    }
                    boolean isExist = this.exist(localFiles, remoteFile);
                    if (isExist && !fo.isOverwritable()) {
                        LocalFileOverwriteConfirm fileOverwriteConfirm = new LocalFileOverwriteConfirm(this.midlet, this.progress, fo, String.valueOf(Local.get("overwriteLocalFileConfirm")) + " " + remoteFile + "?", Local.get("yes"), Local.get("no"));
                        this.midlet.changeScreen(fileOverwriteConfirm);
                        return;
                    }
                    try {
                        int size = fo.getSize();
                        OBEXResponse resp = this.progress.session.getFile(remoteFile, size);
                        if (resp.getOpCode() == -1) {
                            this.progress.progressScreen.setText("Download file aborted: " + resp.getRespCode());
                            Kits.sleep(2000);
                        }
                        if (resp.getRespCode() == 160) {
                            byte[] result = resp.getBody();
                            String fpath = "file:///" + localFolder + remoteFile;
                            FileConnection fc = null;
                            try {
                                fc = (FileConnection)Connector.open((String)fpath, (int)3);
                                if (!fc.exists()) {
                                    fc.create();
                                } else {
                                    fc.truncate(0L);
                                }
                                fc.setHidden(false);
                                fc.setReadable(true);
                                fc.setWritable(true);
                                OutputStream os = fc.openOutputStream();
                                os.write(result);
                                os.flush();
                                os.close();
                                fc.close();
                                if (!isExist && LocalFileHandler.getCurrentFolder().getFullPath() == localFolder) {
                                    LocalFileHandler.getCurrentFolder().addFileObject(new FileObject(remoteFile));
                                }
                                break block28;
                            }
                            catch (SecurityException e) {
                                this.progress.progressScreen.setText("Save file SecurityException: " + e.getMessage());
                                Kits.sleep(2000);
                            }
                            catch (IOException e) {
                                this.progress.progressScreen.setText("Save file IOException: " + e.getMessage());
                                Kits.sleep(2000);
                            }
                            break block28;
                        }
                        this.progress.progressScreen.setText("Downalod file failed: " + resp.getRespCode());
                        Kits.sleep(2000);
                    }
                    catch (IOException e) {
                        this.progress.progressScreen.setText("Download IOException: " + e.getMessage());
                        Kits.sleep(3000);
                    }
                }
                remoteFiles.removeElementAt(0);
            }
            if (ffd.isChild()) {
                try {
                    this.progress.session.changeFolder("..");
                }
                catch (IOException ioe) {
                    BWAlert.errorAlert("download(): " + ioe.toString());
                }
            }
            this.progress.downloadStack.pop();
        }
        UIFsm fsm = this.midlet.getUIFsm();
        fsm.inEvent("enter_bt_download_file_progress");
    }

    void cancel() {
        this.progress.session.cancel();
    }

    boolean exist(Vector localFiles, String remoteFile) {
        int i = 0;
        while (i < localFiles.size()) {
            FileObject fo = (FileObject)localFiles.elementAt(i);
            if (fo.getName().equals(remoteFile)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

