/*
 * Decompiled with CFR 0.152.
 */
package model;

import blue.bExplore;
import comm.BTDiscovery;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.DataElement;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import model.BTDesc;
import model.BTHistory;
import model.BTSearch;
import model.Model;
import model.ModelNeighbor;
import model.UIFsm;
import view.BWAlert;
import view.ProgressScreen;

public class BTNeighborSearch
extends BTSearch
implements Model {
    BTHistory hist = BTHistory.getInstance();

    public BTNeighborSearch(bExplore midlet, ProgressScreen progressScreen) {
        super(midlet, progressScreen);
    }

    public void onEnter() {
        this.progressScreen.setMaxValue(-1);
        this.progressScreen.setValue(2);
        this.start();
    }

    public void onRefresh() {
        this.onEnter();
    }

    public void onCancel() {
        this.cancel();
        this.midlet.getUIFsm().outEvent("enter_neighbor");
    }

    public void deviceInquiryCompleted(Vector devices, Vector classCodes) {
        this.hist.clearNearby();
        int j = 0;
        while (j < devices.size()) {
            RemoteDevice d = (RemoteDevice)devices.elementAt(j);
            String address = d.getBluetoothAddress();
            BTDesc bt = this.hist.get(address);
            if (bt != null) {
                devices.removeElementAt(j);
                bt.setNearby(true);
                continue;
            }
            ++j;
        }
    }

    public void serviceInquiryCompleted(Vector services) {
        int i = 0;
        while (i < services.size()) {
            String address;
            BTDesc bt;
            ServiceRecord s = (ServiceRecord)services.elementAt(i);
            DataElement de = s.getAttributeValue(1);
            UUID sUUID = null;
            Enumeration en = (Enumeration)de.getValue();
            if (en.hasMoreElements()) {
                DataElement de1 = (DataElement)en.nextElement();
                sUUID = (UUID)de1.getValue();
            }
            if ((bt = this.hist.get(address = s.getHostDevice().getBluetoothAddress())) == null) {
                bt = new BTDesc();
                bt.setBtAddress(address);
                try {
                    bt.setBtName(s.getHostDevice().getFriendlyName(false));
                    bt.setNearby(true);
                    this.hist.put(address, bt);
                }
                catch (IOException e) {
                    BWAlert.errorAlert(e.toString());
                }
            }
            String url = s.getConnectionURL(0, false);
            if (sUUID.toString().equals(BTDiscovery.ftpUUID.toString())) {
                bt.setFtpURL(url);
            }
            if (sUUID.toString().equals(BTDiscovery.oppUUID.toString())) {
                bt.setOppURL(url);
            }
            ++i;
        }
        if (services.size() > 0) {
            this.hist.save();
        }
        this.postBTSearch();
    }

    public void postBTSearch() {
        UIFsm fsm = this.midlet.getUIFsm();
        ModelNeighbor model = (ModelNeighbor)fsm.getModel("Neighbor");
        model.onUpdate();
        fsm.outEvent("enter_neighbor");
    }
}

