/*
 * Decompiled with CFR 0.152.
 */
package model;

import blue.bExplore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotOpenException;
import local.Local;
import model.BTDesc;
import model.MyRecordStore;
import view.BWAlert;
import view.Icon;
import view.RowItem;

public class BTHistory
extends MyRecordStore {
    private static BTHistory myInstance = null;
    private Hashtable btMap;
    private static final String RSNAME = "BTRecordStore";
    Vector rowItems = new Vector();
    static final int BTNameLimit = 18;
    static final int BTAddressLimit = 5;

    public static synchronized BTHistory getInstance() {
        if (myInstance == null) {
            myInstance = new BTHistory();
        }
        return myInstance;
    }

    private BTHistory() {
        super(RSNAME);
        this.btMap = new Hashtable();
        this.load();
    }

    public void put(String address, BTDesc btDesc) {
        this.btMap.put(address, btDesc);
    }

    public BTDesc get(String address) {
        return (BTDesc)this.btMap.get(address);
    }

    public void remove(String address) {
        this.btMap.remove(address);
    }

    public Enumeration keys() {
        return this.btMap.keys();
    }

    public Enumeration elements() {
        return this.btMap.elements();
    }

    public void clear() {
        this.btMap.clear();
    }

    public int size() {
        return this.btMap.size();
    }

    public String[] getBTNames() {
        Enumeration keys = this.btMap.keys();
        String[] fileNames = new String[this.btMap.size()];
        int i = 0;
        while (keys.hasMoreElements()) {
            fileNames[i++] = (String)keys.nextElement();
        }
        return fileNames;
    }

    /*
     * Unable to fully structure code
     */
    public void load() {
        block7: {
            numRecords = this.openRecordStore();
            if (numRecords <= 0) break block7;
            recordEnumeration = null;
            try {
                recordEnumeration = this.rs.enumerateRecords(null, null, false);
                if (true) ** GOTO lbl37
            }
            catch (RecordStoreNotOpenException e) {
                BWAlert.errorAlert("Unable to open Store.");
                return;
            }
            do {
                data = null;
                name = "";
                try {
                    data = recordEnumeration.nextRecord();
                    bin = new ByteArrayInputStream(data);
                    din = new DataInputStream(bin);
                    name = din.readUTF();
                    len = din.readInt();
                    value = new byte[len];
                    din.read(value);
                    din.close();
                    bin.close();
                    btDesc = new BTDesc();
                    btDesc.restore(value);
                    this.btMap.put(name, btDesc);
                }
                catch (IOException e) {
                    BWAlert.errorAlert("Error to load BT " + name);
                }
                catch (InvalidRecordIDException e) {
                    e.printStackTrace();
                }
                catch (RecordStoreException e) {
                    e.printStackTrace();
                }
lbl37:
                // 5 sources

            } while (recordEnumeration.hasNextElement());
            recordEnumeration.destroy();
        }
        this.closeRecordStore();
        System.out.println("BTHistory::load() done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        this.deleteRecordStore();
        Hashtable hashtable = this.btMap;
        synchronized (hashtable) {
            if (!this.btMap.isEmpty()) {
                this.openRecordStore();
                String name = null;
                BTDesc bt = null;
                byte[] value = null;
                Enumeration keys = this.btMap.keys();
                while (keys.hasMoreElements()) {
                    name = (String)keys.nextElement();
                    bt = (BTDesc)this.btMap.get(name);
                    try {
                        value = bt.persist();
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        DataOutputStream dout = new DataOutputStream(bout);
                        dout.writeUTF(name);
                        dout.writeInt(value.length);
                        dout.write(value);
                        byte[] data = bout.toByteArray();
                        dout.close();
                        bout.close();
                        this.rs.addRecord(data, 0, data.length);
                    }
                    catch (IOException bout) {
                    }
                    catch (RecordStoreNotOpenException e) {
                        e.printStackTrace();
                    }
                    catch (InvalidRecordIDException e) {
                        e.printStackTrace();
                    }
                    catch (RecordStoreFullException e) {
                        e.printStackTrace();
                    }
                    catch (RecordStoreException e) {
                        e.printStackTrace();
                    }
                }
                this.closeRecordStore();
            }
        }
    }

    public Vector getNearbyBT() {
        Vector<BTDesc> v = new Vector<BTDesc>();
        Enumeration enu = this.btMap.elements();
        while (enu.hasMoreElements()) {
            BTDesc bt = (BTDesc)enu.nextElement();
            if (!bt.isNearby()) continue;
            v.addElement(bt);
        }
        return v;
    }

    public void clearChecked() {
        Enumeration enu = this.btMap.elements();
        while (enu.hasMoreElements()) {
            BTDesc bt = (BTDesc)enu.nextElement();
            bt.setChecked(false);
        }
    }

    public void clearNearby() {
        Enumeration enu = this.btMap.elements();
        while (enu.hasMoreElements()) {
            BTDesc bt = (BTDesc)enu.nextElement();
            bt.setNearby(false);
        }
    }

    public Vector getBT() {
        Vector<BTDesc> v = new Vector<BTDesc>();
        Enumeration enu = this.btMap.elements();
        while (enu.hasMoreElements()) {
            BTDesc bt = (BTDesc)enu.nextElement();
            v.addElement(bt);
        }
        return v;
    }

    public Vector getRowItems() {
        int enCharWidth;
        Vector nearbyBTs = this.getBT();
        this.rowItems.removeAllElements();
        int charWidth = enCharWidth = bExplore.plainFont.stringWidth("n");
        int i = 0;
        while (i < nearbyBTs.size()) {
            RowItem rowItem = new RowItem(2);
            BTDesc btDesc = (BTDesc)nearbyBTs.elementAt(i);
            if (!btDesc.isNearby()) {
                rowItem.setIcon(Icon.GREY_BLUETOOTH);
            } else {
                rowItem.setIcon(Icon.BLUETOOTH);
            }
            if (btDesc.isChecked()) {
                rowItem.setChecked(true);
            }
            String btName = this.formatName(btDesc.getBtName(), 18);
            rowItem.setItems(0, btName, 18 * charWidth);
            String btAddress = this.formatName(btDesc.getBtAddress(), 5);
            rowItem.setItems(1, btAddress, 5 * charWidth);
            this.rowItems.addElement(rowItem);
            ++i;
        }
        return this.rowItems;
    }

    String formatName(String name, int limitLen) {
        if (name == null) {
            return Local.get("unknown");
        }
        if (name.length() > limitLen) {
            String name1 = String.valueOf(name.substring(0, limitLen - 1)) + "..";
            return name1;
        }
        return name;
    }
}

