/*
 * Decompiled with CFR 0.152.
 */
package model;

import blue.bExplore;
import comm.OBEXListener;
import comm.OBEXSession;
import local.Local;
import model.FileObject;
import model.GetFolderThread;
import model.Model;
import model.UIFsm;
import util.Kits;
import util.Stack;
import view.ProgressScreen;

public class BTGetFolderProgress
implements Model,
OBEXListener {
    ProgressScreen progressScreen;
    bExplore midlet;
    String progressText;
    protected OBEXSession obexSession;
    private String btName;
    private Stack pathStack;
    private GetFolderThread thread;
    private BTGetFolderProgress instance = this;
    private boolean isRefresh;

    public boolean isRefresh() {
        return this.isRefresh;
    }

    public void setRefresh(boolean isRefresh) {
        this.isRefresh = isRefresh;
    }

    public BTGetFolderProgress(bExplore midlet, ProgressScreen progressScreen) {
        this.midlet = midlet;
        this.progressScreen = progressScreen;
        this.pathStack = new Stack(30);
    }

    public void progressUpdate(int part, int total) {
        String text = "";
        text = total > 0 ? part / 1024 + "K of " + total / 1024 + "K copied" : part / 1024 + "K copied";
        this.progressScreen.progressUpdate(part, total, text);
    }

    public void progressCompleted(Object obj) {
    }

    public void onEnter() {
        this.progressScreen.setText("");
        this.midlet.changeScreen(this.progressScreen);
        UIFsm fsm = this.midlet.getUIFsm();
        if (this.obexSession == null) {
            this.progressScreen.setText(Local.get("deviceNotConnected"));
            Kits.sleep(3000);
            fsm.outEvent("enter_neighbor");
        } else {
            this.progressScreen.setLabel(String.valueOf(Local.get("retrievingFolderFrom")) + " " + this.btName + " ...");
            this.progressScreen.setMaxValue(-1);
            this.progressScreen.setValue(2);
            this.obexSession.setOBEXListener(this);
            this.thread = new GetFolderThread(this.getInstance(), this.progressScreen);
            this.thread.start();
        }
    }

    public void onRefresh() {
        this.onEnter();
    }

    public void onCancel() {
        if (this.thread != null) {
            this.thread.cancel();
            this.thread = null;
        }
    }

    public void onCompleted(int respCode, String folderName, FileObject[] folders) {
    }

    public void onCancelled() {
    }

    public OBEXSession getObexSession() {
        return this.obexSession;
    }

    public void setObexSession(OBEXSession obexSession) {
        this.obexSession = obexSession;
    }

    public boolean pushPath(String path) {
        return this.pathStack.push(path);
    }

    public String popPath() {
        return (String)this.pathStack.pop();
    }

    public String peekPath() {
        return (String)this.pathStack.peek();
    }

    public void cleanPath() {
        this.pathStack.reset();
    }

    public String getBtName() {
        return this.btName;
    }

    public void setBtName(String btName) {
        this.btName = btName;
    }

    public String getFullPath() {
        String path = "";
        Object[] all = this.pathStack.getAll();
        int i = 0;
        while (i < all.length) {
            path = String.valueOf(path) + "/" + (String)all[i];
            ++i;
        }
        if (path.length() == 0) {
            path = "/";
        }
        return path;
    }

    public BTGetFolderProgress getInstance() {
        return this.instance;
    }

    public void setInstance(BTGetFolderProgress instance) {
        this.instance = instance;
    }
}

