/*
 * Decompiled with CFR 0.152.
 */
package model;

import comm.OBEXHeader;
import comm.OBEXHeaderSet;
import comm.OBEXResponse;
import comm.OBEXSession;
import java.io.IOException;
import local.Local;
import model.BTConnectProgress;
import model.BTDesc;
import util.Kits;
import view.ProgressScreen;

class BTConnectThread
extends Thread {
    private BTDesc bt;
    BTConnectProgress progress;
    ProgressScreen progressScreen;
    OBEXSession session;

    BTConnectThread(BTDesc bt, BTConnectProgress progress, ProgressScreen progressScreen) {
        this.bt = bt;
        this.progress = progress;
        this.progressScreen = progressScreen;
    }

    public void run() {
        String url = this.bt.getFtpURL();
        url = this.replace(url, "btgoep://", "btspp://");
        this.progressScreen.setLabel(String.valueOf(Local.get("conning")) + " " + this.bt.getBtName() + " ...");
        this.progressScreen.setMaxValue(-1);
        this.progressScreen.setValue(2);
        this.progressScreen.setText(String.valueOf(Local.get("waitfor")) + " " + Local.get("authori") + " ...");
        this.session = new OBEXSession(url);
        try {
            this.session.open();
        }
        catch (IOException e) {
            this.progressScreen.setText(String.valueOf(Local.get("conn")) + " " + Local.get("failed") + ", " + Local.get("oor") + "?");
            Kits.sleep(5000);
            try {
                this.session.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.progress.onCompleted(0, this.bt.getBtName(), this.session);
            return;
        }
        OBEXHeaderSet hs = new OBEXHeaderSet();
        hs.setHeader(new OBEXHeader(70, BTConnectProgress.FBUUID));
        int respCode = 0;
        boolean failed = false;
        try {
            OBEXResponse resp = this.session.connect(hs);
            respCode = resp.getRespCode();
            if (respCode != 160) {
                failed = true;
                if (resp.getRespCode() == 198) {
                    this.progressScreen.setText(String.valueOf(Local.get("conn")) + " " + Local.get("rejected"));
                } else if (resp.getRespCode() == 0) {
                    this.progressScreen.setText(String.valueOf(Local.get("conn")) + " " + Local.get("cancelled"));
                } else {
                    this.progressScreen.setText(String.valueOf(Local.get("conn")) + " " + Local.get("failed") + ": " + respCode);
                }
            } else {
                this.progressScreen.setText(String.valueOf(Local.get("conn")) + " " + Local.get("accepted"));
            }
        }
        catch (IOException e) {
            failed = true;
            this.progressScreen.setText(String.valueOf(Local.get("conn")) + " " + Local.get("failed") + ": " + e.toString());
        }
        Kits.sleep(2000);
        if (failed) {
            try {
                this.session.disconnect(null);
                this.session.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.progress.onCompleted(respCode, this.bt.getBtName(), this.session);
    }

    void cancel() {
        if (this.session != null) {
            this.session.cancel();
        }
    }

    String replace(String str, String oldSubstr, String newString) {
        int r = str.indexOf(oldSubstr);
        if (r >= 0) {
            String a = str.substring(0, r);
            String b = str.substring(r + oldSubstr.length());
            str = String.valueOf(a) + newString + b;
        }
        return str;
    }
}

