/*
 * Decompiled with CFR 0.152.
 */
package helper.fsm;

import helper.fsm.Fsm;
import java.util.Vector;

public class State {
    public static int ON_ENTER = 0;
    public static int ON_DO = 1;
    public static int ON_EXIT = 2;
    public static int ON_EVENT = 3;
    String name = "";
    public int numTransitions = 0;
    public int numEvents = 0;
    public int maxEvents = 100;
    public Vector actions = new Vector();
    public Vector transitions = new Vector();

    public State() {
        int i = 0;
        while (i < 10) {
            this.actions.addElement(new Action());
            ++i;
        }
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public void addTransition(String e, State s) {
        if (this.numTransitions < this.maxEvents) {
            this.transitions.addElement(new Transition(e, s));
            ++this.numTransitions;
        }
    }

    public void addAction(int w, String n, String e, int f) {
        if (w < ON_EVENT) {
            ((Action)this.actions.elementAt((int)w)).name = n;
            ((Action)this.actions.elementAt((int)w)).fun = f;
        } else if (this.numEvents < this.maxEvents) {
            ((Action)this.actions.elementAt((int)(w + this.numEvents))).name = n;
            ((Action)this.actions.elementAt((int)(w + this.numEvents))).event = e;
            ((Action)this.actions.elementAt((int)(w + this.numEvents))).fun = f;
            ++this.numEvents;
        }
    }

    public boolean incoming(String e, Fsm f) {
        if (this.numEvents > 0) {
            int i = 0;
            while (i < this.numEvents) {
                Action spec = (Action)this.actions.elementAt(ON_EVENT + i);
                if (spec.event == e) {
                    f.doAction(spec.fun, f);
                    return true;
                }
                ++i;
            }
        } else {
            Action spec = (Action)this.actions.elementAt(ON_ENTER);
            if (spec.fun != 0) {
                f.doAction(spec.fun, f);
            }
        }
        return false;
    }

    public State outgoing(String e, Fsm f) {
        Action action = (Action)this.actions.elementAt(ON_EXIT);
        int i = 0;
        while (i < this.numTransitions) {
            Transition tran = (Transition)this.transitions.elementAt(i);
            if (tran.event.equals(e)) {
                if (action != null && action.fun != 0) {
                    f.doAction(action.fun, f);
                }
                return tran.state;
            }
            ++i;
        }
        return null;
    }

    class Action {
        String name = null;
        String event = null;
        int fun = 0;

        Action() {
        }
    }

    class Transition {
        String event = null;
        State state = null;

        public Transition(String e, State s) {
            this.event = e;
            this.state = s;
        }
    }
}

