/*
 * Decompiled with CFR 0.152.
 */
package helper.fsm;

import helper.fsm.State;
import java.util.Hashtable;

public class Fsm {
    public String event = null;
    public String response = "Idle";
    public State currState = null;
    public State prevState = null;
    public Hashtable states;

    public void addStates(Hashtable st, String initSt) {
        this.states = st;
        this.currState = (State)st.get(initSt);
    }

    public boolean inEvent(String e) {
        if (this.currState != null) {
            return this.currState.incoming(e, this);
        }
        return false;
    }

    public boolean outEvent(String e) {
        if (this.states != null && this.currState != null) {
            this.event = e;
            State temp = this.currState.outgoing(e, this);
            if (temp != null) {
                this.prevState = this.currState;
                this.currState = temp;
                this.currState.incoming(e, this);
                return true;
            }
        }
        this.event = "Unknown event";
        return false;
    }

    public void doAction(int fun, Fsm fsm) {
        switch (fun) {
            case 1: {
                fsm.response = "Powering up...";
                break;
            }
            case 2: {
                fsm.response = "Bender has shut down";
                break;
            }
            case 3: {
                fsm.response = "Bender is now online";
                break;
            }
            case 4: {
                fsm.response = "Activity/Walking";
                break;
            }
            case 5: {
                fsm.response = "Activity/Run";
                break;
            }
            case 6: {
                fsm.response = "Activity/Talking";
            }
        }
    }

    public State getCurrState() {
        return this.currState;
    }

    public State getEnteringState() {
        return this.prevState;
    }
}

