/*
 * Decompiled with CFR 0.152.
 */
package comm;

import comm.OBEXDataStream;
import comm.OBEXHeader;
import comm.OBEXHeaderSet;
import comm.OBEXListener;
import comm.OBEXRequest;
import comm.OBEXResponse;
import java.io.IOException;
import util.Kits;

public class OBEXSession
extends OBEXDataStream {
    static final int PACKET_SIZE = 4096;
    static final int WAITING_TIME = 100;
    private byte[] buf = new byte[4096];
    private byte[] connId = new byte[4];
    private int destPacketSize;
    boolean cancelled;
    static final String SESSION_NOT_CONNECTED = "Session is not connected!";
    OBEXListener listener;

    public OBEXSession(String url) {
        super(url);
    }

    public void setOBEXListener(OBEXListener listener) {
        this.listener = listener;
    }

    public OBEXResponse changeFolder(String folderName) throws IOException {
        if (!this.isConnected()) {
            throw new IOException(SESSION_NOT_CONNECTED);
        }
        if (folderName == null || folderName != null && (folderName.length() == 0 || folderName.equals("."))) {
            return new OBEXResponse(-123);
        }
        OBEXResponse resp = null;
        OBEXHeaderSet hs = new OBEXHeaderSet();
        hs.setHeader(new OBEXHeader(-53, this.connId));
        if (folderName.equals("..")) {
            resp = this.setpath(hs, true, false);
        } else {
            hs.setHeader(new OBEXHeader(1, folderName));
            resp = this.setpath(hs, false, false);
        }
        return resp;
    }

    public OBEXResponse getFolder(String folderName) throws IOException {
        return this.getFile(folderName, null, 0);
    }

    public OBEXResponse getFile(String fileName, int numOfBytes) throws IOException {
        return this.getFile(null, fileName, numOfBytes);
    }

    public OBEXResponse getFile(String folderName, String fileName, int numOfBytes) throws IOException {
        if (!this.isConnected()) {
            throw new IOException(SESSION_NOT_CONNECTED);
        }
        this.cancelled = false;
        OBEXResponse resp = null;
        try {
            if (folderName != null && (resp = this.changeFolder(folderName)).getRespCode() != 160) {
                return resp;
            }
            OBEXHeaderSet hs = new OBEXHeaderSet();
            hs = new OBEXHeaderSet();
            hs.setHeader(new OBEXHeader(-53, this.connId));
            if (fileName == null) {
                hs.setHeader(new OBEXHeader(66, "x-obex/folder-listing"));
            } else {
                hs.setHeader(new OBEXHeader(1, fileName));
            }
            resp = this.get(hs, numOfBytes);
        }
        catch (IOException e) {
            System.err.println("getFolder: " + e.toString());
        }
        catch (Exception e) {
            System.err.println("getFolder: " + e.toString());
        }
        return resp;
    }

    public OBEXResponse putFile(String fileName, String fileType, byte[] content) throws IOException {
        if (!this.isConnected()) {
            throw new IOException(SESSION_NOT_CONNECTED);
        }
        this.cancelled = false;
        OBEXResponse resp = null;
        try {
            OBEXHeaderSet hs = new OBEXHeaderSet();
            hs.setHeader(new OBEXHeader(-53, this.connId));
            hs.setHeader(new OBEXHeader(1, fileName));
            if (fileType == null || fileType.length() == 0) {
                fileType = "application/octet-stream";
            }
            hs.setHeader(new OBEXHeader(66, fileType));
            hs.setHeader(new OBEXHeader(-61, content.length));
            resp = this.put(hs, content);
        }
        catch (IOException e) {
            System.err.println("putFolder: " + e.toString());
        }
        catch (Exception e) {
            System.err.println("putFolder: " + e.toString());
        }
        return resp;
    }

    public OBEXResponse connect(OBEXHeaderSet hs) throws IOException {
        OBEXRequest request = new OBEXRequest(-128);
        request.setHeaderSet(hs);
        byte[] bytes = request.getBytes();
        this.dos.write(bytes);
        this.dos.flush();
        Kits.sleep(100);
        int len = this.dis.available();
        while (len <= 0) {
            if (this.cancelled) break;
            Kits.sleep(1000);
            len = this.dis.available();
        }
        bytes = this.cancelled ? new byte[]{0, 0, 7, 16, 0, 62, -128} : this.readBytes();
        OBEXResponse resp = new OBEXResponse(-128, bytes);
        if (resp.getRespCode() != 160) {
            return resp;
        }
        OBEXHeaderSet rhs = resp.getHeaderSet();
        OBEXHeader connIdHeader = rhs.getHeader((byte)-53);
        System.arraycopy(connIdHeader.getHeaderValue(), 0, this.connId, 0, 4);
        this.destPacketSize = resp.getMaxPacketSize();
        return resp;
    }

    public OBEXResponse put(OBEXHeaderSet hs, byte[] content) throws IOException {
        if (!this.isConnected()) {
            throw new IOException(SESSION_NOT_CONNECTED);
        }
        hs.setHeader(new OBEXHeader(72, new byte[0]));
        OBEXRequest request = new OBEXRequest(2);
        request.setHeaderSet(hs);
        byte[] bytes = request.getBytes();
        this.dos.write(bytes);
        this.dos.flush();
        byte[] resp = this.readBytes();
        int pos = 0;
        int contentLength = content.length;
        int bodyLength = this.destPacketSize - 11;
        while (resp[0] == -112) {
            if (this.cancelled) {
                this.abort();
                break;
            }
            hs = new OBEXHeaderSet();
            hs.setHeader(new OBEXHeader(-53, this.connId));
            if (pos < contentLength) {
                int blen = contentLength - pos;
                if (blen > bodyLength) {
                    blen = bodyLength;
                }
                byte[] body = new byte[blen];
                System.arraycopy(content, pos, body, 0, blen);
                pos += blen;
                hs.setHeader(new OBEXHeader(72, body));
                request = new OBEXRequest(2);
            } else {
                hs.setHeader(new OBEXHeader(73, new byte[0]));
                request = new OBEXRequest(-126);
            }
            request.setHeaderSet(hs);
            bytes = request.getBytes();
            this.dos.write(bytes);
            this.dos.flush();
            Kits.sleep(100);
            resp = this.readBytes();
            if (this.listener == null) continue;
            this.listener.progressUpdate(pos, contentLength);
        }
        OBEXResponse response = new OBEXResponse(2, resp);
        if (this.listener != null) {
            this.listener.progressCompleted(response);
        }
        return response;
    }

    public OBEXResponse get(OBEXHeaderSet hs) throws IOException {
        return this.get(hs, 0);
    }

    public OBEXResponse get(OBEXHeaderSet hs, int numOfBytes) throws IOException {
        if (!this.isConnected()) {
            throw new IOException(SESSION_NOT_CONNECTED);
        }
        OBEXRequest request = new OBEXRequest(-125);
        request.setHeaderSet(hs);
        request.printBytes();
        byte[] bytes = request.getBytes();
        int rcode = 160;
        OBEXResponse response = new OBEXResponse(-125);
        byte[] body = new byte[]{};
        int pos = 0;
        int contentLength = numOfBytes;
        do {
            if (this.cancelled) {
                response = this.abort();
                break;
            }
            this.dos.write(bytes);
            this.dos.flush();
            byte[] resp = this.readBytes();
            response = new OBEXResponse(-125, resp);
            response.printBytes();
            rcode = response.getRespCode();
            OBEXHeaderSet h = response.getHeaderSet();
            OBEXHeader lengthHeader = h.getHeader((byte)-61);
            if (lengthHeader != null) {
                byte[] blen = lengthHeader.getHeaderValue();
                int n = blen.length;
                contentLength = 0;
                int i = 0;
                while (i < n) {
                    contentLength |= (blen[i] & 0xFF) << 8 * (n - i - 1);
                    ++i;
                }
                body = new byte[contentLength];
            }
            if (rcode == 144 || rcode == 160) {
                byte[] b = null;
                if (rcode == 144) {
                    OBEXHeader bodyHeader = h.getHeader((byte)72);
                    if (bodyHeader != null) {
                        b = bodyHeader.getHeaderValue();
                    }
                } else {
                    OBEXHeader endOfBodyHeader = h.getHeader((byte)73);
                    if (endOfBodyHeader != null) {
                        b = endOfBodyHeader.getHeaderValue();
                    }
                }
                if (b != null) {
                    if (body == null) {
                        body = new byte[b.length];
                    } else if (body.length < pos + b.length) {
                        byte[] tmp = new byte[body.length];
                        System.arraycopy(body, 0, tmp, 0, body.length);
                        body = new byte[body.length + b.length];
                        System.arraycopy(tmp, 0, body, 0, tmp.length);
                    }
                    System.arraycopy(b, 0, body, pos, b.length);
                    pos += b.length;
                }
            }
            if (this.listener == null) continue;
            this.listener.progressUpdate(pos, contentLength);
        } while (rcode == 144);
        response.setBody(body);
        if (this.listener != null) {
            this.listener.progressCompleted(response);
        }
        return response;
    }

    public OBEXResponse setpath(OBEXHeaderSet hs, boolean backup, boolean create) throws IOException {
        if (!this.isConnected()) {
            throw new IOException(SESSION_NOT_CONNECTED);
        }
        OBEXRequest request = new OBEXRequest(-123);
        request.setSetpathFlag(backup, create);
        request.setHeaderSet(hs);
        byte[] bytes = request.getBytes();
        OBEXResponse response = null;
        this.dos.write(bytes);
        this.dos.flush();
        byte[] resp = this.readBytes();
        response = new OBEXResponse(-123, resp);
        return response;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public OBEXResponse abort() throws IOException {
        if (!this.isConnected()) {
            new OBEXResponse(-1);
        }
        byte[] resp = null;
        OBEXHeaderSet hs = new OBEXHeaderSet();
        OBEXHeader header = new OBEXHeader(-53, this.connId);
        hs.setHeader(header);
        OBEXRequest request = new OBEXRequest(-1);
        request.setHeaderSet(hs);
        byte[] bytes = request.getBytes();
        this.dos.write(bytes);
        this.dos.flush();
        resp = this.readBytes();
        Kits.sleep(100);
        OBEXResponse response = new OBEXResponse(-1, resp);
        this.cancelled = false;
        return response;
    }

    public OBEXResponse disconnect(OBEXHeaderSet hs) throws IOException {
        if (!this.isConnected()) {
            throw new IOException(SESSION_NOT_CONNECTED);
        }
        OBEXRequest request = new OBEXRequest(-127);
        request.setHeaderSet(hs);
        byte[] bytes = request.getBytes();
        this.dos.write(bytes);
        this.dos.flush();
        byte[] resp = this.readBytes();
        Kits.sleep(100);
        return new OBEXResponse(-127, resp);
    }

    String replace(String str, String oldSubstr, String newString) {
        int r = this.url.indexOf(oldSubstr);
        if (r >= 0) {
            String a = str.substring(0, r);
            String b = str.substring(r + oldSubstr.length());
            str = String.valueOf(a) + newString + b;
        }
        return str;
    }

    byte[] readBytes() throws IOException {
        byte[] resp = new byte[]{};
        int len = this.dis.read(this.buf, 0, 4096);
        if (len >= 3) {
            resp = new byte[len];
            System.arraycopy(this.buf, 0, resp, 0, len);
            int pl = (resp[1] & 0xFF) << 8 | resp[2] & 0xFF;
            if (pl == len) {
                return resp;
            }
            resp = new byte[pl];
            System.arraycopy(this.buf, 0, resp, 0, len);
            int index = len;
            while (index < pl) {
                Kits.sleep(100);
                len = this.dis.read(this.buf, 0, 4096);
                if (len <= 0) continue;
                System.arraycopy(this.buf, 0, resp, index, len);
                index += len;
            }
        }
        return resp;
    }
}

