/*
 * Decompiled with CFR 0.152.
 */
package comm;

import comm.OBEXHeader;
import comm.OBEXHeaderSet;

public class OBEXResponse {
    byte opCode;
    byte respCode;
    int len;
    byte OBEXVersion;
    byte flag;
    int maxPacketSize;
    byte[] body;
    OBEXHeaderSet hs;

    public OBEXResponse(byte opCode) {
        this.opCode = opCode;
        this.respCode = (byte)-96;
    }

    public OBEXHeaderSet getHeaderSet() {
        return this.hs;
    }

    public OBEXResponse(byte opCode, byte[] packet) {
        this.opCode = opCode;
        if (packet == null) {
            return;
        }
        this.respCode = packet[0];
        this.len = (packet[1] & 0xFF) << 8 | packet[2] & 0xFF;
        int offset = 3;
        if (opCode == -128) {
            this.OBEXVersion = packet[3];
            this.flag = packet[4];
            this.maxPacketSize = (packet[5] & 0xFF) << 8 | packet[6] & 0xFF;
            offset = 7;
        }
        this.hs = new OBEXHeaderSet();
        int plen = packet.length;
        while (offset < plen) {
            byte hdcode = packet[offset];
            int d = hdcode & 0xFF;
            if ((d &= 0xC0) == 192) {
                byte[] cbuf = new byte[4];
                System.arraycopy(packet, offset + 1, cbuf, 0, 4);
                OBEXHeader header = new OBEXHeader(hdcode, cbuf);
                this.hs.setHeader(header);
                offset += 5;
            }
            if (d != 0 && d != 64) continue;
            int hdlen = (packet[offset + 1] & 0xFF) << 8 | packet[offset + 2] & 0xFF;
            byte[] cbuf = new byte[hdlen - 3];
            System.out.println("packet length = " + packet.length + ", header length=" + hdlen);
            System.arraycopy(packet, offset + 3, cbuf, 0, hdlen - 3);
            OBEXHeader header = new OBEXHeader(hdcode, cbuf);
            this.hs.setHeader(header);
            offset += hdlen;
        }
    }

    public byte[] getBytes() {
        if (this.len == 0) {
            return new byte[0];
        }
        byte[] bytes = new byte[this.len];
        bytes[0] = this.respCode;
        bytes[1] = (byte)(this.len >> 8);
        bytes[2] = (byte)this.len;
        int offset = 3;
        if (this.opCode == -128) {
            bytes[3] = this.OBEXVersion;
            bytes[4] = this.flag;
            bytes[5] = (byte)(this.maxPacketSize >>> 8);
            bytes[6] = (byte)this.maxPacketSize;
            offset = 7;
        }
        if (this.hs != null) {
            System.arraycopy(this.hs.getBytes(), 0, bytes, offset, this.hs.size());
        }
        return bytes;
    }

    public byte[] getBody() {
        return this.body;
    }

    public byte getFlag() {
        return this.flag;
    }

    public int getLen() {
        return this.len;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public byte getOBEXVersion() {
        return this.OBEXVersion;
    }

    public int getRespCode() {
        return this.respCode & 0xFF;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void printBytes() {
    }

    public byte getOpCode() {
        return this.opCode;
    }
}

