/*
 * Decompiled with CFR 0.152.
 */
package comm;

import comm.OBEXHeaderSet;

public class OBEXRequest {
    public static final byte UNKNOWN = 0;
    public static final byte CONNECT = -128;
    public static final byte DISCONNECT = -127;
    public static final byte PUT = 2;
    public static final byte FINAL_PUT = -126;
    public static final byte GET = -125;
    public static final byte SETPATH = -123;
    public static final byte ABORT = -1;
    byte opCode;
    byte setpathFlag = (byte)2;
    byte OBEXVersion = (byte)16;
    int maxPacketSize = 4096;
    OBEXHeaderSet headerSet;

    public OBEXRequest(byte opCode) {
        this.opCode = opCode;
    }

    public void setHeaderSet(OBEXHeaderSet headerSet) {
        this.headerSet = headerSet;
    }

    public byte[] getBytes() {
        int offset = 3;
        int len = 0;
        if (this.headerSet != null) {
            len = this.headerSet.size();
        }
        int size = len;
        size = this.opCode == -128 ? (size += 7) : (this.opCode == -123 ? (size += 5) : (size += 3));
        byte[] bytes = new byte[size];
        bytes[0] = this.opCode;
        bytes[1] = (byte)(size >> 8);
        bytes[2] = (byte)size;
        if (this.opCode == -128) {
            bytes[3] = this.OBEXVersion;
            bytes[4] = 0;
            bytes[5] = (byte)(this.maxPacketSize >>> 8);
            bytes[6] = (byte)this.maxPacketSize;
            offset = 7;
        } else if (this.opCode == -123) {
            bytes[3] = this.setpathFlag;
            bytes[4] = 0;
            offset = 5;
        }
        if (this.headerSet != null) {
            System.arraycopy(this.headerSet.getBytes(), 0, bytes, offset, len);
        }
        return bytes;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public void setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }

    public void setSetpathFlag(boolean backup, boolean create) {
        this.setpathFlag = !backup && !create ? (byte)2 : (backup && !create ? (byte)3 : (!backup && create ? (byte)0 : 1));
    }

    public byte getSetpathFlag() {
        return this.setpathFlag;
    }

    public OBEXHeaderSet getHeaderSet() {
        return this.headerSet;
    }

    public void printBytes() {
    }
}

