/*
 * Decompiled with CFR 0.152.
 */
package comm;

import comm.OBEXHeader;

public class OBEXHeaderSet {
    public static final int UNKNOWN_INDEX = 0;
    public static final int COUNT_INDEX = 1;
    public static final int NAME_INDEX = 2;
    public static final int TYPE_INDEX = 3;
    public static final int LENGTH_INDEX = 4;
    public static final int TIME_INDEX = 5;
    public static final int DESCRIPTION_INDEX = 6;
    public static final int TARGET_INDEX = 7;
    public static final int HTTP_INDEX = 8;
    public static final int BODY_INDEX = 9;
    public static final int END_OF_BODY_INDEX = 10;
    public static final int WHO_INDEX = 11;
    public static final int CONNECTION_ID_INDEX = 12;
    public static final int APP_PARAMETERS_INDEX = 13;
    public static final int AUTH_CHALLENG_INDEX = 14;
    public static final int AUTH_RESPONSE_INDEX = 15;
    public static final int HEADER_SIZE = 16;
    public static final byte UNKNOWN = 0;
    public static final byte COUNT = -64;
    public static final byte NAME = 1;
    public static final byte TYPE = 66;
    public static final byte LENGTH = -61;
    public static final byte TIME = 68;
    public static final byte DESCRIPTION = 5;
    public static final byte TARGET = 70;
    public static final byte HTTP = 71;
    public static final byte BODY = 72;
    public static final byte END_OF_BODY = 73;
    public static final byte WHO = 74;
    public static final byte CONNECTION_ID = -53;
    public static final byte APP_PARAMETERS = 76;
    public static final byte AUTH_CHALLENG = 77;
    public static final byte AUTH_RESPONSE = 78;
    public static final byte[] HEADER_BYTE;
    private OBEXHeader[] headers = new OBEXHeader[16];
    private int[] order = new int[16];
    private int headerCount = 0;

    static {
        byte[] byArray = new byte[16];
        byArray[1] = -64;
        byArray[2] = 1;
        byArray[3] = 66;
        byArray[4] = -61;
        byArray[5] = 68;
        byArray[6] = 5;
        byArray[7] = 70;
        byArray[8] = 71;
        byArray[9] = 72;
        byArray[10] = 73;
        byArray[11] = 74;
        byArray[12] = -53;
        byArray[13] = 76;
        byArray[14] = 77;
        byArray[15] = 78;
        HEADER_BYTE = byArray;
    }

    public OBEXHeaderSet() {
        int i = 0;
        while (i < 16) {
            this.order[i] = -1;
            ++i;
        }
    }

    public void setHeader(OBEXHeader header) {
        int idx = OBEXHeaderSet.getHeaderIndex(header.getHeaderCode());
        int i = 0;
        while (i < this.headerCount) {
            if (this.order[i] == idx) break;
            ++i;
        }
        if (i == this.headerCount) {
            this.order[this.headerCount++] = idx;
        }
        this.headers[idx] = header;
    }

    public OBEXHeader[] getHeaders() {
        return this.headers;
    }

    public OBEXHeader getHeader(byte header) {
        return this.headers[OBEXHeaderSet.getHeaderIndex(header)];
    }

    public OBEXHeader getHeader(int headerIndex) {
        return this.headers[headerIndex];
    }

    public int size() {
        int len = 0;
        int i = 1;
        while (i < 16) {
            if (this.headers[i] != null) {
                len += this.headers[i].size();
            }
            ++i;
        }
        return len;
    }

    public byte[] getBytes() {
        int len = this.size();
        byte[] bytes = new byte[len];
        int offset = 0;
        int i = 0;
        while (i < this.headerCount) {
            int j = this.order[i];
            if (this.headers[j] != null) {
                int hsize = this.headers[j].size();
                System.arraycopy(this.headers[j].getBytes(), 0, bytes, offset, hsize);
                offset += hsize;
            }
            ++i;
        }
        return bytes;
    }

    public static int getHeaderIndex(byte header) {
        if (header == 0) {
            return 0;
        }
        if (header == -64) {
            return 1;
        }
        if (header == 1) {
            return 2;
        }
        if (header == 66) {
            return 3;
        }
        if (header == -61) {
            return 4;
        }
        if (header == 68) {
            return 5;
        }
        if (header == 5) {
            return 6;
        }
        if (header == 70) {
            return 7;
        }
        if (header == 71) {
            return 8;
        }
        if (header == 72) {
            return 9;
        }
        if (header == 73) {
            return 10;
        }
        if (header == 74) {
            return 11;
        }
        if (header == -53) {
            return 12;
        }
        if (header == 76) {
            return 13;
        }
        if (header == 77) {
            return 14;
        }
        if (header == 78) {
            return 15;
        }
        return 0;
    }
}

