/*
 * Decompiled with CFR 0.152.
 */
package comm;

public class OBEXHeader {
    byte headerCode = 0;
    byte[] headerValue;

    public OBEXHeader(byte headerCode, String val) {
        this.headerCode = headerCode;
        byte code = headerCode;
        int d = code & 0xC0;
        if (d == 0) {
            byte[] bytes = null;
            char[] ac = val.toCharArray();
            bytes = new byte[ac.length * 2 + 2];
            int i = 0;
            while (i < ac.length) {
                bytes[i * 2] = (byte)(ac[i] >> 8);
                bytes[i * 2 + 1] = (byte)ac[i];
                ++i;
            }
            bytes[ac.length * 2] = 0;
            bytes[ac.length * 2 + 1] = 0;
            this.headerValue = bytes;
        } else {
            byte[] b = val.getBytes();
            this.headerValue = new byte[b.length + 1];
            System.arraycopy(b, 0, this.headerValue, 0, b.length);
            this.headerValue[b.length] = 0;
        }
    }

    public OBEXHeader(byte headerCode, byte[] val) {
        this.headerCode = headerCode;
        this.headerValue = val;
    }

    public OBEXHeader(byte headerCode, int val) {
        this.headerCode = headerCode;
        byte[] bytes = new byte[]{(byte)(val >> 24), (byte)(val >> 16), (byte)(val >> 8), (byte)val};
        this.headerValue = bytes;
    }

    public byte[] getBytes() {
        byte code = this.headerCode;
        int d = code & 0xC0;
        byte[] bytes = null;
        if (d == 192) {
            bytes = new byte[this.headerValue.length + 1];
            bytes[0] = this.headerCode;
            System.arraycopy(this.headerValue, 0, bytes, 1, this.headerValue.length);
        }
        if (d == 0 || d == 64) {
            int plen = this.headerValue.length + 3;
            bytes = new byte[plen];
            bytes[0] = this.headerCode;
            bytes[1] = (byte)(plen >> 8);
            bytes[2] = (byte)plen;
            System.arraycopy(this.headerValue, 0, bytes, 3, this.headerValue.length);
        }
        return bytes;
    }

    public int size() {
        byte code = this.headerCode;
        int d = code & 0xC0;
        if (d == 192) {
            return this.headerValue.length + 1;
        }
        if (d == 0 || d == 64) {
            return this.headerValue.length + 3;
        }
        return 0;
    }

    public byte getHeaderCode() {
        return this.headerCode;
    }

    public void setHeaderCode(byte headerCode) {
        this.headerCode = headerCode;
    }

    public byte[] getHeaderValue() {
        return this.headerValue;
    }

    public void setHeaderValue(byte[] headerValue) {
        this.headerValue = headerValue;
    }
}

