/*
 * Decompiled with CFR 0.152.
 */
package comm;

import comm.AbortThread;
import comm.BTServiceListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import util.Kits;
import view.BWAlert;
import view.ProgressScreen;

public class BTDiscovery
implements Runnable,
DiscoveryListener {
    public static int BT_OBJECT_PUSH_PROFILE_UUID = 4357;
    public static int BT_FILE_TRANSFER_PROFILE_UUID = 4358;
    Vector devices = new Vector();
    Vector classCodes;
    Vector records = new Vector();
    Vector servListeners;
    AbortThread cancelThread;
    ProgressScreen ps;
    int transId = -1;
    boolean stopSearch = false;
    boolean discoveryCompleted = true;
    public static UUID oppUUID = new UUID((long)BT_OBJECT_PUSH_PROFILE_UUID);
    public static UUID ftpUUID = new UUID((long)BT_FILE_TRANSFER_PROFILE_UUID);

    public BTDiscovery() {
        this.classCodes = new Vector();
        this.servListeners = new Vector();
    }

    public void setProgressScreen(ProgressScreen ps) {
        this.ps = ps;
    }

    public void addBTServiceListener(BTServiceListener listener) {
        this.servListeners.addElement(listener);
    }

    public void cancel() {
        this.cancelDeviceInquiry();
        this.cancelServiceInquiry();
        this.stopSearch = true;
    }

    void cancelDeviceInquiry() {
        try {
            if (LocalDevice.getLocalDevice().getDiscoveryAgent().cancelInquiry((DiscoveryListener)this)) {
                this.cancelThread.inquiryCompleted = true;
            }
        }
        catch (BluetoothStateException bse) {
            BWAlert.errorAlert("cancelDeviceInquiry(): BluetoothStateException - " + (Object)((Object)bse));
        }
    }

    void cancelServiceInquiry() {
        try {
            LocalDevice.getLocalDevice().getDiscoveryAgent().cancelServiceSearch(this.transId);
        }
        catch (BluetoothStateException bse) {
            BWAlert.errorAlert("cancelServiceInquiry(): BluetoothStateException - " + (Object)((Object)bse));
        }
    }

    public void run() {
        BTServiceListener listener;
        this.discoveryCompleted = false;
        this.devices.removeAllElements();
        this.classCodes.removeAllElements();
        this.records.removeAllElements();
        this.deviceInquiry();
        int i = 0;
        while (i < this.servListeners.size()) {
            listener = (BTServiceListener)this.servListeners.elementAt(i);
            listener.deviceInquiryCompleted(this.devices, this.classCodes);
            ++i;
        }
        if (!this.stopSearch) {
            this.serviceInquiry();
        }
        i = 0;
        while (i < this.servListeners.size()) {
            listener = (BTServiceListener)this.servListeners.elementAt(i);
            listener.serviceInquiryCompleted(this.records);
            ++i;
        }
        this.discoveryCompleted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deviceInquiry() {
        if (this.ps != null) {
            this.ps.setText("Device inquiry...");
        }
        this.cancelThread = new AbortThread(this);
        this.cancelThread.start();
        BTDiscovery bTDiscovery = this;
        synchronized (bTDiscovery) {
            try {
                DiscoveryAgent da = LocalDevice.getLocalDevice().getDiscoveryAgent();
                da.startInquiry(10390323, (DiscoveryListener)this);
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (BluetoothStateException e) {
                BWAlert.errorAlert("Has Bluetooth powered on? " + e.toString());
                this.cancelThread.inquiryCompleted = true;
                Kits.sleep(3000);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceInquiry() {
        if (this.ps != null) {
            this.ps.insertTextField("Service inquiry...");
        }
        Enumeration enum_d = this.devices.elements();
        while (enum_d.hasMoreElements()) {
            BTDiscovery bTDiscovery = this;
            synchronized (bTDiscovery) {
                try {
                    RemoteDevice d = (RemoteDevice)enum_d.nextElement();
                    String btName = d.getFriendlyName(false);
                    this.transId = LocalDevice.getLocalDevice().getDiscoveryAgent().searchServices(new int[]{256, 257, 160, 161, 162, 163, 164}, new UUID[]{ftpUUID}, d, (DiscoveryListener)this);
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.transId = LocalDevice.getLocalDevice().getDiscoveryAgent().searchServices(new int[]{256, 257, 160, 161, 162, 163, 164}, new UUID[]{oppUUID}, d, (DiscoveryListener)this);
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                catch (BluetoothStateException e) {
                    BWAlert.errorAlert("deviceInquiry(): BluetoothStateException - " + e.toString());
                }
                catch (IOException e) {
                    BWAlert.errorAlert("deviceInquiry(): IOException - " + e.toString());
                }
            }
            Kits.sleep(1000);
        }
    }

    public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
        if (this.ps != null) {
            try {
                String name = btDevice.getFriendlyName(false);
                this.ps.insertTextField(name);
            }
            catch (IOException e) {
                BWAlert.errorAlert("deviceDiscovered: IOException - " + e.toString());
            }
        }
        this.devices.addElement(btDevice);
        this.classCodes.addElement(cod);
    }

    public synchronized void inquiryCompleted(int discType) {
        switch (discType) {
            case 0: {
                String txt = "INQUIRY_COMPLETED";
                break;
            }
            case 5: {
                String txt = "INQUIRY_TERMINATED";
                break;
            }
            case 7: {
                String txt = "INQUIRY_ERROR";
                break;
            }
            default: {
                String txt = "n/a";
            }
        }
        this.cancelThread.inquiryCompleted = true;
        this.notifyAll();
    }

    public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
        int i = 0;
        while (i < servRecord.length) {
            this.records.addElement(servRecord[i]);
            ++i;
        }
    }

    public synchronized void serviceSearchCompleted(int transID, int respCode) {
        switch (respCode) {
            case 1: {
                String txt = "SERVICE_SEARCH_COMPLETED";
                break;
            }
            case 2: {
                String txt = "SERVICE_SEARCH_TERMINATED";
                break;
            }
            case 3: {
                String txt = "SERVICE_SEARCH_ERROR";
                break;
            }
            case 4: {
                String txt = "SERVICE_SEARCH_NO_RECORDS";
                break;
            }
            case 6: {
                String txt = "SERVICE_SEARCH_DEVICE_NOT_REACHABLE";
                break;
            }
            default: {
                String txt = "n/a";
            }
        }
        this.notifyAll();
    }

    public boolean isDiscoveryCompleted() {
        return this.discoveryCompleted;
    }
}

