/*
 * Decompiled with CFR 0.152.
 */
package gameboy.ui;

import gameboy.core.GameBoy;
import gameboy.ui.Clock;
import gameboy.ui.Joypad;
import gameboy.ui.Main;
import gameboy.ui.Sound;
import gameboy.ui.Store;
import gameboy.ui.Video;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

public class Emulator
extends GameCanvas
implements Runnable {
    private static final int GAMEBOY_CLOCK = 0x100000;
    private static final int TIMER_CLOCK = 1000;
    private String cartridgeName;
    private Video video;
    private Sound sound;
    private Joypad joypad;
    private Store store;
    private Clock clock;
    private GameBoy gameboy;
    private long time;
    private String title;
    private Thread thread;
    private Main parent;
    private int threadPriority = 5;
    private volatile boolean quit;
    private volatile boolean paused;
    private volatile boolean restored;
    private long elapsed;

    public Emulator(Main parent) {
        super(false);
        this.parent = parent;
        this.video = new Video(this, 160, 144);
        this.sound = new Sound(22050, 1, 8);
        this.joypad = new Joypad(this);
        this.store = new Store();
        this.clock = new Clock();
        this.gameboy = new GameBoy(this.video, this.sound, this.joypad, this.store, this.clock);
        this.thread = new Thread(this);
        this.thread.setPriority(this.threadPriority);
        this.title = null;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == 48) {
            this.parent.showMainMenu();
        }
    }

    public final void setKeyCodes(int[] keyCodes) {
        this.joypad.setKeyCodes(keyCodes);
    }

    public final void setFullGameBoyState(byte[] state, int offset) {
        this.gameboy.setFullGameBoyState(state, offset);
    }

    public final byte[] getFullGameBoyState() {
        return this.gameboy.getFullGameBoyState();
    }

    public final void setCentered(boolean horizontal, boolean vertical) {
        if (!horizontal) {
            this.video.setX(0);
        } else {
            this.video.setX(this.getWidth() / 2 - this.video.getWidth() / 2);
        }
        if (!vertical) {
            this.video.setY(0);
        } else {
            this.video.setY(this.getHeight() / 2 - this.video.getHeight() / 2);
        }
        this.video.clearScreen();
    }

    public final void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
        if (this.thread != null) {
            this.thread.setPriority(threadPriority);
        }
    }

    public final void setFrameSkip(int frameSkip) {
        this.gameboy.setFrameSkip(frameSkip);
    }

    public final Graphics getGraphics() {
        return super.getGraphics();
    }

    public final void load(String cartridgeName) {
        this.cartridgeName = cartridgeName;
        Main.log("Loading: " + cartridgeName);
        this.gameboy.load(cartridgeName);
    }

    public final String getCartridgeName() {
        return this.cartridgeName;
    }

    public final void save(String cartridgeName) {
        this.gameboy.save(cartridgeName);
    }

    public final void start() {
        if (!this.thread.isAlive()) {
            this.quit = false;
            this.thread.start();
        }
    }

    public final void setRestored(boolean restored) {
        this.restored = restored;
    }

    public final void pause() {
        this.stop();
        this.paused = true;
    }

    public final void resume() {
        if (this.thread == null) {
            this.paused = true;
            this.thread = new Thread(this);
            this.thread.setPriority(this.threadPriority);
            this.thread.start();
            while (this.paused) {
                Emulator emulator = this;
                emulator.thread.yield();
            }
            return;
        }
        if (!this.thread.isAlive()) {
            this.thread.start();
        }
    }

    public final boolean isPaused() {
        return this.paused;
    }

    public final void stop() {
        this.quit = true;
        if (this.thread == null) {
            return;
        }
        while (this.thread.isAlive()) {
            Emulator emulator = this;
            emulator.thread.yield();
        }
        this.thread = null;
    }

    public final void reset() {
        this.gameboy.reset();
    }

    public final void run() {
        try {
            if (this.paused) {
                this.time = Emulator.getTimer();
            } else {
                this.time = Emulator.getTimer();
                if (!this.restored) {
                    this.reset();
                    Main.log("Started: " + this.cartridgeName);
                }
                this.elapsed = Emulator.getTimer() - this.time;
            }
            this.gameboy.start();
            this.restored = false;
            this.quit = false;
            this.paused = false;
            while (!this.quit) {
                this.gameboy.emulate(32768);
                this.elapsed = Emulator.getTimer() - this.time;
                Emulator.sleep(31L - this.elapsed);
                this.time += this.elapsed;
            }
            this.gameboy.stop();
        }
        catch (Exception x) {
            Main.log(x.toString());
        }
    }

    private static final long getTimer() {
        return System.currentTimeMillis();
    }

    public static final void sleep(long millis) {
        if (millis > 0L) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

