/*
 * Decompiled with CFR 0.152.
 */
package gameboy.core;

public class RAM {
    private byte[] wram = new byte[8192];
    private byte[] hram = new byte[128];

    public RAM() {
        this.reset();
    }

    public void setWRam(byte[] wram) {
        System.arraycopy(wram, 0, this.wram, 0, 8192);
    }

    public void setHRam(byte[] hram) {
        System.arraycopy(hram, 0, this.hram, 0, 128);
    }

    public byte[] getWRam() {
        return this.wram;
    }

    public byte[] getHRam() {
        return this.hram;
    }

    public final void reset() {
        int index;
        for (index = 0; index < this.wram.length; ++index) {
            this.wram[index] = 0;
        }
        for (index = 0; index < this.hram.length; ++index) {
            this.hram[index] = 0;
        }
    }

    public final void write(int address, int data) {
        if (address >= 49152 && address <= 65023) {
            this.wram[address & 0x1FFF] = (byte)data;
        } else if (address >= 65408 && address <= 65534) {
            this.hram[address & 0x7F] = (byte)data;
        }
    }

    public final int read(int address) {
        if (address >= 49152 && address <= 65023) {
            return this.wram[address & 0x1FFF] & 0xFF;
        }
        if (address >= 65408 && address <= 65534) {
            return this.hram[address & 0x7F] & 0xFF;
        }
        return 255;
    }
}

