/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Screen;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordListener;
import javax.microedition.rms.RecordStore;

public class NoteHax
extends MIDlet
implements ItemCommandListener,
CommandListener,
RecordListener {
    List mainForm = new List("NoteHax", 3);
    List sendList;
    Display display;
    Command cmdAdd;
    Command cmdDelete;
    Command cmdAbout;
    Command cmdSend;
    AddScreen addScreen;
    ContentScreen contentScreen;
    ContentScreen editScreen;
    Note nNote;
    Note tempNote;
    Form viewForm;
    SendResult sendResult;
    Hashtable noteList = new Hashtable(20);

    public NoteHax() {
        this.cmdAdd = new Command("Add", 1, 2);
        this.cmdDelete = new Command("Delete", 1, 3);
        this.cmdSend = new Command("Send", 1, 65);
        this.cmdAbout = new Command("About", 5, 99);
        this.mainForm.addCommand(new Command("Exit", 7, 100));
        this.mainForm.addCommand(this.cmdAdd);
        this.mainForm.addCommand(this.cmdDelete);
        this.mainForm.addCommand(this.cmdAbout);
        this.addScreen = new AddScreen("add Item");
        this.contentScreen = new ContentScreen(this.addScreen.getString() + "'s content", "", 1000, 0);
        this.mainForm.setCommandListener((CommandListener)this);
    }

    public void startApp() {
        if (this.display == null) {
            this.display = Display.getDisplay((MIDlet)this);
            this.display.setCurrent((Displayable)new SplashCanvas(this));
            this.loadNote();
            this.sendResult = new SendResult(new Note("title", "content"));
        } else {
            this.display.setCurrent((Displayable)this.mainForm);
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
        this.notifyDestroyed();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getCommandType() == 7) {
            this.destroyApp(false);
        } else if (command == this.cmdAdd) {
            this.addScreen.setString("");
            this.addScreen.setCommandListener(this);
            this.display.setCurrent((Displayable)this.addScreen);
        } else if (command == this.addScreen.cmdOK) {
            if (this.addScreen.getString().length() < 3) {
                Alert alert = new Alert("Information", "Please fill in the title field", null, AlertType.INFO);
                alert.setTimeout(1750);
                this.display.setCurrent(alert, (Displayable)this.addScreen);
                return;
            }
            if (this.noteList.containsKey(this.addScreen.getString())) {
                Alert alert = new Alert("Information", "Title already exists! Please choose another title", null, AlertType.INFO);
                alert.setTimeout(1200);
                this.addScreen.setString("");
                this.display.setCurrent(alert, (Displayable)this.addScreen);
                return;
            }
            this.contentScreen = new ContentScreen(this.addScreen.getString() + "'s content", "", 1000, 0);
            this.contentScreen.setCommandListener(this);
            this.display.setCurrent((Displayable)this.contentScreen);
        } else if (command == this.contentScreen.cmdSave) {
            this.nNote = new Note(this.addScreen.getString(), this.contentScreen.getString());
            this.saveNote();
            this.display.setCurrent((Displayable)this.mainForm);
        } else if (command == this.cmdDelete) {
            if (this.mainForm.size() > 0) {
                this.display.setCurrent((Displayable)new ConfirmDialog("Delete Confirmation", (Screen)this.mainForm, this));
            }
        } else if (command == List.SELECT_COMMAND && displayable == this.mainForm) {
            String string = this.mainForm.getString(this.mainForm.getSelectedIndex());
            this.viewNote((Note)this.noteList.get(string));
        } else if (command.getCommandType() == 2 || command.getCommandType() == 3) {
            this.display.setCurrent((Displayable)this.mainForm);
        } else if (command == this.cmdAbout) {
            AboutForm aboutForm = new AboutForm("About", "NoteHax " + this.getAppProperty("MIDlet-Version"), "/i.png");
            aboutForm.setCopyright("Mohammad Hafiz", "2009");
            aboutForm.setHyperlink("http://notehax.googlecode.com", this);
            aboutForm.setCommandListener(this);
            aboutForm.append("For storing random notes and rants\n\nThis program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License version 2.0");
            this.display.setCurrent((Displayable)aboutForm);
        } else if (command.getLabel().equals("Edit")) {
            this.editScreen = new ContentScreen("Editing " + this.viewForm.getTitle(), "", 1000, 0);
            this.editScreen.setCommandListener(this);
            Note note = (Note)this.noteList.get(this.viewForm.getTitle());
            this.editScreen.setString(note.content);
            this.editScreen.record = note.recordID;
            this.editScreen.setCommandListener(this);
            this.display.setCurrent((Displayable)this.editScreen);
        } else if (command == this.cmdSend) {
            this.sendResult = new SendResult(this.tempNote);
            this.sendResult.tfPhoneNo.setItemCommandListener((ItemCommandListener)this);
            this.sendResult.setCommandListener(this);
            this.display.setCurrent((Displayable)this.sendResult);
        } else if (command == this.editScreen.cmdSave) {
            this.nNote = new Note(this.viewForm.getTitle(), this.editScreen.getString());
            this.nNote.recordID = this.editScreen.record;
            this.editNote(this.nNote);
            this.display.setCurrent((Displayable)this.mainForm);
        }
    }

    public void commandAction(Command command, Item item) {
        if (command == this.sendResult.cmdSMS) {
            if (this.sendResult.getPhoneNo().length() < 5) {
                Alert alert = new Alert("Error", "Please enter destination phone number", null, AlertType.WARNING);
                this.display.setCurrent(alert, (Displayable)this.sendResult);
                return;
            }
            new SendSMS(this).start();
        }
    }

    public void saveNote() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"notes", (boolean)true);
            recordStore.addRecordListener((RecordListener)this);
            recordStore.addRecord(this.nNote.read(), 0, this.nNote.read().length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            System.out.println("saveNote " + exception.toString());
        }
    }

    public void editNote(Note note) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"notes", (boolean)true);
            recordStore.addRecordListener((RecordListener)this);
            recordStore.setRecord(note.recordID, note.read(), 0, note.read().length);
            recordStore.closeRecordStore();
            this.noteList.remove(note.title);
            this.noteList.put(note.title, note);
        }
        catch (Exception exception) {
            System.out.println("editNote " + exception.toString());
        }
    }

    public void recordAdded(RecordStore recordStore, int n) {
        this.mainForm.append(this.nNote.title, null);
        this.nNote.recordID = n;
        this.noteList.put(this.nNote.title, this.nNote);
    }

    public void recordChanged(RecordStore recordStore, int n) {
    }

    public void recordDeleted(RecordStore recordStore, int n) {
        this.showAlert("Confirmed", "Note has been deleted", AlertType.CONFIRMATION);
        this.mainForm.delete(this.mainForm.getSelectedIndex());
    }

    public void loadNote() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"notes", (boolean)true);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            int n = 0;
            int n2 = recordEnumeration.numRecords();
            int[] nArray = new int[n2];
            while (recordEnumeration.hasNextElement()) {
                nArray[n] = recordEnumeration.nextRecordId();
                ++n;
            }
            for (int i = 0; i < n; ++i) {
                Note note = new Note("" + i, "");
                note.write(recordStore.getRecord(nArray[i]));
                note.recordID = nArray[i];
                this.noteList.put(note.title, note);
                this.mainForm.append(note.title, null);
            }
            recordEnumeration.destroy();
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            System.out.println("loadNote " + exception.toString());
        }
    }

    public void deleteNote(Note note) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"notes", (boolean)true);
            recordStore.addRecordListener((RecordListener)this);
            recordStore.deleteRecord(note.recordID);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            this.showAlert("Error", "Couldn't delete note: " + exception.toString(), AlertType.WARNING);
            System.out.println("Delete Note " + exception.toString());
        }
    }

    public void loadList() {
        Enumeration enumeration = this.noteList.keys();
        while (enumeration.hasMoreElements()) {
            this.mainForm.append((String)enumeration.nextElement(), null);
        }
    }

    public void viewNote(Note note) {
        this.tempNote = note;
        this.viewForm = new Form(note.title);
        this.viewForm.addCommand(new Command("Back", 2, 100));
        this.viewForm.addCommand(new Command("Edit", 1, 50));
        this.viewForm.addCommand(this.cmdSend);
        this.viewForm.setCommandListener((CommandListener)this);
        this.viewForm.append(note.content);
        this.display.setCurrent((Displayable)this.viewForm);
    }

    public void showList() {
        this.display.setCurrent((Displayable)this.mainForm);
    }

    public void showAlert(String string, String string2, AlertType alertType) {
        Alert alert = new Alert(string, string2, null, alertType);
        alert.setTimeout(-2);
        this.display.setCurrent(alert, (Displayable)this.mainForm);
    }

    public void showAlert(String string) {
        this.showAlert("Error", string, AlertType.WARNING);
    }
}

