/*
 * Decompiled with CFR 0.152.
 */
package graph.eqn;

import graph.core.CalculateException;
import graph.core.Settings;
import graph.eqn.Cosinus;
import graph.eqn.Difference;
import graph.eqn.Expression;
import graph.eqn.Number;
import graph.eqn.UnaryExpression;
import graph.eqn.X;
import graph.utils.Utils;

public class ArcCosinus
extends UnaryExpression {
    private Number number = new Number(0.0);
    private Expression nullpointEqn = new Difference(new Cosinus(new X()), this.number);

    public ArcCosinus(Expression eqn) {
        super(eqn);
    }

    public double getValue(double xValue, double yValue) {
        try {
            double s = this.expr1.getValue(xValue, yValue);
            if (s < -1.0 || s > 1.0) {
                return Double.NaN;
            }
            if (s == -1.0) {
                return Math.PI;
            }
            if (s == 1.0) {
                return 0.0;
            }
            this.number.setNumber(s);
            int nbDecimals = Settings.getNbDecimals();
            double x = Utils.getNullpoint(this.nullpointEqn, 0.0, Math.PI, Utils.pow(0.1, nbDecimals));
            return x;
        }
        catch (CalculateException e) {
            e.printStackTrace();
            return Double.NaN;
        }
    }

    public String getFunctionAsString() {
        return "acos(" + this.expr1.getFunctionAsString() + ")";
    }
}

