/*
 * Decompiled with CFR 0.152.
 */
package graph.core;

import graph.core.Color;
import graph.core.ParseException;
import graph.core.Parser;
import graph.core.PlotterScreen;
import graph.core.Sample;
import graph.core.Settings;
import graph.eqn.Derivate;
import graph.eqn.Equation;
import graph.eqn.Expression;
import graph.eqn.Integral;
import graph.eqn.Number;
import graph.eqn.SecondDerivate;
import graph.eqn.X;
import graph.utils.DebugTools;
import graph.utils.Utils;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class Plotter
extends PlotterScreen {
    public boolean showAxisIntersections;
    public boolean showDerivate;
    public boolean showSecondDerivate;
    public boolean showIntegral;
    private static final int ARROW_SIZE = 4;
    private static final int MARGIN = 3;
    private static final int NB_PIXELS_PER_GRIDLINE = 30;
    public Font font;
    protected Equation[] equations;
    private boolean isInterrupted = false;

    public boolean isInterrupted() {
        return this.isInterrupted;
    }

    public synchronized void setInterrupted(boolean isInterrupted) {
        this.isInterrupted = isInterrupted;
    }

    public Plotter(Sample sample, int screenWidth, int screenHeight) throws ParseException {
        super(sample, screenWidth, screenHeight);
        this.showAxisIntersections = sample.showAxisIntersections;
        this.showDerivate = sample.showDerivate;
        this.showSecondDerivate = sample.showSecondDerivate;
        this.showIntegral = sample.showIntegral;
        this.equations = Parser.parse(sample.equations);
        if (!Settings.debug) {
            this.font = Settings.getDefaultFont();
        }
    }

    public Color getForegroundColor() {
        return Settings.BLACK_BACKGROUND ? Color.WHITE : Color.BLACK;
    }

    public Color getBackgroundColor() {
        return Settings.BLACK_BACKGROUND ? Color.BLACK : Color.WHITE;
    }

    public Color getGridColor() {
        return Settings.BLACK_BACKGROUND ? Color.DARK_GREY : Color.LIGHT_GREY;
    }

    public Equation[] getEquations() {
        return this.equations;
    }

    public void plot(Graphics g) {
        int screenWidth = g.getClipWidth();
        int screenHeight = g.getClipHeight();
        g.setColor(this.getBackgroundColor().getRGBValue());
        g.fillRect(0, 0, screenWidth, screenHeight);
        if (this.font != null) {
            g.setFont(this.font);
        }
        if (!this.isInterrupted() && (Settings.SHOW_GRID || Settings.SHOW_GRID_NUMBERS)) {
            this.plotGrid(g);
        }
        if (!this.isInterrupted()) {
            this.plotEquations(g);
        }
        if (Settings.SHOW_AXIS) {
            this.plotAxes(g);
        }
        if (Settings.SHOW_AXIS_NUMBERS) {
            this.plotAxesNumbers(g);
        }
    }

    public void plotGrid(Graphics graphics) {
        int screenWidth = graphics.getClipWidth();
        int screenHeight = graphics.getClipHeight();
        graphics.setColor(this.getGridColor().getRGBValue());
        int xScreenOrigin = this.getXScreenCoordinateOrigin();
        int yScreenOrigin = this.getYScreenCoordinateOrigin();
        int fontHeight = this.font == null ? 15 : this.font.getHeight();
        double screenHeightCoor = this.getScreenHeightInCoordinate();
        int nbHorizontalLines = screenHeight / 30;
        double yStepsize = Utils.roundOnFiveTwoOrOne(screenHeightCoor / (double)nbHorizontalLines);
        double nbLinesBelowXAxis = (long)(ymin / yStepsize);
        double yStartValue = nbLinesBelowXAxis * yStepsize;
        if (yStepsize > 0.0) {
            double y = yStartValue;
            while (y < ymax) {
                if (this.isInterrupted()) {
                    return;
                }
                int yScreen = this.transformYCoordinateToScreen(y);
                if (Settings.SHOW_GRID) {
                    graphics.drawLine(0, yScreen, screenWidth, yScreen);
                } else {
                    graphics.drawLine(xScreenOrigin - 3, yScreen, xScreenOrigin + 3, yScreen);
                }
                if (Settings.SHOW_GRID_NUMBERS) {
                    if (Settings.SHOW_GRID) {
                        graphics.drawString(Utils.doubleToString(Utils.round(y, this.getNbRelevantYDecimals(2))), xScreenOrigin - 3, yScreen + 3, 24);
                    } else {
                        graphics.drawString(Utils.doubleToString(Utils.round(y, this.getNbRelevantYDecimals(2))), xScreenOrigin - 6, yScreen - fontHeight / 2, 24);
                    }
                }
                y += yStepsize;
            }
        }
        double screenWidthCoor = this.getScreenWidthInCoordinate();
        int nbVerticalLines = screenWidth / 30;
        double xStepsize = Utils.roundOnFiveTwoOrOne(screenWidthCoor / (double)nbVerticalLines);
        double nbLinesLeftOfYAxis = (long)(xmin / xStepsize);
        double xStartValue = nbLinesLeftOfYAxis * xStepsize;
        if (xStepsize > 0.0) {
            double x = xStartValue;
            while (x < xmax) {
                if (this.isInterrupted()) {
                    return;
                }
                int xScreen = this.transformXCoordinateToScreen(x);
                if (Settings.SHOW_GRID) {
                    graphics.drawLine(xScreen, 0, xScreen, screenHeight);
                } else {
                    graphics.drawLine(xScreen, yScreenOrigin - 3, xScreen, yScreenOrigin + 3);
                }
                if (Settings.SHOW_GRID_NUMBERS) {
                    int fontWidth;
                    String text = Utils.doubleToString(Utils.round(x, this.getNbRelevantYDecimals(2)));
                    int n = fontWidth = this.font == null ? 5 : this.font.charsWidth(text.toCharArray(), 0, text.length());
                    if (Settings.SHOW_GRID) {
                        graphics.drawString(text, xScreen - 3, yScreenOrigin + 3, 24);
                    } else {
                        graphics.drawString(text, xScreen + fontWidth / 2, yScreenOrigin + 6, 24);
                    }
                }
                x += xStepsize;
            }
        }
    }

    public void plotAxes(Graphics graphics) {
        int screenWidth = graphics.getClipWidth();
        int screenHeight = graphics.getClipHeight();
        graphics.setColor(this.getForegroundColor().getRGBValue());
        int y = this.getYScreenCoordinateOrigin();
        int x = this.getXScreenCoordinateOrigin();
        if (this.screenCoordinateIsOnScreen(1, y)) {
            graphics.drawLine(0, y, screenWidth, y);
            graphics.fillTriangle(screenWidth, y, screenWidth - 4, y - 4, screenWidth - 4, y + 4);
        }
        if (this.screenCoordinateIsOnScreen(x, 1)) {
            graphics.drawLine(x, 0, x, screenHeight);
            graphics.fillTriangle(x, 0, x - 4, 4, x + 4, 4);
        }
    }

    public void plotAxesNumbers(Graphics graphics) {
        int screenWidth = graphics.getClipWidth();
        int screenHeight = graphics.getClipHeight();
        int fontHeight = graphics.getFont().getHeight();
        graphics.setColor(this.getForegroundColor().getRGBValue());
        int y = this.getYScreenCoordinateOrigin();
        int x = this.getXScreenCoordinateOrigin();
        if (this.screenCoordinateIsOnScreen(0, y)) {
            graphics.drawString(this.getXMinRounded(2), 3, y + 2, 20);
            graphics.drawString(this.getXMaxRounded(2), screenWidth - 4 - 2, y + 2, 24);
        } else if (y < 0) {
            graphics.drawString(this.getXMinRounded(2), 3, 3, 20);
            graphics.drawString(this.getXMaxRounded(2), screenWidth - 3, 3, 24);
        } else {
            graphics.drawString(this.getXMinRounded(2), 3, screenHeight - 3, 36);
            graphics.drawString(this.getXMaxRounded(2), screenWidth - 3, screenHeight - 3, 40);
        }
        if (this.screenCoordinateIsOnScreen(x, 0)) {
            graphics.drawString(this.getYMaxRounded(2), x - 1, 6, 24);
            graphics.drawString(this.getYMinRounded(2), x - 1, screenHeight - 4, 40);
        } else {
            int border = 6 + fontHeight;
            if (x < 0) {
                graphics.drawString(this.getYMinRounded(2), 3, screenHeight - border, 36);
                graphics.drawString(this.getYMaxRounded(2), 3, border, 20);
            } else {
                graphics.drawString(this.getYMinRounded(2), screenWidth - 3, screenHeight - border, 40);
                graphics.drawString(this.getYMaxRounded(2), screenWidth - 3, border, 24);
            }
        }
    }

    public void plotEquations(Graphics graphics) {
        int screenWidth = graphics.getClipWidth();
        if (this.equations == null) {
            return;
        }
        int n = this.equations.length;
        int lastXscreen = 0;
        double lastXfunction = this.transformXCoordinateFromScreen(lastXscreen);
        int[] lastYscreen = new int[n];
        double[] lastYfunction = new double[n];
        double[] lastDerivate = new double[n];
        double[] lastSecondDerivate = new double[n];
        double[] lastIntegral = new double[n];
        Derivate[] derivates = new Derivate[n];
        SecondDerivate[] secondDerivates = new SecondDerivate[n];
        Integral[] integrals = new Integral[n];
        int i = 0;
        while (i < n) {
            if (this.isInterrupted()) {
                return;
            }
            if (this.equations[i] != null) {
                lastYfunction[i] = this.equations[i].getFunctionValue(lastXfunction);
                lastYscreen[i] = this.transformYCoordinateToScreen(lastYfunction[i]);
                lastDerivate[i] = Double.NaN;
                lastSecondDerivate[i] = Double.NaN;
                if (this.showDerivate || this.showSecondDerivate) {
                    derivates[i] = new Derivate(this.equations[i]);
                    secondDerivates[i] = new SecondDerivate(this.equations[i]);
                }
                if (this.showIntegral) {
                    integrals[i] = new Integral((Expression)new Number(0.0), (Expression)new X(), this.equations[i]);
                    lastIntegral[i] = integrals[i].getFunctionValue(lastXfunction);
                }
            }
            ++i;
        }
        int nbSteps = Settings.internalPrecision + 10;
        int stepsize = screenWidth / nbSteps;
        if (stepsize < 1) {
            stepsize = 1;
        }
        DebugTools.printToScreen("NbSteps: " + nbSteps + "\tStepsize: " + stepsize);
        double stepsizeFunction = this.transformXCoordinateFromScreen(stepsize) - this.transformXCoordinateFromScreen(0);
        int xscreen = stepsize;
        while (xscreen < screenWidth) {
            if (this.isInterrupted()) {
                return;
            }
            double xfunction = this.transformXCoordinateFromScreen(xscreen);
            int i2 = 0;
            while (i2 < n) {
                Equation eqn = this.equations[i2];
                if (eqn != null) {
                    String yCoord;
                    String xValue;
                    double xValueToRound;
                    int nbDecimals;
                    int integralColor;
                    int secondDerivateColor;
                    int derivateColor;
                    int functionColor;
                    if (n == 1) {
                        functionColor = Color.RED.getRGBValue();
                        derivateColor = Color.GREEN.getRGBValue();
                        secondDerivateColor = Color.BLUE.getRGBValue();
                        integralColor = Color.YELLOW.getRGBValue();
                    } else {
                        Color functionColorObject = Color.ColorArray[i2 % Color.ColorArray.length];
                        functionColor = functionColorObject.getRGBValue();
                        Color derivateColorObject = functionColorObject.mix(this.getBackgroundColor());
                        derivateColor = derivateColorObject.getRGBValue();
                        secondDerivateColor = derivateColorObject.mix(this.getBackgroundColor()).getRGBValue();
                        integralColor = functionColorObject.mix(this.getForegroundColor()).getRGBValue();
                    }
                    double yfunction = eqn.getFunctionValue(xfunction);
                    double derivate = Double.NaN;
                    if (this.showDerivate | this.showSecondDerivate) {
                        derivate = Settings.PRECISION_DERIVATE ? derivates[i2].getFunctionValue(xfunction) : (yfunction - lastYfunction[i2]) / stepsizeFunction;
                    }
                    double secondDerivate = Double.NaN;
                    if (this.showSecondDerivate) {
                        if (Settings.PRECISION_DERIVATE) {
                            if (this.showSecondDerivate) {
                                secondDerivate = secondDerivates[i2].getFunctionValue(xfunction);
                            }
                        } else {
                            secondDerivate = (derivate - lastDerivate[i2]) / stepsizeFunction;
                        }
                    }
                    double integral = Double.NaN;
                    if (this.showIntegral) {
                        integral = Settings.PRECISION_DERIVATE ? integrals[i2].getValue(xfunction, 0.0) : lastIntegral[i2] + yfunction * stepsizeFunction;
                    }
                    int yscreen = this.transformYCoordinateToScreen(yfunction);
                    graphics.setColor(functionColor);
                    if (Utils.isValidDouble(yfunction) && Utils.isValidDouble(lastYfunction[i2])) {
                        graphics.drawLine(lastXscreen, lastYscreen[i2], xscreen, yscreen);
                    }
                    if (this.showAxisIntersections && Utils.hasOppositeSign(lastYfunction[i2], yfunction)) {
                        try {
                            nbDecimals = Math.min(2, this.getNbRelevantXDecimals(2));
                            xValueToRound = Utils.getNullpoint(this.equations[i2].getExpression(), lastXfunction, xfunction, Utils.pow(0.1, nbDecimals + 2));
                            xValue = Utils.doubleToString(Utils.round(xValueToRound, nbDecimals + 1));
                            graphics.drawString(xValue, xscreen - 4, this.getYScreenCoordinateOrigin() - 2, 40);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (this.showAxisIntersections && Utils.hasOppositeSign(lastXfunction, xfunction) && Utils.round(yfunction, 1) != 0.0 && !(yCoord = this.getYValueRounded((yfunction + lastYfunction[i2]) / 2.0, 1)).equals("0")) {
                        graphics.drawString(yCoord, this.getXScreenCoordinateOrigin() + 4, yscreen, 68);
                    }
                    if (this.showDerivate && Utils.isValidDouble(derivate) && Utils.isValidDouble(lastDerivate[i2])) {
                        graphics.setColor(derivateColor);
                        graphics.drawLine(lastXscreen, this.transformYCoordinateToScreen(lastDerivate[i2]), xscreen, this.transformYCoordinateToScreen(derivate));
                        if (this.showAxisIntersections && Utils.hasOppositeSign(lastDerivate[i2], derivate)) {
                            try {
                                nbDecimals = Math.min(2, this.getNbRelevantXDecimals(2));
                                xValueToRound = Utils.getNullpoint(derivates[i2], lastXfunction, xfunction, Utils.pow(0.1, nbDecimals + 2));
                                xValue = Utils.doubleToString(Utils.round(xValueToRound, nbDecimals + 1));
                                graphics.drawString(xValue, xscreen - 4, this.getYScreenCoordinateOrigin() - 2, 40);
                            }
                            catch (Exception nbDecimals2) {
                                // empty catch block
                            }
                        }
                    }
                    if (this.showSecondDerivate && Utils.isValidDouble(secondDerivate) && Utils.isValidDouble(lastSecondDerivate[i2])) {
                        graphics.setColor(secondDerivateColor);
                        graphics.drawLine(lastXscreen, this.transformYCoordinateToScreen(lastSecondDerivate[i2]), xscreen, this.transformYCoordinateToScreen(secondDerivate));
                        if (this.showAxisIntersections && Utils.hasOppositeSign(lastSecondDerivate[i2], secondDerivate)) {
                            try {
                                int nbDecimals3 = Math.min(2, this.getNbRelevantXDecimals(2));
                                xValueToRound = Utils.getNullpoint(secondDerivates[i2], lastXfunction, xfunction, Utils.pow(0.1, nbDecimals3 + 2));
                                xValue = Utils.doubleToString(Utils.round(xValueToRound, nbDecimals3 + 1));
                                graphics.drawString(xValue, xscreen - 4, this.getYScreenCoordinateOrigin() - 2, 40);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if (this.showIntegral && Utils.isValidDouble(integral) && Utils.isValidDouble(lastIntegral[i2])) {
                        graphics.setColor(integralColor);
                        graphics.drawLine(lastXscreen, this.transformYCoordinateToScreen(lastIntegral[i2]), xscreen, this.transformYCoordinateToScreen(integral));
                    }
                    lastYscreen[i2] = yscreen;
                    lastYfunction[i2] = yfunction;
                    lastDerivate[i2] = derivate;
                    lastSecondDerivate[i2] = secondDerivate;
                    lastIntegral[i2] = integral;
                }
                ++i2;
            }
            lastXscreen = xscreen;
            lastXfunction = xfunction;
            xscreen += stepsize;
        }
    }
}

