/*
 * Decompiled with CFR 0.152.
 */
package graph.core;

import graph.core.ParseException;
import graph.eqn.AbsoluteValue;
import graph.eqn.ArcCosinus;
import graph.eqn.ArcSinus;
import graph.eqn.ArcTangens;
import graph.eqn.Ceil;
import graph.eqn.Combination;
import graph.eqn.ComplexEquation;
import graph.eqn.Cosinus;
import graph.eqn.Degrees;
import graph.eqn.Derivate;
import graph.eqn.Difference;
import graph.eqn.E;
import graph.eqn.Equation;
import graph.eqn.EquationInX;
import graph.eqn.Expression;
import graph.eqn.Faculty;
import graph.eqn.Floor;
import graph.eqn.Fraction;
import graph.eqn.HyperboleCosinus;
import graph.eqn.HyperboleSinus;
import graph.eqn.HyperboleTangens;
import graph.eqn.Integral;
import graph.eqn.Logaritm;
import graph.eqn.Modulo;
import graph.eqn.Number;
import graph.eqn.Opposite;
import graph.eqn.Permutation;
import graph.eqn.Pi;
import graph.eqn.Power;
import graph.eqn.Product;
import graph.eqn.Quotient;
import graph.eqn.Radians;
import graph.eqn.RandomNumber;
import graph.eqn.Round;
import graph.eqn.SimpleEquation;
import graph.eqn.Sinus;
import graph.eqn.SquareRoot;
import graph.eqn.Sum;
import graph.eqn.Tangens;
import graph.eqn.X;
import graph.eqn.Y;
import graph.lang.Phrases;
import graph.utils.Utils;

public class Parser {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static Equation[] parse(String[] input) throws ParseException {
        Equation[] equations = new Equation[input.length];
        int i = 0;
        while (i < input.length) {
            try {
                equations[i] = Parser.parse(input[i], equations);
            }
            catch (ParseException parseException) {
                parseException.setEquationNb(i + 1);
                throw parseException;
            }
            ++i;
        }
        return equations;
    }

    public static Equation parse(String input, Equation[] equations) throws ParseException {
        Equation result;
        if (input == null || input.length() == 0) {
            return null;
        }
        input = input.toLowerCase();
        if ((input = Parser.addImplicitProducts(input)).indexOf(61) < 0) {
            Expression expr = Parser.parseRecursive(input, Equation.adaptEquationsToExpressions(equations));
            result = expr.containsY() ? new ComplexEquation(expr) : new SimpleEquation(expr);
        } else if (input.startsWith("y=")) {
            Expression expr = Parser.parseRecursive(input.substring(2, input.length()), Equation.adaptEquationsToExpressions(equations));
            result = new SimpleEquation(expr);
        } else if (input.startsWith("x=")) {
            Expression expr = Parser.parseRecursive(input.substring(2, input.length()), Equation.adaptEquationsToExpressions(equations));
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("graph.eqn.Y");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!expr.contains(clazz)) {
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("graph.eqn.X");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (expr.contains(clazz2)) {
                    throw new ParseException(Phrases.rightTermCannotContainX);
                }
                result = new EquationInX(expr);
            } else {
                result = new ComplexEquation(new Difference(new X(), expr));
            }
        } else {
            int index = input.indexOf(61);
            Expression expr1 = Parser.parseRecursive(input.substring(0, index), Equation.adaptEquationsToExpressions(equations));
            Expression expr2 = Parser.parseRecursive(input.substring(index + 1, input.length()), Equation.adaptEquationsToExpressions(equations));
            result = new ComplexEquation(new Difference(expr1, expr2));
        }
        return result;
    }

    private static String addImplicitProducts(String input) {
        int i = 1;
        while (i < input.length()) {
            char lastChar = input.charAt(i - 1);
            char currentChar = input.charAt(i);
            if (Parser.isNumber(lastChar) && Parser.isLetter(currentChar)) {
                input = Parser.insert('*', i, input);
            } else if (Parser.isLetter(lastChar) && Parser.isNumber(currentChar)) {
                input = Parser.insert('*', i, input);
            } else if (Parser.isNumber(lastChar) && currentChar == '(') {
                input = Parser.insert('*', i, input);
            } else if (lastChar == ')' && (Parser.isLetter(currentChar) || Parser.isNumber(currentChar))) {
                input = Parser.insert('*', i, input);
            } else if (lastChar == ')' && currentChar == '(') {
                input = Parser.insert('*', i, input);
            }
            ++i;
        }
        return input;
    }

    private static boolean isNumber(char inputChar) {
        return "1234567890.".indexOf(inputChar) != -1;
    }

    private static boolean isLetter(char inputChar) {
        return "abcdefghijklmnopqrstuvwxyz".indexOf(inputChar) != -1;
    }

    private static String insert(char charToInsert, int index, String string) {
        return String.valueOf(string.substring(0, index)) + charToInsert + string.substring(index);
    }

    private static Expression parseRecursive(String input, Expression[] equations) throws ParseException {
        int index = Parser.getFirstIndexOfOperationOutsideBrackets(input = input.trim(), '+');
        if (index != -1) {
            return new Sum(Parser.parseRecursive(input.substring(0, index), equations), Parser.parseRecursive(input.substring(index + 1), equations));
        }
        index = Parser.getLastIndexOfOperationOutsideBrackets(input, '-');
        if (index != -1) {
            if (index == 0) {
                return new Opposite(Parser.parseRecursive(input.substring(1), equations));
            }
            return new Difference(Parser.parseRecursive(input.substring(0, index), equations), Parser.parseRecursive(input.substring(index + 1), equations));
        }
        index = Parser.getFirstIndexOfOperationOutsideBrackets(input, '*');
        if (index != -1) {
            return new Product(Parser.parseRecursive(input.substring(0, index), equations), Parser.parseRecursive(input.substring(index + 1), equations));
        }
        index = Parser.getFirstIndexOfOperationOutsideBrackets(input, '/');
        if (index != -1) {
            return new Quotient(Parser.parseRecursive(input.substring(0, index), equations), Parser.parseRecursive(input.substring(index + 1), equations));
        }
        index = Parser.getFirstIndexOfOperationOutsideBrackets(input, '^');
        if (index != -1) {
            return new Power(Parser.parseRecursive(input.substring(0, index), equations), Parser.parseRecursive(input.substring(index + 1), equations));
        }
        index = Parser.getFirstIndexOfOperationOutsideBrackets(input, '%');
        if (index != -1) {
            return new Modulo(Parser.parseRecursive(input.substring(0, index), equations), Parser.parseRecursive(input.substring(index + 1), equations));
        }
        if (input.endsWith("!")) {
            return new Faculty(Parser.parseRecursive(input.substring(0, input.length() - 1), equations));
        }
        if (input.startsWith("(") && input.endsWith(")")) {
            return Parser.parseRecursive(input.substring(1, input.length() - 1), equations);
        }
        if (input.startsWith("sin(") && input.endsWith(")")) {
            return new Sinus(Parser.parseRecursive(input.substring(4, input.length() - 1), equations));
        }
        if (input.startsWith("cos(") && input.endsWith(")")) {
            return new Cosinus(Parser.parseRecursive(input.substring(4, input.length() - 1), equations));
        }
        if (input.startsWith("tan(") && input.endsWith(")")) {
            return new Tangens(Parser.parseRecursive(input.substring(4, input.length() - 1), equations));
        }
        if (input.startsWith("asin(") && input.endsWith(")")) {
            return new ArcSinus(Parser.parseRecursive(input.substring(5, input.length() - 1), equations));
        }
        if (input.startsWith("acos(") && input.endsWith(")")) {
            return new ArcCosinus(Parser.parseRecursive(input.substring(5, input.length() - 1), equations));
        }
        if (input.startsWith("atan(") && input.endsWith(")")) {
            return new ArcTangens(Parser.parseRecursive(input.substring(5, input.length() - 1), equations));
        }
        if (input.startsWith("sinh(") && input.endsWith(")")) {
            Expression f = Parser.parseRecursive(input.substring(5, input.length() - 1), equations);
            return new HyperboleSinus(f);
        }
        if (input.startsWith("cosh(") && input.endsWith(")")) {
            Expression f = Parser.parseRecursive(input.substring(5, input.length() - 1), equations);
            return new HyperboleCosinus(f);
        }
        if (input.startsWith("tanh(") && input.endsWith(")")) {
            Expression f = Parser.parseRecursive(input.substring(5, input.length() - 1), equations);
            return new HyperboleTangens(f);
        }
        if (input.startsWith("rad(") && input.endsWith(")")) {
            return new Degrees(Parser.parseRecursive(input.substring(4, input.length() - 1), equations));
        }
        if (input.endsWith("\u00a4") || input.endsWith("\u00b0")) {
            return new Degrees(Parser.parseRecursive(input.substring(0, input.length() - 1), equations));
        }
        if (input.startsWith("deg(") && input.endsWith(")")) {
            return new Radians(Parser.parseRecursive(input.substring(4, input.length() - 1), equations));
        }
        if (input.startsWith("sqrt(") && input.endsWith(")")) {
            return new SquareRoot(Parser.parseRecursive(input.substring(5, input.length() - 1), equations));
        }
        if (input.startsWith("sr(") && input.endsWith(")")) {
            return new SquareRoot(Parser.parseRecursive(input.substring(3, input.length() - 1), equations));
        }
        if (input.startsWith("log(") && input.endsWith(")")) {
            return new Logaritm(10.0, Parser.parseRecursive(input.substring(4, input.length() - 1), equations));
        }
        if (input.startsWith("ln(") && input.endsWith(")")) {
            return new Logaritm(Math.E, Parser.parseRecursive(input.substring(3, input.length() - 1), equations));
        }
        if (input.startsWith("abs(") && input.endsWith(")")) {
            return new AbsoluteValue(Parser.parseRecursive(input.substring(4, input.length() - 1), equations));
        }
        if (input.startsWith("c(") && input.endsWith(")")) {
            String parameterString = input.substring(2, input.length() - 1);
            String[] params = Parser.splitParameters(parameterString, ',', 2);
            return new Combination(Parser.parseRecursive(params[0], equations), Parser.parseRecursive(params[1], equations));
        }
        if (input.startsWith("p(") && input.endsWith(")")) {
            String parameterString = input.substring(2, input.length() - 1);
            String[] params = Parser.splitParameters(parameterString, ',', 2);
            return new Permutation(Parser.parseRecursive(params[0], equations), Parser.parseRecursive(params[1], equations));
        }
        if (input.startsWith("d(") && input.endsWith(")")) {
            return new Derivate(Parser.parseRecursive(input.substring(2, input.length() - 1), equations));
        }
        if (input.startsWith("i(") && input.endsWith(")")) {
            String parameterString = input.substring(2, input.length() - 1);
            return Parser.parseIntegral(parameterString, equations);
        }
        if (input.startsWith("floor(") && input.endsWith(")")) {
            return new Floor(Parser.parseRecursive(input.substring(6, input.length() - 1), equations));
        }
        if (input.startsWith("ceil(") && input.endsWith(")")) {
            return new Ceil(Parser.parseRecursive(input.substring(5, input.length() - 1), equations));
        }
        if (input.startsWith("round(") && input.endsWith(")")) {
            return new Round(Parser.parseRecursive(input.substring(6, input.length() - 1), equations));
        }
        if (input.startsWith("frac(") && input.endsWith(")")) {
            return new Fraction(Parser.parseRecursive(input.substring(5, input.length() - 1), equations));
        }
        if (input.startsWith("exp(") && input.endsWith(")")) {
            return new Power(new E(), Parser.parseRecursive(input.substring(4, input.length() - 1), equations));
        }
        if (input.equals("rnd")) {
            return new RandomNumber();
        }
        if (input.equals("pi")) {
            return new Pi();
        }
        if (input.startsWith("pi")) {
            return new Product(new Pi(), Parser.parseRecursive(input.substring(2), equations));
        }
        if (input.equals("e")) {
            return new E();
        }
        if (input.startsWith("e")) {
            return new Product(new E(), Parser.parseRecursive(input.substring(1), equations));
        }
        if (input.endsWith("e")) {
            return new Product(Parser.parseRecursive(input.substring(0, input.length() - 1), equations), new E());
        }
        if (input.equals("x")) {
            return new X();
        }
        if (input.startsWith("x")) {
            return new Product(new X(), Parser.parseRecursive(input.substring(1), equations));
        }
        if (input.endsWith("x")) {
            return new Product(Parser.parseRecursive(input.substring(0, input.length() - 1), equations), new X());
        }
        if (input.equals("y")) {
            return new Y();
        }
        if (input.startsWith("y")) {
            return new Product(new Y(), Parser.parseRecursive(input.substring(1), equations));
        }
        if (input.endsWith("y")) {
            return new Product(Parser.parseRecursive(input.substring(0, input.length() - 1), equations), new Y());
        }
        if (input.startsWith("f(") && input.endsWith(")") && equations != null) {
            try {
                int eqnNumber = Integer.parseInt(input.substring(2, input.length() - 1));
                if (eqnNumber <= 0 || eqnNumber > equations.length) {
                    throw new ParseException(String.valueOf(Phrases.invalidReference) + ": " + input);
                }
                Expression result = equations[eqnNumber - 1];
                if (result == null) {
                    throw new ParseException(Phrases.referToPreviousEquations);
                }
                return result;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new ParseException(String.valueOf(Phrases.invalidPart) + ": " + input);
            }
        }
        if (input.equals("a")) {
            return new Number(6.02214179E23);
        }
        if (input.equals("q")) {
            return new Number(1.602176462E-19);
        }
        if (input.equals("h")) {
            return new Number(6.6260693E-34);
        }
        if (input.equals("f")) {
            return new Number(96485.3);
        }
        if (input.equals("g")) {
            return new Number(6.67428E-11);
        }
        if (input.equals("p")) {
            return new Number(8.854187817E-12);
        }
        if (input.equals("m")) {
            return new Number(1.2566E-6);
        }
        try {
            double number = Double.parseDouble(input);
            return new Number(number);
        }
        catch (NumberFormatException numberFormatException) {
            index = Parser.getIndexAfterNumber(input);
            if (index > 0 && index < input.length() - 1) {
                return new Product(Parser.parseRecursive(input.substring(0, index), equations), Parser.parseRecursive(input.substring(index), equations));
            }
            throw new ParseException(String.valueOf(Phrases.invalidPart) + " \"" + input + "\"");
        }
    }

    private static Expression parseIntegral(String parameterString, Expression[] equations) throws ParseException {
        int nbParams = Utils.getNbOccurences(parameterString, ',') + 1;
        if (nbParams == 1) {
            String[] params = Parser.splitParameters(parameterString, ',', nbParams);
            return new Integral((Expression)new Number(0.0), (Expression)new X(), Parser.parseRecursive(params[0], equations));
        }
        if (nbParams == 2) {
            String[] params = Parser.splitParameters(parameterString, ',', nbParams);
            return new Integral(Parser.parseRecursive(params[0], equations), (Expression)new X(), Parser.parseRecursive(params[1], equations));
        }
        if (nbParams == 3) {
            String[] params = Parser.splitParameters(parameterString, ',', nbParams);
            return new Integral(Parser.parseRecursive(params[0], equations), Parser.parseRecursive(params[1], equations), Parser.parseRecursive(params[2], equations));
        }
        throw new ParseException(Phrases.invalidParameters);
    }

    private static int getFirstIndexOfOperationOutsideBrackets(String s, char operator) throws ParseException {
        int nbOpenedBrackets = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == operator && nbOpenedBrackets == 0) {
                return i;
            }
            if (s.charAt(i) == '(') {
                ++nbOpenedBrackets;
            } else if (s.charAt(i) == ')' && --nbOpenedBrackets < 0) {
                throw new ParseException(Phrases.invalidBrackets);
            }
            ++i;
        }
        return -1;
    }

    private static int getLastIndexOfOperationOutsideBrackets(String s, char operator) throws ParseException {
        int nbOpenedBrackets = 0;
        int i = s.length() - 1;
        while (i >= 0) {
            if (s.charAt(i) == operator && nbOpenedBrackets == 0) {
                return i;
            }
            if (s.charAt(i) == ')') {
                ++nbOpenedBrackets;
            } else if (s.charAt(i) == '(' && --nbOpenedBrackets < 0) {
                throw new ParseException(Phrases.invalidBrackets);
            }
            --i;
        }
        return -1;
    }

    private static int getIndexAfterNumber(String string) {
        if (string == null || string.length() == 0) {
            return -1;
        }
        int index = 0;
        while (".1234567890".indexOf(string.charAt(index)) != -1) {
            ++index;
        }
        return index;
    }

    private static String[] splitParameters(String parameterString, char separationSign, int nbParameters) throws ParseException {
        String stringLeft = parameterString;
        String[] result = new String[nbParameters];
        int i = 0;
        while (i < nbParameters - 1) {
            int index = Parser.getFirstIndexOfOperationOutsideBrackets(stringLeft, separationSign);
            if (index <= 0) {
                throw new ParseException(Phrases.invalidParameters);
            }
            result[i] = stringLeft.substring(0, index);
            stringLeft = stringLeft.substring(index + 1);
            ++i;
        }
        int index = Parser.getFirstIndexOfOperationOutsideBrackets(stringLeft, separationSign);
        if (index != -1 || stringLeft.length() <= 0) {
            throw new ParseException(Phrases.invalidParameters);
        }
        result[nbParameters - 1] = stringLeft;
        return result;
    }
}

