/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.CommandHandler;
import graph.MyDisplayable;
import graph.core.Color;
import graph.core.Settings;
import graph.lang.Phrases;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class WelcomeScreen
extends Canvas
implements CommandListener,
MyDisplayable {
    private Displayable nextDisplayable;
    private Image image;
    private static final int MARGIN = 3;

    public WelcomeScreen(Displayable nextDisplayable) {
        try {
            this.nextDisplayable = nextDisplayable;
            this.init(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public WelcomeScreen() {
        try {
            this.init(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init(boolean useCommandHandler) throws Exception {
        this.setCommandListener(this);
        this.setFullScreenMode(true);
        this.setTitle(Phrases.busy);
        InputStream is = this.getClass().getResourceAsStream("/logo.png");
        this.image = Image.createImage((InputStream)is);
        if (useCommandHandler) {
            this.addCommand(CommandHandler.getGlobalBackCommand());
        }
    }

    public void paint(Graphics g) {
        if (this.image != null) {
            int width = this.getWidth();
            int height = this.getHeight();
            g.setColor(Color.WHITE.getRGBValue());
            g.fillRect(0, 0, width, height);
            g.drawImage(this.image, width / 2, height / 2, 3);
            g.setColor(Color.BLACK.getRGBValue());
            g.setFont(Font.getFont((int)0, (int)0, (int)0));
            g.drawString("v" + Settings.versionNumber, width - 3, 3, 24);
            g.drawString("Tim Vermeiren", 3, 3, 20);
            if (this.nextDisplayable != null) {
                g.drawString(Phrases.pressAnyKey, 3, height - 3, 36);
            } else {
                g.drawString("Loading...", 3, height - 3, 36);
            }
        } else {
            g.drawString("GraphViewer", 0, 0, 20);
        }
    }

    private void goToNext() {
        if (this.nextDisplayable != null) {
            CommandHandler.getInstance().setCurrentDisplayable(this.nextDisplayable);
        }
    }

    public void commandAction(Command command, Displayable disp) {
        this.goToNext();
    }

    protected void keyPressed(int key) {
        this.goToNext();
    }

    protected void keyRepeated(int key) {
        this.goToNext();
    }

    protected void pointerReleased(int arg0, int arg1) {
        this.goToNext();
    }

    protected void pointerDragged(int arg0, int arg1) {
        this.goToNext();
    }

    protected void pointerPressed(int arg0, int arg1) {
        this.goToNext();
    }

    public void show(Displayable previousDisplayable) {
    }

    public void hide(Displayable nextDisplayable) {
    }
}

