/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.CommandHandler;
import graph.GraphViewer;
import graph.MyDisplayable;
import graph.core.Settings;
import graph.lang.Language;
import graph.lang.Phrases;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.StringItem;

public class SettingsForm
extends Form
implements CommandListener,
ItemCommandListener,
MyDisplayable {
    Command cancelCommand = new Command(Phrases.Cancel, 3, 2);
    Command okCommand = new Command(Phrases.OK, 4, 2);
    Command okItemCommand = new Command(Phrases.OK, 8, 2);
    ChoiceGroup language = new ChoiceGroup(Phrases.language, 4);
    ChoiceGroup fontSize = new ChoiceGroup(Phrases.fontSize, 4);
    Gauge nbDrawingStepsGauge = new Gauge(Phrases.nbDrawingSteps, true, 5, 3);
    Gauge nbDecimalsGauge = new Gauge(Phrases.nbDecimals, true, 12, 4);
    StringItem okButton = new StringItem("", Phrases.OK, 2);
    ChoiceGroup visualOptions = new ChoiceGroup(Phrases.visualSettings, 2);
    ChoiceGroup precisionOptions = new ChoiceGroup(Phrases.precisionSettings, 2);

    public SettingsForm() {
        super(Phrases.Settings);
        try {
            this.ndsInit();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    void ndsInit() throws Exception {
        this.setCommandListener(this);
        this.addCommand(this.okCommand);
        this.addCommand(this.cancelCommand);
        int i = 0;
        while (i < Settings.languages.length) {
            Language current = Settings.languages[i];
            this.language.append(current.getNameInEnglish(), null);
            ++i;
        }
        this.append((Item)this.language);
        this.visualOptions.setFitPolicy(1);
        this.visualOptions.append(Phrases.blackBackground, null);
        this.visualOptions.append(Phrases.fullScreenMode, null);
        this.visualOptions.append(Phrases.showGrid, null);
        this.visualOptions.append(Phrases.showGridNumbers, null);
        this.visualOptions.append(Phrases.showAxis, null);
        this.visualOptions.append(Phrases.showAxisNumbers, null);
        this.append((Item)this.visualOptions);
        this.fontSize.append(Phrases.Small, null);
        this.fontSize.append(Phrases.Medium, null);
        this.fontSize.append(Phrases.Large, null);
        this.append((Item)this.fontSize);
        this.precisionOptions.setFitPolicy(1);
        this.precisionOptions.append(Phrases.calculateCriticalPoints, null);
        this.append((Item)this.precisionOptions);
        this.append((Item)this.nbDecimalsGauge);
        this.append((Item)this.nbDrawingStepsGauge);
        this.append((Item)this.okButton);
        this.okButton.setDefaultCommand(this.okItemCommand);
        this.okButton.setItemCommandListener((ItemCommandListener)this);
        this.loadCurrentSettings();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.okCommand || command == this.okItemCommand) {
            this.saveSettings();
            CommandHandler.getInstance().goBack();
        } else if (command == this.cancelCommand) {
            this.loadCurrentSettings();
            CommandHandler.getInstance().goBack();
        }
    }

    public void commandAction(Command command, Item item) {
        this.commandAction(command, (Displayable)this);
    }

    private void loadCurrentSettings() {
        this.language.setSelectedFlags(new boolean[Settings.languages.length]);
        this.language.setSelectedIndex(Settings.getCurrentLanguageIndex(), true);
        this.visualOptions.setSelectedIndex(0, Settings.BLACK_BACKGROUND);
        this.visualOptions.setSelectedIndex(1, Settings.FULLSCREEN);
        this.visualOptions.setSelectedIndex(2, Settings.SHOW_GRID);
        this.visualOptions.setSelectedIndex(3, Settings.SHOW_GRID_NUMBERS);
        this.visualOptions.setSelectedIndex(4, Settings.SHOW_AXIS);
        this.visualOptions.setSelectedIndex(5, Settings.SHOW_AXIS_NUMBERS);
        this.fontSize.setSelectedFlags(new boolean[3]);
        this.fontSize.setSelectedIndex(Settings.fontsizeIndex, true);
        this.precisionOptions.setSelectedIndex(0, Settings.CALCULATE_CRITICAL_POINTS);
        this.nbDrawingStepsGauge.setValue(Settings.NB_REDRAWING_STEPS);
        this.nbDecimalsGauge.setValue(Settings.NB_DECIMALS);
    }

    private void saveSettings() {
        Settings.isChanged = true;
        Settings.BLACK_BACKGROUND = this.visualOptions.isSelected(0);
        Settings.FULLSCREEN = this.visualOptions.isSelected(1);
        Settings.SHOW_GRID = this.visualOptions.isSelected(2);
        Settings.SHOW_GRID_NUMBERS = this.visualOptions.isSelected(3);
        Settings.SHOW_AXIS = this.visualOptions.isSelected(4);
        Settings.SHOW_AXIS_NUMBERS = this.visualOptions.isSelected(5);
        Settings.fontsizeIndex = this.fontSize.getSelectedIndex();
        Settings.CALCULATE_CRITICAL_POINTS = this.precisionOptions.isSelected(0);
        Settings.NB_REDRAWING_STEPS = this.nbDrawingStepsGauge.getValue();
        Settings.NB_DECIMALS = this.nbDecimalsGauge.getValue();
        if (this.language.getSelectedIndex() != Settings.getCurrentLanguageIndex()) {
            Settings.setCurrentLanguage(this.language.getSelectedIndex());
            GraphViewer midlet = CommandHandler.getInstance().getMidlet();
            midlet.reinit();
        }
    }

    public void show(Displayable previousDisplayable) {
    }

    public void hide(Displayable nextDisplayable) {
    }
}

