/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.CommandHandler;
import graph.GraphViewer;
import graph.InsertFunctionList;
import graph.MyDisplayable;
import graph.core.Color;
import graph.core.PlotterWithFunctionEvaluation;
import graph.core.Sample;
import graph.lang.Phrases;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;

public class GraphForm
extends Form
implements CommandListener,
ItemCommandListener,
MyDisplayable {
    private static final String DEFAULT_EQUATION_START = "y=xsin(x)";
    private static final String DEFAULT_EQUATION_ADD = "y=x";
    private Command plotItemCommand = new Command(Phrases.plot, 1, 0);
    private Command plotItemCommand2 = new Command(Phrases.plot, 1, 0);
    private Command plotCommand = new Command(Phrases.plot, 1, 0);
    private Command menuCommand = new Command(Phrases.MainMenu, 1, 1);
    private Command addEqnCommand = new Command(Phrases.addEqnShort, Phrases.addEquation, 1, 5);
    private Command addEqnItemCommand = new Command(Phrases.addEqnShort, Phrases.addEquation, 8, 5);
    private Command delEqnCommand = new Command(Phrases.delEqnShort, Phrases.delEquation, 1, 5);
    private Command delEqnItemCommand = new Command(Phrases.delEqnShort, Phrases.delEquation, 8, 5);
    private Command newSampleCommand = new Command(Phrases.newSample, 1, 2);
    private Command newSampleItemCommand = new Command(Phrases.newSample, 8, 2);
    private Command insertFunctionCommand = new Command(Phrases.insertShort, Phrases.insertFunction, 8, -1);
    private Command saveSampleCommand = new Command(Phrases.saveSample, 1, 4);
    private Command saveSampleItemCommand = new Command(Phrases.saveSample, 8, 4);
    private Command loadSampleCommand = new Command(Phrases.loadSample, 1, 3);
    private Command loadSampleItemCommand = new Command(Phrases.loadSample, 8, 3);
    private TextField xminField = new TextField(Phrases.xmin, "-10", 10, 5);
    private TextField xmaxField = new TextField(Phrases.xmax, "10", 10, 5);
    private TextField yminField = new TextField(Phrases.ymin, "-10", 10, 5);
    private TextField ymaxField = new TextField(Phrases.ymax, "10", 10, 5);
    private ChoiceGroup options = new ChoiceGroup("", 2);
    private StringItem newButton = new StringItem("", Phrases.newSample, 2);
    private StringItem loadButton = new StringItem("", Phrases.loadSample, 2);
    private StringItem saveButton = new StringItem("", Phrases.saveSample, 2);
    private StringItem plotButton = new StringItem("", Phrases.plot, 2);
    private StringItem plotButton2 = new StringItem("", Phrases.plot, 2);
    private StringItem addEqnButton = new StringItem("", Phrases.addEqnShort, 2);
    private StringItem delEqnButton = new StringItem("", Phrases.delEqnShort, 2);
    private int nbEquations = 1;
    private TextField[] equationTextfields;
    private int NB_FIELDS_BEFORE_FIRST_EQUATION = 3;

    void ndsInit() throws Exception {
        CommandHandler.getInstance().registerDisplayable((Displayable)this);
        this.setCommandListener(this);
        this.setTitle(Phrases.graphformTitle);
        this.append((Item)this.newButton);
        this.newButton.setDefaultCommand(this.newSampleItemCommand);
        this.newButton.setItemCommandListener((ItemCommandListener)this);
        this.append((Item)this.loadButton);
        this.loadButton.setDefaultCommand(this.loadSampleItemCommand);
        this.loadButton.setItemCommandListener((ItemCommandListener)this);
        CommandHandler.getInstance().registerCommand(this.loadSampleItemCommand, "graph.SampleList");
        this.append((Item)this.saveButton);
        this.saveButton.setDefaultCommand(this.saveSampleItemCommand);
        this.saveButton.setItemCommandListener((ItemCommandListener)this);
        CommandHandler.getInstance().registerCommand(this.saveSampleItemCommand, "graph.AddSampleForm");
        this.equationTextfields = new TextField[this.nbEquations];
        int i = 0;
        while (i < this.nbEquations) {
            this.equationTextfields[i] = new TextField(String.valueOf(Phrases.equation) + " " + (i + 1) + " (" + Color.ColorArray[i % Color.ColorArray.length].getName() + ")", DEFAULT_EQUATION_START, 150, 0);
            this.equationTextfields[i].setConstraints(524288);
            this.append((Item)this.equationTextfields[i]);
            this.equationTextfields[i].setDefaultCommand(this.insertFunctionCommand);
            this.equationTextfields[i].setItemCommandListener((ItemCommandListener)this);
            ++i;
        }
        this.append((Item)this.delEqnButton);
        this.delEqnButton.setDefaultCommand(this.delEqnItemCommand);
        this.delEqnButton.setItemCommandListener((ItemCommandListener)this);
        this.append((Item)this.addEqnButton);
        this.addEqnButton.setDefaultCommand(this.addEqnItemCommand);
        this.addEqnButton.setItemCommandListener((ItemCommandListener)this);
        this.append((Item)this.plotButton);
        this.plotButton.setDefaultCommand(this.plotItemCommand);
        this.plotButton.setItemCommandListener((ItemCommandListener)this);
        this.append((Item)this.options);
        this.options.setFitPolicy(1);
        this.options.append(Phrases.showNullPoints, null);
        this.options.setSelectedIndex(0, true);
        this.options.append(Phrases.showDerivate, null);
        this.options.setSelectedIndex(1, false);
        this.options.append(Phrases.showSecondDerivate, null);
        this.options.setSelectedIndex(2, false);
        this.options.append(Phrases.showIntegral, null);
        this.options.setSelectedIndex(3, false);
        this.append((Item)this.plotButton2);
        this.plotButton2.setDefaultCommand(this.plotItemCommand2);
        this.plotButton2.setItemCommandListener((ItemCommandListener)this);
        this.append((Item)this.xminField);
        this.append((Item)this.xmaxField);
        this.append((Item)this.yminField);
        this.append((Item)this.ymaxField);
        this.addCommand(this.plotCommand);
        this.addCommand(CommandHandler.getGlobalBackCommand());
        this.addCommand(this.menuCommand);
        this.addCommand(this.loadSampleCommand);
        CommandHandler.getInstance().registerCommand(this.loadSampleCommand, "graph.SampleList");
        this.addCommand(this.saveSampleCommand);
        CommandHandler.getInstance().registerCommand(this.saveSampleCommand, "graph.AddSampleForm");
        this.addCommand(this.newSampleCommand);
        this.addCommand(this.addEqnCommand);
        this.addCommand(this.delEqnCommand);
    }

    public void addEquation() {
        TextField[] oldEquationTextfields = this.equationTextfields;
        ++this.nbEquations;
        this.equationTextfields = new TextField[this.nbEquations];
        int i = 0;
        while (i < oldEquationTextfields.length) {
            this.equationTextfields[i] = oldEquationTextfields[i];
            ++i;
        }
        int eqnIndex = this.nbEquations - 1;
        int fieldIndex = this.NB_FIELDS_BEFORE_FIRST_EQUATION + this.nbEquations - 1;
        this.equationTextfields[eqnIndex] = new TextField(String.valueOf(Phrases.equation) + " " + this.nbEquations + " (" + Color.ColorArray[eqnIndex % Color.ColorArray.length].getName() + ")", DEFAULT_EQUATION_ADD, 150, 0);
        this.equationTextfields[eqnIndex].setConstraints(524288);
        this.insert(fieldIndex, (Item)this.equationTextfields[eqnIndex]);
        this.equationTextfields[eqnIndex].setDefaultCommand(this.insertFunctionCommand);
        this.equationTextfields[eqnIndex].setItemCommandListener((ItemCommandListener)this);
    }

    public void delLastEquation() {
        if (this.nbEquations > 1) {
            TextField[] oldEquationTextfields = this.equationTextfields;
            --this.nbEquations;
            this.equationTextfields = new TextField[this.nbEquations];
            int i = 0;
            while (i < this.equationTextfields.length) {
                this.equationTextfields[i] = oldEquationTextfields[i];
                ++i;
            }
            this.delete(this.nbEquations + this.NB_FIELDS_BEFORE_FIRST_EQUATION);
        } else {
            this.equationTextfields[0].setString(DEFAULT_EQUATION_ADD);
        }
    }

    public void resetAll() {
        this.setSample(Sample.defaultSample);
    }

    public void setSample(Sample sample) {
        this.deleteAllEquations();
        int i = 0;
        while (i < sample.equations.length) {
            this.addEquation();
            this.equationTextfields[i].setString(sample.equations[i]);
            ++i;
        }
        this.xminField.setString("" + sample.xmin);
        this.xmaxField.setString("" + sample.xmax);
        this.yminField.setString("" + sample.ymin);
        this.ymaxField.setString("" + sample.ymax);
        this.options.setSelectedIndex(0, sample.showAxisIntersections);
        this.options.setSelectedIndex(1, sample.showDerivate);
        this.options.setSelectedIndex(2, sample.showSecondDerivate);
        this.options.setSelectedIndex(3, sample.showIntegral);
    }

    public Sample getSample() {
        String[] equations = new String[this.nbEquations];
        int i = 0;
        while (i < this.nbEquations) {
            equations[i] = this.equationTextfields[i].getString();
            ++i;
        }
        double xmin = -10.0;
        double xmax = 10.0;
        double ymin = -10.0;
        double ymax = 10.0;
        try {
            xmin = Double.parseDouble(this.xminField.getString());
            xmax = Double.parseDouble(this.xmaxField.getString());
            ymin = Double.parseDouble(this.yminField.getString());
            ymax = Double.parseDouble(this.ymaxField.getString());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        if (xmin >= xmax || ymin >= ymax) {
            xmin = -10.0;
            xmax = 10.0;
            ymin = -10.0;
            ymax = 10.0;
        }
        boolean showAxisIntersections = this.options.isSelected(0);
        boolean showDerivate = this.options.isSelected(1);
        boolean showSecondDerivate = this.options.isSelected(2);
        boolean showIntegral = this.options.isSelected(3);
        return new Sample("", equations, xmin, xmax, ymin, ymax, showAxisIntersections, showDerivate, showSecondDerivate, showIntegral);
    }

    private void deleteAllEquations() {
        int i = 0;
        while (i < this.nbEquations) {
            this.delete(this.NB_FIELDS_BEFORE_FIRST_EQUATION);
            ++i;
        }
        this.equationTextfields = new TextField[0];
        this.nbEquations = 0;
    }

    public GraphForm() {
        super("");
        try {
            this.ndsInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.plotCommand || command == this.plotItemCommand || command == this.plotItemCommand2) {
            this.plot();
        } else if (command == this.addEqnCommand || command == this.addEqnItemCommand) {
            this.addEquation();
        } else if (command == this.delEqnCommand || command == this.delEqnItemCommand) {
            this.delLastEquation();
        } else if (command == this.newSampleCommand || command == this.newSampleItemCommand) {
            this.resetAll();
        } else if (command == this.menuCommand) {
            CommandHandler.getInstance().setCurrentDisplayable((Displayable)GraphViewer.mainMenu);
        } else {
            CommandHandler.getInstance().handleCommand(command);
        }
    }

    public void commandAction(Command command, Item item) {
        if (command.equals(this.insertFunctionCommand) && item instanceof TextField) {
            CommandHandler.getInstance().setCurrentDisplayable((Displayable)new InsertFunctionList((TextField)item, 0));
        } else {
            this.commandAction(command, (Displayable)this);
        }
    }

    private void plot() {
        CommandHandler.getInstance().setCurrentDisplayable((Displayable)GraphViewer.graphCanvas);
    }

    public void selectFirstEquation() {
        CommandHandler.getInstance().setCurrentItem((Item)this.equationTextfields[0]);
    }

    public void selectPlotButton() {
        CommandHandler.getInstance().setCurrentItem((Item)this.plotButton);
    }

    public void updateFromGraphCanvas(PlotterWithFunctionEvaluation plotter) {
        this.xminField.setString(plotter.getXMinRounded(2));
        this.xmaxField.setString(plotter.getXMaxRounded(2));
        this.yminField.setString(plotter.getYMinRounded(2));
        this.ymaxField.setString(plotter.getYMaxRounded(2));
    }

    public void show(Displayable previousDisplayable) {
    }

    public void hide(Displayable nextDisplayable) {
    }
}

