/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.CommandHandler;
import graph.InsertFunctionList;
import graph.MyDisplayable;
import graph.core.Parser;
import graph.core.Settings;
import graph.eqn.Equation;
import graph.lang.Phrases;
import graph.utils.Utils;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;

public class Calculator
extends Form
implements CommandListener,
ItemCommandListener,
MyDisplayable {
    StringItem result = new StringItem(Phrases.result, "0", 0);
    TextField formula = new TextField(Phrases.formula, "", 50, 0);
    TextField xValue = new TextField(Phrases.xValue, "0", 50, 0);
    StringItem calcButton = new StringItem("", Phrases.calculate, 2);
    Command calculateCommand = new Command(Phrases.calculate, 1, 1);
    Command calculateItemCommand = new Command(Phrases.calculate, 8, 1);
    Command insertFunctionCommand = new Command(Phrases.insertShort, Phrases.insertFunction, 8, 0);

    public Calculator() {
        super(Phrases.Calculator);
        try {
            this.ndsInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void ndsInit() throws Exception {
        CommandHandler.getInstance().registerDisplayable((Displayable)this);
        this.setCommandListener(this);
        CommandHandler.getInstance().registerCommand(this.insertFunctionCommand, "graph.InsertFunctionList");
        this.addCommand(CommandHandler.getGlobalBackCommand());
        this.addCommand(this.calculateCommand);
        this.append((Item)this.result);
        this.result.setText("0");
        this.result.setFont(Font.getFont((int)32, (int)0, (int)0));
        this.append((Item)this.formula);
        this.formula.setMaxSize(150);
        this.formula.setConstraints(524288);
        this.formula.addCommand(this.insertFunctionCommand);
        this.formula.setItemCommandListener((ItemCommandListener)this);
        this.append((Item)this.calcButton);
        this.calcButton.setDefaultCommand(this.calculateItemCommand);
        this.calcButton.setItemCommandListener((ItemCommandListener)this);
        this.append((Item)this.xValue);
        this.xValue.setConstraints(5);
    }

    public void calculate() {
        try {
            Equation eq = Parser.parse(this.formula.getString(), null);
            if (eq != null) {
                double x = Double.parseDouble(this.xValue.getString());
                Settings.setMaxPrecision(true);
                double result = eq.getFunctionValue(x);
                if (Settings.doRound) {
                    result = Utils.round(result, Settings.getNbDecimals());
                }
                Settings.setMaxPrecision(false);
                this.result.setText(Double.toString(result));
            } else {
                this.result.setText("0");
            }
        }
        catch (NumberFormatException e) {
            this.result.setText(String.valueOf(Phrases.error) + ": " + Phrases.invalidX);
        }
        catch (Exception e) {
            this.result.setText(String.valueOf(Phrases.error) + ": " + e.getMessage());
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.calculateCommand || command == this.calculateItemCommand) {
            this.calculate();
        } else {
            CommandHandler.getInstance().handleCommand(command);
        }
    }

    public void commandAction(Command command, Item item) {
        if (command.equals(this.insertFunctionCommand) && item instanceof TextField) {
            CommandHandler.getInstance().setCurrentDisplayable((Displayable)new InsertFunctionList((TextField)item, 1));
        } else {
            this.commandAction(command, (Displayable)this);
        }
    }

    public void show(Displayable previousDisplayable) {
    }

    public void hide(Displayable nextDisplayable) {
    }
}

