/*
 * Decompiled with CFR 0.152.
 */
package engine.world;

import app.GameAppState;
import java.io.DataInputStream;

public class SectorEdge {
    public byte pointsNumber;
    public short[] xPoint;
    public short[] yPoint;
    public byte[] edgeType;
    public byte[] nextSectorDeltaX;
    public byte[] nextSectorDeltaY;

    public SectorEdge(DataInputStream dis) {
        try {
            this.pointsNumber = dis.readByte();
            this.xPoint = new short[this.pointsNumber];
            this.yPoint = new short[this.pointsNumber];
            this.edgeType = new byte[this.pointsNumber - 1];
            this.nextSectorDeltaX = new byte[this.pointsNumber - 1];
            this.nextSectorDeltaY = new byte[this.pointsNumber - 1];
            for (int i = 0; i < this.pointsNumber; ++i) {
                this.xPoint[i] = dis.readShort();
                this.yPoint[i] = dis.readShort();
                if (GameAppState.levelNumber == 7) {
                    int n = i;
                    this.yPoint[n] = (short)(this.yPoint[n] + 2);
                    if (this.xPoint[i] >= 266) {
                        int n2 = i;
                        this.xPoint[n2] = (short)(this.xPoint[n2] - 2);
                    }
                    if (this.xPoint[i] >= 798) {
                        int n3 = i;
                        this.xPoint[n3] = (short)(this.xPoint[n3] - 4);
                    }
                }
                if (i >= this.pointsNumber - 1) continue;
                this.edgeType[i] = dis.readByte();
                if (this.edgeType[i] < 0) continue;
                this.nextSectorDeltaX[i] = dis.readByte();
                this.nextSectorDeltaY[i] = dis.readByte();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void movePoint(int id, int value) {
        int n = id;
        this.xPoint[n] = (short)(this.xPoint[n] + value);
    }
}

