/*
 * Decompiled with CFR 0.152.
 */
package com.mliven.utils;

import com.mliven.utils.GladFont;
import com.mliven.utils.MainMenu;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class ScrollTextBox {
    private static final int MARGIN = 12;
    private int x;
    private int y;
    private int w;
    private int h;
    private int boxX;
    private int boxY;
    private int boxW;
    private int boxH;
    private int currentY;
    private String[] lines;
    private int linesHeight;
    private int titleHeight;
    private String text;
    private String title;
    private int textStartY;
    private Sprite arrow;
    private int animHeight;
    private int animSpeed = 5;
    private boolean fadeIn;

    public ScrollTextBox(String text) {
        this(ScrollTextBox.adjustX(12, 240), ScrollTextBox.adjustY(12, 300), 240 - (ScrollTextBox.adjustX(12, 240) << 1), 280 - (ScrollTextBox.adjustY(12, 240) << 1), text);
        this.fadeIn = false;
    }

    public ScrollTextBox(int x, int y, int w, int h, String text) {
        this.boxX = x;
        this.boxY = y;
        this.boxW = w;
        this.boxH = h;
        this.x = x + 12;
        this.y = y + 12;
        this.w = w - 24;
        this.currentY = 0;
        if (text != null) {
            this.setText(text);
        }
        try {
            this.arrow = new Sprite(Image.createImage((String)"/arrow_text.png"));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.titleHeight = 0;
        this.fadeIn = false;
    }

    public void setTitle(String title) {
        this.title = title;
        if (title == null) {
            this.titleHeight = 0;
        }
        this.titleHeight = GladFont.getRowHeight();
        this.setText(this.text);
    }

    public void resetScrollBar() {
        this.currentY = 0;
    }

    public void setPosition(int x, int y) {
        this.boxX = x;
        this.boxY = y;
        this.x = x + 12;
        this.y = y + 12;
        this.setText(this.text);
    }

    public void setText(String text) {
        int rowHeight;
        this.text = text;
        this.textStartY = this.y;
        if (text == null) {
            return;
        }
        if (this.title != null) {
            this.textStartY += this.titleHeight + 12;
        }
        this.lines = GladFont.getLineArray(text, this.w);
        this.linesHeight = rowHeight = GladFont.getRowHeight() * this.lines.length;
        this.h = this.boxH - this.textStartY - 12;
        this.h -= this.h % GladFont.getRowHeight();
    }

    public int getHeight() {
        return this.boxH;
    }

    public void up() {
        this.currentY += this.h / 5;
        if (this.currentY > 0) {
            this.currentY = 0;
        }
    }

    public void down() {
        if (this.linesHeight > this.h) {
            this.currentY -= this.h / 5;
            if (this.currentY < -(this.linesHeight - this.h)) {
                this.currentY = -(this.linesHeight - this.h);
            }
        }
    }

    public void fadeIn() {
        this.resetScrollBar();
        this.fadeIn = true;
        this.animHeight = 0;
    }

    public void tick() {
        if (this.fadeIn) {
            this.animHeight += this.animSpeed;
            if (this.animHeight >= this.boxH / 2) {
                this.animHeight = this.boxH / 2;
                this.fadeIn = false;
            }
        }
    }

    public void draw(Graphics g) {
        if (this.fadeIn) {
            this.setPosition(this.boxX, 150 - this.animHeight);
        }
        g.setClip(this.boxX, 150 - this.animHeight, this.boxW, this.animHeight * 2);
        GladFont.setGraphics(g);
        MainMenu.drawBox(g, this.boxX, this.boxY, this.boxW, this.boxH);
        if (this.title != null) {
            GladFont.setFont(0);
            GladFont.drawString(this.title, this.x + (this.w >> 1), this.y - 6, 4);
            g.setColor(4140826);
            int marginX = GladFont.getStringWidth("OO");
            g.drawLine(this.x + marginX, this.textStartY - 12, this.x + this.w - marginX, this.textStartY - 12);
            g.setColor(0);
            g.drawLine(this.x + marginX, this.textStartY - 12 + 1, this.x + this.w - marginX, this.textStartY - 12 + 1);
        }
        int arrowOffset = 4;
        if (this.currentY < 0) {
            this.arrow.setTransform(0);
            this.arrow.setPosition(this.boxX + this.boxW - 12 - this.arrow.getWidth(), this.boxY + this.boxH - 12 - this.arrow.getHeight() - 1 - arrowOffset);
            this.arrow.paint(g);
        }
        if (this.currentY > -(this.linesHeight - this.h)) {
            this.arrow.setTransform(3);
            this.arrow.setPosition(this.boxX + this.boxW - 12 - this.arrow.getWidth(), this.boxY + this.boxH - 12 - arrowOffset);
            this.arrow.paint(g);
        }
        GladFont.setFont(0);
        int max_clip_height = 2 * this.animHeight - (this.textStartY - this.boxY);
        if (this.h < max_clip_height) {
            max_clip_height = this.h;
        }
        g.setClip(this.x, this.textStartY + 2, this.w, max_clip_height + 5);
        if (this.lines != null) {
            GladFont.drawLines(this.lines, this.x, this.currentY + this.textStartY);
        }
        g.setClip(0, 0, 240, 300);
        MainMenu.drawLines(g, this.boxX, 150 - this.animHeight + this.animHeight * 2, this.boxW);
    }

    public void release() {
        if (this.lines != null) {
            for (int i = 0; i < this.lines.length; ++i) {
                if (this.lines[i] == null) continue;
                this.lines[i] = null;
            }
            this.lines = null;
        }
        this.text = null;
        this.title = null;
        this.arrow = null;
    }

    public static int adjustX(int x, int w) {
        return 100 * w / 176 * x / 100;
    }

    public static int adjustY(int y, int h) {
        return 100 * h / 220 * y / 100;
    }
}

