/*
 * Decompiled with CFR 0.152.
 */
package com.mliven.utils;

import com.mliven.Arena;
import com.mliven.DataStore;
import com.mliven.Fighter;
import com.mliven.Gladiator2D;
import com.mliven.utils.GScreen;
import com.mliven.utils.GladFont;
import com.mliven.utils.IntroScreen;
import com.mliven.utils.MainMenu;
import com.mliven.utils.SharedGraphics;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class ResourceLoader
extends GScreen
implements Runnable {
    public static final int LOAD_MENU_RES = 0;
    public static final int INIT_GAME = 1;
    public static final int LOAD_FIGHT = 2;
    public static final int LOAD_INTRO = 3;
    public static final int CHANGE_LANGUAGE = 4;
    private Image[] loadingAnim;
    private int activeFrame = 0;
    private long lastAnimated = 0L;
    private int loadType;
    private Object loadData;
    private Object loadData2;
    private String debugInfo = "";
    private String debugInfo2 = "";

    public ResourceLoader() {
        try {
            this.loadingAnim = new Image[5];
            for (int i = 0; i < this.loadingAnim.length; ++i) {
                this.loadingAnim[i] = Image.createImage((String)("/gladius000" + i + ".png"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        if (Gladiator2D.sound != null && Gladiator2D.sound.isMusicPlaying()) {
            Gladiator2D.sound.stop();
        }
        this.lastAnimated = 0L;
        switch (this.loadType) {
            case 4: {
                Gladiator2D.TEXT.setLanguage(DataStore.language);
                ((MainMenu)this.loadData).animHeader.setText(Gladiator2D.TEXT.getText(19));
                ((MainMenu)this.loadData).buildUpMenu();
                ((MainMenu)this.loadData).menu.setCurrentMenu(13, DataStore.language);
                DataStore.save();
                Gladiator2D.getInstance().handleEvent(9, null);
                break;
            }
            case 3: {
                try {
                    IntroScreen.splash = new Image[3];
                    IntroScreen.splash[0] = Image.createImage((String)"/logo_fishlabs.png");
                    IntroScreen.splash[1] = Image.createImage((String)"/logo_dreamworks.png");
                    IntroScreen.splash[2] = Image.createImage((String)"/logo_universal.png");
                    IntroScreen.intro1 = Image.createImage((String)"/intro_1.png");
                    IntroScreen.intro2 = Image.createImage((String)"/intro_2.png");
                    MainMenu.menu_border = Image.createImage((String)"/menu_border.png");
                    MainMenu.menu_bg = Image.createImage((String)"/menu_bgr.png");
                    Gladiator2D.intro.onInitialize();
                    Gladiator2D.getInstance().handleEvent(7, null);
                }
                catch (Exception e) {}
                break;
            }
            case 1: {
                DataStore.load();
                Gladiator2D.TEXT.setLanguage(DataStore.language);
                try {
                    SharedGraphics.selectionWing = new Sprite(Image.createImage((String)"/selected_wing.png"));
                    SharedGraphics.imgPattern = Image.createImage((String)"/filter.png");
                    SharedGraphics.imgArrows = Image.createImage((String)"/soft_arrows.png");
                }
                catch (Exception e) {
                    return;
                }
                Gladiator2D.getInstance().handleEvent(2, null);
                break;
            }
            case 2: {
                Gladiator2D.mainMenu.cleanUp();
                Gladiator2D.fightScreen.arena.cleanUp();
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    int i;
                    Arena.arenaImage = new Image[6];
                    for (i = 0; i < Arena.arenaImage.length; ++i) {
                        Arena.arenaImage[i] = DataStore.g_current_fight == 4 && DataStore.g_game_mode == 0 ? Image.createImage((String)("/colosseum/col_" + (i + 1) + ".png")) : Image.createImage((String)("/arena/arena_" + (i + 1) + ".png"));
                    }
                    Arena.arenaBackground = new Image[6];
                    for (i = 0; i < Arena.arenaBackground.length; ++i) {
                        Arena.arenaBackground[i] = DataStore.g_current_fight == 4 && DataStore.g_game_mode == 0 ? Image.createImage((String)("/colosseum/ctop_" + (i + 1) + ".png")) : Image.createImage((String)("/arena/atop_" + (i + 1) + ".png"));
                    }
                    Arena.clouds = Image.createImage((String)"/arena/sky.png");
                    Arena.shadow = Image.createImage((String)"/shadow.png");
                    Arena.corner_box = new Sprite(Image.createImage((String)"/corner_box.png"));
                    Arena.noend = Image.createImage((String)"/noend.png");
                    Arena.ground = Image.createImage((String)"/arena/sand.png");
                    Arena.footerBorder = Image.createImage((String)"/menu_border.png");
                    Arena.special_bar = Image.createImage((String)"/spec_bar.png");
                    Arena.special_adjust = Image.createImage((String)"/spec_adjust.png");
                    Arena.special_mark = Image.createImage((String)"/spec_mark.png");
                    Arena.special_overlay = Image.createImage((String)"/attack_grey.png");
                    Arena.menu_eagle = Image.createImage((String)"/menu_eagle.png");
                    Arena.sparkle = new Sprite(Image.createImage((String)"/arena/sparkle.png"));
                    Image blood = Image.createImage((String)"/arena/blood.png");
                    Arena.blood = new Sprite(blood, blood.getWidth() / 2, blood.getHeight());
                    Arena.jewel = Image.createImage((String)"/attr_jewel.png");
                    Arena.defeat = Image.createImage((String)"/def_blood.png");
                    Image img = Image.createImage((String)"/numbers.png");
                    Arena.numbers = new Sprite(img, img.getWidth() / 10, img.getHeight());
                    Arena.damage_up = new Image[2];
                    Arena.damage_up[0] = Image.createImage((String)"/fame_blue.png");
                    Arena.damage_up[1] = Image.createImage((String)"/fame_red.png");
                    img = Image.createImage((String)"/border_arrow.png");
                    Arena.border_arrow = new Sprite(img);
                    if (DataStore.g_game_mode == 4) {
                        Arena.proximo = Image.createImage((String)"/tut_proximo.png");
                        Arena.tut_dpad = Image.createImage((String)"/tut_dpad.png");
                        Arena.tut_press = Image.createImage((String)"/tut_press.png");
                        Arena.tut_hold = Image.createImage((String)"/tut_hold.png");
                        Arena.tut_num1 = Image.createImage((String)"/tut_num1.png");
                        Arena.tut_num2 = Image.createImage((String)"/tut_num2.png");
                        Arena.tut_num3 = Image.createImage((String)"/tut_num3.png");
                        Arena.tut_button_hold = Image.createImage((String)"/tut_but_hold.png");
                        Arena.tut_button_press = Image.createImage((String)"/tut_but_press.png");
                        Arena.tut_arrow_hold = new Sprite(Image.createImage((String)"/tut_arrow_hold.png"));
                        Arena.tut_arrow_press = new Sprite(Image.createImage((String)"/tut_arrow_press.png"));
                        Arena.tut_hash = Image.createImage((String)"/tut_hash.png");
                        Arena.tut_hash_press = Image.createImage((String)"/tut_hash_press.png");
                        Arena.tut_hash_hold = Image.createImage((String)"/tut_hash_hold.png");
                        Arena.tut_star = Image.createImage((String)"/tut_star.png");
                        Arena.tut_star_press = Image.createImage((String)"/tut_star_press.png");
                        Arena.tut_star_hold = Image.createImage((String)"/tut_star_hold.png");
                    } else {
                        Arena.hands = new Image[3];
                        Arena.hands[0] = Image.createImage((String)"/h1.png");
                        Arena.hands[1] = Image.createImage((String)"/h2.png");
                        Arena.hands[2] = Image.createImage((String)"/h3.png");
                        Arena.awards = new Image[3];
                        Arena.awards[0] = Image.createImage((String)"/vict_bronze.png");
                        Arena.awards[1] = Image.createImage((String)"/vict_silver.png");
                        Arena.awards[2] = Image.createImage((String)"/vict_gold.png");
                    }
                }
                catch (Exception e) {
                    return;
                }
                try {
                    int[] whichFighters = (int[])this.loadData;
                    Gladiator2D.fightScreen.arena.createFighters(whichFighters[0], whichFighters[1]);
                    for (int i = 0; i < whichFighters.length; ++i) {
                        Fighter currentFighter = i == 0 ? ((Arena)this.loadData2).getPlayer() : ((Arena)this.loadData2).getOpponent();
                        currentFighter.charName = ResourceLoader.getCharacterName(currentFighter.fighterId);
                        int[][] animFrames = null;
                        switch (whichFighters[i]) {
                            case 1: {
                                animFrames = Fighter.AMAZON_ANIM_DELAYS;
                                break;
                            }
                            case 7: {
                                animFrames = Fighter.MAXIMUS_ANIM_DELAYS;
                                break;
                            }
                            case 3: {
                                animFrames = Fighter.BULL_ANIM_DELAYS;
                                break;
                            }
                            case 8: {
                                animFrames = Fighter.COMMODUS_ANIM_DELAYS;
                                break;
                            }
                            case 5: {
                                animFrames = Fighter.HAGEN_ANIM_DELAYS;
                                break;
                            }
                            case 6: {
                                animFrames = Fighter.TIGER_ANIM_DELAYS;
                                break;
                            }
                            case 4: {
                                animFrames = Fighter.TRIDENT_ANIM_DELAYS;
                                break;
                            }
                            case 2: {
                                animFrames = Fighter.JUBA_ANIM_DELAYS;
                                break;
                            }
                            case 0: {
                                animFrames = Fighter.MACE_ANIM_DELAYS;
                            }
                        }
                        currentFighter.animations = ResourceLoader.buildUpAnimationMatrix(18, animFrames);
                        if (i == 1 && whichFighters[0] == whichFighters[1]) {
                            Gladiator2D.fightScreen.arena.getOpponent().animations = Gladiator2D.fightScreen.arena.getPlayer().animations;
                            Gladiator2D.fightScreen.arena.getOpponent().trident_net = Gladiator2D.fightScreen.arena.getPlayer().trident_net;
                            Gladiator2D.fightScreen.arena.getOpponent();
                            Gladiator2D.fightScreen.arena.getPlayer();
                            continue;
                        }
                        switch (whichFighters[i]) {
                            case 1: {
                                ResourceLoader.loadAmazonSpecificAnim(currentFighter);
                                break;
                            }
                            case 7: {
                                ResourceLoader.loadMaximusSpecificAnim(currentFighter);
                                break;
                            }
                            case 3: {
                                ResourceLoader.loadBullSpecificAnim(currentFighter);
                                break;
                            }
                            case 8: {
                                ResourceLoader.loadCommodusSpecificAnim(currentFighter);
                                break;
                            }
                            case 5: {
                                ResourceLoader.loadHagenSpecificAnim(currentFighter);
                                break;
                            }
                            case 6: {
                                ResourceLoader.loadTigerSpecificAnim(currentFighter);
                                break;
                            }
                            case 4: {
                                ResourceLoader.loadTridentSpecificAnim(currentFighter);
                                break;
                            }
                            case 2: {
                                ResourceLoader.loadJubaSpecificAnim(currentFighter);
                                break;
                            }
                            case 0: {
                                ResourceLoader.loadMaceSpecificAnim(currentFighter);
                            }
                        }
                        currentFighter.animations[17][0] = currentFighter.animations[7][0];
                    }
                }
                catch (Exception e) {
                    this.debugInfo2 = e.toString();
                    return;
                }
                Gladiator2D.fightScreen.arena.initFight();
                Gladiator2D.fightScreen.arena.initMenu();
                Gladiator2D.getInstance().handleEvent(4, null);
                break;
            }
            case 0: {
                try {
                    Gladiator2D.fightScreen.cleanUp();
                    if (Gladiator2D.intro != null) {
                        Gladiator2D.intro.cleanUp();
                        Gladiator2D.intro = null;
                    }
                    try {
                        int i;
                        MainMenu.char_icons = new Image[DataStore.FIGHTER_NAMES.length];
                        for (i = 0; i < MainMenu.char_icons.length; ++i) {
                            MainMenu.char_icons[i] = ResourceLoader.getCharacterIcon(i);
                        }
                        MainMenu.menu_meander = Image.createImage((String)"/menu_meander.png");
                        MainMenu.gladiator_logo = Image.createImage((String)"/gladiator_logo.png");
                        MainMenu.menu_eagle = Image.createImage((String)"/menu_eagle.png");
                        MainMenu.disable = Image.createImage((String)"/disable_grey.png");
                        MainMenu.border = Image.createImage((String)"/border_vs.png");
                        MainMenu.border_selected = Image.createImage((String)"/border_selected.png");
                        MainMenu.attributeBar = Image.createImage((String)"/attr_bar.png");
                        MainMenu.attributeJewel = Image.createImage((String)"/attr_jewel.png");
                        MainMenu.versus = Image.createImage((String)"/menu_vs.png");
                        MainMenu.arrow_vs = Image.createImage((String)"/arrow_vs.png");
                        MainMenu.cross = Image.createImage((String)"/cross.png");
                        MainMenu.awards = new Image[3];
                        MainMenu.awards[0] = Image.createImage((String)"/vict_bronze.png");
                        MainMenu.awards[1] = Image.createImage((String)"/vict_silver.png");
                        MainMenu.awards[2] = Image.createImage((String)"/vict_gold.png");
                        if (MainMenu.menu_bg == null) {
                            MainMenu.menu_bg = Image.createImage((String)"/menu_bgr.png");
                        }
                        if (MainMenu.menu_border == null) {
                            MainMenu.menu_border = Image.createImage((String)"/menu_border.png");
                        }
                        MainMenu.gradient = Image.createImage((String)"/gradient.png");
                        MainMenu.bg = Image.createImage((String)"/bg.png");
                        MainMenu.shadow = Image.createImage((String)"/shadow.png");
                        MainMenu.charIdles = new Sprite[DataStore.FIGHTER_NAMES.length][2];
                        for (i = 0; i < MainMenu.charIdles.length; ++i) {
                            MainMenu.charIdles[i][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(i, 0, 0)));
                            MainMenu.charIdles[i][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(i, 0, 1)));
                        }
                    }
                    catch (Exception e) {
                        return;
                    }
                    if (Gladiator2D.mainMenu == null) {
                        Gladiator2D.mainMenu = new MainMenu();
                        Gladiator2D.mainMenu.buildUpMenu();
                    }
                }
                catch (Exception e) {
                    return;
                }
                Gladiator2D.getInstance().handleEvent(0, null);
            }
        }
    }

    private static Sprite[][] buildUpAnimationMatrix(int animCount, int[][] animFrames) {
        Sprite[][] output = new Sprite[animCount][];
        for (int j = 0; j < animCount; ++j) {
            output[j] = new Sprite[animFrames[j].length];
        }
        return output;
    }

    private static String getPngPath(int fighterId, int animation, int seqNum) {
        String output = null;
        switch (fighterId) {
            case 7: {
                output = "/maximus/max_";
                break;
            }
            case 1: {
                output = "/amazon/ama_";
                break;
            }
            case 3: {
                output = "/bul/bul_";
                break;
            }
            case 8: {
                output = "/commodus/com_";
                break;
            }
            case 5: {
                output = "/hagen/hag_";
                break;
            }
            case 2: {
                output = "/juba/jub_";
                break;
            }
            case 0: {
                output = "/mace/mac_";
                break;
            }
            case 6: {
                output = "/tiger/tig_";
                break;
            }
            case 4: {
                output = "/trident/tri_";
            }
        }
        switch (animation) {
            case 0: {
                output = output + "idle";
                break;
            }
            case 2: {
                output = output + "backward";
                break;
            }
            case 1: {
                output = output + "forward";
                break;
            }
            case 3: {
                output = output + "cheer";
                break;
            }
            case 5: {
                output = output + "attacks";
                break;
            }
            case 4: {
                output = output + "attack_stun";
                break;
            }
            case 6: {
                output = output + "attack_heavy";
                break;
            }
            case 7: {
                output = output + "block";
                break;
            }
            case 8: {
                output = output + "attack_fierce";
                break;
            }
            case 9: {
                output = output + "attack_spec";
                break;
            }
            case 13: {
                output = output + "death";
                break;
            }
            case 10: 
            case 11: {
                output = output + "combo";
                break;
            }
            case 12: 
            case 15: {
                output = output + "critical";
            }
        }
        output = output + "_" + (seqNum + 1);
        output = output + ".png";
        return output;
    }

    private static void loadAnimSeq(Fighter currentFighter, int animId) throws Exception {
        for (int j = 0; j < currentFighter.animations[animId].length; ++j) {
            currentFighter.animations[animId][j] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, animId, j)));
        }
    }

    private static void loadHagenSpecificAnim(Fighter currentFighter) throws Exception {
        ResourceLoader.loadAnimSeq(currentFighter, 0);
        ResourceLoader.loadAnimSeq(currentFighter, 1);
        ResourceLoader.loadAnimSeq(currentFighter, 2);
        currentFighter.animations[13][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 13, 0)));
        currentFighter.animations[13][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 13, 1)));
        currentFighter.animations[13][2] = currentFighter.animations[13][0];
        currentFighter.animations[13][3] = currentFighter.animations[13][1];
        currentFighter.animations[13][4] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 13, 2)));
        currentFighter.animations[13][5] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 13, 3)));
        ResourceLoader.loadAnimSeq(currentFighter, 7);
        currentFighter.animations[3][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 3, 0)));
        currentFighter.animations[3][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 3, 1)));
        currentFighter.animations[3][2] = currentFighter.animations[3][0];
        currentFighter.animations[9][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 0)));
        currentFighter.animations[9][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 1)));
        currentFighter.animations[9][2] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 2)));
        currentFighter.animations[9][3] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 3)));
        currentFighter.animations[9][4] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 5)));
        currentFighter.animations[9][5] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 4)));
        ResourceLoader.loadAnimSeq(currentFighter, 5);
        ResourceLoader.loadAnimSeq(currentFighter, 4);
        ResourceLoader.loadAnimSeq(currentFighter, 8);
        currentFighter.animations[6][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 6, 0)));
        currentFighter.animations[6][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 6, 1)));
        currentFighter.animations[6][2] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 6, 2)));
        currentFighter.animations[6][3] = currentFighter.animations[6][1];
        currentFighter.animations[6][4] = currentFighter.animations[6][2];
        currentFighter.animations[6][5] = currentFighter.animations[6][1];
        currentFighter.animations[6][6] = currentFighter.animations[6][2];
        currentFighter.animations[6][7] = currentFighter.animations[6][1];
        currentFighter.animations[6][8] = currentFighter.animations[6][2];
        currentFighter.animations[6][9] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 6, 3)));
        currentFighter.animations[12][0] = currentFighter.animations[13][1];
        currentFighter.animations[15][0] = currentFighter.animations[13][1];
        currentFighter.animations[14][0] = currentFighter.animations[1][0];
        currentFighter.animations[14][1] = currentFighter.animations[1][1];
        currentFighter.animations[14][2] = currentFighter.animations[0][0];
        currentFighter.animations[14][3] = currentFighter.animations[1][0];
        currentFighter.animations[14][4] = currentFighter.animations[1][1];
        currentFighter.animations[16][0] = currentFighter.animations[3][0];
        currentFighter.animations[16][1] = currentFighter.animations[3][1];
        currentFighter.animations[10][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 10, 0)));
        currentFighter.animations[10][1] = currentFighter.animations[5][1];
        currentFighter.animations[11][0] = currentFighter.animations[5][0];
        currentFighter.animations[11][1] = currentFighter.animations[8][3];
        currentFighter.animations[11][2] = currentFighter.animations[8][2];
        currentFighter.animations[11][3] = currentFighter.animations[8][3];
    }

    private static void loadJubaSpecificAnim(Fighter currentFighter) throws Exception {
        ResourceLoader.loadAnimSeq(currentFighter, 0);
        ResourceLoader.loadAnimSeq(currentFighter, 1);
        ResourceLoader.loadAnimSeq(currentFighter, 2);
        currentFighter.animations[13][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 13, 0)));
        currentFighter.animations[13][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 13, 1)));
        currentFighter.animations[13][2] = currentFighter.animations[13][0];
        currentFighter.animations[13][3] = currentFighter.animations[13][1];
        currentFighter.animations[13][4] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 13, 2)));
        currentFighter.animations[13][5] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 13, 3)));
        ResourceLoader.loadAnimSeq(currentFighter, 7);
        currentFighter.animations[3][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 3, 0)));
        currentFighter.animations[3][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 3, 1)));
        currentFighter.animations[3][2] = currentFighter.animations[3][0];
        ResourceLoader.loadAnimSeq(currentFighter, 9);
        ResourceLoader.loadAnimSeq(currentFighter, 5);
        currentFighter.animations[4][0] = currentFighter.animations[1][0];
        currentFighter.animations[4][1] = currentFighter.animations[1][1];
        currentFighter.animations[4][2] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 4, 0)));
        currentFighter.animations[4][3] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 4, 1)));
        currentFighter.animations[4][4] = currentFighter.animations[2][0];
        currentFighter.animations[4][5] = currentFighter.animations[2][1];
        ResourceLoader.loadAnimSeq(currentFighter, 6);
        currentFighter.animations[8][0] = currentFighter.animations[6][0];
        currentFighter.animations[8][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 8, 0)));
        currentFighter.animations[8][2] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 8, 1)));
        currentFighter.animations[8][3] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 8, 2)));
        currentFighter.animations[8][4] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 8, 3)));
        currentFighter.animations[8][5] = currentFighter.animations[1][0];
        currentFighter.animations[8][6] = currentFighter.animations[1][1];
        currentFighter.animations[12][0] = currentFighter.animations[13][1];
        currentFighter.animations[15][0] = currentFighter.animations[13][1];
        currentFighter.animations[14][0] = currentFighter.animations[1][0];
        currentFighter.animations[14][1] = currentFighter.animations[1][1];
        currentFighter.animations[14][2] = currentFighter.animations[0][0];
        currentFighter.animations[14][3] = currentFighter.animations[1][0];
        currentFighter.animations[14][4] = currentFighter.animations[1][1];
        currentFighter.animations[16][0] = currentFighter.animations[3][0];
        currentFighter.animations[16][1] = currentFighter.animations[3][1];
        currentFighter.animations[10][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 10, 0)));
        currentFighter.animations[10][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 10, 1)));
        currentFighter.animations[11][0] = currentFighter.animations[9][7];
        currentFighter.animations[11][1] = currentFighter.animations[9][8];
    }

    private static void loadMaceSpecificAnim(Fighter currentFighter) throws Exception {
        ResourceLoader.loadAnimSeq(currentFighter, 0);
        ResourceLoader.loadAnimSeq(currentFighter, 1);
        ResourceLoader.loadAnimSeq(currentFighter, 2);
        ResourceLoader.loadAnimSeq(currentFighter, 13);
        ResourceLoader.loadAnimSeq(currentFighter, 7);
        currentFighter.animations[3][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 3, 0)));
        currentFighter.animations[3][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 3, 1)));
        currentFighter.animations[3][2] = currentFighter.animations[3][0];
        ResourceLoader.loadAnimSeq(currentFighter, 9);
        ResourceLoader.loadAnimSeq(currentFighter, 5);
        ResourceLoader.loadAnimSeq(currentFighter, 4);
        ResourceLoader.loadAnimSeq(currentFighter, 8);
        currentFighter.animations[6][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 6, 0)));
        currentFighter.animations[6][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 6, 1)));
        currentFighter.animations[6][2] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 6, 2)));
        currentFighter.animations[6][3] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 6, 3)));
        currentFighter.animations[6][4] = currentFighter.animations[6][0];
        currentFighter.animations[6][5] = currentFighter.animations[6][1];
        currentFighter.animations[6][6] = currentFighter.animations[6][2];
        currentFighter.animations[6][7] = currentFighter.animations[6][3];
        currentFighter.animations[6][8] = currentFighter.animations[6][0];
        currentFighter.animations[6][9] = currentFighter.animations[6][1];
        currentFighter.animations[6][10] = currentFighter.animations[6][2];
        currentFighter.animations[12][0] = currentFighter.animations[13][2];
        currentFighter.animations[15][0] = currentFighter.animations[13][2];
        currentFighter.animations[14][0] = currentFighter.animations[1][0];
        currentFighter.animations[14][1] = currentFighter.animations[1][1];
        currentFighter.animations[14][2] = currentFighter.animations[0][0];
        currentFighter.animations[14][3] = currentFighter.animations[1][0];
        currentFighter.animations[14][4] = currentFighter.animations[1][1];
        currentFighter.animations[16][0] = currentFighter.animations[3][0];
        currentFighter.animations[16][1] = currentFighter.animations[3][1];
        currentFighter.animations[10][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 10, 0)));
        currentFighter.animations[10][1] = currentFighter.animations[5][1];
        currentFighter.animations[11][0] = currentFighter.animations[0][0];
        currentFighter.animations[11][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 11, 1)));
        currentFighter.animations[11][2] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 11, 2)));
    }

    private static void loadTigerSpecificAnim(Fighter currentFighter) throws Exception {
        ResourceLoader.loadAnimSeq(currentFighter, 0);
        ResourceLoader.loadAnimSeq(currentFighter, 1);
        currentFighter.animations[2][0] = currentFighter.animations[1][1];
        currentFighter.animations[2][1] = currentFighter.animations[1][0];
        ResourceLoader.loadAnimSeq(currentFighter, 13);
        ResourceLoader.loadAnimSeq(currentFighter, 7);
        currentFighter.animations[3][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 3, 0)));
        currentFighter.animations[3][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 3, 1)));
        currentFighter.animations[3][2] = currentFighter.animations[3][0];
        ResourceLoader.loadAnimSeq(currentFighter, 9);
        currentFighter.animations[5][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 5, 0)));
        currentFighter.animations[5][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 5, 1)));
        currentFighter.animations[5][2] = currentFighter.animations[5][0];
        currentFighter.animations[4][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 4, 0)));
        currentFighter.animations[4][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 4, 1)));
        currentFighter.animations[4][2] = currentFighter.animations[4][0];
        ResourceLoader.loadAnimSeq(currentFighter, 8);
        ResourceLoader.loadAnimSeq(currentFighter, 6);
        currentFighter.animations[12][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 12, 0)));
        currentFighter.animations[15][0] = currentFighter.animations[12][0];
        currentFighter.animations[14][0] = currentFighter.animations[1][0];
        currentFighter.animations[14][1] = currentFighter.animations[1][1];
        currentFighter.animations[14][2] = currentFighter.animations[0][0];
        currentFighter.animations[14][3] = currentFighter.animations[1][0];
        currentFighter.animations[14][4] = currentFighter.animations[1][1];
        currentFighter.animations[16][0] = currentFighter.animations[3][0];
        currentFighter.animations[16][1] = currentFighter.animations[3][1];
        currentFighter.animations[10][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 5, 2)));
        currentFighter.animations[10][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 10, 0)));
        currentFighter.animations[11][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 10, 1)));
        currentFighter.animations[11][1] = currentFighter.animations[10][0];
        currentFighter.animations[11][2] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 11, 2)));
    }

    private static void loadTridentSpecificAnim(Fighter currentFighter) throws Exception {
        currentFighter.trident_net = new Sprite[2];
        currentFighter.trident_net[0] = new Sprite(Image.createImage((String)"/trident/tri_net_1.png"));
        currentFighter.trident_net[1] = new Sprite(Image.createImage((String)"/trident/tri_net_2.png"));
        ResourceLoader.loadAnimSeq(currentFighter, 0);
        ResourceLoader.loadAnimSeq(currentFighter, 1);
        ResourceLoader.loadAnimSeq(currentFighter, 2);
        ResourceLoader.loadAnimSeq(currentFighter, 13);
        ResourceLoader.loadAnimSeq(currentFighter, 7);
        currentFighter.animations[3][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 3, 0)));
        currentFighter.animations[3][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 3, 1)));
        currentFighter.animations[3][2] = currentFighter.animations[3][0];
        currentFighter.animations[9][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 0)));
        currentFighter.animations[9][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 1)));
        currentFighter.animations[9][2] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 2)));
        currentFighter.animations[9][3] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 3)));
        currentFighter.animations[9][4] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 4)));
        currentFighter.animations[9][5] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 5)));
        currentFighter.animations[9][6] = currentFighter.animations[9][4];
        currentFighter.animations[5][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 5, 0)));
        currentFighter.animations[5][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 5, 1)));
        currentFighter.animations[5][2] = currentFighter.animations[5][0];
        currentFighter.animations[4][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 4, 0)));
        currentFighter.animations[4][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 4, 1)));
        currentFighter.animations[4][2] = currentFighter.animations[4][0];
        currentFighter.animations[8][0] = currentFighter.animations[1][0];
        currentFighter.animations[8][1] = currentFighter.animations[1][1];
        currentFighter.animations[8][2] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 8, 0)));
        currentFighter.animations[8][3] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 8, 1)));
        currentFighter.animations[8][4] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 8, 2)));
        currentFighter.animations[8][5] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 8, 3)));
        currentFighter.animations[8][6] = currentFighter.animations[8][2];
        currentFighter.animations[8][7] = currentFighter.animations[8][1];
        currentFighter.animations[6][0] = currentFighter.animations[1][0];
        currentFighter.animations[6][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 6, 0)));
        currentFighter.animations[6][2] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 6, 1)));
        currentFighter.animations[6][3] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 6, 2)));
        currentFighter.animations[12][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 12, 0)));
        currentFighter.animations[15][0] = currentFighter.animations[12][0];
        currentFighter.animations[14][0] = currentFighter.animations[1][0];
        currentFighter.animations[14][1] = currentFighter.animations[1][1];
        currentFighter.animations[14][2] = currentFighter.animations[0][0];
        currentFighter.animations[14][3] = currentFighter.animations[1][0];
        currentFighter.animations[14][4] = currentFighter.animations[1][1];
        currentFighter.animations[16][0] = currentFighter.animations[3][0];
        currentFighter.animations[16][1] = currentFighter.animations[3][1];
        currentFighter.animations[10][0] = currentFighter.animations[4][1];
        currentFighter.animations[11][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 11, 0)));
        currentFighter.animations[11][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 11, 1)));
    }

    private static void loadCommodusSpecificAnim(Fighter currentFighter) throws Exception {
        ResourceLoader.loadAnimSeq(currentFighter, 0);
        ResourceLoader.loadAnimSeq(currentFighter, 1);
        ResourceLoader.loadAnimSeq(currentFighter, 2);
        ResourceLoader.loadAnimSeq(currentFighter, 13);
        ResourceLoader.loadAnimSeq(currentFighter, 7);
        currentFighter.animations[3][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 3, 0)));
        currentFighter.animations[3][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 3, 1)));
        currentFighter.animations[3][2] = currentFighter.animations[3][0];
        ResourceLoader.loadAnimSeq(currentFighter, 5);
        ResourceLoader.loadAnimSeq(currentFighter, 4);
        ResourceLoader.loadAnimSeq(currentFighter, 8);
        currentFighter.animations[6][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 6, 0)));
        currentFighter.animations[6][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 6, 1)));
        currentFighter.animations[6][2] = currentFighter.animations[5][1];
        currentFighter.animations[6][3] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 6, 2)));
        currentFighter.animations[6][4] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 6, 3)));
        currentFighter.animations[9][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 0)));
        currentFighter.animations[9][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 1)));
        currentFighter.animations[9][2] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 2)));
        currentFighter.animations[9][3] = currentFighter.animations[9][1];
        currentFighter.animations[9][4] = currentFighter.animations[6][1];
        currentFighter.animations[12][0] = currentFighter.animations[13][2];
        currentFighter.animations[15][0] = currentFighter.animations[13][2];
        currentFighter.animations[14][0] = currentFighter.animations[1][0];
        currentFighter.animations[14][1] = currentFighter.animations[1][1];
        currentFighter.animations[14][2] = currentFighter.animations[0][0];
        currentFighter.animations[14][3] = currentFighter.animations[1][0];
        currentFighter.animations[14][4] = currentFighter.animations[1][1];
        currentFighter.animations[16][0] = currentFighter.animations[3][0];
        currentFighter.animations[16][1] = currentFighter.animations[3][1];
        currentFighter.animations[10][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 10, 0)));
        currentFighter.animations[10][1] = currentFighter.animations[5][1];
        currentFighter.animations[11][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 11, 1)));
        currentFighter.animations[11][1] = currentFighter.animations[5][1];
    }

    private static void loadBullSpecificAnim(Fighter currentFighter) throws Exception {
        ResourceLoader.loadAnimSeq(currentFighter, 1);
        ResourceLoader.loadAnimSeq(currentFighter, 2);
        ResourceLoader.loadAnimSeq(currentFighter, 5);
        ResourceLoader.loadAnimSeq(currentFighter, 4);
        ResourceLoader.loadAnimSeq(currentFighter, 6);
        ResourceLoader.loadAnimSeq(currentFighter, 7);
        ResourceLoader.loadAnimSeq(currentFighter, 3);
        ResourceLoader.loadAnimSeq(currentFighter, 0);
        ResourceLoader.loadAnimSeq(currentFighter, 8);
        currentFighter.animations[13][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 13, 0)));
        currentFighter.animations[13][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 13, 1)));
        currentFighter.animations[13][2] = currentFighter.animations[13][0];
        currentFighter.animations[13][3] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 13, 2)));
        currentFighter.animations[13][4] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 13, 3)));
        currentFighter.animations[12][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 12, 0)));
        currentFighter.animations[15][0] = currentFighter.animations[12][0];
        currentFighter.animations[14][0] = currentFighter.animations[1][0];
        currentFighter.animations[14][1] = currentFighter.animations[1][1];
        currentFighter.animations[14][2] = currentFighter.animations[0][0];
        currentFighter.animations[14][3] = currentFighter.animations[2][0];
        currentFighter.animations[9][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 0)));
        currentFighter.animations[9][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 1)));
        currentFighter.animations[9][2] = currentFighter.animations[5][1];
        currentFighter.animations[9][3] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 3)));
        currentFighter.animations[9][4] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 4)));
        currentFighter.animations[9][5] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 2)));
        currentFighter.animations[9][6] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 5)));
        currentFighter.animations[9][7] = currentFighter.animations[5][1];
        currentFighter.animations[9][8] = currentFighter.animations[9][6];
        currentFighter.animations[11][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 11, 1)));
        currentFighter.animations[11][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 11, 0)));
        currentFighter.animations[11][2] = currentFighter.animations[11][0];
        currentFighter.animations[11][3] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 11, 2)));
        currentFighter.animations[11][4] = currentFighter.animations[9][4];
        currentFighter.animations[10][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 11, 3)));
        currentFighter.animations[10][1] = currentFighter.animations[5][1];
        currentFighter.animations[16][0] = currentFighter.animations[3][0];
    }

    private static void loadAmazonSpecificAnim(Fighter currentFighter) throws Exception {
        Fighter.knife = new Sprite(Image.createImage((String)"/amazon/knife.png"));
        ResourceLoader.loadAnimSeq(currentFighter, 1);
        ResourceLoader.loadAnimSeq(currentFighter, 2);
        ResourceLoader.loadAnimSeq(currentFighter, 5);
        ResourceLoader.loadAnimSeq(currentFighter, 6);
        ResourceLoader.loadAnimSeq(currentFighter, 7);
        ResourceLoader.loadAnimSeq(currentFighter, 3);
        ResourceLoader.loadAnimSeq(currentFighter, 0);
        ResourceLoader.loadAnimSeq(currentFighter, 9);
        ResourceLoader.loadAnimSeq(currentFighter, 8);
        ResourceLoader.loadAnimSeq(currentFighter, 13);
        currentFighter.animations[12][0] = currentFighter.animations[13][2];
        currentFighter.animations[15][0] = currentFighter.animations[12][0];
        currentFighter.animations[14][0] = currentFighter.animations[1][0];
        currentFighter.animations[14][1] = currentFighter.animations[1][1];
        currentFighter.animations[14][2] = currentFighter.animations[0][0];
        currentFighter.animations[14][3] = currentFighter.animations[2][0];
        currentFighter.animations[14][4] = currentFighter.animations[2][1];
        currentFighter.animations[4][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 4, 0)));
        currentFighter.animations[4][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 4, 1)));
        currentFighter.animations[4][2] = currentFighter.animations[4][0];
        currentFighter.animations[10][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 11, 0)));
        currentFighter.animations[10][1] = currentFighter.animations[5][1];
        currentFighter.animations[11][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 11, 1)));
        currentFighter.animations[11][1] = currentFighter.animations[5][1];
        currentFighter.animations[16][0] = currentFighter.animations[3][0];
        currentFighter.animations[16][1] = currentFighter.animations[3][1];
    }

    private static void loadMaximusSpecificAnim(Fighter currentFighter) throws Exception {
        ResourceLoader.loadAnimSeq(currentFighter, 13);
        ResourceLoader.loadAnimSeq(currentFighter, 5);
        ResourceLoader.loadAnimSeq(currentFighter, 4);
        ResourceLoader.loadAnimSeq(currentFighter, 6);
        ResourceLoader.loadAnimSeq(currentFighter, 7);
        ResourceLoader.loadAnimSeq(currentFighter, 0);
        ResourceLoader.loadAnimSeq(currentFighter, 1);
        ResourceLoader.loadAnimSeq(currentFighter, 2);
        currentFighter.animations[3][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 3, 0)));
        currentFighter.animations[3][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 3, 1)));
        currentFighter.animations[3][2] = currentFighter.animations[3][0];
        currentFighter.animations[3][3] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 3, 0)));
        currentFighter.animations[8][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 0)));
        currentFighter.animations[8][1] = currentFighter.animations[8][0];
        currentFighter.animations[8][2] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 1)));
        currentFighter.animations[8][3] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 2)));
        currentFighter.animations[8][4] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 8, 0)));
        currentFighter.animations[10][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 3)));
        currentFighter.animations[10][1] = currentFighter.animations[5][1];
        currentFighter.animations[11][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 5)));
        currentFighter.animations[11][1] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 6)));
        currentFighter.animations[11][2] = currentFighter.animations[11][0];
        currentFighter.animations[12][0] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 12, 0)));
        currentFighter.animations[15][0] = currentFighter.animations[12][0];
        currentFighter.animations[9][0] = currentFighter.animations[8][0];
        currentFighter.animations[9][1] = currentFighter.animations[8][0];
        currentFighter.animations[9][2] = currentFighter.animations[8][2];
        currentFighter.animations[9][3] = currentFighter.animations[8][3];
        currentFighter.animations[9][4] = currentFighter.animations[10][0];
        currentFighter.animations[9][5] = new Sprite(Image.createImage((String)ResourceLoader.getPngPath(currentFighter.fighterId, 9, 4)));
        currentFighter.animations[9][6] = currentFighter.animations[11][0];
        currentFighter.animations[9][7] = currentFighter.animations[11][1];
        currentFighter.animations[9][8] = currentFighter.animations[9][6];
        currentFighter.animations[14][0] = currentFighter.animations[1][0];
        currentFighter.animations[14][1] = currentFighter.animations[1][1];
        currentFighter.animations[14][2] = currentFighter.animations[0][0];
        currentFighter.animations[14][3] = currentFighter.animations[2][0];
        currentFighter.animations[14][4] = currentFighter.animations[2][1];
        currentFighter.animations[16][0] = currentFighter.animations[3][0];
        currentFighter.animations[16][1] = currentFighter.animations[3][1];
    }

    private static Image getCharacterName(int id) {
        try {
            switch (id) {
                case 1: {
                    return Image.createImage((String)"/ingame_ama.png");
                }
                case 3: {
                    return Image.createImage((String)"/ingame_bull.png");
                }
                case 8: {
                    return Image.createImage((String)"/ingame_com.png");
                }
                case 5: {
                    return Image.createImage((String)"/ingame_hag.png");
                }
                case 2: {
                    return Image.createImage((String)"/ingame_jub.png");
                }
                case 0: {
                    return Image.createImage((String)"/ingame_mac.png");
                }
                case 7: {
                    return Image.createImage((String)"/ingame_max.png");
                }
                case 6: {
                    return Image.createImage((String)"/ingame_tig.png");
                }
                case 4: {
                    return Image.createImage((String)"/ingame_trid.png");
                }
            }
            return Image.createImage((String)"/ingame_max.png");
        }
        catch (Exception e) {
            System.err.println("Failed to load charactername.");
            return null;
        }
    }

    private static final Image getCharacterIcon(int id) {
        try {
            switch (id) {
                case 1: {
                    return Image.createImage((String)"/icon_amazon.png");
                }
                case 3: {
                    return Image.createImage((String)"/icon_bovinus.png");
                }
                case 8: {
                    return Image.createImage((String)"/icon_commodus.png");
                }
                case 5: {
                    return Image.createImage((String)"/icon_hagen.png");
                }
                case 2: {
                    return Image.createImage((String)"/icon_juba.png");
                }
                case 0: {
                    return Image.createImage((String)"/icon_mace.png");
                }
                case 7: {
                    return Image.createImage((String)"/icon_maximus.png");
                }
                case 6: {
                    return Image.createImage((String)"/icon_tiger.png");
                }
                case 4: {
                    return Image.createImage((String)"/icon_trident.png");
                }
            }
            return Image.createImage((String)"/icon_maximus.png");
        }
        catch (Exception e) {
            System.err.println("Failed to load charactericon.");
            return null;
        }
    }

    public void loadResources(int type, Object data, Object data2) {
        this.loadType = type;
        this.loadData = data;
        this.loadData2 = data2;
        new Thread(this).start();
    }

    public void tick() {
        if (this.lastAnimated + 150L < System.currentTimeMillis()) {
            this.lastAnimated = System.currentTimeMillis();
            ++this.activeFrame;
            if (this.activeFrame >= this.loadingAnim.length) {
                this.activeFrame = 0;
            }
        }
    }

    public void cleanUp() {
        this.loadingAnim = null;
        System.gc();
    }

    private void debug(String text) {
        this.debugInfo = text;
    }

    public void keyEvent(int keyCode, boolean pressed) {
    }

    public void softKeyEvent(int keyCode, boolean pressed) {
    }

    public void drawScreen(Graphics g) {
        g.setClip(0, 0, 240, 300);
        g.setColor(921102);
        g.fillRect(0, 0, 240, 300);
        g.drawImage(this.loadingAnim[this.activeFrame], 120, 150, 3);
        GladFont.setFont(0);
        GladFont.setGraphics(g);
        if (Gladiator2D.TEXT.getText(182) == null) {
            GladFont.drawString("Loading...", 120 - GladFont.getStringWidth("Loading...") / 2, 150 + (this.loadingAnim[this.activeFrame].getHeight() >> 1));
        } else {
            GladFont.drawString(Gladiator2D.TEXT.getText(182) + "...", 120 - GladFont.getStringWidth(Gladiator2D.TEXT.getText(182) + "...") / 2, 150 + (this.loadingAnim[this.activeFrame].getHeight() >> 1));
        }
    }
}

