/*
 * Decompiled with CFR 0.152.
 */
package com.mliven.utils;

import java.util.Vector;

public class MenuItem {
    private String caption;
    private String[] toggleStrings;
    private int toggleIndex;
    public int menuIndex;
    public Vector subMenu;
    public MenuItem parent;

    public MenuItem(String caption, String[] toggleCaptions) {
        this.caption = caption;
        this.toggleStrings = toggleCaptions;
        this.toggleIndex = 0;
        this.subMenu = null;
    }

    public void setParent(MenuItem parent) {
        this.parent = parent;
    }

    public void setToggleIndex(int toggleIndex) {
        this.toggleIndex = toggleIndex;
    }

    public int getToggleIndex() {
        return this.toggleIndex;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getText() {
        if (this.caption == null) {
            return "";
        }
        String toggle = this.getToggleString();
        if (toggle.equals("")) {
            return this.caption;
        }
        return this.caption + " " + this.getToggleString();
    }

    public String getToggleString() {
        if (this.toggleStrings == null) {
            return "";
        }
        return this.toggleStrings[this.toggleIndex];
    }

    public String getToggleString(int index) {
        if (this.toggleStrings == null) {
            return "";
        }
        return this.toggleStrings[index];
    }

    public void toggleRight() {
        if (this.toggleStrings != null) {
            ++this.toggleIndex;
            if (this.toggleIndex >= this.toggleStrings.length) {
                this.toggleIndex = 0;
            }
        }
    }

    public void toggleLeft() {
        if (this.toggleStrings != null) {
            --this.toggleIndex;
            if (this.toggleIndex < 0) {
                this.toggleIndex = this.toggleStrings.length - 1;
            }
        }
    }

    public int getToggleLength() {
        return this.toggleStrings == null ? 0 : this.toggleStrings.length;
    }

    public MenuItem getMenuWithIndex(int index) {
        if (this.menuIndex == index) {
            return this;
        }
        if (this.subMenu != null) {
            for (int i = 0; i < this.subMenu.size(); ++i) {
                MenuItem m = ((MenuItem)this.subMenu.elementAt(i)).getMenuWithIndex(index);
                if (m == null) continue;
                return m;
            }
        }
        return null;
    }
}

