/*
 * Decompiled with CFR 0.152.
 */
package com.mliven.utils;

import com.mliven.DataStore;
import com.mliven.Fighter;
import com.mliven.Gladiator2D;
import com.mliven.GladiatorMidlet;
import com.mliven.utils.AnimatedHeader;
import com.mliven.utils.ChoiceWindow;
import com.mliven.utils.GCanvas;
import com.mliven.utils.GScreen;
import com.mliven.utils.GladFont;
import com.mliven.utils.MenuItem;
import com.mliven.utils.ScrollTextBox;
import com.mliven.utils.SharedGraphics;
import com.mliven.utils.SimpleMenu;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class MainMenu
extends GScreen {
    public static final int LOGO_MEANDER_SPACING = 10;
    public static final int BORDER_HEIGHT = 4;
    public static final int ATTR_OFFSET_X = 1;
    public static final int ATTR_OFFSET_Y = 2;
    public static final int ATTR_BAR_OFFSET_Y = 3;
    public static final int NEXT_FIGHT_PORTRAIT_SPACING = 12;
    public static final int EAGLE_OFFSET = -1;
    public static final int SUBMENU_TEXT_OFFSET = 1;
    public static final int SUBMENU_CHAR_NAME_OFFSET = 2;
    public static final int EASE_OFFSET = 9;
    public static final int SUB_MENU_TXT_BOX_ADD = 0;
    public static final int JEWEl_OFFSET = 1;
    public static final int MENU_TEXT_OFFSET = 3;
    public static final int STATS_OFFSET = 12;
    public static final int DISABLE_DIFFICULTY_LINE_OFFSET = 2;
    public static final int PORTRAIT_SPACING = 10;
    public static final int BORDER_LEFT = 5;
    public static final int BORDER_TOP = 5;
    public static final int BAR_LEFT = 45;
    public static final int BAR_TOP = 7;
    public static final int SPACE_MIDDLE = 50;
    public static final int BAR_HEIGHT = 8;
    public static final int BAR_NAME_SPACE = 2;
    public static final int BARS_SPACE = 3;
    public static final int MEDAL_SPACE_X = 1;
    public static final int MEDAL_SPACE_Y = 3;
    public static final int HEIGHT_FOOTER = 20;
    public static final int MENU_ITEM_HEIGHT = 13;
    public static final int MARGIN = 6;
    public static final int MENU_MAIN = 0;
    public static final int MENU_OPTIONS = 1;
    public static final int MENU_HELP = 2;
    public static final int MENU_MORE_GAMES = 3;
    public static final int MENU_ABOUT = 4;
    public static final int MENU_PLAY = 5;
    public static final int MENU_DIFFICULTY = 6;
    public static final int MENU_BLUETOOTH = 7;
    public static final int MENU_SERVER = 8;
    public static final int MENU_CLIENT = 9;
    public static final int MENU_SERVER_SELECT = 10;
    public static final int MENU_RESUME = 11;
    public static final int MENU_CONTROLS = 12;
    public static final int MENU_LANGUAGE = 13;
    public static final int STATE_MENU = 0;
    public static final int STATE_CHAR_SELECT = 1;
    public static final int STATE_CHAR_INFO = 2;
    public static final int STATE_VERSUS = 3;
    public static final int STATE_ENEMY_SELECT = 4;
    public static final int ITEM_PLAY = 0;
    public static final int ITEM_OPTIONS = 1;
    public static final int ITEM_HELP = 2;
    public static final int ITEM_ABOUT = 3;
    public static final int ITEM_QUIT = 4;
    public static final int ITEM_GET_MORE_GAMES = -1;
    private static final int ITEM_SOUND = 0;
    private static final int ITEM_VIBRATION = 1;
    private static final int ITEM_TIME_LIMIT = 2;
    private static final int ITEM_LANGUAGE = 3;
    private static int ITEM_ARCADE = 0;
    private static int ITEM_SURVIVAL = 1;
    private static int ITEM_TRAINING = 2;
    private static int ITEM_BLUETOOTH = 3;
    private static final int ITEM_EASY = 0;
    private static final int ITEM_NORMAL = 1;
    private static final int ITEM_HARD = 2;
    private static final int ITEM_HOST_GAME = 0;
    private static final int ITEM_JOIN_GAME = 1;
    private static final int ITEM_RECONNECT_1 = 2;
    private static final int ITEM_RECONNECT_2 = 3;
    private static final int ITEM_RECONNECT_3 = 4;
    private static final int ITEM_RESUME = 0;
    private static final int ITEM_START_NEW_GAME = 1;
    private static final int ITEM_INSTRUCTIONS = 0;
    private static final int ITEM_CONTROLS = 1;
    private static final int ITEM_TUTORIAL = 2;
    private static final int SELECTION_MARK_ANIM_TIME = 700;
    public static Image[] char_icons;
    public static Image border;
    public static Image border_selected;
    public static Image disable;
    public static Image attributeBar;
    public static Image attributeJewel;
    public static Image versus;
    public static Image cross;
    public static Image arrow_vs;
    public static Image[] awards;
    public static Image menu_bg;
    public static Image menu_border;
    public static Image gradient;
    public static Image menu_meander;
    public static Image gladiator_logo;
    public static Image menu_eagle;
    public static Sprite[][] charIdles;
    public static Image shadow;
    public static Image bg;
    private int currentMenu;
    private int currentItem;
    public int lastMenuItem;
    private int secondLastMenuItem;
    private int selection_mark_offset = 0;
    private int selection_mark_direction = 0;
    public int state;
    private ChoiceWindow choiceWindow = new ChoiceWindow();
    private boolean showMsg = false;
    private boolean showNewUnlocked = false;
    private boolean showTutorialQuestion = false;
    private int[] idleFrames;
    private int[] idleAnims;
    private int char_index = 0;
    public SimpleMenu menu;
    public AnimatedHeader animHeader = new AnimatedHeader();
    private int animHeaderLastChanged = 0;
    private static boolean animHeaderTextChange;
    private static final int ANIM_HEADER_CHANGE_TIME = 75;
    private ScrollTextBox textBox = new ScrollTextBox("");
    private boolean isTextBoxShowing = false;
    private int[] attribs = new int[DataStore.char_attributes[this.char_index].length];
    public boolean noQuitConfirmMessage = false;
    private static final String GLADIUS = "4523487";
    private static final String CHAMPION = "24267466";
    private String cheatCode = "";
    private long lastCheatEntered = 0L;
    public long menuActivationTime = 0L;

    public MainMenu() {
        this.idleAnims = new int[2];
        this.idleAnims[0] = Math.abs(Gladiator2D.rnd.nextInt() % Fighter.MAXIMUS_ANIM_DELAYS[0][0]);
        this.idleAnims[1] = Math.abs(Gladiator2D.rnd.nextInt() % Fighter.MAXIMUS_ANIM_DELAYS[0][0]);
        this.idleFrames = new int[2];
        this.idleFrames[0] = 0;
        this.idleFrames[1] = 0;
    }

    public void tick() {
        int i;
        this.animHeader.tick();
        if (!this.showMsg && !this.isTextBoxShowing && this.state == 1 && this.animHeaderLastChanged + 75 < Gladiator2D.tick) {
            this.animHeaderLastChanged = Gladiator2D.tick;
            if (!this.animHeader.isAnimating()) {
                switch (DataStore.g_game_mode) {
                    case 1: {
                        if (animHeaderTextChange) {
                            this.animHeader.setText(Gladiator2D.TEXT.getText(88) + ": " + DataStore.survival_records[this.char_index][0] + " " + Gladiator2D.TEXT.getText(38));
                            break;
                        }
                        if (this.animHeader.getText().equals(DataStore.FIGHTER_NAMES_MENU[this.char_index])) break;
                        this.animHeader.setText(DataStore.FIGHTER_NAMES_MENU[this.char_index]);
                        break;
                    }
                    case 0: {
                        if (animHeaderTextChange) {
                            this.animHeader.setText(Gladiator2D.TEXT.getText(87) + ": " + DataStore.arcade_records[this.char_index][DataStore.difficulty * 2]);
                            break;
                        }
                        if (this.animHeader.getText().equals(DataStore.FIGHTER_NAMES_MENU[this.char_index])) break;
                        this.animHeader.setText(DataStore.FIGHTER_NAMES_MENU[this.char_index]);
                        break;
                    }
                    case 2: {
                        if (animHeaderTextChange) {
                            this.animHeader.setText(Gladiator2D.TEXT.getText(11));
                            break;
                        }
                        if (this.animHeader.getText().equals(DataStore.FIGHTER_NAMES_MENU[this.char_index])) break;
                        this.animHeader.setText(DataStore.FIGHTER_NAMES_MENU[this.char_index]);
                    }
                }
                animHeaderTextChange = !animHeaderTextChange;
            }
        }
        this.textBox.tick();
        for (i = 0; i < this.idleAnims.length; ++i) {
            int n = i;
            this.idleAnims[n] = this.idleAnims[n] + 1;
            if (this.idleAnims[i] % Fighter.MAXIMUS_ANIM_DELAYS[0][0] != 0) continue;
            this.idleFrames[i] = 1 - this.idleFrames[i];
        }
        if (this.showMsg) {
            this.choiceWindow.tick();
        } else if (this.selection_mark_direction == 0) {
            ++this.selection_mark_offset;
            if (this.selection_mark_offset > 3) {
                this.selection_mark_direction = 1;
            }
        } else {
            --this.selection_mark_offset;
            if (this.selection_mark_offset < 1) {
                this.selection_mark_direction = 0;
            }
        }
        if (this.state == 1) {
            for (i = 0; i < 4; ++i) {
                if (this.attribs[i] < DataStore.char_attributes[this.char_index][i] * 25) {
                    int n = i;
                    this.attribs[n] = this.attribs[n] + 5;
                    if (this.attribs[i] <= DataStore.char_attributes[this.char_index][i] * 25) continue;
                    this.attribs[i] = DataStore.char_attributes[this.char_index][i] * 25;
                    continue;
                }
                if (this.attribs[i] <= DataStore.char_attributes[this.char_index][i] * 25) continue;
                int n = i;
                this.attribs[n] = this.attribs[n] - 5;
                if (this.attribs[i] >= DataStore.char_attributes[this.char_index][i] * 25) continue;
                this.attribs[i] = DataStore.char_attributes[this.char_index][i] * 25;
            }
        }
    }

    public void cleanUp() {
        int i;
        if (char_icons != null) {
            for (i = 0; i < char_icons.length; ++i) {
                MainMenu.char_icons[i] = null;
            }
        }
        char_icons = null;
        border = null;
        border_selected = null;
        disable = null;
        attributeBar = null;
        attributeJewel = null;
        versus = null;
        cross = null;
        arrow_vs = null;
        if (awards != null) {
            for (i = 0; i < awards.length; ++i) {
                MainMenu.awards[i] = null;
            }
        }
        awards = null;
        menu_bg = null;
        menu_border = null;
        gradient = null;
        menu_meander = null;
        gladiator_logo = null;
        menu_eagle = null;
        shadow = null;
        if (charIdles != null) {
            for (i = 0; i < charIdles.length; ++i) {
                for (int j = 0; j < charIdles[i].length; ++j) {
                    MainMenu.charIdles[i][j] = null;
                }
            }
        }
        charIdles = null;
        bg = null;
        this.choiceWindow.cleanUp();
        System.gc();
    }

    public void keyEvent(int keyCode, boolean pressed) {
        int key;
        if (this.menuActivationTime + 500L > System.currentTimeMillis()) {
            return;
        }
        if (pressed && this.state == 0 && this.menu.getCurrentMenu() == 0 && this.menu.getCurrentItem() == 3 && this.isTextBoxShowing) {
            if (this.lastCheatEntered + 3000L < System.currentTimeMillis()) {
                this.lastCheatEntered = System.currentTimeMillis();
                this.cheatCode = "";
            }
            switch (keyCode) {
                case 48: {
                    this.cheatCode = this.cheatCode + "0";
                    break;
                }
                case 49: {
                    this.cheatCode = this.cheatCode + "1";
                    break;
                }
                case 50: {
                    this.cheatCode = this.cheatCode + "2";
                    break;
                }
                case 51: {
                    this.cheatCode = this.cheatCode + "3";
                    break;
                }
                case 52: {
                    this.cheatCode = this.cheatCode + "4";
                    break;
                }
                case 53: {
                    this.cheatCode = this.cheatCode + "5";
                    break;
                }
                case 54: {
                    this.cheatCode = this.cheatCode + "6";
                    break;
                }
                case 55: {
                    this.cheatCode = this.cheatCode + "7";
                    break;
                }
                case 56: {
                    this.cheatCode = this.cheatCode + "8";
                    break;
                }
                case 57: {
                    this.cheatCode = this.cheatCode + "9";
                }
            }
            if (this.cheatCode.compareTo(CHAMPION) == 0) {
                this.cheatCode = "";
                DataStore.unlocked_character = 8;
                DataStore.unlocked_difficulty = 2;
                DataStore.cheat_unlock = true;
                this.buildUpMenu();
                DataStore.saveRecords();
                this.isTextBoxShowing = false;
                this.displayUnlockablesIfNecessary();
                return;
            }
            if (this.cheatCode.compareTo(GLADIUS) == 0) {
                this.cheatCode = "";
                DataStore.cheat_fight = true;
                this.isTextBoxShowing = false;
            } else {
                String s1 = CHAMPION;
                String s2 = GLADIUS;
                if (this.cheatCode.compareTo(s1.substring(0, this.cheatCode.length())) != 0 && this.cheatCode.compareTo(s2.substring(0, this.cheatCode.length())) != 0) {
                    this.cheatCode = "";
                }
            }
        }
        if (keyCode != -21 && keyCode != -22 && keyCode != 42 && keyCode != 52 && keyCode != 54 && keyCode != 53 && keyCode != 50 && keyCode != 56) {
            try {
                key = GCanvas.getInstance().getGameAction(keyCode);
            }
            catch (Exception e) {
                return;
            }
        } else {
            key = keyCode;
        }
        if (pressed) {
            if (this.showMsg) {
                this.handleMsgWindowKeyPress(key);
                return;
            }
            if (this.isTextBoxShowing) {
                this.handleTextBoxKeyPress(key);
                return;
            }
            block13 : switch (this.state) {
                case 4: {
                    this.handleSelectCharacterKeyPress(key, false);
                    break;
                }
                case 1: {
                    this.handleSelectCharacterKeyPress(key, true);
                    break;
                }
                case 3: {
                    this.handleVersusKeyPress(key);
                    break;
                }
                case 0: {
                    this.currentMenu = this.menu.getCurrentMenu();
                    this.currentItem = this.menu.getCurrentItem();
                    switch (this.currentMenu) {
                        case 0: {
                            this.handleMainMenuKeypress(key);
                            break block13;
                        }
                        case 1: {
                            this.handleOptionsKeyPress(key);
                            break block13;
                        }
                        case 13: {
                            this.handleLanguageKeyPress(key);
                            break block13;
                        }
                        case 2: {
                            this.handleHelpMenuKeyPress(key);
                            break block13;
                        }
                        case 5: {
                            this.handlePlayMenuKeypress(key);
                            break block13;
                        }
                        case 6: {
                            this.handleDifficultyMenuKeyPress(key);
                            break block13;
                        }
                        case 11: {
                            this.handleResumeMenuKeypress(key);
                        }
                    }
                }
            }
        }
    }

    public void softKeyEvent(int keyCode, boolean pressed) {
        this.keyEvent(keyCode, pressed);
    }

    private void handleVersusKeyPress(int key) {
        switch (key) {
            case 2: 
            case 52: {
                if (!DataStore.cheat_fight || DataStore.g_current_fight <= 0) break;
                DataStore.opponentChar = DataStore.arcade_opponents[DataStore.playerChar][--DataStore.g_current_fight];
                break;
            }
            case 5: 
            case 54: {
                if (!DataStore.cheat_fight || DataStore.g_current_fight >= DataStore.arcade_opponents[0].length - 1) break;
                DataStore.opponentChar = DataStore.arcade_opponents[DataStore.playerChar][++DataStore.g_current_fight];
                break;
            }
            case -21: 
            case 8: 
            case 53: {
                Gladiator2D.getInstance().handleEvent(5, null);
                break;
            }
            case -22: {
                if (!this.noQuitConfirmMessage) {
                    if (this.showMsg) break;
                    this.choiceWindow.set(Gladiator2D.TEXT.getText(49), true);
                    this.showMsg = true;
                    break;
                }
                this.setState(1);
                this.animHeader.setText(Gladiator2D.TEXT.getText(16));
            }
        }
    }

    private void handleSelectCharacterKeyPress(int key, boolean char_select) {
        int index = 0;
        index = this.char_index;
        switch (key) {
            case 8: 
            case 53: {
                switch (this.state) {
                    case 1: {
                        if (index > DataStore.unlocked_character) break;
                        DataStore.playerChar = index;
                        if (DataStore.g_game_mode == 2) {
                            this.setState(4);
                            this.animHeader.setText(Gladiator2D.TEXT.getText(17));
                        }
                        if (DataStore.g_game_mode == 1) {
                            Gladiator2D.fightScreen.arena.initSurvivalMode();
                            Gladiator2D.getInstance().handleEvent(5, null);
                        }
                        if (DataStore.g_game_mode != 0) break;
                        Gladiator2D.fightScreen.arena.initArcadeMode();
                        this.setState(3);
                        break;
                    }
                    case 4: {
                        DataStore.opponentChar = index;
                        Gladiator2D.getInstance().handleEvent(5, null);
                    }
                }
                return;
            }
            case -22: {
                if (DataStore.g_game_mode == 0) {
                    this.goToMenu();
                    break;
                }
                if (this.state == 4) {
                    this.setState(1);
                    this.char_index = DataStore.playerChar;
                    this.animHeader.setText(Gladiator2D.TEXT.getText(16));
                    return;
                }
                this.goToMenu();
                break;
            }
            case -21: {
                if (char_select) {
                    if (this.char_index > DataStore.unlocked_character) break;
                    if (DataStore.g_game_mode == 0) {
                        this.initTextBox(this.textBox, DataStore.FIGHTER_NAMES[this.char_index], Gladiator2D.TEXT.getText(87) + ": " + DataStore.arcade_records[this.char_index][DataStore.difficulty * 2] + "\n" + Gladiator2D.TEXT.getText(90) + ": " + this.getReputation(DataStore.g_game_mode, DataStore.difficulty, this.char_index) + "\n\n" + this.getDiscriptionText(this.char_index));
                        break;
                    }
                    if (DataStore.g_game_mode == 1) {
                        this.initTextBox(this.textBox, DataStore.FIGHTER_NAMES[this.char_index], Gladiator2D.TEXT.getText(88) + ": " + DataStore.survival_records[this.char_index][0] + " " + Gladiator2D.TEXT.getText(38) + "\n" + Gladiator2D.TEXT.getText(90) + ": " + this.getReputation(DataStore.g_game_mode, DataStore.difficulty, this.char_index) + "\n\n" + this.getDiscriptionText(this.char_index));
                        break;
                    }
                    this.initTextBox(this.textBox, DataStore.FIGHTER_NAMES[this.char_index], this.getDiscriptionText(this.char_index));
                    break;
                }
                DataStore.opponentChar = index;
                Gladiator2D.getInstance().handleEvent(5, null);
                return;
            }
            case 5: 
            case 54: {
                if (++index == 9 || index == 8 && DataStore.unlocked_character < 8) {
                    index = 0;
                }
                if (index > DataStore.unlocked_character && char_select) {
                    --index;
                    break;
                }
                if (this.state != 1) break;
                this.animHeader.setText(DataStore.FIGHTER_NAMES_MENU[index]);
                break;
            }
            case 2: 
            case 52: {
                int startIndex = index--;
                if (index == -1) {
                    index = 8;
                }
                if (index == 8 && DataStore.unlocked_character < 8) {
                    index = 7;
                }
                if (index > DataStore.unlocked_character && char_select) {
                    index = startIndex;
                    break;
                }
                if (this.state != 1) break;
                this.animHeader.setText(DataStore.FIGHTER_NAMES_MENU[index]);
                break;
            }
            case 1: 
            case 6: 
            case 50: 
            case 56: {
                int startIndex = index;
                int value = 5;
                if (DataStore.unlocked_character < 8) {
                    value = 4;
                }
                if (index < value) {
                    if ((index += value) == 9) {
                        index = 8;
                    }
                    if (index == 8 && DataStore.unlocked_character < 8) {
                        index = 7;
                    }
                } else {
                    index -= value;
                }
                if (index > DataStore.unlocked_character && char_select) {
                    index = startIndex;
                    break;
                }
                if (this.state != 1) break;
                this.animHeader.setText(DataStore.FIGHTER_NAMES_MENU[index]);
            }
        }
        this.char_index = index;
    }

    private void handleTextBoxKeyPress(int keyCode) {
        switch (keyCode) {
            case 1: 
            case 50: {
                this.textBox.up();
                break;
            }
            case 6: 
            case 56: {
                this.textBox.down();
                break;
            }
            case -22: {
                this.isTextBoxShowing = false;
            }
        }
    }

    private void handleMsgWindowKeyPress(int keyCode) {
        switch (keyCode) {
            case 1: 
            case 50: {
                this.choiceWindow.up();
                break;
            }
            case 6: 
            case 56: {
                this.choiceWindow.down();
                break;
            }
            case -21: 
            case 8: 
            case 53: {
                this.showMsg = false;
                this.showNewUnlocked = false;
                if (this.showTutorialQuestion) {
                    this.showTutorialQuestion = false;
                    if (this.choiceWindow.fire()) {
                        Gladiator2D.fightScreen.arena.initTutorial();
                        Gladiator2D.getInstance().handleEvent(5, null);
                    } else {
                        this.menu.select();
                        this.animHeader.setText(this.getMenuText());
                    }
                    return;
                }
                if (!this.choiceWindow.fire()) break;
                if (this.state == 3) {
                    if (!this.choiceWindow.fire()) break;
                    this.saveGameDuringVersusScreen();
                    this.goBackToMenu();
                    return;
                }
                switch (this.menu.getCurrentMenu()) {
                    case 0: {
                        if (this.showNewUnlocked) break;
                        Gladiator2D.getInstance().close();
                        break;
                    }
                    case 11: {
                        DataStore.resume_last_game = false;
                        DataStore.deleteLastGame(DataStore.g_game_mode);
                        if (DataStore.g_game_mode == 0) {
                            this.menu.setCurrentMenu(6, 0);
                            this.animHeader.setText(this.getMenuText());
                            break;
                        }
                        this.setState(1);
                        this.animHeader.setText(Gladiator2D.TEXT.getText(16));
                    }
                }
                break;
            }
            case -22: {
                this.showMsg = false;
                this.showNewUnlocked = false;
            }
        }
    }

    private void handleDifficultyMenuKeyPress(int keyCode) {
        switch (keyCode) {
            case 1: 
            case 50: {
                this.menu.up();
                String t = this.menu.getItemAt(this.menu.getCurrentItem()).getText();
                if (t.equals(Gladiator2D.TEXT.getText(14)) && DataStore.unlocked_difficulty == 0) {
                    this.menu.down();
                }
                t = null;
                break;
            }
            case 6: 
            case 56: {
                this.menu.down();
                String t = this.menu.getItemAt(this.menu.getCurrentItem()).getText();
                if (t.equals(Gladiator2D.TEXT.getText(14)) && DataStore.unlocked_difficulty == 0) {
                    this.menu.up();
                }
                t = null;
                break;
            }
            case -21: 
            case 8: 
            case 53: {
                DataStore.difficulty = this.menu.getCurrentItem();
                this.setState(1);
                this.animHeader.setText(Gladiator2D.TEXT.getText(16));
                break;
            }
            case -22: {
                this.menu.back(this.lastMenuItem);
                this.animHeader.setText(this.getMenuText());
            }
        }
    }

    private void handlePlayMenuKeypress(int keyCode) {
        this.handleMenuMovementKeys(keyCode);
        switch (keyCode) {
            case -21: 
            case 8: 
            case 53: {
                if (this.currentItem == ITEM_TRAINING) {
                    DataStore.g_game_mode = 2;
                    this.lastMenuItem = this.currentItem;
                    this.menu.setCurrentMenu(6, 0);
                    this.animHeader.setText(this.getMenuText());
                }
                if (this.currentItem == ITEM_ARCADE) {
                    boolean saveGame = DataStore.loadLastGame(0);
                    DataStore.g_game_mode = 0;
                    this.menu.select();
                    this.lastMenuItem = this.currentItem;
                    if (!saveGame) {
                        this.menu.setCurrentMenu(this.menu.getCurrentMenu(), 1);
                        this.menu.select();
                        this.noQuitConfirmMessage = true;
                    } else {
                        this.loadGlobalFightData();
                    }
                    this.animHeader.setText(this.getMenuText());
                }
                if (this.currentItem != ITEM_SURVIVAL) break;
                DataStore.g_game_mode = 1;
                if (DataStore.loadLastGame(1)) {
                    this.loadGlobalFightData();
                    this.menu.setCurrentMenu(11, 0);
                    this.animHeader.setText(this.getMenuText());
                    break;
                }
                this.setState(1);
                this.animHeader.setText(Gladiator2D.TEXT.getText(16));
                break;
            }
            case -22: {
                this.menu.back(0);
                this.animHeader.setText("");
            }
        }
    }

    private void handleMainMenuKeypress(int keyCode) {
        this.handleMenuMovementKeys(keyCode);
        block0 : switch (keyCode) {
            case -21: 
            case 8: 
            case 53: {
                switch (this.currentItem) {
                    case 3: {
                        this.initTextBox(this.textBox, Gladiator2D.TEXT.getText(3), "v" + GladiatorMidlet.instance.getAppProperty("MIDlet-Version") + "\n\n" + Gladiator2D.TEXT.getText(32) + "\n");
                        break block0;
                    }
                    case 4: {
                        this.choiceWindow.set(Gladiator2D.TEXT.getText(48), true);
                        this.showMsg = true;
                        break block0;
                    }
                }
                if (this.menu.getCurrentItem() == 0 && DataStore.start_tutorial) {
                    DataStore.start_tutorial = false;
                    DataStore.saveRecords();
                    if (this.choiceWindow == null) {
                        this.choiceWindow = new ChoiceWindow();
                    }
                    this.choiceWindow.set(Gladiator2D.TEXT.getText(156), true);
                    this.choiceWindow.up();
                    this.showTutorialQuestion = true;
                    this.showMsg = true;
                    return;
                }
                this.menu.select();
                if (this.menu.getCurrentMenu() == 1) {
                    this.menu.getItemAt(0).setToggleIndex(DataStore.opt_soundVolume);
                    this.menu.getItemAt(1).setToggleIndex(DataStore.opt_vibration ? 0 : 1);
                }
                this.animHeader.setText(this.getMenuText());
            }
        }
    }

    private void handleResumeMenuKeypress(int keyCode) {
        this.handleMenuMovementKeys(keyCode);
        switch (keyCode) {
            case -21: 
            case 8: 
            case 53: {
                if (this.menu.getCurrentItem() == 0) {
                    if (DataStore.g_game_mode == 0) {
                        this.noQuitConfirmMessage = true;
                        DataStore.resume_last_game = true;
                        DataStore.g_current_fight = DataStore.resume_current_fight;
                        DataStore.playerChar = DataStore.resume_char_id;
                        this.setState(3);
                    }
                    if (DataStore.g_game_mode != 1) break;
                    DataStore.resume_last_game = true;
                    Gladiator2D.getInstance().handleEvent(5, null);
                    break;
                }
                this.choiceWindow.set(Gladiator2D.TEXT.getText(47), true);
                this.noQuitConfirmMessage = true;
                this.showMsg = true;
                break;
            }
            case -22: {
                this.menu.back(this.lastMenuItem);
                this.animHeader.setText(this.getMenuText());
            }
        }
    }

    private void handleLanguageKeyPress(int keyCode) {
        this.handleMenuMovementKeys(keyCode);
        switch (keyCode) {
            case -21: 
            case 8: 
            case 53: {
                DataStore.language = this.menu.getCurrentItem();
                Gladiator2D.getInstance().handleEvent(10, this);
                DataStore.saveSettings();
                break;
            }
            case -22: {
                this.menu.back(3);
                this.animHeader.setText(this.getMenuText());
            }
        }
    }

    private void handleHelpMenuKeyPress(int keyCode) {
        this.handleMenuMovementKeys(keyCode);
        switch (keyCode) {
            case -21: 
            case 8: 
            case 53: {
                switch (this.currentItem) {
                    case 0: {
                        this.initTextBox(this.textBox, Gladiator2D.TEXT.getText(24), Gladiator2D.TEXT.getText(46));
                        break;
                    }
                    case 1: {
                        this.initTextBox(this.textBox, Gladiator2D.TEXT.getText(22), Gladiator2D.TEXT.getText(45));
                        break;
                    }
                    case 2: {
                        Gladiator2D.fightScreen.arena.initTutorial();
                        Gladiator2D.getInstance().handleEvent(5, null);
                    }
                }
                break;
            }
            case -22: {
                this.menu.back(2);
                this.animHeader.setText("");
            }
        }
    }

    private void handleOptionsKeyPress(int keyCode) {
        this.handleMenuMovementKeys(keyCode);
        switch (keyCode) {
            case -21: 
            case 8: 
            case 53: {
                if (this.currentItem == 3) {
                    this.menu.select();
                    this.animHeader.setText(this.getMenuText());
                    break;
                }
            }
            case 5: 
            case 54: {
                this.menu.right();
                this.optionsToggle(0, this.currentItem, this.menu.getItemAt(this.menu.getCurrentItem()).getToggleIndex());
                break;
            }
            case 2: 
            case 52: {
                this.menu.left();
                this.optionsToggle(0, this.currentItem, this.menu.getItemAt(this.menu.getCurrentItem()).getToggleIndex());
                break;
            }
            case -22: {
                this.menu.back(1);
                this.animHeader.setText("");
            }
        }
    }

    private void handleMenuMovementKeys(int keyCode) {
        switch (keyCode) {
            case 1: 
            case 50: {
                this.menu.up();
                break;
            }
            case 6: 
            case 56: {
                this.menu.down();
            }
        }
    }

    private void initTextBox(ScrollTextBox box, String title, String text) {
        box.setText(text);
        box.setTitle(title);
        box.fadeIn();
        box.resetScrollBar();
        this.isTextBoxShowing = true;
    }

    public void goBackToMenu() {
        if (DataStore.g_game_mode == 4) {
            this.menu.back(0);
        } else {
            this.menu.back(this.lastMenuItem);
        }
        this.state = 0;
        this.animHeader.setText(this.getMenuText());
    }

    public void goToMenu() {
        this.state = 0;
        this.animHeader.setText(this.getMenuText());
    }

    private String getMenuText() {
        switch (this.menu.getCurrentMenu()) {
            case 5: {
                return Gladiator2D.TEXT.getText(7);
            }
            case 11: {
                return Gladiator2D.TEXT.getText(18);
            }
            case 2: {
                return Gladiator2D.TEXT.getText(2);
            }
            case 6: {
                return Gladiator2D.TEXT.getText(12);
            }
            case 7: {
                return Gladiator2D.TEXT.getText(59);
            }
            case 10: {
                return Gladiator2D.TEXT.getText(60);
            }
            case 13: {
                return Gladiator2D.TEXT.getText(19);
            }
            case 1: {
                return Gladiator2D.TEXT.getText(1);
            }
        }
        return "";
    }

    private String getDiscriptionText(int id) {
        switch (id) {
            case 1: {
                return Gladiator2D.TEXT.getText(65);
            }
            case 3: {
                return Gladiator2D.TEXT.getText(66);
            }
            case 8: {
                return Gladiator2D.TEXT.getText(67);
            }
            case 5: {
                return Gladiator2D.TEXT.getText(68);
            }
            case 2: {
                return Gladiator2D.TEXT.getText(69);
            }
            case 0: {
                return Gladiator2D.TEXT.getText(70);
            }
            case 7: {
                return Gladiator2D.TEXT.getText(71);
            }
            case 6: {
                return Gladiator2D.TEXT.getText(72);
            }
            case 4: {
                return Gladiator2D.TEXT.getText(73);
            }
        }
        return "wrong id";
    }

    private String getReputation(int mode, int difficulty, int character) {
        if (mode == 0) {
            switch (DataStore.arcade_records[character][difficulty * 2 + 1]) {
                case 0: {
                    return Gladiator2D.TEXT.getText(91);
                }
                case 1: {
                    return Gladiator2D.TEXT.getText(92);
                }
                case 2: {
                    return Gladiator2D.TEXT.getText(93);
                }
                case 3: {
                    return Gladiator2D.TEXT.getText(94);
                }
            }
        } else if (mode == 1 && DataStore.survival_records[character][0] >= 3) {
            if (DataStore.survival_records[character][0] < 5) {
                return Gladiator2D.TEXT.getText(92);
            }
            if (DataStore.survival_records[character][0] < 8) {
                return Gladiator2D.TEXT.getText(93);
            }
            return Gladiator2D.TEXT.getText(94);
        }
        return Gladiator2D.TEXT.getText(91);
    }

    public void buildUpMenu() {
        MenuItem[] difficultyMenu;
        this.state = 0;
        this.currentMenu = 0;
        this.currentItem = 0;
        this.menu = new SimpleMenu();
        int rootItemCount = 5;
        MenuItem[] rootMenu = new MenuItem[rootItemCount];
        rootMenu[0] = new MenuItem(Gladiator2D.TEXT.getText(0), null);
        rootMenu[1] = new MenuItem(Gladiator2D.TEXT.getText(1), null);
        rootMenu[3] = new MenuItem(Gladiator2D.TEXT.getText(3), null);
        rootMenu[2] = new MenuItem(Gladiator2D.TEXT.getText(2), null);
        rootMenu[4] = new MenuItem(Gladiator2D.TEXT.getText(4), null);
        int menu_length = 3;
        MenuItem[] playMenu = new MenuItem[menu_length];
        playMenu[MainMenu.ITEM_ARCADE] = new MenuItem(Gladiator2D.TEXT.getText(8), null);
        playMenu[MainMenu.ITEM_SURVIVAL] = new MenuItem(Gladiator2D.TEXT.getText(9), null);
        playMenu[MainMenu.ITEM_TRAINING] = new MenuItem(Gladiator2D.TEXT.getText(11), null);
        if (DataStore.unlocked_difficulty > 1) {
            difficultyMenu = new MenuItem[3];
            difficultyMenu[2] = new MenuItem(Gladiator2D.TEXT.getText(15), null);
        } else {
            difficultyMenu = new MenuItem[]{new MenuItem(Gladiator2D.TEXT.getText(13), null), new MenuItem(Gladiator2D.TEXT.getText(14), null)};
        }
        MenuItem[] resumeMenu = new MenuItem[]{new MenuItem(Gladiator2D.TEXT.getText(20), null), new MenuItem(Gladiator2D.TEXT.getText(21), null)};
        MenuItem[] moreGamesMenu = new MenuItem[]{new MenuItem(null, null)};
        MenuItem[] aboutMenu = new MenuItem[]{new MenuItem(null, null)};
        MenuItem[] helpMenu = new MenuItem[]{new MenuItem(Gladiator2D.TEXT.getText(24), null), new MenuItem(Gladiator2D.TEXT.getText(22), null), new MenuItem(Gladiator2D.TEXT.getText(23), null)};
        MenuItem[] controlsMenu = new MenuItem[]{new MenuItem(null, null)};
        MenuItem[] instructionsMenu = new MenuItem[]{new MenuItem(null, null)};
        MenuItem[] optionsMenu = new MenuItem[4];
        optionsMenu[3] = new MenuItem(Gladiator2D.TEXT.getText(25), null);
        optionsMenu[0] = new MenuItem(Gladiator2D.TEXT.getText(26), new String[]{Gladiator2D.TEXT.getText(27), Gladiator2D.TEXT.getText(28)});
        optionsMenu[1] = new MenuItem(Gladiator2D.TEXT.getText(29), new String[]{Gladiator2D.TEXT.getText(28), Gladiator2D.TEXT.getText(27)});
        optionsMenu[2] = new MenuItem(Gladiator2D.TEXT.getText(30) + ":", new String[]{Gladiator2D.TEXT.getText(31), "60s", "90s"});
        optionsMenu[2].setToggleIndex(DataStore.g_timeLimit);
        optionsMenu[0].setToggleIndex(DataStore.opt_soundVolume);
        if (DataStore.opt_vibration) {
            optionsMenu[1].setToggleIndex(0);
        } else {
            optionsMenu[1].setToggleIndex(1);
        }
        MenuItem[] langMenu = new MenuItem[]{new MenuItem("English", null), new MenuItem("Deutsch", null), new MenuItem("Fran\u00e7ais", null), new MenuItem("Italiano", null), new MenuItem("Espa\u00f1ol", null)};
        this.menu.addMenu(0, null, rootMenu);
        this.menu.addMenu(5, new int[]{0}, playMenu);
        this.menu.addMenu(11, new int[]{0, ITEM_ARCADE}, resumeMenu);
        this.menu.addMenu(11, new int[]{0, ITEM_SURVIVAL}, resumeMenu);
        this.menu.addMenu(6, new int[]{0, ITEM_ARCADE, 1}, difficultyMenu);
        this.menu.addMenu(6, new int[]{0, ITEM_TRAINING}, difficultyMenu);
        this.menu.addMenu(1, new int[]{1}, optionsMenu);
        this.menu.addMenu(13, new int[]{1, 3}, langMenu);
        this.menu.addMenu(4, new int[]{3}, aboutMenu);
        this.menu.addMenu(2, new int[]{2}, helpMenu);
        this.menu.addMenu(12, new int[]{2, 1}, controlsMenu);
        this.menu.addMenu(12, new int[]{2, 0}, instructionsMenu);
        this.menu.setCurrentMenu(this.currentMenu, this.currentItem);
    }

    private void optionsToggle(int key, int currentItem, int toggleIndex) {
        block12: {
            block0 : switch (this.menu.getCurrentMenu()) {
                case 1: {
                    switch (currentItem) {
                        case 0: {
                            DataStore.opt_soundVolume = toggleIndex;
                            if (toggleIndex == 0) {
                                Gladiator2D.sound.stop();
                            } else if (toggleIndex == 1) {
                                Gladiator2D.sound.playMusic(17);
                            }
                            Gladiator2D.sound.setVolume(DataStore.opt_soundVolume);
                            break block0;
                        }
                        case 1: {
                            boolean bl = DataStore.opt_vibration = toggleIndex == 0;
                            if (DataStore.opt_vibration) {
                                Gladiator2D.getInstance().vibrate();
                                break block0;
                            }
                            break block12;
                        }
                        case 2: {
                            DataStore.g_timeLimit = toggleIndex;
                        }
                    }
                }
            }
        }
    }

    public static void drawLines(Graphics g, int x, int y, int width) {
        g.setColor(3217416);
        g.drawLine(x, y - 3, x + width - 1, y - 3);
        g.setColor(8479041);
        g.drawLine(x, y - 2, x + width - 1, y - 2);
        g.setColor(4598034);
        g.drawLine(x, y - 1, x + width - 1, y - 1);
        g.setColor(0);
        g.drawLine(x, y, x + width - 1, y);
    }

    private static void drawMenuBG(Graphics g, int bottom_y) {
        int i;
        for (i = 0; i < 240; i += menu_border.getWidth()) {
            g.drawImage(menu_border, i, bottom_y - menu_border.getHeight(), 0);
        }
        for (i = 0; i < 240; i += menu_bg.getWidth()) {
            g.drawImage(menu_bg, i, bottom_y - menu_border.getHeight() - menu_bg.getHeight(), 0);
        }
        for (i = 0; i < 240; i += menu_border.getWidth()) {
            g.drawImage(menu_border, i, bottom_y - 2 * menu_border.getHeight() - menu_bg.getHeight(), 0);
        }
    }

    private static void drawMenuBG(Graphics g, int top, int bottom) {
        int i;
        g.setClip(0, top, 240, bottom);
        for (int j = 0; j < bottom - top - 2 * menu_border.getHeight(); j += menu_bg.getHeight()) {
            for (int i2 = 0; i2 < 240; i2 += menu_bg.getWidth()) {
                g.drawImage(menu_bg, i2, top + menu_border.getHeight() + j, 0);
            }
        }
        for (i = 0; i < 240; i += menu_border.getWidth()) {
            g.drawImage(menu_border, i, bottom - menu_border.getHeight(), 0);
        }
        for (i = 0; i < 240; i += menu_border.getWidth()) {
            g.drawImage(menu_border, i, top, 0);
        }
        g.setClip(0, 0, 240, 300);
    }

    private static void drawMenuBackground(Graphics g) {
        MainMenu.drawMenuBG(g, 280 - menu_bg.getHeight() - 2 * menu_border.getHeight(), 280);
    }

    private void displayUnlockablesIfNecessary() {
        if (DataStore.last_unlocked_character != DataStore.unlocked_character || DataStore.last_unlocked_difficulty != DataStore.unlocked_difficulty || DataStore.unlock_hint) {
            this.showMsg = true;
            String text = "";
            if (DataStore.unlock_hint) {
                text = text + Gladiator2D.TEXT.getText(188);
                DataStore.unlock_hint = false;
            } else if (DataStore.last_unlocked_character != DataStore.unlocked_character) {
                text = DataStore.unlocked_character - DataStore.last_unlocked_character == 1 ? text + Gladiator2D.TEXT.getText(34) + ":\n\n" : text + Gladiator2D.TEXT.getText(35) + ":\n\n";
                for (int i = DataStore.last_unlocked_character + 1; i <= DataStore.unlocked_character; ++i) {
                    text = text + " - " + DataStore.FIGHTER_NAMES[i] + "\n";
                }
                DataStore.last_unlocked_character = DataStore.unlocked_character;
            }
            if (DataStore.last_unlocked_difficulty != DataStore.unlocked_difficulty) {
                if (text.length() > 2) {
                    text = text + "\n";
                }
                text = text + Gladiator2D.TEXT.getText(36) + ":\n\n";
                if (DataStore.last_unlocked_difficulty == 0) {
                    text = text + " - " + Gladiator2D.TEXT.getText(14) + "\n";
                    if (!DataStore.cheat_unlock) {
                        text = text + "\n" + Gladiator2D.TEXT.getText(189);
                    }
                } else {
                    text = text + " - " + Gladiator2D.TEXT.getText(15) + "\n";
                }
                DataStore.last_unlocked_difficulty = DataStore.unlocked_difficulty;
            }
            if (this.choiceWindow == null) {
                this.choiceWindow = new ChoiceWindow();
            }
            this.showNewUnlocked = true;
            this.choiceWindow.set(text, false);
        }
    }

    public void setState(int state) {
        switch (state) {
            case 3: {
                this.animHeader.setText(Gladiator2D.TEXT.getText(37));
                if (DataStore.opt_soundVolume == 0 || Gladiator2D.sound.getLastMusic() == 18) break;
                Gladiator2D.sound.stop();
                Gladiator2D.sound.playMusic(18);
                break;
            }
            case 1: 
            case 4: {
                this.animHeaderLastChanged = Gladiator2D.tick;
                animHeaderTextChange = false;
                this.char_index = 0;
            }
            case 2: {
                if (DataStore.opt_soundVolume == 0 || Gladiator2D.sound.getLastMusic() == 18) break;
                Gladiator2D.sound.stop();
                Gladiator2D.sound.playMusic(18);
                break;
            }
            case 0: {
                this.displayUnlockablesIfNecessary();
                if (DataStore.opt_soundVolume != 0 && Gladiator2D.sound.getLastMusic() != 17) {
                    Gladiator2D.sound.stop();
                    Gladiator2D.sound.playMusic(17);
                }
                this.animHeader.setText(this.getMenuText());
            }
        }
        this.state = state;
    }

    public static int getMenuBGHeight() {
        return menu_border.getHeight() * 2 + menu_bg.getHeight();
    }

    private void drawMenu(Graphics g) {
        GladFont.setFont(0);
        if (!this.menu.currentMenuIsEmpty()) {
            String t;
            int i;
            int menu_top = 280 - MainMenu.getMenuBGHeight() / 2 - this.menu.getCurrentLength() * 13 / 2 + 3;
            for (i = 0; i < this.menu.getCurrentLength(); ++i) {
                t = this.menu.getItemAt(i).getText();
                if (i == this.menu.getCurrentItem()) {
                    SharedGraphics.drawSelectionWing(g, true, 120 - this.selection_mark_offset - GladFont.getStringWidth(t) / 2, menu_top + this.menu.getCurrentItem() * 13);
                    SharedGraphics.drawSelectionWing(g, false, 120 + this.selection_mark_offset + GladFont.getStringWidth(t) / 2, menu_top + this.menu.getCurrentItem() * 13);
                }
                GladFont.drawString(t, 120, menu_top + i * 13 - GladFont.getRowHeight() / 2, 4);
            }
            for (i = 0; i < this.menu.getCurrentLength(); ++i) {
                t = this.menu.getItemAt(i).getText();
                if (!t.equals(Gladiator2D.TEXT.getText(14)) || DataStore.unlocked_difficulty != 0) continue;
                g.setColor(9991232);
                g.drawLine(120 - GladFont.getStringWidth(t) / 2 - 2, menu_top + i * 13 + 2, 120 + GladFont.getStringWidth(t) / 2 + 2, menu_top + i * 13 + 2);
            }
        }
    }

    public static void drawBox(Graphics g, int x, int y, int width, int height) {
        g.setColor(921102);
        g.fillRect(x, y, width, height);
        g.setColor(3217416);
        g.drawLine(x, y, x + width - 1, y);
        g.setColor(8479041);
        g.drawLine(x, y + 1, x + width - 1, y + 1);
        g.setColor(4598034);
        g.drawLine(x, y + 2, x + width - 1, y + 2);
        g.setColor(0);
        g.drawLine(x, y + 3, x + width - 1, y + 3);
        g.setColor(3217416);
        g.drawLine(x, y + height - 3, x + width - 1, y + height - 3);
        g.setColor(8479041);
        g.drawLine(x, y + height - 2, x + width - 1, y + height - 2);
        g.setColor(4598034);
        g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
        g.setColor(0);
        g.drawLine(x, y + height, x + width - 1, y + height);
    }

    public void drawMenuTop(Graphics g, boolean drawEagle) {
        if (this.state == 0) {
            if (bg.getWidth() < 240) {
                g.setColor(0);
                g.fillRect(0, 0, (240 - bg.getWidth()) / 2 + 1, bg.getHeight());
                g.fillRect((240 - bg.getWidth()) / 2 + bg.getWidth(), 0, (240 - bg.getWidth()) / 2 + 1, bg.getHeight());
            }
            g.drawImage(bg, 120, 4 + 2 * menu_meander.getHeight() + gladiator_logo.getHeight() + 20 + 2, 17);
        }
        g.setColor(3217416);
        g.drawLine(0, 0, 240, 0);
        g.setColor(8479041);
        g.drawLine(0, 1, 240, 1);
        g.setColor(4598034);
        g.drawLine(0, 2, 240, 2);
        g.setColor(0);
        g.drawLine(0, 3, 240, 3);
        g.setColor(921102);
        g.fillRect(0, 4 + menu_meander.getHeight(), 240, gladiator_logo.getHeight() + 20);
        for (int i = 0; i < 240; i += menu_meander.getWidth()) {
            g.drawImage(menu_meander, 0 + i, 4, 0);
            g.drawImage(menu_meander, 0 + i, 4 + menu_meander.getHeight() + gladiator_logo.getHeight() + 20, 0);
        }
        g.drawImage(gladiator_logo, 120 - gladiator_logo.getWidth() / 2, menu_meander.getHeight() + 4 + 10, 0);
        g.setColor(3217416);
        g.drawLine(0, 4 + 2 * menu_meander.getHeight() + gladiator_logo.getHeight() + 20, 240, 4 + 2 * menu_meander.getHeight() + gladiator_logo.getHeight() + 20);
        g.setColor(8479041);
        g.drawLine(0, 4 + 2 * menu_meander.getHeight() + gladiator_logo.getHeight() + 20 + 1, 240, 4 + 2 * menu_meander.getHeight() + gladiator_logo.getHeight() + 20 + 1);
        g.setColor(4598034);
        g.drawLine(0, 4 + 2 * menu_meander.getHeight() + gladiator_logo.getHeight() + 20 + 2, 240, 4 + 2 * menu_meander.getHeight() + gladiator_logo.getHeight() + 20 + 2);
        g.setColor(0);
        g.drawLine(0, 4 + 2 * menu_meander.getHeight() + gladiator_logo.getHeight() + 20 + 3, 240, 4 + 2 * menu_meander.getHeight() + gladiator_logo.getHeight() + 20 + 3);
        if (drawEagle) {
            int EASE_IN_VALUE = 4 + 2 * menu_meander.getHeight() + gladiator_logo.getHeight() + 20;
            g.drawImage(menu_eagle, 120, EASE_IN_VALUE + -1 + 0, 17);
        }
    }

    public static void drawRedBox(Graphics g, int x, int y, int width, int height, boolean lower_line) {
        int clipx = g.getClipX();
        int clipy = g.getClipY();
        int clipwidth = g.getClipWidth();
        int clipheight = g.getClipHeight();
        g.setClip(x, y, width, height);
        for (int i = x; i < x + width; i += menu_bg.getWidth()) {
            g.drawImage(menu_bg, i, y, 0);
        }
        g.setClip(clipx, clipy, clipwidth, clipheight);
        if (lower_line) {
            g.setColor(3217416);
            g.drawLine(x, y + height - 3, x + width - 1, y + height - 3);
            g.setColor(8479041);
            g.drawLine(x, y + height - 2, x + width - 1, y + height - 2);
            g.setColor(4598034);
            g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
            g.setColor(0);
            g.drawLine(x, y + height, x + width - 1, y + height);
        } else {
            g.setColor(3217416);
            g.drawLine(x, y, x + width - 1, y);
            g.setColor(8479041);
            g.drawLine(x, y + 1, x + width - 1, y + 1);
            g.setColor(4598034);
            g.drawLine(x, y + 2, x + width - 1, y + 2);
            g.setColor(0);
            g.drawLine(x, y + 3, x + width - 1, y + 3);
        }
    }

    public static int getMenuBorderHeight() {
        if (menu_border == null) {
            return 0;
        }
        return menu_border.getHeight();
    }

    public static void drawMenuBackground(Graphics g, int top, int bottom) {
        MainMenu.drawMenuBG(g, top, bottom);
    }

    private void drawCharacterPortraitSelection(Graphics g, boolean characterSelect) {
        int index = this.char_index;
        int characters_first_line = 5;
        if (DataStore.unlocked_character < 8) {
            characters_first_line = 4;
        }
        int portrait_width = char_icons[0].getWidth();
        int portrait_spacing = 10;
        int left = 120 - characters_first_line * (portrait_width + portrait_spacing) / 2;
        int char_count = 9;
        if (DataStore.unlocked_character < 8) {
            char_count = 8;
        }
        for (int i = 0; i < char_count; ++i) {
            int factor_y = i < characters_first_line ? 0 : 1;
            int factor_x = i < characters_first_line || DataStore.unlocked_character < 8 ? 0 : 1;
            int x = 120 - characters_first_line * (portrait_width + portrait_spacing) / 2 + i % characters_first_line * (portrait_width + portrait_spacing) + portrait_spacing / 2;
            int y = 280 - MainMenu.getMenuBorderHeight() - 3 * portrait_spacing / 2 - 2 * portrait_width;
            int offset = (border.getWidth() - char_icons[0].getWidth()) / 2;
            g.drawImage(char_icons[i], x + factor_x * (portrait_width + portrait_spacing) / 2, y + factor_y * (portrait_width + portrait_spacing), 0);
            g.drawImage(border, x - offset + factor_x * (portrait_width + portrait_spacing) / 2, y + factor_y * (portrait_width + portrait_spacing) - offset, 0);
            if (i <= DataStore.unlocked_character || !characterSelect) continue;
            g.drawImage(disable, x + factor_x * (portrait_width + portrait_spacing) / 2, y + factor_y * (portrait_width + portrait_spacing), 0);
        }
        int x = 120 - characters_first_line * (portrait_width + portrait_spacing) / 2 + index % characters_first_line * (portrait_width + portrait_spacing) + portrait_spacing / 2;
        int y = 280 - MainMenu.getMenuBorderHeight() - 3 * portrait_spacing / 2 - 2 * portrait_width;
        int factor_y = index < characters_first_line ? 0 : 1;
        int factor_x = index < characters_first_line || DataStore.unlocked_character < 8 ? 0 : 1;
        int offset = (border_selected.getWidth() - char_icons[0].getWidth()) / 2;
        g.drawImage(border_selected, x + factor_x * (portrait_width + portrait_spacing) / 2 - offset, y + factor_y * (portrait_width + portrait_spacing) - offset, 0);
    }

    private void drawStats(Graphics g) {
        int portrait_width = char_icons[0].getWidth();
        int portrait_spacing = 10;
        int EASE_IN_VALUE = 4 + 2 * menu_meander.getHeight() + gladiator_logo.getHeight() + 20;
        int left = 120 - 5 * (portrait_width + portrait_spacing) / 2;
        if (this.char_index <= DataStore.unlocked_character) {
            String[] attributes = new String[]{Gladiator2D.TEXT.getText(83), Gladiator2D.TEXT.getText(84), Gladiator2D.TEXT.getText(85), Gladiator2D.TEXT.getText(86)};
            int top = EASE_IN_VALUE + 13 + 12;
            for (int i = 0; i < attributes.length; ++i) {
                int fact = 20;
                GladFont.drawString(attributes[i], left, top + i * GladFont.getRowHeight() * fact / 10 - 2);
                if (i >= 4) continue;
                g.setColor(9991232);
                g.drawImage(attributeBar, left, top + i * GladFont.getRowHeight() * fact / 10 + GladFont.getRowHeight() + 3, 0);
                g.setColor(13842693);
                g.drawLine(left + 1, top + i * GladFont.getRowHeight() * fact / 10 + GladFont.getRowHeight() + 3 + 2, left + 1 + this.attribs[i] * (attributeBar.getWidth() - 1) / 100 - 1, top + i * GladFont.getRowHeight() * fact / 10 + GladFont.getRowHeight() + 3 + 2);
                g.drawLine(left + 1, top + i * GladFont.getRowHeight() * fact / 10 + GladFont.getRowHeight() + 3 + 2 + 2, left + 1 + this.attribs[i] * (attributeBar.getWidth() - 1) / 100 - 1, top + i * GladFont.getRowHeight() * fact / 10 + GladFont.getRowHeight() + 3 + 2 + 2);
                g.setColor(16740864);
                g.drawLine(left + 1, top + i * GladFont.getRowHeight() * fact / 10 + GladFont.getRowHeight() + 3 + 2 + 1, left + 1 + this.attribs[i] * (attributeBar.getWidth() - 1) / 100 - 1, top + i * GladFont.getRowHeight() * fact / 10 + GladFont.getRowHeight() + 3 + 2 + 1);
                g.drawImage(attributeJewel, left + 1 + this.attribs[i] * (attributeBar.getWidth() - 1) / 100 - 1 - attributeJewel.getWidth() / 2, top + i * GladFont.getRowHeight() * fact / 10 + GladFont.getRowHeight() + 3 + 2 - attributeJewel.getHeight() / 2 + 1, 0);
            }
        }
    }

    private static void drawGradient(Graphics g, int y) {
        for (int i = 0; i < 240; i += gradient.getWidth()) {
            g.drawImage(gradient, i, y, 0);
        }
    }

    public void drawScreen(Graphics g) {
        int offset = 1;
        int versusOffset = 55;
        switch (this.state) {
            case 4: {
                int EASE_OUT_VALUE = 4 + 2 * menu_meander.getHeight() + gladiator_logo.getHeight() + 20 - 13 + 6 - 9;
                MainMenu.drawGradient(g, EASE_OUT_VALUE + 13 + 6 - 4);
                g.drawImage(versus, 120 - versus.getWidth() / 2, 280 - 2 * MainMenu.getMenuBorderHeight() - 20 - 2 * char_icons[0].getWidth() - 13 - 6 + -versusOffset, 0);
                int shadowOffset = 5;
                charIdles[DataStore.playerChar][this.idleFrames[0]].setTransform(0);
                charIdles[DataStore.playerChar][this.idleFrames[0]].setPosition(36 - charIdles[DataStore.playerChar][this.idleFrames[0]].getWidth() / 2, 280 - 2 * MainMenu.getMenuBorderHeight() - 20 - 2 * char_icons[0].getWidth() - 13 - 6 - offset - charIdles[DataStore.playerChar][this.idleFrames[0]].getHeight() + 5);
                g.drawImage(shadow, charIdles[DataStore.playerChar][this.idleFrames[0]].getX() + charIdles[DataStore.playerChar][this.idleFrames[0]].getWidth() / 2, shadowOffset + 300 - 20 - 2 * MainMenu.getMenuBorderHeight() - 20 - 2 * char_icons[0].getWidth() - 13 - 6 - offset, 33);
                charIdles[DataStore.playerChar][this.idleFrames[0]].paint(g);
                charIdles[this.char_index][this.idleFrames[1]].setTransform(2);
                charIdles[this.char_index][this.idleFrames[1]].setPosition(204 - charIdles[this.char_index][this.idleFrames[1]].getWidth() / 2, 280 - 2 * MainMenu.getMenuBorderHeight() - 20 - 2 * char_icons[0].getWidth() - 13 - 6 - offset - charIdles[this.char_index][this.idleFrames[1]].getHeight() + 5);
                g.drawImage(shadow, charIdles[this.char_index][this.idleFrames[1]].getX() + charIdles[this.char_index][this.idleFrames[1]].getWidth() / 2, shadowOffset + 300 - 20 - 2 * MainMenu.getMenuBorderHeight() - 20 - 2 * char_icons[0].getWidth() - 13 - 6 - offset + 5, 33);
                charIdles[this.char_index][this.idleFrames[1]].paint(g);
                this.drawMenuTop(g, false);
                MainMenu.drawMenuBackground(g, 280 - 2 * MainMenu.getMenuBorderHeight() - 20 - 2 * char_icons[0].getWidth(), 280);
                this.drawCharacterPortraitSelection(g, false);
                this.animHeader.draw(g);
                MainMenu.drawRedBox(g, 0, 280 - 2 * MainMenu.getMenuBorderHeight() - 20 - 2 * char_icons[0].getWidth() - 13 - 6 + 5, 240, 14, false);
                GladFont.drawString(DataStore.FIGHTER_NAMES[DataStore.playerChar], 6, 280 - 2 * MainMenu.getMenuBorderHeight() - 20 - 2 * char_icons[0].getWidth() - 13 - 6 + (19 - GladFont.getRowHeight()) - offset);
                GladFont.drawString(DataStore.FIGHTER_NAMES[this.char_index], 234 - GladFont.getStringWidth(DataStore.FIGHTER_NAMES[this.char_index]), 280 - 2 * MainMenu.getMenuBorderHeight() - 20 - 2 * char_icons[0].getWidth() - 13 - 6 + (19 - GladFont.getRowHeight()) - offset, 0);
                if (this.isTextBoxShowing) {
                    SharedGraphics.drawFooter(g, null, null, Gladiator2D.TEXT.getText(6));
                    this.textBox.draw(g);
                    break;
                }
                SharedGraphics.drawFooter(g, Gladiator2D.TEXT.getText(5), null, Gladiator2D.TEXT.getText(6));
                break;
            }
            case 1: {
                int EASE_OUT_VALUE = 4 + 2 * menu_meander.getHeight() + gladiator_logo.getHeight() + 20 - 13 + 6 - 9;
                MainMenu.drawGradient(g, EASE_OUT_VALUE + 13 + 6 - 4);
                int shadowOffset = 5;
                if (this.char_index <= DataStore.unlocked_character) {
                    charIdles[this.char_index][this.idleFrames[0]].setTransform(2);
                    charIdles[this.char_index][this.idleFrames[0]].setPosition(204 - charIdles[this.char_index][this.idleFrames[0]].getWidth() / 2, 280 - 2 * MainMenu.getMenuBorderHeight() - 20 - 2 * char_icons[0].getWidth() - 6 - offset - charIdles[this.char_index][this.idleFrames[0]].getHeight());
                    g.drawImage(shadow, charIdles[this.char_index][this.idleFrames[0]].getX() + charIdles[this.char_index][this.idleFrames[0]].getWidth() / 2, shadowOffset + 300 - 20 - 2 * MainMenu.getMenuBorderHeight() - 20 - 2 * char_icons[0].getWidth() - 6 - offset, 33);
                    charIdles[this.char_index][this.idleFrames[0]].paint(g);
                }
                this.drawMenuTop(g, false);
                MainMenu.drawMenuBackground(g, 280 - 2 * MainMenu.getMenuBorderHeight() - 20 - 2 * char_icons[0].getWidth(), 280);
                this.drawCharacterPortraitSelection(g, true);
                this.drawStats(g);
                this.animHeader.draw(g);
                if (DataStore.g_game_mode == 0) {
                    if (DataStore.arcade_records[this.char_index][DataStore.difficulty * 2 + 1] > 0) {
                        g.drawImage(awards[DataStore.arcade_records[this.char_index][DataStore.difficulty * 2 + 1] - 1], 237 - awards[0].getWidth(), this.animHeader.getOutPosition() + 2, 0);
                    }
                } else if (DataStore.g_game_mode == 1 && DataStore.survival_records[this.char_index][0] >= 3) {
                    if (DataStore.survival_records[this.char_index][0] < 5) {
                        g.drawImage(awards[0], 237 - awards[0].getWidth(), this.animHeader.getOutPosition() + 2, 0);
                    } else if (DataStore.survival_records[this.char_index][0] < 8) {
                        g.drawImage(awards[1], 237 - awards[0].getWidth(), this.animHeader.getOutPosition() + 2, 0);
                    } else {
                        g.drawImage(awards[2], 237 - awards[0].getWidth(), this.animHeader.getOutPosition() + 2, 0);
                    }
                }
                if (this.isTextBoxShowing) {
                    SharedGraphics.drawFooter(g, null, null, Gladiator2D.TEXT.getText(6));
                    this.textBox.draw(g);
                    break;
                }
                if (this.char_index > DataStore.unlocked_character) {
                    SharedGraphics.drawFooter(g, null, null, Gladiator2D.TEXT.getText(6));
                    break;
                }
                SharedGraphics.drawFooter(g, Gladiator2D.TEXT.getText(41), Gladiator2D.TEXT.getText(42), Gladiator2D.TEXT.getText(6));
                break;
            }
            case 3: {
                GladFont.setFont(0);
                int EASE_OUT_VALUE = 4 + 2 * menu_meander.getHeight() + gladiator_logo.getHeight() + 20 - 13 + 6 - 9;
                MainMenu.drawGradient(g, EASE_OUT_VALUE + 13 + 6 - 4);
                this.drawMenuTop(g, false);
                int shadowOffset = 5;
                charIdles[DataStore.playerChar][this.idleFrames[0]].setTransform(0);
                charIdles[DataStore.playerChar][this.idleFrames[0]].setPosition(36 - charIdles[DataStore.playerChar][this.idleFrames[0]].getWidth() / 2, 280 - 2 * MainMenu.getMenuBorderHeight() - 20 - 2 * char_icons[0].getWidth() - 13 - 6 - offset - charIdles[DataStore.playerChar][this.idleFrames[0]].getHeight());
                g.drawImage(shadow, charIdles[DataStore.playerChar][this.idleFrames[0]].getX() + charIdles[DataStore.playerChar][this.idleFrames[0]].getWidth() / 2, shadowOffset + 300 - 20 - 2 * MainMenu.getMenuBorderHeight() - 20 - 2 * char_icons[0].getWidth() - 13 - 6 - offset, 33);
                charIdles[DataStore.playerChar][this.idleFrames[0]].paint(g);
                charIdles[DataStore.opponentChar][this.idleFrames[1]].setTransform(2);
                charIdles[DataStore.opponentChar][this.idleFrames[1]].setPosition(204 - charIdles[DataStore.opponentChar][this.idleFrames[1]].getWidth() / 2, 280 - 2 * MainMenu.getMenuBorderHeight() - 20 - 2 * char_icons[0].getWidth() - 13 - 6 - offset - charIdles[DataStore.opponentChar][this.idleFrames[1]].getHeight());
                g.drawImage(shadow, charIdles[DataStore.opponentChar][this.idleFrames[1]].getX() + charIdles[DataStore.opponentChar][this.idleFrames[1]].getWidth() / 2, shadowOffset + 300 - 20 - 2 * MainMenu.getMenuBorderHeight() - 20 - 2 * char_icons[0].getWidth() - 13 - 6 - offset, 33);
                charIdles[DataStore.opponentChar][this.idleFrames[1]].paint(g);
                MainMenu.drawMenuBackground(g);
                this.animHeader.draw(g);
                MainMenu.drawRedBox(g, 0, 300 - MainMenu.getMenuBGHeight() - 13 - 6 - 20, 240, 19, false);
                GladFont.drawString(DataStore.FIGHTER_NAMES[DataStore.playerChar], 6, 300 - MainMenu.getMenuBGHeight() - 13 - 6 - 20 + (19 - GladFont.getRowHeight()) - 1);
                GladFont.drawString(DataStore.FIGHTER_NAMES[DataStore.opponentChar], 234 - GladFont.getStringWidth(DataStore.FIGHTER_NAMES[DataStore.opponentChar]) + 0, 300 - MainMenu.getMenuBGHeight() - 13 - 6 - 20 + (19 - GladFont.getRowHeight()) - 1, 0);
                int SPACING = 12;
                int x = 120 - char_icons[0].getWidth() * 5 / 2 - 2 * SPACING;
                int y = 300 - MainMenu.getMenuBGHeight() / 2 - 20 - char_icons[0].getHeight() / 2;
                offset = (border.getWidth() - char_icons[0].getWidth()) / 2;
                int cross_offset = (char_icons[0].getWidth() - cross.getWidth()) / 2;
                int arrow_offset = (char_icons[0].getWidth() - arrow_vs.getWidth()) / 2;
                int arrow_offset_y = 0;
                MainMenu.drawLines(g, x - SPACING, y + char_icons[0].getHeight() / 2 + 2, 240 - 2 * (x - SPACING));
                g.drawImage(attributeJewel, x - SPACING - attributeJewel.getWidth() / 2, y + char_icons[0].getHeight() / 2 - attributeJewel.getHeight() / 2 + 1, 0);
                g.drawImage(attributeJewel, 240 - x + SPACING - attributeJewel.getWidth() / 2, y + char_icons[0].getHeight() / 2 - attributeJewel.getHeight() / 2 + 1, 0);
                for (int i = 0; i < DataStore.arcade_opponents[0].length; ++i) {
                    g.drawImage(border, x + i * (char_icons[i].getWidth() + SPACING) - offset, y - offset, 0);
                    g.drawImage(char_icons[DataStore.arcade_opponents[DataStore.playerChar][i]], x + i * (char_icons[i].getWidth() + SPACING), y, 0);
                    if (i > DataStore.g_current_fight) {
                        g.drawImage(disable, x + i * (char_icons[i].getWidth() + SPACING), y, 0);
                        continue;
                    }
                    if (i == DataStore.g_current_fight) {
                        g.drawImage(arrow_vs, x + i * (char_icons[i].getWidth() + SPACING) + arrow_offset + 0, y - offset + 1 - arrow_offset_y, 36);
                        continue;
                    }
                    g.drawImage(cross, x + i * (char_icons[i].getWidth() + SPACING) + cross_offset, y, 0);
                }
                g.drawImage(versus, 120 - versus.getWidth() / 2, 280 - 2 * MainMenu.getMenuBorderHeight() - 20 - 2 * char_icons[0].getWidth() - 13 - 6 - versusOffset, 0);
                SharedGraphics.drawFooter(g, Gladiator2D.TEXT.getText(5), null, Gladiator2D.TEXT.getText(6));
                if (!this.showMsg) break;
                SharedGraphics.drawTransparentPattern(g);
                SharedGraphics.drawFooter(g, Gladiator2D.TEXT.getText(5), null, Gladiator2D.TEXT.getText(6));
                this.choiceWindow.draw(g);
                break;
            }
            case 0: {
                this.drawMenuTop(g, false);
                this.animHeader.draw(g);
                MainMenu.drawMenuBackground(g);
                this.drawMenu(g);
                if (this.isTextBoxShowing) {
                    SharedGraphics.drawFooter(g, null, "drawArrows()", Gladiator2D.TEXT.getText(6));
                    this.textBox.draw(g);
                    return;
                }
                if (this.showMsg) {
                    SharedGraphics.drawTransparentPattern(g);
                    SharedGraphics.drawFooter(g, Gladiator2D.TEXT.getText(5), null, Gladiator2D.TEXT.getText(6));
                    this.choiceWindow.draw(g);
                    break;
                }
                if (this.menu.getCurrentMenu() == 0) {
                    SharedGraphics.drawFooter(g, Gladiator2D.TEXT.getText(5), "drawArrows()", null);
                    break;
                }
                if (this.menu.getCurrentMenu() == 1) {
                    SharedGraphics.drawFooter(g, Gladiator2D.TEXT.getText(44), "drawArrows()", Gladiator2D.TEXT.getText(6));
                    break;
                }
                if (this.menu.getCurrentMenu() == 4 || this.menu.getCurrentMenu() == 12) break;
                SharedGraphics.drawFooter(g, Gladiator2D.TEXT.getText(5), "drawArrows()", Gladiator2D.TEXT.getText(6));
            }
        }
    }

    private void loadGlobalFightData() {
        if (DataStore.resume_game_mode != -1) {
            DataStore.g_game_mode = DataStore.resume_game_mode;
        }
        if (DataStore.resume_current_fight != -1) {
            DataStore.g_current_fight = DataStore.resume_current_fight;
        }
        if (DataStore.resume_char_id != -1) {
            DataStore.playerChar = DataStore.resume_char_id;
        }
        if (DataStore.resume_opponent_id != -1) {
            DataStore.opponentChar = DataStore.resume_opponent_id;
        }
        if (DataStore.resume_total_fame != -1) {
            DataStore.g_total_fame = DataStore.resume_total_fame;
        }
        if (DataStore.resume_difficulty != -1) {
            DataStore.difficulty = DataStore.resume_difficulty;
        }
    }

    public void saveGameDuringVersusScreen() {
        DataStore.resume_time = DataStore.round_time[DataStore.g_timeLimit];
        DataStore.resume_round = 1;
        DataStore.resume_char_health = 100;
        DataStore.resume_opponent_health = 100;
        DataStore.resume_char_fame = 0;
        DataStore.resume_opponent_fame = 0;
        DataStore.resume_char_wins = 0;
        DataStore.resume_opponent_wins = 0;
        DataStore.resume_game_mode = DataStore.g_game_mode;
        DataStore.resume_current_fight = DataStore.g_current_fight;
        DataStore.resume_char_id = DataStore.playerChar;
        DataStore.resume_opponent_id = DataStore.opponentChar;
        DataStore.resume_total_fame = DataStore.g_total_fame;
        DataStore.resume_difficulty = DataStore.difficulty;
        DataStore.saveLastGame(0);
    }
}

