/*
 * Decompiled with CFR 0.152.
 */
package com.mliven.utils;

import com.mliven.Gladiator2D;
import com.mliven.utils.GladFont;
import com.mliven.utils.MainMenu;
import com.mliven.utils.SharedGraphics;
import javax.microedition.lcdui.Graphics;

public class ChoiceWindow {
    private static final int MARGIN = 5;
    private int x;
    private int y;
    private int width;
    private int height;
    private String[] msg;
    private int buttonStartY;
    private boolean confirm;
    private boolean yesNo;
    private int selection_mark_offset;
    private int selection_mark_direction;

    public ChoiceWindow(int x, int y, int width) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = 150;
    }

    public ChoiceWindow() {
        this(30, 0, 180);
    }

    public void set(String str) {
        this.set(str, false);
    }

    public void set(String str, boolean yesNo) {
        this.confirm = false;
        this.yesNo = yesNo;
        this.msg = GladFont.getLineArray(str, this.width - 10);
        this.height = GladFont.getRowHeight() * this.msg.length + 10 + 26;
        if (yesNo) {
            this.height += 13;
        }
        this.y = 150 - this.height / 2 - 2;
        this.buttonStartY = this.y + this.msg.length * GladFont.getRowHeight() + 2 + 13;
    }

    public boolean fire() {
        return this.yesNo ? this.confirm : false;
    }

    public void up() {
        if (this.yesNo) {
            this.confirm = !this.confirm;
        }
    }

    public void down() {
        this.up();
    }

    public void tick() {
        if (this.selection_mark_direction == 0) {
            ++this.selection_mark_offset;
            if (this.selection_mark_offset > 3) {
                this.selection_mark_direction = 1;
            }
        } else {
            --this.selection_mark_offset;
            if (this.selection_mark_offset < 1) {
                this.selection_mark_direction = 0;
            }
        }
    }

    public void draw(Graphics g) {
        if (this.msg == null) {
            return;
        }
        GladFont.setFont(0);
        MainMenu.drawBox(g, this.x, this.y, this.width, this.height);
        if (this.msg.length > 1) {
            GladFont.drawLines(this.msg, this.x + 5, this.y + 5);
        } else {
            GladFont.drawString(this.msg[0], 120 - GladFont.getStringWidth(this.msg[0]) / 2, this.y + 5, 0);
        }
        GladFont.setFont(0);
        int marginX = GladFont.getStringWidth("OO");
        g.setColor(4140826);
        g.drawLine(this.x + marginX, this.buttonStartY - 6, this.x + this.width - marginX, this.buttonStartY - 6);
        g.setColor(0);
        g.drawLine(this.x + marginX, this.buttonStartY - 6 + 1, this.x + this.width - marginX, this.buttonStartY - 6 + 1);
        if (this.yesNo) {
            if (this.confirm) {
                SharedGraphics.drawSelectionWing(g, true, this.x + (this.width >> 1) - GladFont.getStringWidth(Gladiator2D.TEXT.getText(39)) / 2 - this.selection_mark_offset, this.buttonStartY + 5);
                SharedGraphics.drawSelectionWing(g, false, this.x + (this.width >> 1) + GladFont.getStringWidth(Gladiator2D.TEXT.getText(39)) / 2 + this.selection_mark_offset, this.buttonStartY + 5);
            } else {
                SharedGraphics.drawSelectionWing(g, true, this.x + (this.width >> 1) - GladFont.getStringWidth(Gladiator2D.TEXT.getText(40)) / 2 - this.selection_mark_offset, this.buttonStartY + 13 + 5);
                SharedGraphics.drawSelectionWing(g, false, this.x + (this.width >> 1) + GladFont.getStringWidth(Gladiator2D.TEXT.getText(40)) / 2 + this.selection_mark_offset, this.buttonStartY + 13 + 5);
            }
            GladFont.drawString(Gladiator2D.TEXT.getText(39), this.x + (this.width >> 1), this.buttonStartY, 4);
            GladFont.drawString(Gladiator2D.TEXT.getText(40), this.x + (this.width >> 1), this.buttonStartY + 13, 4);
        } else {
            SharedGraphics.drawSelectionWing(g, true, this.x + (this.width >> 1) - GladFont.getStringWidth(Gladiator2D.TEXT.getText(5)) / 2 - this.selection_mark_offset, this.buttonStartY + 5);
            SharedGraphics.drawSelectionWing(g, false, this.x + (this.width >> 1) + GladFont.getStringWidth(Gladiator2D.TEXT.getText(5)) / 2 + this.selection_mark_offset, this.buttonStartY + 5);
            GladFont.drawString(Gladiator2D.TEXT.getText(5), this.x + (this.width >> 1), this.buttonStartY, 4);
        }
        g.setClip(0, 0, 240, 300);
    }

    public void cleanUp() {
        if (this.msg != null) {
            for (int i = 0; i < this.msg.length; ++i) {
                if (this.msg[i] == null) continue;
                this.msg[i] = null;
            }
            this.msg = null;
        }
    }
}

