/*
 * Decompiled with CFR 0.152.
 */
package com.mliven.utils;

import com.mliven.utils.GladFont;
import com.mliven.utils.MainMenu;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AnimatedHeader {
    private boolean isHeaderOut = false;
    private boolean isHeaderAnimating = false;
    private int animHeaderPos;
    private String currentText = "";
    private String nextText = "";
    private Image currentImage = null;
    private Image nextImage;
    private int inPos;
    private int outPos;
    private int height;
    private int headerSpeed;

    public AnimatedHeader() {
        int EASE_IN_VALUE;
        this.inPos = EASE_IN_VALUE = 4 + 2 * MainMenu.menu_meander.getHeight() + MainMenu.gladiator_logo.getHeight() + 20;
        this.outPos = EASE_IN_VALUE + 13 - 6 + 9;
        this.height = this.outPos - this.inPos;
        this.headerSpeed = 100 * this.height / 10;
        this.animHeaderPos = 100 * this.inPos;
    }

    public String getText() {
        return this.currentText;
    }

    public int getOutPosition() {
        return this.outPos;
    }

    public void setText(String text) {
        if (!this.isHeaderAnimating) {
            if (this.isHeaderOut) {
                this.nextText = text;
            } else {
                this.currentText = text;
            }
        } else if (this.isHeaderOut) {
            this.nextText = text;
        } else {
            this.isHeaderOut = true;
            this.nextText = text;
        }
        this.nextImage = null;
        this.isHeaderAnimating = true;
    }

    public void setImage(Image image) {
        this.nextImage = image;
        this.nextText = "";
        this.isHeaderAnimating = true;
    }

    public void tick() {
        if (this.isHeaderAnimating) {
            if (this.isHeaderOut) {
                this.animHeaderPos -= this.headerSpeed;
                if (this.animHeaderPos <= 100 * this.inPos) {
                    this.animHeaderPos = 100 * this.inPos;
                    this.isHeaderOut = false;
                    if (this.nextImage == null && this.nextText.length() == 0) {
                        this.isHeaderAnimating = false;
                    } else {
                        this.currentText = this.nextText;
                        this.currentImage = this.nextImage;
                    }
                }
            } else {
                this.animHeaderPos += this.headerSpeed;
                if (this.animHeaderPos >= 100 * this.outPos) {
                    this.animHeaderPos = 100 * this.outPos;
                    this.isHeaderOut = true;
                    if (this.currentText.length() > 0) {
                        this.isHeaderAnimating = false;
                    }
                }
            }
        }
    }

    public boolean isAnimating() {
        return this.isHeaderAnimating;
    }

    public void draw(Graphics g) {
        g.setClip(0, this.inPos + 4, 240, this.height);
        if (this.animHeaderPos / 100 - this.inPos + -1 > 0) {
            MainMenu.drawRedBox(g, 0, this.inPos + 4, 240, this.animHeaderPos / 100 - this.inPos + -1, true);
        }
        GladFont.setGraphics(g);
        int offset = 2;
        GladFont.drawString(this.currentText, 120 - GladFont.getStringWidth(this.currentText) / 2, this.animHeaderPos / 100 + 1 - GladFont.getRowHeight() - offset);
        g.setClip(0, 0, 240, 300);
        g.drawImage(MainMenu.menu_eagle, 120, this.animHeaderPos / 100 + -1 + 0, 17);
    }
}

