/*
 * Decompiled with CFR 0.152.
 */
package com.mliven;

import com.mliven.DataStore;
import com.mliven.Gladiator2D;
import java.io.InputStream;
import javax.microedition.lcdui.AlertType;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class Sound
implements PlayerListener {
    public static final int VOL_100 = 1;
    public static final int VOL_0 = 0;
    public static final int[] volumes = new int[]{0, 100};
    private Player musicPlayer;
    private int volume = DataStore.opt_soundVolume;
    private boolean playerWasKilled = false;
    private int music_id;
    private String SoundName;
    private static final String[] filenames = new String[]{"/block04.wav", "/cut04.wav", "/cut09.wav", "/kleng03.wav", "/special03.wav", "/kling19.wav", "/kling20.wav", "/kling23.wav", "/klong01.wav", "/klong02.wav", "/punch07.wav", "/punch03.wav", "/swosh01.wav", "/swosh02.wav", "/crowdya14.wav", "/criticalhit.wav", "/music/gl_justdark.mid", "/music/gl_theme.mid", "/music/gl_justdrums.mid", "/music/gl_finalvictory.mid"};
    private int currentID = 0;
    public static final int HIT_COUNT = 3;
    public static final int BLOCK_COUNT = 5;
    public static final int MISS_COUNT = 3;
    public static final int BLOCK_01 = 0;
    public static final int CUT_01 = 1;
    public static final int CUT_02 = 2;
    public static final int CHAIN_01 = 3;
    public static final int SPECIAL_01 = 4;
    public static final int KLING_01 = 5;
    public static final int KLING_02 = 6;
    public static final int KLING_03 = 7;
    public static final int KLONG_01 = 8;
    public static final int KLONG_02 = 9;
    public static final int PUNCH_01 = 10;
    public static final int PUNCH_02 = 11;
    public static final int SWOSH_01 = 12;
    public static final int SWOSH_02 = 13;
    public static final int CROWD_01 = 14;
    public static final int CRITICAL_HIT_01 = 15;
    public static final int MUSIC_DRUMS = 16;
    public static final int MUSIC_MENU = 17;
    public static final int MUSIC_CHAR_SELECT = 18;
    public static final int MUSIC_VICTORY = 19;

    public int getLastMusic() {
        return this.music_id;
    }

    public void playMusic(int type) {
        this._playMusic(type, false);
    }

    public void playMusicOnce(int type) {
        this._playMusic(type, true);
    }

    public void _playMusic(int type, boolean once) {
        if (this.isMusicPlaying()) {
            System.out.println("music is already playing");
            return;
        }
        try {
            System.out.println("trying to play " + type);
            InputStream is = this.getClass().getResourceAsStream(filenames[type]);
            this.music_id = type;
            this.musicPlayer = Manager.createPlayer((InputStream)is, (String)"audio/midi");
            this.musicPlayer.addPlayerListener((PlayerListener)this);
            this.musicPlayer.setLoopCount(1);
            this.musicPlayer.realize();
            if (this.musicPlayer.getState() != 300) {
                this.musicPlayer.prefetch();
            }
            this.musicPlayer.start();
            DataStore.r_soundResume = false;
            is = null;
        }
        catch (Exception e) {
            System.out.println("Music(): (" + type + ") " + e.toString());
            DataStore.r_soundResume = true;
            if (this.musicPlayer != null) {
                this.musicPlayer.deallocate();
                this.musicPlayer.close();
            }
            this.musicPlayer = null;
            e.printStackTrace();
        }
    }

    public boolean isMusicPlaying() {
        try {
            if (this.musicPlayer != null) {
                return this.musicPlayer.getState() == 400;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public void stop() {
        try {
            if (this.musicPlayer != null) {
                this.musicPlayer.removePlayerListener((PlayerListener)this);
                this.musicPlayer.stop();
                this.musicPlayer.deallocate();
                this.musicPlayer = null;
                System.gc();
            }
            Thread.sleep(100L);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.musicPlayer = null;
        }
        System.out.println("Music stopped");
    }

    public void pause() {
        try {
            try {
                VolumeControl volumeControl = (VolumeControl)this.musicPlayer.getControl("VolumeControl");
                volumeControl.setMute(true);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.musicPlayer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resume() {
        try {
            if (DataStore.opt_soundVolume != 0) {
                try {
                    VolumeControl volumeControl = (VolumeControl)this.musicPlayer.getControl("VolumeControl");
                    volumeControl.setMute(false);
                    AlertType.ERROR.playSound(Gladiator2D.display);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.musicPlayer.start();
            }
            DataStore.r_soundResume = false;
        }
        catch (Exception e) {
            DataStore.r_soundResume = true;
            if (this.musicPlayer != null) {
                this.musicPlayer.deallocate();
                this.musicPlayer.close();
            }
            this.musicPlayer = null;
            e.printStackTrace();
        }
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    public void playSound(int index) {
    }

    public void playerUpdate(Player player, String event, Object object) {
        if (event.compareTo("endOfMedia") == 0) {
            try {
                this.musicPlayer.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (event.compareTo("deviceUnavailable") == 0 && this.musicPlayer != null && this.musicPlayer.getState() != 0) {
            this.playerWasKilled = true;
        }
        if (event.compareTo("deviceAvailable") == 0 && this.playerWasKilled) {
            this.playerWasKilled = false;
            DataStore.r_soundResume = true;
        }
    }

    private int getPriority(int id) {
        switch (id) {
            case 14: 
            case 15: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }
}

