/*
 * Decompiled with CFR 0.152.
 */
package com.mliven;

import com.mliven.DataStore;
import com.mliven.Sound;
import com.mliven.utils.FightScreen;
import com.mliven.utils.GCanvas;
import com.mliven.utils.GScreen;
import com.mliven.utils.GameText;
import com.mliven.utils.GladFont;
import com.mliven.utils.IntroScreen;
import com.mliven.utils.MainMenu;
import com.mliven.utils.ResourceLoader;
import java.util.Random;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;

public class Gladiator2D
implements Runnable {
    public static final int EVENT_LOAD_TO_MENU = 0;
    public static final int EVENT_LOADUP_MENU = 1;
    public static final int EVENT_INIT_GAME_DONE = 2;
    public static final int EVENT_INIT_GAME = 3;
    public static final int EVENT_FIGHT_LOADED = 4;
    public static final int EVENT_LOADUP_FIGHT = 5;
    public static final int EVENT_SHOW_INTRO = 7;
    public static final int EVENT_LOADUP_INTRO = 8;
    public static final int EVENT_LANGUAGE_CHANGED = 9;
    public static final int EVENT_CHANGE_LANGUAGE = 10;
    public static final int EVENT_SHOW_MENU = 11;
    private static final int VIBRA_TIME = 300;
    private static Gladiator2D instance = null;
    private boolean active = true;
    public Thread thread = null;
    public static final int MILLIS_PER_TICK = 30;
    private static long lastVibrated;
    private static GCanvas canvas;
    public static Display display;
    public static MIDlet midlet;
    private static ResourceLoader loader;
    public static MainMenu mainMenu;
    public static FightScreen fightScreen;
    public static IntroScreen intro;
    public static Sound sound;
    public static GameText TEXT;
    public static Random rnd;
    public static int tick;
    private static long resumesleepTime;
    private static int resumeframeDrop;

    private Gladiator2D(MIDlet midlet) {
        sound = new Sound();
        tick = 0;
        lastVibrated = 0L;
        rnd = new Random(System.currentTimeMillis());
        instance = this;
        TEXT = new GameText();
        TEXT.setLanguage(0);
        Gladiator2D.midlet = midlet;
        display = Display.getDisplay((MIDlet)midlet);
        canvas = GCanvas.getInstance();
        display.setCurrent((Displayable)canvas);
        loader = new ResourceLoader();
        GladFont.loadFont();
        GladFont.setFont(0);
        fightScreen = new FightScreen();
        intro = new IntroScreen();
        this.startThread();
        this.handleEvent(3, null);
    }

    public static Gladiator2D getInstance(MIDlet midlet) {
        if (instance == null) {
            new Gladiator2D(midlet);
        }
        return instance;
    }

    public static Gladiator2D getInstance() {
        if (instance == null) {
            throw new RuntimeException("No Gladiator2D instance created yet.");
        }
        return instance;
    }

    public void vibrate() {
        if (DataStore.opt_vibration && lastVibrated + 300L < System.currentTimeMillis()) {
            display.vibrate(300);
            lastVibrated = System.currentTimeMillis();
        }
    }

    public void handleEvent(int event, Object eventData) {
        switch (event) {
            case 10: {
                this.setScreen(loader);
                loader.loadResources(4, eventData, null);
                break;
            }
            case 9: {
                if (DataStore.opt_soundVolume != 0) {
                    sound.playMusic(17);
                }
                this.setScreen(mainMenu);
                break;
            }
            case 5: {
                this.setScreen(loader);
                int[] chars = new int[]{DataStore.playerChar, DataStore.opponentChar};
                loader.loadResources(2, chars, Gladiator2D.fightScreen.arena);
                break;
            }
            case 4: {
                if (DataStore.opt_soundVolume != 0) {
                    sound.playMusic(16);
                }
                this.setScreen(fightScreen);
                break;
            }
            case 3: {
                this.setScreen(loader);
                loader.loadResources(1, null, null);
                break;
            }
            case 2: {
                this.handleEvent(8, null);
                break;
            }
            case 1: {
                this.setScreen(loader);
                loader.loadResources(0, null, null);
                break;
            }
            case 8: {
                this.setScreen(loader);
                loader.loadResources(3, null, null);
                break;
            }
            case 7: {
                this.setScreen(intro);
                break;
            }
            case 0: 
            case 11: {
                Gladiator2D.mainMenu.menuActivationTime = System.currentTimeMillis();
                this.setScreen(mainMenu);
                if (DataStore.opt_soundVolume == 0) break;
                sound.playMusic(17);
            }
        }
    }

    private void setScreen(GScreen screen) {
        if (canvas.getScreen() != screen) {
            canvas.setScreen(screen);
        }
    }

    public GScreen getScreen() {
        return canvas.getScreen();
    }

    public final void run() {
        int frameDrop;
        long sleepTime;
        if (resumesleepTime == -1L) {
            sleepTime = 20L;
            frameDrop = 6;
        } else {
            sleepTime = resumesleepTime;
            frameDrop = resumeframeDrop;
        }
        long lastFpsTime = 0L;
        int cycles = 0;
        long localTicks = 0L;
        do {
            canvas.tick();
            if (frameDrop >= 6) {
                canvas.repaint();
                canvas.serviceRepaints();
            } else if (localTicks % (long)frameDrop > 0L) {
                canvas.repaint();
                canvas.serviceRepaints();
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (Exception e) {
                // empty catch block
            }
            ++cycles;
            if (lastFpsTime + 500L < System.currentTimeMillis()) {
                lastFpsTime = System.currentTimeMillis();
                sleepTime = (cycles *= 2) <= 30 ? --sleepTime : (sleepTime += 4L);
                if (sleepTime < 0L) {
                    sleepTime = 0L;
                }
                if (sleepTime > 30L) {
                    sleepTime = 30L;
                }
                if (sleepTime == 0L && frameDrop > 2 && canvas.getScreen() == fightScreen) {
                    --frameDrop;
                }
                cycles = 0;
            }
            ++localTicks;
            ++tick;
        } while (this.active);
        resumesleepTime = sleepTime;
        resumeframeDrop = frameDrop;
        this.thread = null;
    }

    public static synchronized void handleSoundPause() {
        if (sound != null && sound.isMusicPlaying()) {
            sound.stop();
        }
    }

    public static synchronized void handleSoundResume() {
        sound.stop();
        if (DataStore.opt_soundVolume != 0) {
            if (Gladiator2D.getInstance().getScreen() == fightScreen) {
                sound.playMusic(16);
            } else if (Gladiator2D.getInstance().getScreen() == mainMenu) {
                switch (Gladiator2D.mainMenu.state) {
                    case 0: {
                        sound.playMusic(17);
                        break;
                    }
                    default: {
                        sound.playMusic(18);
                        break;
                    }
                }
            } else {
                sound.playMusic(18);
            }
        }
    }

    public final synchronized void stopThread() {
        this.active = false;
    }

    public final synchronized void startThread() {
        this.thread = null;
        if (this.thread == null) {
            this.active = true;
            this.thread = new Thread(this);
            this.thread.setPriority(10);
            this.thread.start();
        }
    }

    public final void close() {
        if (canvas.getScreen() == fightScreen) {
            Gladiator2D.fightScreen.arena.saveGame();
        } else if (canvas.getScreen() == mainMenu && Gladiator2D.mainMenu.state == 3) {
            mainMenu.saveGameDuringVersusScreen();
        }
        DataStore.save();
        this.active = false;
        long startTime = System.currentTimeMillis();
        while (startTime + 1500L < System.currentTimeMillis() && this.thread != null) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (sound != null && sound.isMusicPlaying()) {
            sound.stop();
        }
        midlet.notifyDestroyed();
    }

    static {
        resumesleepTime = -1L;
        resumeframeDrop = -1;
    }
}

