/*
 * Decompiled with CFR 0.152.
 */
package com.mliven;

import com.mliven.Fighter;
import com.mliven.Gladiator2D;

public class FighterAI {
    private static final int MODE_RANDOM = 0;
    private static final int MODE_AGILE = 2;
    private static final int MODE_LOW_LIFE = 4;
    private static final int MODE_SLOW = 5;
    public static final int STAGE_1 = 0;
    public static final int STAGE_2 = 1;
    public static final int STAGE_3 = 2;
    public static final int STAGE_4 = 3;
    public static final int STAGE_5 = 4;
    private static final int INTELLIGENCE_LOW = 0;
    private static final int INTELLIGENCE_MEDIUM = 1;
    private static final int INTELLIGENCE_HIGH = 2;
    private int DODGE_CHANCE = 30;
    private int DODGE_CHANCE_DIFF_ALTER = 15;
    private int DODGE_CHANCE_STAGE_ALTER = 5;
    private int DODGE_MOVE_BACK = 15;
    private int DODGE_MOVE_LEFT_RIGHT = 25;
    private int DODGE_BLOCK = 100;
    private int PARRY_CHANCE = 35;
    private int PARRY_CHANCE_DIFF_ALTER = 15;
    private int COMBO_CHANCE = 20;
    private int COMBO_CHANCE_DIFF_ALTER = 15;
    private int COMBO_CHANCE_TIGER_ADD = 5;
    private int SPECIAL_SUCCESS_PROBABILITY = 60;
    private int ACTION_PROBABILITY = 25;
    private int ACTION_PROBABILITY_DIFF_ALTER = 10;
    private int ACTION_PROBABILITY_STAGE_ALTER = 3;
    private int ACTION_PROBABILITY_LOW_HEALTH_THRESHOLD = 20;
    private int ACTION_PROBABILITY_LOW_HEALTH_BONUS_LOW = 15;
    private int ACTION_PROBABILITY_LOW_HEALTH_BONUS_MEDIUM = 10;
    private int ACTION_PROBABILITY_LOW_HEALTH_BONUS_HIGH = 7;
    private int TURN_LEFT_RIGHT_CHANCE = 10;
    private int STUN_CHANCE = 20;
    private int HEAVY_ATTACK_CHANCE = 30;
    private int STEP_BACK_CHANCE = 55;
    private int ATTACK_CHANCE = 100;
    private int SPECIAL_ATTACK_CHANCE = 5;
    private int TURN_LEFT_RIGHT_CHANCE_FAR = 20;
    private int STEP_FORWARD_CHANCE = 65;
    private int RANGE_ATTACK_CHANCE = 100;
    private int AGILE_MOVE_THEN_ATTACK = 10;
    private int AGILE_RANDOM_ACTION = 100;
    private int SLOW_LEFT_RIGHT_CHANCE = 5;
    private int SLOW_STEP_BACK_CHANCE = 17;
    private int SLOW_BLOCK_CHANCE = 35;
    private int SLOW_SHIELD_ATTACK_CHANCE = 40;
    private int SLOW_ATTACK_CHANCE = 85;
    private int SLOW_HEAVY_ATTACK_CHANCE = 100;
    private int SLOW_FAR_LEFT_RIGHT_CHANCE = 10;
    private int SLOW_FAR_MOVE_FORWARD_CHANCE = 25;
    private int SLOW_FAR_ATTACK_CHANCE = 65;
    private int SLOW_FAR_SPECIAL_ATTACK_CHANCE = 85;
    private int SLOW_FAR_HEAVY_ATTACK_CHANCE = 100;
    private static final int HAGEN_MACE_HEAVY_ATTACK_EASY_SUB = 10;
    private int LOW_LIFE_MOVE_BACK_CHANCE = 20;
    private int LOW_LIFE_BLOCK_CHANCE = 45;
    private int LOW_LIFE_ATTACK_CHANCE = 75;
    private int LOW_LIFE_MOVE_LEFT_RIGHT_CHANCE = 100;
    private int LOW_LIFE_FAR_ATTACK = 30;
    private int LOW_LIFE_FAR_SPECIAL_ATTACK = 60;
    private int LOW_LIFE_FAR_MOVE_FORWARD = 80;
    private int LOW_LIFE_FAR_MOVE_LEFT_RIGHT_CHANCE = 100;
    private int HEAVY_ATTACK_BACKWARD_LOW = 8;
    private int HEAVY_ATTACK_BACKWARD_MEDIUM = 30;
    private int HEAVY_ATTACK_BACKWARD_HIGH = 60;
    private Fighter fighter;
    private Fighter opponent;
    private int heavy_attack_time;
    private int opponent_block_time;
    private static final int OPPONENT_BLOCK_ACTION_TIME = 800;
    private static final int SPECIAL_DELAY = 30;
    private int difficulty;
    private int stage;
    private int mode;
    private boolean attack;
    private boolean specialOutcomeDetermined;
    private boolean specialWillHit;
    private boolean block;
    private boolean performSpecials;
    private boolean moveBackward;
    private int action_probability_bonus;
    private long special_wait_time;
    private boolean dynamic_dodge_alter;
    private int dodge_chance;
    private int parry_chance;
    private long last_action_time;
    private int dodge_sub_time;
    private int last_action;
    private static final int DODGE_SUBTRACT_TIME = 400;
    private static final int DODGE_TIME_SUB = 4;
    private static final int PARRY_TIME_SUB = 4;
    private static final int DODGE_ACTION_SUB = 20;
    private static int DODGE_ADD = 3;
    private static int PARRY_ADD = 3;
    private static final int AI_THINK_INTERVAL = 3;
    private long aiLastThink;

    public FighterAI(int difficulty, int stage) {
        this.setDifficulty(difficulty, stage);
    }

    public void disableSpecials() {
        this.performSpecials = false;
        this.SPECIAL_ATTACK_CHANCE = -1;
    }

    public void setDifficulty(int difficulty, int stage) {
        this.difficulty = difficulty;
        this.stage = stage;
        ++this.stage;
        switch (difficulty) {
            case 0: {
                this.DODGE_CHANCE -= this.DODGE_CHANCE_DIFF_ALTER;
                this.ACTION_PROBABILITY -= this.ACTION_PROBABILITY_DIFF_ALTER;
                this.PARRY_CHANCE -= this.PARRY_CHANCE_DIFF_ALTER;
                this.COMBO_CHANCE -= this.COMBO_CHANCE_DIFF_ALTER;
                this.dynamic_dodge_alter = stage > 2;
                break;
            }
            case 2: {
                this.DODGE_CHANCE += this.DODGE_CHANCE_DIFF_ALTER;
                this.ACTION_PROBABILITY += this.ACTION_PROBABILITY_DIFF_ALTER;
                this.PARRY_CHANCE += this.PARRY_CHANCE_DIFF_ALTER;
                this.COMBO_CHANCE += this.COMBO_CHANCE_DIFF_ALTER;
                this.dynamic_dodge_alter = true;
                break;
            }
            case 1: {
                this.dynamic_dodge_alter = true;
            }
        }
        DODGE_ADD = stage <= 3 ? 2 : 3;
        PARRY_ADD = stage <= 3 ? 2 : 3;
        for (int i = 0; i < stage; ++i) {
            this.DODGE_CHANCE += this.DODGE_CHANCE_STAGE_ALTER;
            this.ACTION_PROBABILITY += this.ACTION_PROBABILITY_STAGE_ALTER;
        }
        this.dodge_chance = this.DODGE_CHANCE;
        this.parry_chance = this.PARRY_CHANCE;
        this.mode = 0;
        this.performSpecials = true;
        this.action_probability_bonus = 0;
    }

    public void restartAi() {
        this.aiLastThink = 0L;
    }

    public static int random(int max) {
        return Math.abs(Gladiator2D.rnd.nextInt() % max);
    }

    public void setFighters(Fighter ai_fighter, Fighter opponent) {
        this.fighter = ai_fighter;
        this.opponent = opponent;
        this.aiLastThink = 0L;
        this.mode = 0;
        if (this.getIntelligence() != 0) {
            if (this.fighter.agility <= 1) {
                this.mode = 5;
                if (this.difficulty == 0) {
                    this.SLOW_HEAVY_ATTACK_CHANCE -= 10;
                    this.SLOW_FAR_HEAVY_ATTACK_CHANCE -= 10;
                }
            } else {
                this.mode = this.fighter.agility > opponent.agility ? 2 : 0;
            }
        } else if (this.fighter.agility <= 1) {
            if (this.stage > 3) {
                this.ACTION_PROBABILITY -= (this.stage - 3) * this.ACTION_PROBABILITY_STAGE_ALTER;
            }
            this.mode = 5;
            if (this.difficulty == 0) {
                this.SLOW_HEAVY_ATTACK_CHANCE -= 10;
                this.SLOW_FAR_HEAVY_ATTACK_CHANCE -= 10;
            }
        }
        if (ai_fighter.fighterId == 6) {
            this.COMBO_CHANCE += this.COMBO_CHANCE_TIGER_ADD;
        }
        if (this.difficulty == 0) {
            switch (opponent.fighterId) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.dynamic_dodge_alter = false;
                }
            }
        }
        switch (ai_fighter.fighterId) {
            case 7: 
            case 8: {
                DODGE_ADD = 6;
                PARRY_ADD = 6;
            }
        }
    }

    private void performRandomMove() {
        int rnd = FighterAI.random(100);
        if (this.fighter.opponentWillBeInCloseRange()) {
            if (FighterAI.random(100) < 20) {
                this.moveLeftOrRight();
            }
            if (rnd <= this.STUN_CHANCE && this.fighter.facesOpponent()) {
                this.fighter.startAnim(4);
            } else if (rnd <= this.HEAVY_ATTACK_CHANCE && this.fighter.facesOpponent()) {
                this.heavy_attack_time = 0;
                this.fighter.startAnim(6);
            } else if (rnd <= this.STEP_BACK_CHANCE) {
                if (this.fighter.moveBackwardsPossible()) {
                    this.fighter.startAnim(2);
                }
            } else if (this.fighter.facesOpponent()) {
                this.fighter.startAnim(5);
            }
        } else if (rnd <= this.SPECIAL_ATTACK_CHANCE && this.special_wait_time > 30L) {
            this.performSpecial();
        } else if (rnd <= this.STEP_FORWARD_CHANCE) {
            if (this.fighter.moveForwardPossible()) {
                this.fighter.startAnim(1);
            }
        } else if (this.special_wait_time > 30L) {
            this.fighter.startAnim(8);
        }
    }

    private int getIntelligence() {
        if (this.difficulty == 0 && this.stage <= 3 || this.difficulty == 1 && this.stage <= 1) {
            return 0;
        }
        if (this.difficulty == 0 && this.stage == 4 || this.difficulty == 1 && this.stage > 1 || this.difficulty == 2 && this.stage <= 0) {
            return 1;
        }
        return 2;
    }

    private void performSpecial() {
        this.fighter.startAnim(9);
    }

    private void moveEventuallyIfNotRotatedCorrectly() {
        switch (FighterAI.random(10)) {
            case 0: 
            case 1: {
                if (this.fighter.moveForwardPossible()) {
                    this.fighter.startAnim(1);
                    break;
                }
                this.fighter.turnAround();
                break;
            }
            case 2: 
            case 3: {
                this.fighter.turnAround();
                break;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateTutorialShowMove(int lesson_id, int step) {
        switch (lesson_id) {
            case 1: {
                switch (step) {
                    case 0: {
                        if (this.fighter.currentAnim != 0) return step;
                        this.fighter.startAnim(2);
                        return step + 1;
                    }
                    case 1: {
                        if (this.fighter.currentAnim != 0) return step;
                        this.fighter.startAnim(1);
                        return step + 1;
                    }
                    case 2: {
                        if (this.fighter.currentAnim != 0) return step;
                        this.fighter.startAnim(14);
                        return step + 1;
                    }
                    case 3: {
                        if (this.fighter.currentAnim != 0) return step;
                        this.fighter.turnAround();
                        return step + 1;
                    }
                    case 4: {
                        if (this.fighter.currentAnim != 0) return step;
                        this.fighter.startAnim(14);
                        return step + 1;
                    }
                    case 5: {
                        if (this.fighter.currentAnim != 0) return step;
                        this.fighter.turnAround();
                        return step + 1;
                    }
                    case 6: {
                        if (this.fighter.currentAnim != 0) return step;
                        return -1;
                    }
                }
                return step;
            }
            case 2: {
                switch (step) {
                    case 0: {
                        this.fighter.startAnim(1);
                        return step + 1;
                    }
                    case 1: {
                        if (this.fighter.currentAnim != 0) return step;
                        this.fighter.startAnim(5);
                        return step + 1;
                    }
                    case 2: {
                        if (this.fighter.currentAnim != 0) return step;
                        return -1;
                    }
                }
                return step;
            }
            case 3: {
                switch (step) {
                    case 0: {
                        this.fighter.startAnim(1);
                        return step + 1;
                    }
                    case 1: {
                        if (this.fighter.currentAnim != 0) return step;
                        this.fighter.startAnim(5);
                        this.fighter.doCombo1 = true;
                        this.fighter.doCombo2 = true;
                        return step + 1;
                    }
                    case 2: {
                        if (this.fighter.currentAnim != 0) return step;
                        return -1;
                    }
                }
                return step;
            }
            case 4: {
                switch (step) {
                    case 0: {
                        this.fighter.startAnim(1);
                        return step + 1;
                    }
                    case 1: {
                        if (this.fighter.currentAnim == 0) {
                            this.fighter.startAnim(6);
                            return step + 1;
                        }
                    }
                    case 2: {
                        if (this.fighter.currentAnim != 0) return step;
                        return -1;
                    }
                }
                return step;
            }
            case 5: {
                switch (step) {
                    case 0: {
                        this.fighter.startAnim(8);
                        return step + 1;
                    }
                    case 1: {
                        if (this.fighter.currentAnim != 0) return step;
                        if (!this.fighter.opponentInCloseRange()) return -1;
                        this.fighter.startAnim(2);
                        return step + 1;
                    }
                    case 2: {
                        if (this.fighter.currentAnim != 0) return step;
                        return -1;
                    }
                }
                return step;
            }
            case 6: {
                switch (step) {
                    case 0: {
                        this.fighter.startAnim(9);
                        this.fighter.isSpecialSuccess = true;
                        return step + 1;
                    }
                    case 1: {
                        if (this.fighter.currentAnim != 0) return step;
                        this.fighter.isSpecialSuccess = false;
                        return step + 1;
                    }
                    case 2: {
                        if (this.fighter.currentAnim != 0) return step;
                        this.fighter.startAnim(2);
                        return step + 1;
                    }
                    case 3: {
                        if (this.fighter.currentAnim != 0) return step;
                        return -1;
                    }
                }
                return step;
            }
            case 7: {
                switch (step) {
                    case 0: {
                        this.fighter.startAnim(1);
                        return step + 1;
                    }
                    case 1: {
                        if (this.fighter.currentAnim != 0) return step;
                        this.fighter.startAnim(7);
                        this.opponent.startAnim(5);
                        return step + 1;
                    }
                    case 2: {
                        if (this.opponent.currentAnim != 0) return step;
                        this.fighter.stopAnim();
                        return -1;
                    }
                }
                return step;
            }
            case 8: {
                switch (step) {
                    case 0: {
                        this.fighter.startAnim(1);
                        return step + 1;
                    }
                    case 1: {
                        if (this.fighter.currentAnim != 0) return step;
                        this.opponent.startAnim(5);
                        this.fighter.startAnim(14);
                        return step + 1;
                    }
                    case 2: {
                        if (this.fighter.currentAnim != 0) return step;
                        this.fighter.turnAround();
                        this.fighter.startAnim(4);
                        return step + 1;
                    }
                    case 3: {
                        if (this.fighter.currentAnim != 0 || this.opponent.currentAnim != 0) return step;
                        return -1;
                    }
                }
                return step;
            }
            case 9: {
                switch (step) {
                    case 0: {
                        this.fighter.startAnim(1);
                        return step + 1;
                    }
                    case 1: {
                        if (this.fighter.currentAnim != 0) return step;
                        this.fighter.startAnim(5);
                        this.fighter.doCombo1 = true;
                        this.fighter.doCombo2 = true;
                        return step + 1;
                    }
                    case 2: {
                        if (this.fighter.currentAnim != 0) return step;
                        this.fighter.startAnim(3);
                        return step + 1;
                    }
                    case 3: {
                        if (this.fighter.currentAnim != 0 || this.opponent.currentAnim != 0) return step;
                        return -1;
                    }
                }
            }
        }
        return step;
    }

    private void moveLeftOrRight() {
        if (this.fighter.facesOpponent() && this.fighter.opponentInCloseRange() && this.fighter.opponentWillBeInCloseRange()) {
            this.fighter.startAnim(14);
        }
    }

    public void update(long elapsed_time, long currentTick) {
        if (this.opponent.currentAnim == 13 || this.fighter.currentAnim == 13) {
            if (this.fighter.currentAnim == 9 && this.fighter.animDelays[9][this.fighter.currentFrame] == 999) {
                this.fighter.isSpecialSuccess = false;
                this.fighter.advanceFrame();
            }
            return;
        }
        if (currentTick < this.aiLastThink + 3L) {
            return;
        }
        this.aiLastThink = currentTick;
        this.special_wait_time = this.fighter.opponentInCloseRange() ? currentTick : currentTick - this.special_wait_time;
        if (this.fighter.health <= 0) {
            this.fighter.startAnim(13);
        }
        this.dodge_sub_time = (int)((long)this.dodge_sub_time + elapsed_time);
        if (this.dodge_sub_time > 400) {
            this.dodge_sub_time = 0;
            this.dodge_chance -= 4;
            if (this.dodge_chance < this.DODGE_CHANCE) {
                this.dodge_chance = this.DODGE_CHANCE;
            }
            this.parry_chance -= 4;
            if (this.parry_chance < this.PARRY_CHANCE) {
                this.parry_chance = this.PARRY_CHANCE;
            }
        }
        if (this.fighter.health < this.ACTION_PROBABILITY_LOW_HEALTH_THRESHOLD && this.action_probability_bonus == 0) {
            switch (this.getIntelligence()) {
                case 0: {
                    this.action_probability_bonus = this.ACTION_PROBABILITY_LOW_HEALTH_BONUS_LOW;
                    break;
                }
                case 1: {
                    this.mode = 4;
                    this.action_probability_bonus = this.ACTION_PROBABILITY_LOW_HEALTH_BONUS_MEDIUM;
                    break;
                }
                case 2: {
                    this.mode = 4;
                    this.action_probability_bonus = this.ACTION_PROBABILITY_LOW_HEALTH_BONUS_HIGH;
                }
            }
        }
        if (this.opponent.isPerformingSpecial) {
            return;
        }
        if (this.fighter.isPerformingSpecial) {
            if (FighterAI.random(100) > 15) {
                return;
            }
            if (this.fighter.animDelays[9][this.fighter.currentFrame] == 999) {
                if (FighterAI.random(100) <= this.SPECIAL_SUCCESS_PROBABILITY) {
                    this.fighter.isSpecialSuccess = true;
                    switch (FighterAI.random(4)) {
                        case 0: {
                            this.fighter.specialResult = 1;
                            break;
                        }
                        case 1: {
                            this.fighter.specialResult = 0;
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.fighter.specialResult = 2;
                        }
                    }
                } else {
                    this.fighter.isSpecialSuccess = false;
                    this.fighter.specialResult = -1;
                }
                this.fighter.advanceFrame();
            }
            return;
        }
        if (this.opponent.currentAnim == 15 && this.getIntelligence() != 0 && this.fighter.currentAnim != 3 && FighterAI.random(3) == 0) {
            this.fighter.startAnim(3);
            return;
        }
        if (!(this.getIntelligence() != 2 && this.getIntelligence() != 1 || this.fighter.currentAnim != 6 || this.fighter.currentFrame != 0 || this.fighter.opponentWillBeInCloseRange() && this.fighter.facesOpponent())) {
            this.fighter.stopAnim();
        }
        if (this.opponent.currentAnim == 12) {
            if (this.fighter.opponentWillBeInCloseRange()) {
                switch (this.getIntelligence()) {
                    case 0: {
                        this.fighter.startAnim(5);
                        break;
                    }
                    case 1: {
                        this.heavy_attack_time = 0;
                        this.fighter.startAnim(6);
                        break;
                    }
                    case 2: {
                        if (FighterAI.random(2) == 0 && this.fighter.moveBackwardsPossible()) {
                            this.fighter.startAnim(2);
                            break;
                        }
                        this.heavy_attack_time = 0;
                        this.fighter.startAnim(6);
                    }
                }
            } else if (this.special_wait_time > 30L) {
                this.performSpecial();
            }
            return;
        }
        if (this.opponent.currentAnim == 15) {
            if (this.fighter.opponentWillBeInCloseRange()) {
                switch (this.getIntelligence()) {
                    case 0: {
                        if (this.fighter.moveBackwardsPossible()) {
                            this.fighter.startAnim(2);
                            break;
                        }
                        if (!this.opponent.facesOpponent()) break;
                        this.fighter.startAnim(14);
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (FighterAI.random(2) == 0) {
                            if (this.fighter.moveBackwardsPossible()) {
                                this.fighter.startAnim(2);
                                break;
                            }
                            if (!this.opponent.facesOpponent()) break;
                            this.fighter.startAnim(14);
                            break;
                        }
                        this.fighter.startAnim(3);
                    }
                }
            }
            return;
        }
        if (this.opponent.currentAnim == 6 && this.fighter.opponentWillBeInCloseRange()) {
            int compare = this.HEAVY_ATTACK_BACKWARD_LOW;
            switch (this.getIntelligence()) {
                case 1: {
                    compare = this.HEAVY_ATTACK_BACKWARD_MEDIUM;
                    break;
                }
                case 2: {
                    compare = this.HEAVY_ATTACK_BACKWARD_HIGH;
                }
            }
            if (FighterAI.random(100) <= compare) {
                if (FighterAI.random(3) == 0) {
                    if (this.fighter.moveBackwardsPossible()) {
                        this.fighter.startAnim(2);
                    } else {
                        this.moveLeftOrRight();
                    }
                } else {
                    this.moveLeftOrRight();
                }
            }
        }
        if (this.opponent.currentAnim == 7) {
            this.opponent_block_time = (int)((long)this.opponent_block_time + elapsed_time);
            if (this.opponent_block_time > 800) {
                switch (this.getIntelligence()) {
                    case 0: {
                        if (this.fighter.opponentWillBeInCloseRange()) {
                            switch (FighterAI.random(6)) {
                                case 0: {
                                    this.heavy_attack_time = 0;
                                    this.opponent_block_time = 0;
                                    this.fighter.startAnim(6);
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    this.moveLeftOrRight();
                                    this.opponent_block_time = 0;
                                    break;
                                }
                                case 5: {
                                    if (!this.fighter.moveBackwardsPossible()) break;
                                    this.fighter.startAnim(2);
                                    break;
                                }
                                case 3: 
                                case 4: {
                                    this.fighter.startAnim(5);
                                }
                            }
                            break;
                        }
                        if (this.special_wait_time <= 30L || FighterAI.random(2) != 0) break;
                        this.opponent_block_time = 0;
                        this.performSpecial();
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (this.fighter.opponentWillBeInCloseRange()) {
                            switch (FighterAI.random(3)) {
                                case 0: {
                                    this.heavy_attack_time = 0;
                                    this.fighter.startAnim(6);
                                    this.opponent_block_time = 0;
                                    break;
                                }
                                case 1: {
                                    this.moveLeftOrRight();
                                    this.opponent_block_time = 0;
                                    break;
                                }
                                case 2: {
                                    if (!this.fighter.moveBackwardsPossible()) break;
                                    this.fighter.startAnim(2);
                                }
                            }
                            break;
                        }
                        if (this.special_wait_time <= 30L) break;
                        this.opponent_block_time = 0;
                        this.performSpecial();
                    }
                }
                return;
            }
        } else {
            this.opponent_block_time = 0;
        }
        if (this.opponent.isRecovering() && this.opponent.opponentInCloseRange() && this.fighter.facesOpponent()) {
            if (this.fighter.currentAnim == 7) {
                this.fighter.stopAnim();
            }
            block38 : switch (this.getIntelligence()) {
                case 0: 
                case 1: {
                    switch (FighterAI.random(3)) {
                        case 0: {
                            if (this.fighter.moveBackwardsPossible()) {
                                this.fighter.startAnim(2);
                                break;
                            }
                            this.fighter.startAnim(14);
                            break;
                        }
                        case 1: {
                            this.fighter.startAnim(5);
                            break;
                        }
                        case 2: {
                            if (this.fighter.fighterId == 0 || this.fighter.fighterId == 5) {
                                this.fighter.startAnim(6);
                                break;
                            }
                            this.fighter.startAnim(5);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (FighterAI.random(4)) {
                        case 0: {
                            if (this.fighter.moveBackwardsPossible()) {
                                this.fighter.startAnim(2);
                                break block38;
                            }
                            this.fighter.startAnim(14);
                            break block38;
                        }
                        case 1: {
                            this.fighter.startAnim(5);
                            break block38;
                        }
                        case 2: {
                            this.fighter.startAnim(14);
                            break block38;
                        }
                        case 3: {
                            if (this.fighter.fighterId == 0 || this.fighter.fighterId == 5) {
                                this.fighter.startAnim(6);
                                break block38;
                            }
                            this.fighter.startAnim(5);
                        }
                    }
                }
            }
            return;
        }
        if (this.opponent.facesOpponent() && this.fighter.currentAnim == 0 && (this.opponent.opponentInCloseRange() && (this.opponent.currentAnim == 5 || this.opponent.currentAnim == 4 || this.opponent.currentAnim == 10 || this.opponent.currentAnim == 11) || this.opponent.opponentWillBeInCloseRange() && this.opponent.currentAnim == 8) && FighterAI.random(100) < 50 + this.difficulty * 8 + this.stage * 3) {
            this.fighter.startAnim(7);
            return;
        }
        if (this.fighter.currentAnim == 7) {
            if (!this.fighter.facesOpponent()) {
                switch (this.getIntelligence()) {
                    case 0: 
                    case 1: {
                        if (FighterAI.random(100) >= this.ACTION_PROBABILITY + this.action_probability_bonus) break;
                        this.fighter.stopAnim();
                        break;
                    }
                    case 2: {
                        this.fighter.stopAnim();
                    }
                }
            }
            if (this.opponent.currentAnim != 8 && FighterAI.random(100) < this.ACTION_PROBABILITY + this.action_probability_bonus) {
                this.fighter.stopAnim();
            }
            return;
        }
        if (this.fighter.currentAnim == 5 && FighterAI.random(100) < this.COMBO_CHANCE) {
            this.fighter.doCombo1 = true;
        }
        if (this.fighter.currentAnim == 10 && FighterAI.random(100) < this.COMBO_CHANCE) {
            this.fighter.doCombo2 = true;
        }
        if (!this.fighter.facesOpponent() && this.fighter.currentAnim != 12) {
            if (this.fighter.health < 60) {
                this.fighter.turnAround();
            } else if (FighterAI.random(100) < 10 + this.difficulty * 10) {
                this.fighter.turnAround();
            }
            return;
        }
        this.heavy_attack_time = -1;
        switch (this.mode) {
            case 0: {
                if (FighterAI.random(100) > this.ACTION_PROBABILITY + this.action_probability_bonus) break;
                this.performRandomMove();
                break;
            }
            case 4: {
                if (FighterAI.random(100) > this.ACTION_PROBABILITY + this.action_probability_bonus) break;
                int rnd = FighterAI.random(100);
                if (this.fighter.opponentWillBeInCloseRange()) {
                    if (rnd <= this.LOW_LIFE_MOVE_BACK_CHANCE) {
                        if (!this.fighter.moveBackwardsPossible()) break;
                        this.fighter.startAnim(2);
                        break;
                    }
                    if (rnd <= this.LOW_LIFE_BLOCK_CHANCE) {
                        this.fighter.startAnim(7);
                        break;
                    }
                    if (rnd <= this.LOW_LIFE_ATTACK_CHANCE) {
                        this.fighter.startAnim(5);
                        break;
                    }
                    if (rnd > this.LOW_LIFE_MOVE_LEFT_RIGHT_CHANCE) break;
                    this.moveLeftOrRight();
                    break;
                }
                if (rnd <= this.LOW_LIFE_FAR_ATTACK) {
                    this.fighter.startAnim(8);
                    break;
                }
                if (rnd <= this.LOW_LIFE_FAR_SPECIAL_ATTACK && this.special_wait_time > 30L) {
                    this.performSpecial();
                    break;
                }
                if (rnd > this.LOW_LIFE_FAR_MOVE_FORWARD || !this.fighter.moveForwardPossible()) break;
                this.fighter.startAnim(1);
                break;
            }
            case 5: {
                if (FighterAI.random(100) > this.ACTION_PROBABILITY + this.action_probability_bonus) break;
                int rnd = FighterAI.random(100);
                if (this.fighter.opponentWillBeInCloseRange()) {
                    if (rnd <= this.SLOW_LEFT_RIGHT_CHANCE) {
                        this.moveLeftOrRight();
                        break;
                    }
                    if (rnd <= this.SLOW_STEP_BACK_CHANCE) {
                        if (!this.fighter.moveBackwardsPossible()) break;
                        this.fighter.startAnim(2);
                        break;
                    }
                    if (rnd <= this.SLOW_BLOCK_CHANCE) {
                        this.fighter.startAnim(7);
                        break;
                    }
                    if (rnd <= this.SLOW_SHIELD_ATTACK_CHANCE) {
                        this.fighter.startAnim(4);
                        break;
                    }
                    if (rnd <= this.SLOW_ATTACK_CHANCE) {
                        this.fighter.startAnim(5);
                        break;
                    }
                    if (rnd > this.SLOW_HEAVY_ATTACK_CHANCE) break;
                    this.fighter.startAnim(6);
                    break;
                }
                if (rnd <= this.SLOW_FAR_LEFT_RIGHT_CHANCE) {
                    this.moveLeftOrRight();
                    break;
                }
                if (rnd <= this.SLOW_FAR_MOVE_FORWARD_CHANCE) {
                    if (!this.fighter.moveForwardPossible()) break;
                    this.fighter.startAnim(1);
                    break;
                }
                if (rnd <= this.SLOW_FAR_ATTACK_CHANCE) {
                    this.fighter.startAnim(8);
                    break;
                }
                if (rnd <= this.SLOW_FAR_SPECIAL_ATTACK_CHANCE && this.special_wait_time > 30L) {
                    this.performSpecial();
                    break;
                }
                if (rnd > this.SLOW_FAR_HEAVY_ATTACK_CHANCE) break;
                this.fighter.startAnim(6);
                break;
            }
            case 2: {
                if (this.attack) {
                    if (this.fighter.facesOpponent()) {
                        if (!this.opponent.facesOpponent()) {
                            this.fighter.startAnim(4);
                        } else {
                            this.fighter.startAnim(5);
                        }
                        this.attack = false;
                    } else if (this.getIntelligence() == 2) {
                        this.moveLeftOrRight();
                    }
                    return;
                }
                if (FighterAI.random(100) > this.ACTION_PROBABILITY + this.action_probability_bonus) break;
                if (!this.fighter.facesOpponent()) {
                    this.moveEventuallyIfNotRotatedCorrectly();
                }
                if (FighterAI.random(100) <= this.AGILE_MOVE_THEN_ATTACK) {
                    this.moveLeftOrRight();
                    this.attack = true;
                    break;
                }
                this.performRandomMove();
            }
        }
    }
}

