/*
 * Decompiled with CFR 0.152.
 */
package com.mliven;

import com.mliven.Arena;
import com.mliven.DataStore;
import com.mliven.FighterAI;
import com.mliven.Gladiator2D;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Fighter {
    private static final int FIGHTER_MIN_POSITION = 1;
    private static final int FIGHTER_MAX_POSITION = 7;
    public static final int MAX_HITPOINTS = 100;
    public static final int MAX_ANIM_NUM = 18;
    public static final int ANIM_IDLE = 0;
    public static final int ANIM_FORWARD = 1;
    public static final int ANIM_BACKWARD = 2;
    public static final int ANIM_CHEER = 3;
    public static final int ANIM_SHIELD_STUN = 4;
    public static final int ANIM_NORMAL_ATTACK = 5;
    public static final int ANIM_HEAVY_ATTACK = 6;
    public static final int ANIM_BLOCK = 7;
    public static final int ANIM_FIERCE_ATTACK = 8;
    public static final int ANIM_SPECIAL_ATTACK = 9;
    public static final int ANIM_COMBO_1 = 10;
    public static final int ANIM_COMBO_2 = 11;
    public static final int ANIM_STUNNED = 12;
    public static final int ANIM_DEATH = 13;
    public static final int ANIM_MOVE_BEHIND = 14;
    public static final int ANIM_CRITICAL = 15;
    public static final int ANIM_VICTORY = 16;
    public static final int ANIM_HITTED = 17;
    private static final int HITTED_TIME = 10;
    private static final int RECOVERY_TIME = 30;
    private static final int STUNNED_TIME = 83;
    private static final int CRIT_TIME = 15;
    public static final int FAME_DAMAGE_BONUS_THRESHOLD_1 = 34;
    public static final int FAME_DAMAGE_BONUS_THRESHOLD_2 = 67;
    private static final int FAME_DAMAGE_BONUS_FACTOR_1 = 15;
    private static final int FAME_DAMAGE_BONUS_FACTOR_2 = 20;
    private static final int FAME_DOWN_TIME = 83;
    private static final int FAME_DOWN_AMOUNT = 1;
    private static final int BULL_FIERCE_STUN_PROB = 50;
    public static final int[][] CHAR_ATTRIBUTES = new int[][]{{4, 1, 3, 2}, {2, 3, 2, 2}, {3, 4, 2, 2}, {3, 2, 3, 2}, {3, 3, 2, 2}, {4, 1, 3, 2}, {4, 1, 3, 4}, {3, 3, 2, 4}, {2, 4, 2, 3}};
    public static final int[] BASIC_DAMAGES = new int[]{3, 3, 4, 5, 10, 1, 7, 3};
    public static final int[] BASIC_BONUSES = new int[]{1, 1, 1, 1, 2, 1, 1, 1};
    public static final int[] SPECIAL_ATTACK_STOP_FRAMES = new int[]{1, 1, 2, 2, 1, 1, 3, 3, 0};
    public static final int[][] MAXIMUS_DAMAGE_FRAMES = new int[][]{{-1}, {-1}, {-1}, {-1}, {1}, {1}, {2}, {-1}, {3}, {2, 6}, {1}, {1}, {-1}, {-1}, {-1}, {-1}, {-1}, {-1}};
    public static final int[][] AMAZON_DAMAGE_FRAMES = new int[][]{{-1}, {-1}, {-1}, {-1}, {1}, {1}, {2}, {-1}, {3}, {1, 4}, {1}, {1}, {-1}, {-1}, {-1}, {-1}, {-1}, {-1}};
    public static final int[][] HAGEN_DAMAGE_FRAMES = new int[][]{{-1}, {-1}, {-1}, {-1}, {1}, {1}, {2, 4, 6, 8}, {-1}, {3}, {2, 6}, {1}, {1}, {-1}, {-1}, {-1}, {-1}, {-1}, {-1}};
    public static final int[][] COMMODUS_DAMAGE_FRAMES = new int[][]{{-1}, {-1}, {-1}, {-1}, {1}, {1}, {2}, {-1}, {3}, {1, 3}, {1}, {1}, {-1}, {-1}, {-1}, {-1}, {-1}, {-1}};
    public static final int[][] TIGER_DAMAGE_FRAMES = new int[][]{{-1}, {-1}, {-1}, {-1}, {1}, {1}, {2}, {-1}, {3}, {3, 7}, {1}, {1}, {-1}, {-1}, {-1}, {-1}, {-1}, {-1}};
    public static final int[][] TRIDENT_DAMAGE_FRAMES = new int[][]{{-1}, {-1}, {-1}, {-1}, {1}, {1}, {2}, {-1}, {3}, {4, 6}, {1}, {1}, {-1}, {-1}, {-1}, {-1}, {-1}, {-1}};
    public static final int[][] JUBA_DAMAGE_FRAMES = new int[][]{{-1}, {-1}, {-1}, {-1}, {1}, {1}, {2}, {-1}, {3}, {4, 8}, {1}, {1}, {-1}, {-1}, {-1}, {-1}, {-1}, {-1}};
    public static final int[][] MACE_DAMAGE_FRAMES = new int[][]{{-1}, {-1}, {-1}, {-1}, {1}, {1}, {2, 6, 10}, {-1}, {3}, {2, 6}, {1}, {2}, {-1}, {-1}, {-1}, {-1}, {-1}, {-1}};
    public static final int[][] MAXIMUS_ANIM_DELAYS = new int[][]{{9, 9}, {3, 3}, {3, 3}, {3, 15, 3, 3}, {6, 3}, {3, 6}, {40, 3, 3, 3}, {0}, {3, 3, 3, 3, 3}, {3, 999, 3, 3, 3, 999, 3, 6, 3}, {5, 5}, {5, 5, 5}, {83}, {5, 5, 5, 5}, {3, 3, 3, 3, 3}, {15}, {3, 0}, {10}};
    public static final int[][] MAXIMUS_ANIM_OFFSET_X = new int[][]{{0, -1}, {20, 40}, {-20, -40}, {0, 0, 0, 0}, {30, 15}, {-20, 20}, {0, 30, 15, 5}, {0}, {20, 40, 60, 80, 85}, {20, 40, 60, 80, 80, 60, 80, 80, 80}, {0, 0}, {0, 0, 0}, {0}, {0, 0, 0, 0}, {20, 40, 60, 80, 100}, {0}, {0, 0}, {0}};
    public static final int[][] MAXIMUS_ANIM_OFFSET_Y = new int[][]{{0, 0}, {0, 0}, {0, 0}, {0, 0, 0, 0}, {0, 0}, {0, 0}, {0, 0, 0, 0}, {0}, {14, 30, 16, 8, 3}, {14, 30, 16, 8, 3, 0, 0, 0, 0}, {0, 0}, {0, 0, 0}, {0}, {0, 0, 0, -5}, {0, 0, 0, 0, 0}, {0}, {0, 0}, {0}};
    public static final int[][] BULL_ANIM_DELAYS = new int[][]{{9, 9}, {3, 3}, {3}, {15}, {3, 3, 6}, {3, 6}, {33, 3, 6, 3, 3}, {0}, {3, 3, 3}, {3, 999, 3, 3, 3, 999, 3, 6, 3}, {6, 3}, {3, 6, 3, 6, 3}, {83}, {3, 6, 3, 3, 9999}, {3, 3, 3, 3}, {15}, {0}, {10}};
    public static final int[][] BULL_ANIM_OFFSET_X = new int[][]{{0, 0}, {9, 30}, {-32}, {-9}, {-27, 9, 27}, {-35, 14}, {-15, -5, 12, 32, -9}, {-14}, {5, 59, 100}, {23, 39, 79, 86, 67, 67, 67, 67, 67}, {-15, 14}, {-15, -15, -15, 5, 5}, {0}, {6, 9, 6, 18, 1}, {14, 35, 67, 95}, {0}, {-9}, {-14}};
    public static final int[][] BULL_ANIM_OFFSET_Y = new int[][]{{0, -1}, {0, 0}, {0}, {0}, {0, 0, 0}, {0, 0}, {0, 0, 0, 0, 0}, {0}, {0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0}, {0, 0, 0, 0, 0}, {0}, {0, 0, 0, -5, -5}, {0, 0, 0, 0}, {0}, {0}, {0}};
    public static final int[][] AMAZON_ANIM_DELAYS = new int[][]{{9, 9}, {3, 3}, {3, 3}, {3, 6, 3}, {3, 6, 3}, {3, 6}, {36, 6, 3}, {15}, {6, 3, 6}, {999, 3, 3, 999, 6}, {3, 3}, {6, 3}, {83}, {3, 6, 9, 9999}, {3, 3, 3, 3, 3}, {15}, {3, 0}, {10}};
    public static final int[][] AMAZON_ANIM_OFFSET_X = new int[][]{{0, 0}, {13, 36}, {-31, -51}, {-10, -8, -12}, {13, 18, 13}, {-35, 11}, {-12, 12, 18}, {-10}, {0, 0, 0}, {20, 69, 55, 52, 78}, {0, 11}, {0, 11}, {0}, {6, 0, 30, 30}, {13, 36, 60, 91, 111}, {0}, {-10, -8}, {-10}};
    public static final int[][] AMAZON_ANIM_OFFSET_Y = new int[][]{{0, 0}, {0, 0}, {0, 3}, {0, 0, 0}, {0, 0, 0}, {0, 0}, {0, 0, 0}, {0}, {0, 0, 0}, {25, 0, 0, 0, 0}, {0, 0}, {0, 0}, {0}, {0, 0, -1, -1}, {0, 0, 0, 0, 0}, {0}, {0, 0}, {0}};
    public static final int[][] COMMODUS_ANIM_DELAYS = new int[][]{{9, 9}, {3, 3}, {3, 3}, {3, 6, 3}, {3, 3, 3}, {3, 6}, {40, 3, 3, 3, 3}, {0}, {3, 3, 3, 6}, {999, 3, 999, 3, 3}, {6, 6}, {6, 6}, {83}, {6, 3, 6, 15}, {3, 3, 3, 3, 3}, {15}, {3, 0}, {10}};
    public static final int[][] COMMODUS_ANIM_OFFSET_X = new int[][]{{0, 0}, {25, 41}, {-3, -33}, {0, 0, 0}, {17, 43, 24}, {-32, 24}, {-12, 10, 16, 22, 8}, {-6}, {12, 60, 80, 80}, {29, 60, 45, 60, 60}, {0, 21}, {10, 21}, {0}, {-1, -7, 8, 8}, {25, 41, 60, 85, 101}, {0}, {0, 0}, {-6}};
    public static final int[][] COMMODUS_ANIM_OFFSET_Y = new int[][]{{0, 0}, {0, 0}, {2, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0}, {0, 0, 0, 0, 0}, {0}, {0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0}, {0, 0}, {0}, {0, 0, -1, -3}, {0, 0, 0, 0, 0}, {0}, {0, 0}, {0}};
    public static final int[][] HAGEN_ANIM_DELAYS = new int[][]{{9, 9}, {3, 3}, {3, 3}, {3, 6, 3}, {3, 3, 3}, {3, 6}, {3, 3, 3, 3, 3, 3, 3, 3, 3, 3}, {0}, {3, 3, 3, 3}, {3, 999, 3, 999, 3, 3}, {6, 6}, {3, 3, 3, 3}, {83}, {6, 15, 6, 3, 3, 15}, {3, 3, 3, 3, 3}, {15}, {3, 0}, {10}};
    public static final int[][] HAGEN_ANIM_OFFSET_X = new int[][]{{0, 0}, {33, 40}, {-37, -51}, {0, -1, 0}, {-30, 6, 14}, {-26, 29}, {10, -42, 30, -42, 30, -42, 30, -42, 30, 15}, {-19}, {1, -8, 38, 11}, {0, 29, 75, 42, 100, 100}, {-5, 29}, {-26, 20, 40, 20}, {0}, {0, 0, 0, 0, -26, -15}, {33, 40, 60, 93, 100}, {0}, {0, 0}, {-19}};
    public static final int[][] HAGEN_ANIM_OFFSET_Y = new int[][]{{0, 0}, {0, 0}, {0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0}, {0, 0, 0, 0}, {0, 21, 0, 0, 0, 0}, {0, 1}, {0, 0, 0, 0}, {0}, {-1, -6, -1, -6, -2, -4}, {0, 0, 0, 0, 0}, {0}, {0, 0}, {0}};
    public static final int[][] JUBA_ANIM_DELAYS = new int[][]{{9, 9}, {3, 3}, {3, 3}, {3, 6, 3}, {3, 3, 3, 3, 3, 3}, {3, 6}, {33, 3, 3, 6}, {0}, {3, 3, 3, 3, 6, 3, 3}, {3, 3, 999, 3, 6, 3, 999, 3, 6}, {6, 6}, {6, 6}, {83}, {6, 12, 12, 3, 0, 15}, {3, 3, 3, 3, 3}, {15}, {3, 0}, {10}};
    public static final int[][] JUBA_ANIM_OFFSET_X = new int[][]{{0, 0}, {19, 42}, {-28, -52}, {18, 19, 18}, {10, 20, 35, 40, 20, 10}, {-16, 20}, {0, 0, 0, 0}, {-18}, {2, 8, 54, 74, 112, 42, 19}, {-5, 20, 30, 50, 60, 60, 60, 60, 60}, {15, 15}, {-15, 20}, {0}, {11, 14, 11, 14, 27, 26}, {19, 42, 60, 79, 102}, {0}, {0, 0}, {-18}};
    public static final int[][] JUBA_ANIM_OFFSET_Y = new int[][]{{0, 0}, {0, 0}, {0, 0}, {0, 0, 0}, {0, 0, 1, 0, 0, 0}, {0, 1}, {0, 0, 0, 0}, {0}, {0, 2, 0, 0, 0, 0, 0}, {0, 29, 44, 0, 0, 0, 0, 0, 0}, {0, 0}, {0, 0}, {0}, {-1, -1, -1, -1, -1, -3}, {0, 0, 0, 0, 0}, {0}, {0, 0}, {0}};
    public static final int[][] MACE_ANIM_DELAYS = new int[][]{{9, 9}, {3, 3}, {3, 3}, {6, 6, 6}, {3, 3, 3}, {3, 6}, {3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3}, {0}, {3, 3, 3, 6}, {3, 999, 3, 6, 3, 999, 6, 3}, {6, 6}, {6, 6, 6}, {83}, {3, 3, 6, 6, 9999}, {3, 3, 3, 3, 3}, {15}, {3, 0}, {10}};
    public static final int[][] MACE_ANIM_OFFSET_X = new int[][]{{0, 0}, {32, 40}, {-13, -39}, {-9, -9, -9}, {-16, 9, 45}, {-13, 32}, {0, 1, 2, 2, 0, 1, 2, 2, 0, 1, 2}, {-3}, {16, 48, 89, 99}, {-8, 30, 80, 70, 70, 70, 70, 70}, {0, 32}, {0, -20, 0}, {0}, {-8, -12, 18, 18, 18}, {32, 40, 60, 92, 100}, {0}, {0, 0}, {-3}};
    public static final int[][] MACE_ANIM_OFFSET_Y = new int[][]{{0, 0}, {0, 0}, {0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0}, {0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0}, {0}, {0, 0, 0, 0}, {0, 8, 0, 0, 0, 0, 0, 0}, {0, 0}, {0, 0, 0}, {0}, {0, 0, -2, -2, -2}, {0, 0, 0, 0, 0}, {0}, {0, 0}, {0}};
    public static final int[][] TIGER_ANIM_DELAYS = new int[][]{{9, 9}, {3, 3}, {3, 3}, {6, 6, 6}, {3, 6, 3}, {3, 3, 3}, {40, 6, 3}, {0}, {3, 3, 3, 3, 3, 3}, {3, 3, 999, 3, 3, 999, 3, 3, 3}, {6, 6}, {6, 6, 3}, {83}, {3, 3, 15}, {3, 3, 3, 3, 3}, {15}, {3, 0}, {10}};
    public static final int[][] TIGER_ANIM_OFFSET_X = new int[][]{{0, 0}, {30, 60}, {-8, -40}, {0, -1, 0}, {35, 15, 35}, {0, 23, 10}, {-33, 33, 43}, {-15}, {31, 30, 35, 60, 55, 70}, {-16, 41, 60, 74, 103, 70, 70, 70, 70}, {23, -10}, {15, 10, 0}, {0}, {-11, -27, -61}, {37, 41, 60, 97, 101}, {0}, {0, 0}, {-15}};
    public static final int[][] TIGER_ANIM_OFFSET_Y = new int[][]{{0, 0}, {0, 0}, {0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0}, {0, 0, 0, 0, 0, 0}, {0, 3, 41, 4, 0, 0, 0, 0, 0}, {0, 0}, {0, 0, 0}, {0}, {0, -4, -4}, {0, 0, 0, 0, 0}, {0}, {0, 0}, {0}};
    public static final int[][] TRIDENT_ANIM_DELAYS = new int[][]{{9, 9}, {3, 3}, {3, 3}, {6, 15, 3}, {3, 6, 3}, {3, 6, 3}, {3, 33, 3, 6}, {0}, {3, 3, 3, 3, 3, 6, 3, 3}, {3, 999, 6, 3, 3, 999, 3}, {6}, {6, 6}, {83}, {12, 6, 15}, {3, 3, 3, 3, 3}, {15}, {3, 0}, {10}};
    public static final int TRIDENT_NET_OFFSET_X = 95;
    public static final int TRIDENT_NET_OFFSET_Y = 99;
    public static final int[][] TRIDENT_ANIM_OFFSET_X = new int[][]{{0, 0}, {22, 55}, {-13, -26}, {-1, -3, -1}, {22, 33, 22}, {13, 30, 13}, {12, 29, 19, 27}, {-21}, {-3, 40, -11, 30, 70, 18, -10, 20}, {0, 0, 0, 60, 84, 60, 84}, {45}, {20, 35}, {0}, {-1, 32, 36}, {22, 55, 60, 82, 115}, {0}, {0, 0}, {-21}};
    public static final int[][] TRIDENT_ANIM_OFFSET_Y = new int[][]{{0, 0}, {1, 0}, {0, 0}, {0, 0, 0}, {2, 0, 2}, {2, 0, 2}, {1, 0, 0, 0}, {0}, {0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, -3, 25, -3, -3, -3}, {0}, {0, 0}, {-7}, {-7, 0, -3}, {0, 0, 0, 0, 0}, {-7}, {0, 0}, {0}};
    public static final int MAP_UNIT_WIDTH = 60;
    public Image charName;
    private Arena arena;
    public Sprite[][] animations;
    public int[][] animDelays;
    public int[][] animOffsetX;
    private int[][] animOffsetY;
    private int[][] damageFrames;
    private int specialStopFrame;
    public Sprite[] trident_net;
    private int futurePosition;
    public int currentAnim;
    public int currentFrame;
    public long animChanged;
    public int position;
    public boolean isOnLeft;
    public boolean isFacingLeft;
    public int fighterId;
    public long recoveryTime;
    public int health;
    public int oldhealth;
    public int fame;
    public int roundWons;
    public int strength;
    public int agility;
    public int constitution;
    public int charisma;
    public boolean doCombo1;
    public boolean doCombo2;
    public boolean isPerformingSpecial;
    public boolean isSpecialSuccess;
    public int specialResult;
    public static final int SPECIAL_FAILED = -1;
    public static final int SPECIAL_GOOD = 0;
    public static final int SPECIAL_OK = 1;
    public static final int SPECIAL_PERFECT = 2;
    public int animStartPosX;
    public int animStartPosY;
    public int amazonThrowPositionX;
    public boolean isAmazonThrowActive;
    private boolean isBleeding;
    private long bleedStarted;
    private int bloodOffset;
    private static final int BLEED_TIME = 5;
    private boolean isSparkling;
    private long sparkleStarted;
    private static final int SPARKLE_TIME = 5;
    private boolean new_fame_level;
    private int new_fame_level_time;
    private static final int NEW_FAME_LEVEL_TIME = 100;
    public boolean highlight_fame;
    private long fameStartTime;
    private int last_added_fame;
    private static final int HIT_DISPLAY_TIME = 13;
    private long hit_display_start_time;
    public static final int AMAZON_THROW_SPEED = 10;
    public static final int AMAZON_THROW_Y = 180;
    public static final int AMAZON_THROW_WIDTH = 15;
    public static Sprite knife;

    public Fighter(Arena arena, int fighterId, boolean isOnLeft) {
        this.arena = arena;
        this.isOnLeft = isOnLeft;
        this.fighterId = fighterId;
        switch (fighterId) {
            case 1: {
                this.damageFrames = AMAZON_DAMAGE_FRAMES;
                this.animDelays = AMAZON_ANIM_DELAYS;
                this.animOffsetX = Fighter.copyMatrix(AMAZON_ANIM_OFFSET_X);
                this.animOffsetY = Fighter.copyMatrix(AMAZON_ANIM_OFFSET_Y);
                this.specialStopFrame = SPECIAL_ATTACK_STOP_FRAMES[1];
                break;
            }
            case 7: {
                this.damageFrames = MAXIMUS_DAMAGE_FRAMES;
                this.animDelays = MAXIMUS_ANIM_DELAYS;
                this.animOffsetX = Fighter.copyMatrix(MAXIMUS_ANIM_OFFSET_X);
                this.animOffsetY = Fighter.copyMatrix(MAXIMUS_ANIM_OFFSET_Y);
                this.specialStopFrame = SPECIAL_ATTACK_STOP_FRAMES[7];
                break;
            }
            case 3: {
                this.damageFrames = MAXIMUS_DAMAGE_FRAMES;
                this.animDelays = BULL_ANIM_DELAYS;
                this.animOffsetX = Fighter.copyMatrix(BULL_ANIM_OFFSET_X);
                this.animOffsetY = Fighter.copyMatrix(BULL_ANIM_OFFSET_Y);
                this.specialStopFrame = SPECIAL_ATTACK_STOP_FRAMES[3];
                break;
            }
            case 8: {
                this.damageFrames = COMMODUS_DAMAGE_FRAMES;
                this.animDelays = COMMODUS_ANIM_DELAYS;
                this.animOffsetX = Fighter.copyMatrix(COMMODUS_ANIM_OFFSET_X);
                this.animOffsetY = Fighter.copyMatrix(COMMODUS_ANIM_OFFSET_Y);
                this.specialStopFrame = SPECIAL_ATTACK_STOP_FRAMES[8];
                break;
            }
            case 4: {
                this.damageFrames = TRIDENT_DAMAGE_FRAMES;
                this.animDelays = TRIDENT_ANIM_DELAYS;
                this.animOffsetX = Fighter.copyMatrix(TRIDENT_ANIM_OFFSET_X);
                this.animOffsetY = Fighter.copyMatrix(TRIDENT_ANIM_OFFSET_Y);
                this.specialStopFrame = SPECIAL_ATTACK_STOP_FRAMES[4];
                break;
            }
            case 6: {
                this.damageFrames = TIGER_DAMAGE_FRAMES;
                this.animDelays = TIGER_ANIM_DELAYS;
                this.animOffsetX = Fighter.copyMatrix(TIGER_ANIM_OFFSET_X);
                this.animOffsetY = Fighter.copyMatrix(TIGER_ANIM_OFFSET_Y);
                this.specialStopFrame = SPECIAL_ATTACK_STOP_FRAMES[6];
                break;
            }
            case 0: {
                this.damageFrames = MACE_DAMAGE_FRAMES;
                this.animDelays = MACE_ANIM_DELAYS;
                this.animOffsetX = Fighter.copyMatrix(MACE_ANIM_OFFSET_X);
                this.animOffsetY = Fighter.copyMatrix(MACE_ANIM_OFFSET_Y);
                this.specialStopFrame = SPECIAL_ATTACK_STOP_FRAMES[0];
                break;
            }
            case 2: {
                this.damageFrames = JUBA_DAMAGE_FRAMES;
                this.animDelays = JUBA_ANIM_DELAYS;
                this.animOffsetX = Fighter.copyMatrix(JUBA_ANIM_OFFSET_X);
                this.animOffsetY = Fighter.copyMatrix(JUBA_ANIM_OFFSET_Y);
                this.specialStopFrame = SPECIAL_ATTACK_STOP_FRAMES[2];
                break;
            }
            case 5: {
                this.damageFrames = HAGEN_DAMAGE_FRAMES;
                this.animDelays = HAGEN_ANIM_DELAYS;
                this.animOffsetX = Fighter.copyMatrix(HAGEN_ANIM_OFFSET_X);
                this.animOffsetY = Fighter.copyMatrix(HAGEN_ANIM_OFFSET_Y);
                this.specialStopFrame = SPECIAL_ATTACK_STOP_FRAMES[5];
            }
        }
        int i = -1;
        this.strength = CHAR_ATTRIBUTES[fighterId][0];
        this.agility = CHAR_ATTRIBUTES[fighterId][1];
        this.constitution = CHAR_ATTRIBUTES[fighterId][2];
        this.charisma = CHAR_ATTRIBUTES[fighterId][3];
        this.resetFighter(isOnLeft);
        this.setPosition(this.position);
    }

    private static int[][] copyMatrix(int[][] from) {
        int[][] to = new int[from.length][];
        for (int i = 0; i < from.length; ++i) {
            to[i] = new int[from[i].length];
            for (int j = 0; j < from[i].length; ++j) {
                to[i][j] = from[i][j];
            }
        }
        return to;
    }

    public void resetFighter(boolean isOnLeft) {
        this.specialResult = -1;
        this.recoveryTime = -1L;
        this.isBleeding = false;
        this.isSparkling = false;
        this.sparkleStarted = 0L;
        this.bleedStarted = 0L;
        this.fameStartTime = 0L;
        this.hit_display_start_time = 0L;
        this.currentAnim = 0;
        this.new_fame_level = false;
        this.new_fame_level_time = 0;
        this.currentFrame = 0;
        this.isAmazonThrowActive = false;
        this.isPerformingSpecial = false;
        this.doCombo2 = false;
        this.doCombo1 = false;
        this.isSpecialSuccess = false;
        this.isOnLeft = isOnLeft;
        this.fame = 0;
        this.last_added_fame = 0;
        this.animChanged = Math.abs(Gladiator2D.rnd.nextInt() % this.animDelays[0][0]);
        if (isOnLeft) {
            this.position = 3;
            this.futurePosition = 3;
            this.isFacingLeft = false;
        } else {
            this.position = 5;
            this.futurePosition = 5;
            this.isFacingLeft = true;
        }
        this.setPosition(this.position);
        this.health = 100;
    }

    public void cleanUp() {
        for (int i = 0; i < this.animations.length; ++i) {
            for (int j = 0; j < this.animations[i].length; ++j) {
                this.animations[i][j] = null;
            }
        }
        this.animOffsetX = null;
        this.animOffsetY = null;
        this.animDelays = null;
        this.animations = null;
        this.charName = null;
        this.trident_net = null;
        knife = null;
    }

    public void startAnim(int animid) {
        if (this.recoveryTime > this.arena.arenaTick && animid != 15 && animid != 12 && animid != 17) {
            return;
        }
        if (this.arena.getFightersOpponent((Fighter)this).currentAnim == 14) {
            return;
        }
        if (this.arena.getFightersOpponent((Fighter)this).currentAnim == 9 && animid != 0 && animid != 15 && animid != 17) {
            return;
        }
        switch (animid) {
            case 14: {
                if (this.arena.getPlayer() == this && DataStore.g_game_mode == 4) {
                    if (this.arena.round != 8 && this.arena.round != 1) {
                        return;
                    }
                    if (this.arena.round == 1) {
                        this.arena.tutorial1behindmove = true;
                        this.arena.getOpponent().turnAround();
                    }
                }
                if (!this.opponentWillBeInCloseRange() || !this.facesOpponent()) {
                    return;
                }
                if (this.arena.getFightersOpponent((Fighter)this).position == 1 && this.position == 2) {
                    return;
                }
                if (this.arena.getFightersOpponent((Fighter)this).position != 7 || this.position != 6) break;
                return;
            }
        }
        if ((this.arena.status == 0 || this.arena.status == 14 || this.arena.status == 11) && (this.currentAnim == 0 || this.currentAnim == 17 || this.currentAnim == 7 && animid == 0)) {
            if (animid == 8 && this.fighterId == 1) {
                this.initAmazonThrow();
            }
            this.currentAnim = animid;
            this.currentFrame = 0;
            this.animChanged = this.arena.arenaTick;
            this.animStartPosX = this.position * 60;
            this.checkSpecialAttackInit();
            this.calculateFuturePosition();
        }
    }

    public void stopAnim() {
        switch (this.currentAnim) {
            case 9: {
                this.isPerformingSpecial = false;
                break;
            }
            case 1: {
                if (this.facesOpponent()) break;
                this.turnAround();
            }
        }
        if (this.arena.getOpponent() == this && DataStore.g_game_mode == 4) {
            switch (this.currentAnim) {
                case 5: {
                    this.arena.getPlayer().stopAnim();
                }
            }
        }
        if (this.arena.getPlayer() == this && DataStore.g_game_mode == 4) {
            switch (this.currentAnim) {
                case 1: {
                    this.arena.tutorial1forwardmove = true;
                    break;
                }
                case 2: {
                    this.arena.tutorial1backmove = true;
                    break;
                }
                case 5: {
                    if (!this.opponentInCloseRange()) break;
                    this.arena.tutorial2normalattack = true;
                    break;
                }
                case 6: {
                    if (!this.opponentInCloseRange()) break;
                    this.arena.tutorial4heavyattack = true;
                    break;
                }
                case 11: {
                    this.arena.tutorial3combo = true;
                    break;
                }
                case 8: {
                    this.arena.tutorial5fierce = true;
                    break;
                }
                case 4: {
                    if (this.arena.getOpponent().currentAnim != 12) break;
                    this.arena.tutorial8stun = true;
                }
            }
        }
        this.currentAnim = 0;
        this.currentFrame = 0;
        this.animChanged = this.arena.arenaTick;
        this.animStartPosX = this.position * 60;
    }

    public void setPosition(int pos) {
        this.futurePosition = this.position = pos;
        this.animStartPosX = this.position * 60;
    }

    public void bleed() {
        this.isBleeding = true;
        Arena.blood.setFrame(FighterAI.random(2));
        this.bleedStarted = this.arena.arenaTick;
        this.bloodOffset = FighterAI.random(this.animations[this.currentAnim][this.currentFrame].getHeight() / 4);
    }

    public void sparkle() {
        this.isSparkling = true;
        this.sparkleStarted = this.arena.arenaTick;
    }

    private void checkSpecialAttackInit() {
        if (this.currentAnim == 9 && this.currentFrame < this.animDelays[9].length && this.animDelays[this.currentAnim][this.currentFrame] == 999) {
            this.arena.initSpecialBar();
            this.isPerformingSpecial = true;
            this.specialResult = -1;
        }
    }

    public static int getAttackFromAnim(int animId) {
        switch (animId) {
            case 4: {
                return 5;
            }
            case 5: {
                return 0;
            }
            case 6: {
                return 4;
            }
            case 8: {
                return 3;
            }
            case 9: {
                return 6;
            }
            case 10: {
                return 1;
            }
            case 11: {
                return 2;
            }
        }
        return -1;
    }

    public boolean isRecovering() {
        return this.recoveryTime > this.arena.arenaTick;
    }

    public void abortAnim() {
        if (this.currentAnim != 13 && this.currentAnim != 12 && this.currentAnim != 15 && this.currentAnim != 17 && this.currentAnim != 14 && this.currentAnim != 1 && this.currentAnim != 2) {
            this.currentAnim = 17;
            this.currentFrame = 0;
            this.animChanged = this.arena.arenaTick;
            this.animStartPosX = this.position * 60;
            this.futurePosition = this.position;
        }
    }

    private void checkForDamage() {
        if (this.currentAnim == 9 && !this.isSpecialSuccess) {
            return;
        }
        Fighter opponent = this.arena.getFightersOpponent(this);
        if (opponent.currentAnim == 14 || opponent.currentAnim == 15) {
            return;
        }
        for (int i = 0; i < this.damageFrames[this.currentAnim].length; ++i) {
            if (this.damageFrames[this.currentAnim][i] != this.currentFrame) continue;
            if (!(this.opponentWillBeInCloseRange() || this.fighterId == 5 && this.currentAnim == 8 || this.fighterId == 4 && this.currentAnim == 8 || this.fighterId == 2 && this.currentAnim == 8 || this.fighterId == 1 && this.currentAnim == 8)) {
                return;
            }
            if ((this.currentAnim != 6 || this.fighterId != 5 && this.fighterId != 0) && !this.facesOpponent()) {
                return;
            }
            int factor = 10;
            if (this.fame >= 34) {
                factor = this.fame >= 67 ? 20 : 15;
            }
            int subtract = 0;
            if (this.currentAnim == 9) {
                switch (this.specialResult) {
                    case 1: {
                        subtract = 3;
                        break;
                    }
                    case 0: {
                        subtract = 2;
                    }
                }
            }
            int damage = this.currentAnim == 6 && (this.fighterId == 5 || this.fighterId == 0) ? (BASIC_DAMAGES[7] + BASIC_BONUSES[7] * this.strength / 2) * factor / 10 - opponent.constitution / 2 - subtract : (BASIC_DAMAGES[Fighter.getAttackFromAnim(this.currentAnim)] + BASIC_BONUSES[Fighter.getAttackFromAnim(this.currentAnim)] * this.strength / 2) * factor / 10 - opponent.constitution / 2 - subtract;
            boolean isBlocked = false;
            switch (this.currentAnim) {
                case 6: {
                    if (this.fighterId != 5 && this.fighterId != 0 || opponent.currentAnim != 7 || !opponent.facesOpponent()) break;
                    isBlocked = true;
                    break;
                }
                default: {
                    if (opponent.currentAnim != 7 || !opponent.facesOpponent()) break;
                    isBlocked = true;
                }
            }
            if (opponent.currentAnim == 14) {
                isBlocked = false;
            }
            if (isBlocked) {
                this.recoveryTime = this.arena.arenaTick + 30L;
                opponent.sparkle();
            } else {
                if (opponent == this.arena.getPlayer()) {
                    Gladiator2D.getInstance().vibrate();
                }
                opponent.oldhealth = opponent.health;
                opponent.health -= damage;
                opponent.highlight_fame = false;
                opponent.setFame(opponent.fame - 2, false);
                int bonus = this.currentAnim == 6 && (this.fighterId == 5 || this.fighterId == 0) ? BASIC_DAMAGES[7] + BASIC_DAMAGES[7] * this.charisma / 4 : BASIC_DAMAGES[Fighter.getAttackFromAnim(this.currentAnim)] + BASIC_DAMAGES[Fighter.getAttackFromAnim(this.currentAnim)] * this.charisma / 4;
                if (this.currentAnim == 5 || this.currentAnim == 10) {
                    bonus = bonus * 2 / 3;
                }
                this.setFame(this.fame + bonus, false);
                opponent.hit_display_start_time = this.arena.arenaTick;
                opponent.bleed();
                opponent.abortAnim();
                if (this.currentAnim == 11) {
                    opponent.startAnim(15);
                }
            }
            int opponentStartAnim = opponent.currentAnim;
            if (this.currentAnim == 4 && opponent.isFacingLeft == opponent.isOnLeft && this.opponentInCloseRange() && opponent.currentAnim != 12) {
                opponentStartAnim = 12;
            }
            if (this.fighterId != 5 && this.fighterId != 0 && this.currentAnim == 6 && this.facesOpponent() && this.opponentInCloseRange()) {
                if (opponent.currentAnim == 7) {
                    if (this.fighterId != 0 && this.fighterId != 5) {
                        opponentStartAnim = 15;
                    }
                } else {
                    opponentStartAnim = 15;
                }
            }
            if (this.fighterId == 3 && this.currentAnim == 8 && FighterAI.random(100) < 50) {
                opponentStartAnim = 12;
            }
            if (opponent.health <= 0 && opponent.currentAnim != 13) {
                opponentStartAnim = 13;
                if (this.currentAnim == 9) {
                    this.stopAnim();
                    this.setPosition(this.futurePosition);
                }
            }
            if (opponentStartAnim == opponent.currentAnim || opponent.currentAnim == 13) continue;
            opponent.stopAnim();
            opponent.startAnim(opponentStartAnim);
        }
    }

    public void advanceFrame() {
        if (this.currentAnim == 13 && this.currentFrame == this.animations[13].length - 1) {
            return;
        }
        if ((this.isPerformingSpecial || this.arena.getFightersOpponent((Fighter)this).isPerformingSpecial) && this.currentAnim != 9) {
            return;
        }
        ++this.currentFrame;
        this.animChanged = this.arena.arenaTick;
        this.checkForDamage();
    }

    public void calculateFuturePosition() {
        switch (this.currentAnim) {
            case 14: {
                if (this.isFacingLeft) {
                    this.futurePosition = this.position - 2;
                    break;
                }
                this.futurePosition = this.position + 2;
                break;
            }
            case 8: {
                if (this.fighterId == 4 || this.fighterId == 2 || this.fighterId == 1 || this.fighterId == 5) break;
                if (this.isFacingLeft) {
                    this.futurePosition = this.position - 1;
                    break;
                }
                this.futurePosition = this.position + 1;
                break;
            }
            case 9: {
                if (this.isFacingLeft) {
                    this.futurePosition = this.position - 1;
                    break;
                }
                this.futurePosition = this.position + 1;
                break;
            }
            case 1: {
                if (this.isFacingLeft) {
                    this.futurePosition = this.position - 1;
                    break;
                }
                this.futurePosition = this.position + 1;
                break;
            }
            case 2: {
                this.futurePosition = this.isFacingLeft ? this.position + 1 : this.position - 1;
            }
        }
    }

    public void tick() {
        if (this.isAmazonThrowActive) {
            this.amazonThrowPositionX = this.isFacingLeft ? (this.amazonThrowPositionX -= 10) : (this.amazonThrowPositionX += 10);
        }
        Fighter opponent = this.arena.getFightersOpponent(this);
        if (this.fameStartTime + 83L < this.arena.arenaTick && this.currentAnim != 16 && this.currentAnim != 13 && this.arena.status == 0) {
            this.setFame(this.fame - 1, false);
        }
        if (this.hit_display_start_time + 13L < this.arena.arenaTick && this.oldhealth != this.health) {
            this.oldhealth = this.health;
        }
        if (--this.new_fame_level_time < 0) {
            this.new_fame_level_time = 0;
            this.new_fame_level = false;
        }
        if (this.isBleeding && this.bleedStarted + 5L < this.arena.arenaTick) {
            this.isBleeding = false;
        }
        if (this.isSparkling && this.sparkleStarted + 5L < this.arena.arenaTick) {
            this.isSparkling = false;
        }
        if (this.currentAnim == 16 && this.currentFrame == this.animations[16].length - 1) {
            return;
        }
        if (this.currentAnim == 0 && this.arena.getFightersOpponent((Fighter)this).currentAnim == 13) {
            this.startAnim(16);
            ++this.roundWons;
            if (this.arena.status == 0) {
                this.arena.setState(2);
                return;
            }
        }
        if (this.currentAnim != 7 && this.animChanged + (long)this.animDelays[this.currentAnim][this.currentFrame] < this.arena.arenaTick) {
            if (this.currentAnim == 9 && this.currentFrame - 1 == this.specialStopFrame && !this.isSpecialSuccess) {
                if (this.isOnLeft) {
                    this.setPosition(++this.position);
                } else {
                    this.setPosition(--this.position);
                }
                this.stopAnim();
                opponent.sparkle();
                opponent.abortAnim();
                return;
            }
            if (this.currentAnim == 0 && this.arena.getFightersOpponent((Fighter)this).currentAnim == 9) {
                return;
            }
            this.advanceFrame();
            this.checkSpecialAttackInit();
            if (this.currentFrame > this.animations[this.currentAnim].length - 1) {
                switch (this.currentAnim) {
                    case 3: {
                        if (!this.highlight_fame) {
                            this.last_added_fame = 0;
                        }
                        this.setFame(this.fame + 2 * this.last_added_fame, true);
                        break;
                    }
                    case 5: {
                        this.stopAnim();
                        if (!this.doCombo1 || opponent.currentAnim == 7 || !this.opponentWillBeInCloseRange() || !this.facesOpponent() || opponent.currentAnim == 15) break;
                        this.doCombo1 = false;
                        this.startAnim(10);
                        break;
                    }
                    case 10: {
                        this.stopAnim();
                        if (!this.doCombo2 || opponent.currentAnim == 7 || !this.opponentWillBeInCloseRange() || !this.facesOpponent() || opponent.currentAnim == 15) break;
                        this.doCombo2 = false;
                        this.startAnim(11);
                        break;
                    }
                    case 11: {
                        this.stopAnim();
                        break;
                    }
                    case 9: {
                        if (this.opponentWillBeInCloseRange()) {
                            if (this.isSpecialSuccess) {
                                opponent.startAnim(15);
                                if (this.arena.getPlayer() == this && DataStore.g_game_mode == 4) {
                                    this.arena.tutorial6special = true;
                                }
                            } else {
                                opponent.sparkle();
                                opponent.abortAnim();
                            }
                        }
                        this.setPosition(this.futurePosition);
                        break;
                    }
                    case 14: {
                        boolean bl = this.isOnLeft = !this.isOnLeft;
                        if (this.arena.getFightersOpponent((Fighter)this).currentAnim != 13) {
                            this.arena.getFightersOpponent((Fighter)this).isOnLeft = !this.arena.getFightersOpponent((Fighter)this).isOnLeft;
                        }
                    }
                    case 1: 
                    case 2: 
                    case 8: {
                        this.setPosition(this.futurePosition);
                    }
                }
                if (this.currentAnim != 5 && this.currentAnim != 10 && this.currentAnim != 11) {
                    this.stopAnim();
                }
            }
        }
    }

    public void setFame(int new_fame, boolean cheering) {
        if (new_fame > this.fame) {
            if (!cheering) {
                this.last_added_fame = new_fame - this.fame;
            } else {
                this.last_added_fame = 0;
                if (this.arena.getPlayer() == this && DataStore.g_game_mode == 4) {
                    this.arena.tutorial9cheer = true;
                }
            }
        }
        this.fameStartTime = this.arena.arenaTick;
        if (this.fame < 34 && new_fame >= 34 || this.fame < 67 && new_fame >= 67) {
            this.new_fame_level = true;
            this.new_fame_level_time = 100;
        }
        this.highlight_fame = new_fame > this.fame;
        this.fame = new_fame;
        if (this.fame > 100) {
            this.fame = 100;
        } else if (this.fame < 0) {
            this.fame = 0;
        }
    }

    public void setHighlightFame(boolean b) {
        this.highlight_fame = b;
    }

    public void turnAround() {
        if (this.arena.getFightersOpponent((Fighter)this).currentAnim != 14 && (this.currentAnim == 0 || this.currentAnim == 1)) {
            this.isFacingLeft = !this.isFacingLeft;
        }
    }

    public boolean moveForwardPossible() {
        if (this.isFacingLeft) {
            if (this.position == 1) {
                return false;
            }
            if (this.facesOpponent()) {
                return !this.opponentWillBeInCloseRange();
            }
            return this.opponentWillBeInCloseRange();
        }
        if (this.position == 7) {
            return false;
        }
        if (this.facesOpponent()) {
            return !this.opponentWillBeInCloseRange();
        }
        return this.opponentWillBeInCloseRange();
    }

    public boolean moveBackwardsPossible() {
        if (this.isFacingLeft) {
            if (this.position == 7) {
                return false;
            }
            if (this.facesOpponent()) {
                return this.opponentWillBeInCloseRange();
            }
            return !this.opponentWillBeInCloseRange();
        }
        if (this.position == 1) {
            return false;
        }
        if (this.facesOpponent()) {
            return this.opponentWillBeInCloseRange();
        }
        return !this.opponentWillBeInCloseRange();
    }

    public boolean opponentWillBeInCloseRange() {
        Fighter opponent = this.arena.getFightersOpponent(this);
        return Math.abs(opponent.futurePosition - this.futurePosition) == 1;
    }

    public boolean facesOpponent() {
        Fighter opponent = this.arena.getFightersOpponent(this);
        if (opponent.currentAnim == 14) {
            return false;
        }
        if (this.isFacingLeft) {
            return opponent.position < this.position;
        }
        return opponent.position > this.position;
    }

    public boolean opponentInCloseRange() {
        return this.arena.getOpponentsDistance() == 1;
    }

    public int getDamageUpTime() {
        return this.new_fame_level_time;
    }

    public int getMaxDamageUpTime() {
        return 100;
    }

    public boolean fameMultiplierChanged() {
        return this.new_fame_level;
    }

    private void initAmazonThrow() {
        this.isAmazonThrowActive = true;
        this.amazonThrowPositionX = 0;
    }

    public void draw(Graphics g, int x, int y) {
        if (!this.isFacingLeft) {
            this.animations[this.currentAnim][this.currentFrame].setTransform(0);
        } else {
            this.animations[this.currentAnim][this.currentFrame].setTransform(2);
        }
        this.animations[this.currentAnim][this.currentFrame].setPosition(x, y + this.animStartPosY - this.animOffsetY[this.currentAnim][this.currentFrame] - this.animations[this.currentAnim][this.currentFrame].getHeight());
        this.animations[this.currentAnim][this.currentFrame].paint(g);
        if (this.fighterId == 4 && this.currentAnim == 9) {
            if (!this.isFacingLeft) {
                this.trident_net[1].setTransform(0);
            } else {
                this.trident_net[1].setTransform(2);
            }
            if (this.currentFrame == 1) {
                this.trident_net[1].setPosition(x, y - 99);
                if (!this.isFacingLeft) {
                    this.trident_net[1].move(95, 0);
                } else {
                    this.trident_net[1].move(-95 + this.trident_net[1].getWidth(), 0);
                }
                this.trident_net[1].paint(g);
            }
        }
        Fighter opponent = this.arena.getFightersOpponent(this);
        if (opponent.fighterId == 4 && opponent.currentAnim == 9) {
            if (!opponent.isFacingLeft) {
                opponent.trident_net[0].setTransform(0);
                opponent.trident_net[0].setPosition(x - opponent.trident_net[0].getWidth() / 3, y - opponent.trident_net[0].getHeight());
            } else {
                opponent.trident_net[0].setTransform(2);
                opponent.trident_net[0].setPosition(x, y - opponent.trident_net[0].getHeight());
            }
            if (opponent.currentFrame > 1) {
                opponent.trident_net[0].paint(g);
            }
        }
        if (this.isBleeding && this.currentAnim != 13) {
            if (this.isOnLeft) {
                Arena.blood.setTransform(0);
                Arena.blood.setPosition(x, y + this.animStartPosY - this.animOffsetY[this.currentAnim][this.currentFrame] - this.animations[this.currentAnim][this.currentFrame].getHeight());
                Arena.blood.move(Arena.blood.getWidth(), this.animations[this.currentAnim][this.currentFrame].getHeight() / 4 + this.bloodOffset - Arena.blood.getHeight());
            } else {
                Arena.blood.setTransform(2);
                Arena.blood.setPosition(x, y + this.animStartPosY - this.animOffsetY[this.currentAnim][this.currentFrame] - this.animations[this.currentAnim][this.currentFrame].getHeight());
                Arena.blood.move(0, this.animations[this.currentAnim][this.currentFrame].getHeight() / 4 + this.bloodOffset - Arena.blood.getHeight());
            }
            Arena.blood.paint(g);
        }
        if (this.isSparkling) {
            if (!this.isOnLeft) {
                Arena.sparkle.setTransform(2);
                Arena.sparkle.setPosition(x, y + this.animStartPosY - this.animOffsetY[this.currentAnim][this.currentFrame] - this.animations[this.currentAnim][this.currentFrame].getHeight());
                Arena.sparkle.move(-Arena.sparkle.getWidth(), 0);
            } else {
                Arena.sparkle.setTransform(0);
                Arena.sparkle.setPosition(x, y + this.animStartPosY - this.animOffsetY[this.currentAnim][this.currentFrame] - this.animations[this.currentAnim][this.currentFrame].getHeight());
                Arena.sparkle.move(Arena.sparkle.getWidth(), 0);
            }
            Arena.sparkle.paint(g);
        }
    }
}

