/*
 * Decompiled with CFR 0.152.
 */
package com.mliven;

import com.mliven.DataStore;
import com.mliven.Fighter;
import com.mliven.FighterAI;
import com.mliven.Gladiator2D;
import com.mliven.utils.ChoiceWindow;
import com.mliven.utils.GladFont;
import com.mliven.utils.MainMenu;
import com.mliven.utils.MenuItem;
import com.mliven.utils.ScrollTextBox;
import com.mliven.utils.SharedGraphics;
import com.mliven.utils.SimpleMenu;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Arena {
    public static final int STATE_FIGHT = 0;
    public static final int STATE_PRE_FIGHT = 1;
    public static final int STATE_POST_FIGHT = 2;
    public static final int STATE_ADD_FAME = 3;
    public static final int STATE_SURVIVAL_OVER = 4;
    public static final int STATE_CONTINUE_QUESTION = 5;
    public static final int STATE_CONTINUE_DECISION = 6;
    public static final int STATE_ARCADE_OUTRO_SEQUENCE = 7;
    public static final int STATE_PAUSE = 8;
    public static final int STATE_HINT = 9;
    public static final int STATE_LESSON_HINT = 10;
    public static final int STATE_LESSON = 11;
    public static final int STATE_LESSON_COMMENT = 12;
    public static final int STATE_LESSON_OVER = 13;
    public static final int STATE_LESSON_DEMO = 14;
    public static final int STATE_ARCADE_GAME_OVER = 15;
    private static final int EAGLE_OFFSET_Y = 0;
    private static final int FIGHT_INTERFACE_X = 2;
    private static final int FIGHT_INTERFACE_Y = 6;
    private static final int FIGHT_INTERFACE_HEIGHT = 21;
    private static final int TIME_INTERFACE_Y = 5;
    private static final int TIME_INTERFACE_WIDTH = 50;
    private static final int TIME_INTERFACE_HEIGHT = 26;
    private static final int BOX_NAME_OFFSET = 3;
    private static final int NAME_X = 2;
    private static final int NAME_JEWEL_OFFSET = 2;
    private static final int JEWEL_X = 5;
    private static final int JEWEL_SPACE_X = 4;
    private static final int LIFE_X_OFFSET = 3;
    private static final int LIFE_Y_OFFSET = 2;
    private static final int LIFE_HEIGHT = 5;
    private static final int FAME_HEIGHT = 3;
    private static final int SPECIAL_BAR_HEIGHT = 6;
    public static final int SPECIAL_BOX_HEIGHT = 16;
    private static final int SPECIAL_BAR_OFFSET_X = 5;
    private static final int SPECIAL_BAR_OFFSET_Y = 2;
    private static final int FAME_Y_OFFSET = 2;
    private static final int FAME_THIRD_X_OFFSET = 2;
    private static final int SCROLL_ARROW_OFFSET = 6;
    private static final int SELECTION_WING_OFFSET = -2;
    private static final int MARGIN = 6;
    private static final int TEXT_OFFSET = 1;
    private static final int NUMBERS_OFFSET = 2;
    public static Image clouds;
    public static Image[] arenaBackground;
    private static final int INTRO_TIME = 100;
    private static final int OUTRO_TIME = 100;
    private static final int CONTINUE_COST_EASY = 150;
    private static final int CONTINUE_COST_NORMAL = 150;
    private static final int CONTINUE_COST_HARD = 200;
    public static final int INGAME_PAUSE_MENU = 0;
    public static final int INGAME_PAUSE_MENU_LESSON_SELECT = 1;
    public static final int PAUSE_RESUME = 0;
    public static final int PAUSE_SOUND = 1;
    public static final int PAUSE_VIBRATION = 2;
    public static final int PAUSE_CONTROLS = 3;
    public static int PAUSE_QUIT;
    public static int PAUSE_SKIP_LESSON;
    public static int PAUSE_RESTART_LESSON;
    public static int PAUSE_SELECT_LESSON;
    public static Image[] arenaImage;
    public static Image ground;
    public static Image noend;
    public static Image shadow;
    public static Image footerBorder;
    public static Sprite corner_box;
    public static Sprite blood;
    public static Sprite sparkle;
    public static Sprite numbers;
    public static Image special_bar;
    public static Image special_mark;
    public static Image special_adjust;
    public static Image special_overlay;
    public static Image menu_eagle;
    public static Image jewel;
    public static Image defeat;
    public static Image[] damage_up;
    public static Image[] awards;
    public static Image proximo;
    public static Image[] hands;
    public static Sprite border_arrow;
    public static Image tut_dpad;
    public static Sprite tut_arrow_hold;
    public static Sprite tut_arrow_press;
    public static Image tut_button_hold;
    public static Image tut_button_press;
    public static Image tut_hash;
    public static Image tut_hash_press;
    public static Image tut_hash_hold;
    public static Image tut_star;
    public static Image tut_star_press;
    public static Image tut_star_hold;
    public static Image tut_press;
    public static Image tut_hold;
    public static Image tut_num1;
    public static Image tut_num2;
    public static Image tut_num3;
    private static final int TEXT_SPEED = 2;
    private static int NBR_OF_LINES;
    private int top_line_index;
    private String[] lines;
    public String[] output;
    private String outro_text;
    private int outro_step;
    private boolean text_fully_displayed;
    private boolean new_record;
    private int reputation;
    private static final int TUTORIAL_NUMBER_OF_LINES = 3;
    private static final int TUTORIAL_NUMBER_OF_LESSONS = 9;
    private static final int TUTORIAL_LESSON_TIME = 1000;
    private long aiDemoLastShow;
    public int lesson_step;
    public int demo_step;
    public int tutorial_time;
    public String[] tutorial_text;
    public int tutorial_text_line;
    public int text_display_time;
    public long[][] tutorial_bit_masks = new long[][]{{0x3C0000L, 0L}, {8L, 65536L}, {256L, 0L}, {2048L, 0L}, {0x1000000L, 0L}, {0x40000000L, 0L}, {4096L, 0L}, {0L, 0x4000000L}, {2L, 0L}};
    public boolean tutorial1backmove;
    public boolean tutorial1forwardmove;
    public boolean tutorial1behindmove;
    public boolean tutorial2normalattack;
    public boolean tutorial3combo;
    public boolean tutorial4heavyattack;
    public boolean tutorial5fierce;
    public boolean tutorial6special;
    public boolean tutorial7blockedattack;
    public boolean tutorial8stun;
    public boolean tutorial9cheer;
    public static final int TUT_BUTTON_HOLD = 0;
    public static final int TUT_BUTTON_PRESS = 1;
    public static final int TUT_BUTTON_HOLD_BLINK = 2;
    public static final int TUT_BUTTON_PRESS_BLINK = 3;
    public static final int TUT_BUTTON_UP = 0;
    public static final int TUT_BUTTON_LEFT = 1;
    public static final int TUT_BUTTON_DOWN = 2;
    public static final int TUT_BUTTON_RIGHT = 3;
    public static final int TUT_BUTTON_FIRE = 4;
    public static final int TUT_BUTTON_STAR = 5;
    private static final int[][] tutorial_button_highlights;
    private static long tut_display_time;
    public static int TICK;
    public int lastArenaState = -1;
    private Fighter[] players = new Fighter[2];
    private FighterAI ai;
    public long arenaTick;
    public boolean isSpecialBarVisible;
    public boolean isSpecStopped;
    public int specPercent;
    public int specTimeout;
    public long specDrawStartTime;
    public long specStopTime;
    private static final int SPECIAL_SPEED = 1000;
    public static final int SPECIAL_SHOW_DELAY = 30;
    private static final int FAME_DECRASE_SIZE = 1;
    private static final int CONTINUE_TIME = 300;
    private int intro_time;
    private int outro_time;
    public int round;
    private int margin_left = 30;
    private int needed_wins;
    public int displayed_fame;
    private int continue_time;
    private int required_fame;
    private int roundTime;
    public SimpleMenu ingame_menu;
    public boolean showMsg;
    public ChoiceWindow choiceWindow = new ChoiceWindow();
    public boolean showBox;
    public ScrollTextBox box = new ScrollTextBox("");
    private int selection_mark_offset;
    private int selection_mark_direction;
    private int camerax;
    private int backgroundCamerax;
    public int status;
    private boolean display_quote = false;
    private String[] quote_text;
    private String quote_character;
    private long gameOverStartTime;
    private static final long GAME_OVER_TIME = 150L;
    private static final int MASK_SIZE = 32;
    private int[] mask = new int[1024];
    private int fadeAlpha;
    private int cloudPosX = 0;
    private static final int ARENA_BOTTOM_Y = 212;
    private static final int CLOUDPOS_Y = 0;
    private static final int FIGHTER_POS_Y = 246;
    private static final int ARENA_BACKGROUND_Y = 120;
    private static final int CAMERA_SPEED = 3;
    private static final int CLOUDSPEED = 30;
    private static final int MAX_BACKGROUND_CAMERA_OFFSET = 20;

    public Arena() {
        for (int i = 0; i < this.mask.length; ++i) {
            this.mask[i] = 0;
        }
    }

    public void initTextBox(ScrollTextBox box, String title, String text) {
        box.setText(text);
        box.setTitle(title);
        box.fadeIn();
        box.resetScrollBar();
        this.showBox = true;
    }

    public void tick() {
        if (this.status != 8) {
            this.players[0].tick();
            this.players[1].tick();
            ++this.arenaTick;
        }
        if (this.showMsg) {
            this.choiceWindow.tick();
        }
        switch (this.status) {
            case 15: {
                if (this.gameOverStartTime + 150L < this.arenaTick) {
                    this.handleExit();
                    break;
                }
                this.fadeAlpha += 4;
                if (this.fadeAlpha > 255) {
                    this.fadeAlpha = 255;
                }
                for (int i = 0; i < this.mask.length; ++i) {
                    this.mask[i] = this.fadeAlpha << 24;
                }
                break;
            }
            case 12: {
                ++this.text_display_time;
                break;
            }
            case 8: {
                this.box.tick();
                if (this.showMsg || this.showBox) break;
                if (this.selection_mark_direction == 0) {
                    ++this.selection_mark_offset;
                    if (this.selection_mark_offset <= 3) break;
                    this.selection_mark_direction = 1;
                    break;
                }
                --this.selection_mark_offset;
                if (this.selection_mark_offset >= 1) break;
                this.selection_mark_direction = 0;
                break;
            }
            case 7: {
                ++this.outro_time;
                break;
            }
            case 6: {
                if (this.displayed_fame <= 0 && DataStore.g_total_fame <= 0) break;
                if (this.displayed_fame > 1 && DataStore.g_total_fame > 1) {
                    --this.displayed_fame;
                    --DataStore.g_total_fame;
                    break;
                }
                if (this.displayed_fame > DataStore.g_total_fame) {
                    this.displayed_fame -= DataStore.g_total_fame;
                    DataStore.g_total_fame = 0;
                    break;
                }
                DataStore.g_total_fame -= this.displayed_fame;
                this.displayed_fame = 0;
                break;
            }
            case 5: {
                if (--this.continue_time > 0) break;
                DataStore.deleteLastGame(0);
                this.setState(15);
                break;
            }
            case 3: {
                if (this.players[0].fame > 0) {
                    if (this.players[0].fame > 1) {
                        --this.players[0].fame;
                        ++this.displayed_fame;
                    } else {
                        this.displayed_fame += this.players[0].fame;
                        this.players[0].fame = 0;
                    }
                }
                DataStore.g_total_fame = this.displayed_fame;
                break;
            }
            case 2: {
                if (--this.outro_time > 0) break;
                switch (DataStore.g_game_mode) {
                    case 2: {
                        if (this.players[0].roundWons >= this.needed_wins || this.players[1].roundWons >= this.needed_wins) {
                            Gladiator2D.getInstance().handleEvent(1, null);
                            this.handleExit();
                            break;
                        }
                        this.restartFight();
                        ++this.round;
                        break;
                    }
                    case 0: {
                        if (this.players[0].currentAnim == 16) {
                            this.displayed_fame = DataStore.g_total_fame;
                            this.status = 3;
                            break;
                        }
                        if (this.players[1].roundWons == 2) {
                            this.setState(5);
                            break;
                        }
                        ++this.round;
                        this.restartFight();
                        break;
                    }
                    case 1: {
                        do {
                            if (++DataStore.g_current_fight != DataStore.survival_opponents.length) continue;
                            if (DataStore.difficulty == 1) {
                                DataStore.difficulty = 2;
                            } else if (DataStore.difficulty == 2) {
                                // empty if block
                            }
                            DataStore.g_current_fight = 0;
                        } while (DataStore.playerChar == (DataStore.opponentChar = DataStore.survival_opponents[DataStore.g_current_fight]));
                        if (this.players[0].currentAnim == 13) {
                            this.setState(4);
                            break;
                        }
                        ++this.round;
                        int health_bonus = this.players[0].fame / 3;
                        if (health_bonus > (DataStore.survival_hp - this.players[0].health) / 2) {
                            health_bonus = (DataStore.survival_hp - this.players[0].health) / 2;
                        }
                        DataStore.survival_hp = this.players[0].health + health_bonus;
                        this.displayed_fame = DataStore.g_total_fame;
                        this.status = 3;
                    }
                }
                break;
            }
            case 1: {
                if (--this.intro_time > 0) break;
                this.status = 0;
                if (DataStore.g_game_mode != 4) break;
                if (this.round == 1) {
                    this.lesson_step = -1;
                }
                this.initLessonComment();
                break;
            }
            case 14: {
                if (this.aiDemoLastShow + 30L < this.arenaTick) {
                    this.aiDemoLastShow = this.arenaTick;
                    if (this.getOpponent().currentAnim == 9 && this.getOpponent().animDelays[9][this.getOpponent().currentFrame] == 999) {
                        this.getOpponent().advanceFrame();
                    } else {
                        this.demo_step = this.ai.updateTutorialShowMove(this.round, this.demo_step);
                    }
                }
                if (this.demo_step != -1) break;
                this.setState(12);
                break;
            }
            case 9: {
                ++this.tutorial_time;
                return;
            }
            case 10: {
                ++this.tutorial_time;
                break;
            }
            case 11: {
                ++this.tutorial_time;
                if (this.showMsg) {
                    --this.tutorial_time;
                    return;
                }
                if (this.players[1].health <= 20) {
                    this.showMsg = true;
                    GladFont.setFont(0);
                    this.choiceWindow.set(Gladiator2D.TEXT.getText(155), false);
                    return;
                }
                boolean isCompletedTutorial = false;
                switch (this.round) {
                    case 1: {
                        if (!this.tutorial1forwardmove || !this.tutorial1backmove || !this.tutorial1behindmove) break;
                        isCompletedTutorial = true;
                        break;
                    }
                    case 2: {
                        if (!this.tutorial2normalattack) break;
                        isCompletedTutorial = true;
                        break;
                    }
                    case 3: {
                        if (!this.tutorial3combo) break;
                        isCompletedTutorial = true;
                        break;
                    }
                    case 4: {
                        if (!this.tutorial4heavyattack) break;
                        isCompletedTutorial = true;
                        break;
                    }
                    case 5: {
                        if (!this.tutorial5fierce) break;
                        isCompletedTutorial = true;
                        break;
                    }
                    case 6: {
                        if (this.tutorial6special) {
                            isCompletedTutorial = true;
                        }
                        if (this.players[1].currentAnim != 7) break;
                        this.players[1].stopAnim();
                        break;
                    }
                    case 7: {
                        if (!this.tutorial7blockedattack) break;
                        isCompletedTutorial = true;
                        break;
                    }
                    case 8: {
                        if (!this.tutorial8stun) break;
                        isCompletedTutorial = true;
                        break;
                    }
                    case 9: {
                        if (!this.tutorial9cheer) break;
                        isCompletedTutorial = true;
                    }
                }
                if (isCompletedTutorial) {
                    this.setState(12);
                    return;
                }
                if (this.round == 7 && this.players[0].currentAnim == 7) {
                    this.players[1].startAnim(5);
                    this.tutorial7blockedattack = true;
                }
                if (!this.showMsg && this.tutorial_time >= 1000 && this.players[0].currentAnim == 0) {
                    this.status = 10;
                    this.showMsg = true;
                    GladFont.setFont(0);
                    this.choiceWindow.set(Gladiator2D.TEXT.getText(160 + this.round - 1), false);
                    this.tutorial_time = -66;
                }
            }
            case 0: {
                if (this.roundTime != -1 && --this.roundTime <= 0) {
                    if (this.players[0].health > this.players[1].health) {
                        ++this.players[0].roundWons;
                    } else if (this.players[1].health > this.players[0].health) {
                        ++this.players[1].roundWons;
                    }
                    this.setState(2);
                    return;
                }
                if (this.players[0].isPerformingSpecial && !this.isSpecialBarVisible && this.specDrawStartTime + (long)this.specTimeout < this.arenaTick) {
                    this.isSpecialBarVisible = true;
                }
                if (this.isSpecialBarVisible && !this.isSpecStopped) {
                    this.specPercent += 1000;
                    if (this.specPercent >= 15000) {
                        this.stopSpecBar();
                    }
                }
                if (this.isSpecialBarVisible && this.isSpecStopped && this.specStopTime + 30L < this.arenaTick) {
                    this.hideSpecBar();
                }
                if (this.status == 0 && !this.getPlayer().isPerformingSpecial) {
                    this.ai.update(0L, this.arenaTick);
                }
                this.cloudPosX -= 30;
                if (this.cloudPosX + 100 * clouds.getWidth() > 0) break;
                this.cloudPosX += 100 * clouds.getWidth();
            }
        }
    }

    public Fighter getPlayer() {
        return this.players[0];
    }

    public Fighter getOpponent() {
        return this.players[1];
    }

    public Fighter getFightersOpponent(Fighter player) {
        if (player == this.players[0]) {
            return this.players[1];
        }
        return this.players[0];
    }

    public void createFighters(int playerid, int opponentid) {
        this.ai = null;
        this.ai = new FighterAI(DataStore.difficulty, DataStore.g_current_fight);
        this.players[0] = new Fighter(this, playerid, true);
        this.players[1] = new Fighter(this, opponentid, false);
        this.ai.setFighters(this.players[1], this.players[0]);
        this.calculateCameraPosition(true);
        this.showBox = false;
        this.showMsg = false;
    }

    public void restartFight() {
        this.ai.restartAi();
        Gladiator2D.fightScreen.resetKeys();
        if (DataStore.g_game_mode != 4) {
            this.status = 1;
        }
        this.intro_time = 100;
        this.arenaTick = 0L;
        this.roundTime = DataStore.round_time[DataStore.g_timeLimit];
        this.isSpecialBarVisible = false;
        this.players[0].resetFighter(true);
        this.players[1].resetFighter(false);
        if (DataStore.g_game_mode == 4 && this.round == 1) {
            this.players[1].setPosition(4);
        }
        this.calculateCameraPosition(true);
    }

    public void initFight() {
        this.ai.restartAi();
        this.ai.setDifficulty(DataStore.difficulty, DataStore.g_current_fight);
        Gladiator2D.fightScreen.resetKeys();
        if (DataStore.g_game_mode != 4) {
            this.status = 1;
            this.roundTime = DataStore.round_time[DataStore.g_timeLimit];
        }
        this.intro_time = 100;
        this.arenaTick = 0L;
        this.isSpecialBarVisible = false;
        switch (DataStore.g_game_mode) {
            case 0: {
                this.needed_wins = 2;
                this.round = 1;
                break;
            }
            case 1: {
                this.needed_wins = 1;
                this.players[0].health = DataStore.survival_hp;
                break;
            }
            case 4: {
                if (this.round != 1) break;
                this.players[1].setPosition(4);
                break;
            }
            default: {
                this.needed_wins = 2;
                this.round = 1;
            }
        }
        if (DataStore.resume_last_game && DataStore.g_game_mode != 2 && DataStore.g_game_mode != 4) {
            DataStore.resume_last_game = false;
            this.loadSpecificFightData();
        }
        this.calculateCameraPosition(true);
    }

    public void initSurvivalMode() {
        this.round = 1;
        DataStore.survival_hp = 100;
        DataStore.difficulty = 0;
        DataStore.g_total_fame = 0;
        DataStore.g_current_fight = DataStore.playerChar == 0 ? 1 : 0;
        DataStore.opponentChar = DataStore.survival_opponents[DataStore.g_current_fight];
    }

    public void initArcadeMode() {
        this.round = 1;
        DataStore.g_total_fame = 0;
        DataStore.g_current_fight = 0;
        DataStore.opponentChar = DataStore.arcade_opponents[DataStore.playerChar][0];
    }

    public void initTutorial() {
        DataStore.g_game_mode = 4;
        this.resetTutorialPresses();
        this.lesson_step = -1;
        this.demo_step = 0;
        this.tutorial_time = 0;
        this.round = 1;
        this.aiDemoLastShow = 0L;
        this.text_display_time = 0;
        this.roundTime = -1;
        DataStore.playerChar = 0;
        DataStore.opponentChar = 4;
        this.setState(1);
    }

    public synchronized void handleArcadeFightOver() {
        if (this.players[0].currentAnim == 16) {
            if (this.players[0].roundWons == 2) {
                if (++DataStore.g_current_fight >= DataStore.arcade_opponents[DataStore.playerChar].length) {
                    this.setState(7);
                } else {
                    DataStore.opponentChar = DataStore.arcade_opponents[DataStore.playerChar][DataStore.g_current_fight];
                    this.round = 1;
                    Gladiator2D.mainMenu.noQuitConfirmMessage = false;
                    Gladiator2D.mainMenu.setState(3);
                    Gladiator2D.getInstance().handleEvent(1, null);
                }
            } else {
                ++this.round;
                this.restartFight();
            }
        } else if (this.players[1].roundWons >= 2) {
            DataStore.deleteLastGame(0);
            Gladiator2D.getInstance().handleEvent(1, null);
            Gladiator2D.mainMenu.goBackToMenu();
        } else {
            ++this.round;
            this.restartFight();
        }
    }

    public void handleExit() {
        Gladiator2D.mainMenu.menu.setCurrentMenu(0, 0);
        Gladiator2D.mainMenu.setState(0);
        Gladiator2D.getInstance().handleEvent(1, null);
    }

    public void handleContinuedArcade() {
        this.round = 1;
        this.players[0].roundWons = 0;
        this.players[1].roundWons = 0;
        this.restartFight();
    }

    public void handleArcadeSkipText() {
        if (this.outro_step == 0) {
            if (this.top_line_index + NBR_OF_LINES < this.lines.length) {
                if (!this.text_fully_displayed) {
                    this.outro_time += 32000;
                    return;
                }
                this.text_fully_displayed = false;
                this.top_line_index += NBR_OF_LINES;
                this.outro_time = 0;
            } else {
                if (!this.text_fully_displayed) {
                    this.outro_time += 32000;
                    return;
                }
                ++this.outro_step;
            }
        } else if (this.outro_step == 1) {
            ++this.outro_step;
        } else {
            this.handleExit();
        }
    }

    public void resetFight() {
        this.round = 1;
        this.players[1].roundWons = 0;
        this.players[0].roundWons = 0;
        this.initFight();
    }

    public void initSpecialBar() {
        this.getPlayer().isSpecialSuccess = false;
        if (this.getOpponent().currentAnim == 7) {
            this.getOpponent().startAnim(0);
        }
        this.isSpecialBarVisible = false;
        this.isSpecStopped = false;
        this.specPercent = 0;
        this.specDrawStartTime = this.arenaTick;
        this.specTimeout = Math.abs(Gladiator2D.rnd.nextInt() % 60);
    }

    public void stopSpecBar() {
        this.isSpecStopped = true;
        this.specStopTime = this.arenaTick;
        if (this.specPercent != 0 && this.specPercent <= 10000) {
            this.getPlayer().isSpecialSuccess = true;
            this.players[0].specialResult = this.specPercent >= 6600 ? 2 : (this.specPercent >= 3300 ? 0 : 1);
        } else {
            this.getPlayer().specialResult = -1;
            this.getPlayer().isSpecialSuccess = false;
            this.isSpecialBarVisible = true;
        }
        this.getPlayer().advanceFrame();
    }

    public void hideSpecBar() {
        this.isSpecialBarVisible = false;
    }

    public void setState(int state) {
        block1 : switch (state) {
            case 15: {
                this.fadeAlpha = 0;
                for (int i = 0; i < this.mask.length; ++i) {
                    this.mask[i] = this.fadeAlpha << 24;
                }
                this.display_quote = false;
                this.gameOverStartTime = this.arenaTick;
                int rnd = Math.abs(Gladiator2D.rnd.nextInt() % 6);
                this.quote_text = GladFont.getLineArray(Gladiator2D.TEXT.getText(198 + rnd), 216);
                switch (rnd) {
                    case 3: {
                        this.quote_character = "-" + Gladiator2D.TEXT.getText(207) + "-";
                        break block1;
                    }
                    case 5: {
                        this.quote_character = "-" + Gladiator2D.TEXT.getText(209) + "-";
                        break block1;
                    }
                }
                this.quote_character = "-" + Gladiator2D.TEXT.getText(208) + "-";
                break;
            }
            case 4: {
                DataStore.deleteLastGame(1);
                if (this.round - 1 > DataStore.survival_records[DataStore.playerChar][0]) {
                    DataStore.survival_records[DataStore.playerChar][0] = this.round - 1;
                    DataStore.survival_records[DataStore.playerChar][1] = DataStore.g_total_fame;
                    DataStore.saveRecords();
                    break;
                }
                if (this.round - 1 != DataStore.survival_records[DataStore.playerChar][0] || DataStore.survival_records[DataStore.playerChar][1] >= DataStore.g_total_fame) break;
                DataStore.survival_records[DataStore.playerChar][1] = DataStore.g_total_fame;
                DataStore.saveRecords();
                break;
            }
            case 8: {
                if (this.status != 8) {
                    this.lastArenaState = this.status;
                    this.ingame_menu.getItemAt(1).setToggleIndex(DataStore.opt_soundVolume);
                    this.ingame_menu.getItemAt(2).setToggleIndex(DataStore.opt_vibration ? 0 : 1);
                    break;
                }
                this.status = this.lastArenaState;
                return;
            }
            case 7: {
                this.outro_step = 0;
                try {
                    boolean unlock;
                    int i;
                    DataStore.deleteLastGame(0);
                    boolean save = false;
                    if (DataStore.g_total_fame > DataStore.arcade_records[DataStore.playerChar][DataStore.difficulty * 2]) {
                        DataStore.arcade_records[DataStore.playerChar][DataStore.difficulty * 2] = DataStore.g_total_fame;
                        save = true;
                        this.new_record = true;
                    } else {
                        this.new_record = false;
                    }
                    if (DataStore.arcade_records[DataStore.playerChar][1] == 0) {
                        int last_unlocks = DataStore.unlocked_character;
                        if (DataStore.unlocked_character < DataStore.FIGHTER_NAMES.length - 3) {
                            ++DataStore.unlocked_character;
                        }
                        if (last_unlocks == DataStore.unlocked_character && DataStore.unlocked_character < 7) {
                            DataStore.unlock_hint = true;
                        }
                    }
                    if (DataStore.difficulty == 1 && DataStore.arcade_records[DataStore.playerChar][3] == 0) {
                        boolean unlock_maximus = true;
                        if (DataStore.unlocked_character < 7) {
                            for (i = 0; i < DataStore.FIGHTER_NAMES.length - 3; ++i) {
                                if (i == DataStore.playerChar) continue;
                                unlock_maximus = unlock_maximus && DataStore.arcade_records[i][3] != 0;
                            }
                            if (unlock_maximus) {
                                DataStore.unlocked_character = 7;
                            }
                        } else if (DataStore.unlocked_character == 7 && DataStore.playerChar == 7) {
                            ++DataStore.unlocked_character;
                        }
                    }
                    if (DataStore.g_total_fame >= 0) {
                        if (DataStore.g_total_fame < 500) {
                            if (DataStore.arcade_records[DataStore.playerChar][DataStore.difficulty * 2 + 1] < 1) {
                                DataStore.arcade_records[DataStore.playerChar][DataStore.difficulty * 2 + 1] = 1;
                                save = true;
                            }
                            this.reputation = 1;
                        } else if (DataStore.g_total_fame < 750) {
                            if (DataStore.arcade_records[DataStore.playerChar][DataStore.difficulty * 2 + 1] < 2) {
                                DataStore.arcade_records[DataStore.playerChar][DataStore.difficulty * 2 + 1] = 2;
                                save = true;
                            }
                            this.reputation = 2;
                        } else {
                            if (DataStore.arcade_records[DataStore.playerChar][DataStore.difficulty * 2 + 1] < 3) {
                                DataStore.arcade_records[DataStore.playerChar][DataStore.difficulty * 2 + 1] = 3;
                                save = true;
                            }
                            this.reputation = 3;
                        }
                    }
                    if (DataStore.unlocked_difficulty == 0) {
                        unlock = true;
                        for (i = 0; unlock && i < DataStore.FIGHTER_NAMES.length - 2; ++i) {
                            if (DataStore.arcade_records[i][1] != 0) continue;
                            unlock = false;
                        }
                        if (unlock) {
                            DataStore.unlock_hint = false;
                            DataStore.unlocked_difficulty = 1;
                            save = true;
                        }
                    } else if (DataStore.unlocked_difficulty < 2) {
                        unlock = true;
                        for (i = 0; unlock && i < DataStore.FIGHTER_NAMES.length; ++i) {
                            if (DataStore.arcade_records[i][3] != 0) continue;
                            unlock = false;
                        }
                        if (unlock) {
                            DataStore.unlocked_difficulty = 2;
                            save = true;
                        }
                    }
                    if (save) {
                        DataStore.saveRecords();
                    }
                    Gladiator2D.mainMenu.buildUpMenu();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                switch (DataStore.playerChar) {
                    case 7: {
                        this.outro_text = Gladiator2D.TEXT.getText(184).toUpperCase() + "\n\n" + Gladiator2D.TEXT.getText(74);
                        break;
                    }
                    case 8: {
                        this.outro_text = Gladiator2D.TEXT.getText(184).toUpperCase() + "\n\n" + Gladiator2D.TEXT.getText(75);
                        break;
                    }
                    case 6: {
                        this.outro_text = Gladiator2D.TEXT.getText(184).toUpperCase() + "\n\n" + Gladiator2D.TEXT.getText(76);
                        break;
                    }
                    case 0: {
                        this.outro_text = Gladiator2D.TEXT.getText(184).toUpperCase() + "\n\n" + Gladiator2D.TEXT.getText(80);
                        break;
                    }
                    case 1: {
                        this.outro_text = Gladiator2D.TEXT.getText(184).toUpperCase() + "\n\n" + Gladiator2D.TEXT.getText(77);
                        break;
                    }
                    case 2: {
                        this.outro_text = Gladiator2D.TEXT.getText(184).toUpperCase() + "\n\n" + Gladiator2D.TEXT.getText(78);
                        break;
                    }
                    case 3: {
                        this.outro_text = Gladiator2D.TEXT.getText(184).toUpperCase() + "\n\n" + Gladiator2D.TEXT.getText(79);
                        break;
                    }
                    case 4: {
                        this.outro_text = Gladiator2D.TEXT.getText(184).toUpperCase() + "\n\n" + Gladiator2D.TEXT.getText(81);
                        break;
                    }
                    case 5: {
                        this.outro_text = Gladiator2D.TEXT.getText(184).toUpperCase() + "\n\n" + Gladiator2D.TEXT.getText(82);
                    }
                }
                GladFont.setFont(0);
                this.lines = GladFont.getLineArray(this.outro_text, 216);
                NBR_OF_LINES = 4;
                this.outro_time = 0;
                this.top_line_index = 0;
                this.text_fully_displayed = false;
                break;
            }
            case 5: {
                this.continue_time = 300;
                break;
            }
            case 6: {
                switch (DataStore.difficulty) {
                    case 0: {
                        this.required_fame = 150;
                        break;
                    }
                    case 1: {
                        this.required_fame = 150;
                        break;
                    }
                    case 2: {
                        this.required_fame = 200;
                    }
                }
                this.displayed_fame = this.required_fame;
                break;
            }
            case 2: {
                this.outro_time = 100;
            }
        }
        this.status = state;
    }

    public void resetTutorialPresses() {
        this.tutorial1backmove = false;
        this.tutorial1forwardmove = false;
        this.tutorial1behindmove = false;
        this.tutorial2normalattack = false;
        this.tutorial3combo = false;
        this.tutorial4heavyattack = false;
        this.tutorial5fierce = false;
        this.tutorial6special = false;
        this.tutorial7blockedattack = false;
        this.tutorial8stun = false;
        this.tutorial9cheer = false;
    }

    public void nextTutorialLesson() {
        this.resetTutorialPresses();
        this.players[0].resetFighter(true);
        this.players[1].resetFighter(false);
        this.initFight();
        this.aiDemoLastShow = 0L;
        this.showMsg = false;
        this.lesson_step = 0;
        this.tutorial_time = 0;
        this.text_display_time = 0;
        tut_display_time = 0L;
        ++this.round;
        if (this.round == 1) {
            this.players[1].setPosition(4);
        } else {
            this.players[1].setPosition(5);
        }
        this.initMenu();
        this.setState(1);
        if (this.round == 10) {
            this.handleExit();
            return;
        }
    }

    public void restartTutorialLesson() {
        --this.round;
        this.nextTutorialLesson();
    }

    public void cleanUp() {
        int i;
        clouds = null;
        arenaBackground = null;
        if (arenaImage != null) {
            for (i = 0; i < arenaImage.length; ++i) {
                Arena.arenaImage[i] = null;
            }
            arenaImage = null;
        }
        if (this.players[0] != null) {
            this.players[0].cleanUp();
            this.players[0] = null;
        }
        if (this.players[1] != null) {
            this.players[1].cleanUp();
            this.players[1] = null;
        }
        corner_box = null;
        noend = null;
        ground = null;
        shadow = null;
        footerBorder = null;
        menu_eagle = null;
        jewel = null;
        defeat = null;
        numbers = null;
        damage_up = null;
        awards = null;
        this.ingame_menu = null;
        proximo = null;
        border_arrow = null;
        tut_dpad = null;
        tut_arrow_hold = null;
        tut_arrow_press = null;
        tut_button_hold = null;
        tut_button_press = null;
        tut_hash = null;
        tut_hash_press = null;
        tut_hash_hold = null;
        tut_star = null;
        tut_star_press = null;
        tut_star_hold = null;
        tut_press = null;
        tut_hold = null;
        tut_num1 = null;
        tut_num2 = null;
        tut_num3 = null;
        if (hands != null) {
            for (i = 0; i < hands.length; ++i) {
                Arena.hands[i] = null;
            }
            hands = null;
        }
        System.gc();
    }

    public int getOpponentsDistance() {
        return Math.abs(this.players[0].position - this.players[1].position);
    }

    private static void drawLife(Graphics g, int x1, int x2, int y, boolean old_hitpoints, boolean disable) {
        if (old_hitpoints) {
            g.setColor(12257030);
        } else if (disable) {
            g.setColor(2052613);
        } else {
            g.setColor(4035075);
        }
        g.drawLine(x1, y, x2, y);
        g.drawLine(x1, y + 5 - 1, x2, y + 5 - 1);
        if (old_hitpoints) {
            g.setColor(15272202);
        } else if (disable) {
            g.setColor(1660673);
        } else {
            g.setColor(3846661);
        }
        g.drawLine(x1, y + 1, x2, y + 1);
        g.drawLine(x1, y + 5 - 2, x2, y + 5 - 2);
        if (old_hitpoints) {
            g.setColor(16748033);
        } else if (disable) {
            g.setColor(2456834);
        } else {
            g.setColor(5308164);
        }
        for (int i = 0; i < 1; ++i) {
            g.drawLine(x1, y + 2 + i, x2, y + 2 + i);
        }
    }

    public static void drawHitPoints(Graphics g, int player_life, int opponent_life, boolean old_hitpoints) {
        int percent = Math.max(100 * player_life / 100, 0);
        int y = 12;
        int x1 = 9;
        int width = 82;
        int x2 = x1 + width * percent / 100;
        if (player_life > 0 && x2 <= x1) {
            x2 = x1 + 1;
        }
        if (old_hitpoints) {
            Arena.drawLife(g, x1, x1 + width, y, false, true);
        }
        if (x2 > x1 && player_life > 0) {
            Arena.drawLife(g, x1, x2, y, old_hitpoints, false);
        }
        percent = Math.max(100 * opponent_life / 100, 0);
        x1 = 231;
        x2 = x1 - width * percent / 100 - 1;
        if (opponent_life > 0 && x2 >= x1) {
            x2 = x1 - 1;
        }
        if (old_hitpoints) {
            Arena.drawLife(g, x1, x1 - width - 1, y, false, true);
        }
        if (x2 < x1 && opponent_life > 0) {
            Arena.drawLife(g, x1, x2, y, old_hitpoints, false);
        }
    }

    public void drawFightInterface(Graphics g) {
        Arena.drawFightBox(g, 2, 6, 236, 21, 4653313, false, false);
        Arena.drawFightBox(g, 95, 5, 50, 26, 921102, true, true);
        g.drawImage(this.players[0].charName, 2, 30, 0);
        g.drawImage(this.players[1].charName, 238 - this.players[1].charName.getWidth(), 30, 0);
    }

    public static void drawFightBox(Graphics g, int x, int y, int width, int height, int color, boolean draw_corners, boolean draw_eagle) {
        g.setColor(color);
        g.fillRect(x, y, width, height);
        g.setColor(0);
        g.drawLine(x, y, x + width, y);
        g.drawLine(x + width, y, x + width, y + height);
        g.drawLine(x, y + height, x + width, y + height);
        g.drawLine(x, y, x, y + height);
        g.setColor(3483672);
        g.drawLine(x + 1, y + 1, x + width - 1, y + 1);
        g.drawLine(x + width - 1, y + 1, x + width - 1, y + height - 1);
        g.drawLine(x + 1, y + height - 1, x + width - 1, y + height - 1);
        g.drawLine(x + 1, y + 1, x + 1, y + height - 1);
        g.setColor(10249786);
        g.drawLine(x + 2, y + 2, x + width - 2, y + 2);
        g.drawLine(x + width - 2, y + 2, x + width - 2, y + height - 2);
        g.drawLine(x + 2, y + height - 2, x + width - 2, y + height - 2);
        g.drawLine(x + 2, y + 2, x + 2, y + height - 2);
        g.setColor(0);
        g.drawLine(x + 3, y + 3, x + width - 3, y + 3);
        g.drawLine(x + width - 3, y + 3, x + width - 3, y + height - 3);
        g.drawLine(x + 3, y + height - 3, x + width - 3, y + height - 3);
        g.drawLine(x + 3, y + 3, x + 3, y + height - 3);
        if (draw_corners) {
            corner_box.setTransform(6);
            corner_box.setPosition(x - 1, y - 1);
            corner_box.paint(g);
            corner_box.setTransform(0);
            corner_box.setPosition(x + width + 2 - corner_box.getWidth(), y - 1);
            corner_box.paint(g);
            corner_box.setTransform(5);
            corner_box.setPosition(x + width + 2 - corner_box.getWidth(), y + height + 2 - corner_box.getHeight());
            corner_box.paint(g);
            corner_box.setTransform(3);
            corner_box.setPosition(x - 1, y + height + 2 - corner_box.getHeight());
            corner_box.paint(g);
        }
        if (draw_eagle) {
            g.drawImage(menu_eagle, x + width / 2 - menu_eagle.getWidth() / 2, y + height - 4 - 0, 0);
        }
    }

    public static void drawTime(Graphics g, int round_time) {
        if (DataStore.g_timeLimit != DataStore.TIME_OFF && (DataStore.g_game_mode == 1 || DataStore.g_game_mode == 0 || DataStore.g_game_mode == 2)) {
            numbers.setFrame(Math.max(0, round_time / 10));
            numbers.setPosition(120 - numbers.getWidth(), 18 - numbers.getHeight() / 2 - 1);
            numbers.paint(g);
            numbers.setFrame(Math.max(0, round_time % 10));
            numbers.setPosition(120, 18 - numbers.getHeight() / 2 - 1);
            numbers.paint(g);
        } else {
            g.drawImage(noend, 120 - noend.getWidth() / 2, 18 - noend.getHeight() / 2 - 1, 0);
        }
    }

    private void calculateCameraPosition(boolean isInstant) {
        int[] playerpos = new int[2];
        for (int i = 0; i < playerpos.length; ++i) {
            playerpos[i] = this.players[i].animStartPosX;
            if (this.players[i].currentAnim != 2 && this.players[i].currentAnim != 1 && (this.players[i].currentAnim != 8 || this.players[i].fighterId == 5 || this.players[i].fighterId == 4) && this.players[i].currentAnim != 9 && this.players[i].currentAnim != 14) continue;
            if (!this.players[i].isFacingLeft) {
                if (this.players[i].currentAnim != 14 && this.players[i].animOffsetX[this.players[i].currentAnim][this.players[i].currentFrame] > 60) {
                    int n = i;
                    playerpos[n] = playerpos[n] + 60;
                    continue;
                }
                int n = i;
                playerpos[n] = playerpos[n] + this.players[i].animOffsetX[this.players[i].currentAnim][this.players[i].currentFrame];
                continue;
            }
            if (this.players[i].currentAnim != 14 && this.players[i].animOffsetX[this.players[i].currentAnim][this.players[i].currentFrame] > 60) {
                int n = i;
                playerpos[n] = playerpos[n] + -60;
                continue;
            }
            int n = i;
            playerpos[n] = playerpos[n] + -this.players[i].animOffsetX[this.players[i].currentAnim][this.players[i].currentFrame];
        }
        int gamePos = (playerpos[0] + playerpos[1]) / 2;
        int minPos = 90;
        int maxPos = 390;
        int gamePositionPercent = 100 * (gamePos -= minPos) / (maxPos -= minPos);
        int maxCamPos = arenaImage[0].getWidth() * arenaImage.length - 120;
        int minCamPos = 120;
        int camMoveWidth = maxCamPos - minCamPos;
        int currentCamPos = gamePositionPercent * camMoveWidth / 100;
        currentCamPos += minCamPos;
        if (isInstant) {
            this.camerax = currentCamPos;
        } else if (this.camerax < currentCamPos - 3) {
            this.camerax += 3;
        } else if (this.camerax > currentCamPos + 3) {
            this.camerax -= 3;
        }
        if (this.camerax < minCamPos) {
            this.camerax = minCamPos;
        } else if (this.camerax > maxCamPos) {
            this.camerax = maxCamPos;
        }
        int maxCamPosOffset = arenaImage.length * arenaImage[0].getWidth() / 2 - 90;
        int percent = 100 * Math.abs(arenaImage.length * arenaImage[0].getWidth() / 2 - this.camerax) / maxCamPosOffset;
        this.backgroundCamerax = 20 * percent / 100;
        if (this.camerax > arenaImage.length * arenaImage[0].getWidth() / 2) {
            this.backgroundCamerax *= -1;
        }
        this.backgroundCamerax += this.camerax;
    }

    private void drawSpecialLayer(Graphics g) {
        int x = 0;
        int y = 0;
        do {
            y = 0;
            do {
                g.drawImage(special_overlay, x, y, 20);
            } while ((y += special_overlay.getHeight()) < 280);
        } while ((x += special_overlay.getHeight()) < 240);
    }

    private static void drawSpecialMeter(Graphics g, int percent) {
        int y = 244;
        int x = 6;
        int w = special_bar.getWidth() + 12;
        int h = special_mark.getHeight();
        int offset_y = (special_mark.getHeight() - special_bar.getHeight()) / 2;
        int offset_x = (special_adjust.getWidth() - special_mark.getWidth()) / 2;
        Arena.drawFightBox(g, x, y, w, h, 4653313, true, false);
        g.drawImage(special_bar, x + 6, y + offset_y, 0);
        g.drawImage(special_mark, x + 6 + special_bar.getWidth() * 2 / 3, y, 0);
        if (percent >= 100) {
            g.drawImage(special_adjust, x + 6 - offset_x + Math.min(special_bar.getWidth(), percent * special_bar.getWidth() * 2 / 3 / 100 + 2), y, 0);
        } else {
            g.drawImage(special_adjust, x + 6 - offset_x + Math.min(special_bar.getWidth(), percent * special_bar.getWidth() * 2 / 3 / 100), y, 0);
        }
    }

    private static void drawWins(Graphics g, Fighter player, Fighter opponent) {
        int i;
        int medal_w = jewel.getWidth();
        for (i = 0; i < player.roundWons; ++i) {
            g.drawImage(jewel, 5 + i * (medal_w + 4), 30 + player.charName.getHeight() + 2, 0);
        }
        for (i = 0; i < opponent.roundWons; ++i) {
            g.drawImage(jewel, 235 - medal_w - i * (medal_w + 4), 30 + opponent.charName.getHeight() + 2, 0);
        }
    }

    public static void drawFame(Graphics g, Fighter player, Fighter opponent) {
        int j;
        int i;
        int third_width = 18;
        int x1 = 9;
        int y = 19;
        int percent = Math.min(player.fame, 100);
        for (i = 0; i < 3; ++i) {
            if (i > 0) {
                percent -= 33;
            }
            x1 = 9 + i * (third_width + 2);
            g.setColor(266017);
            g.drawLine(x1, y, x1 + 33 * third_width / 33 - 1, y);
            for (j = 0; j < 1; ++j) {
                g.setColor(1449798);
                g.drawLine(x1, y + 1 + j, x1 + 33 * third_width / 33 - 1, y + 1 + j);
            }
            g.setColor(266017);
            g.drawLine(x1, y + 3 - 1, x1 + 33 * third_width / 33 - 1, y + 3 - 1);
            if (Math.max(Math.min(33, percent), 0) * third_width / 33 <= 0) continue;
            g.setColor(player.highlight_fame ? 761586 : 807093);
            g.drawLine(x1, y, x1 + Math.max(Math.min(33, percent), 0) * third_width / 33 - 1, y);
            for (j = 0; j < 1; ++j) {
                g.setColor(player.highlight_fame ? 6285042 : 7318013);
                g.drawLine(x1, y + 1 + j, x1 + Math.max(Math.min(33, percent), 0) * third_width / 33 - 1, y + 1 + j);
            }
            g.setColor(player.highlight_fame ? 761586 : 807093);
            g.drawLine(x1, y + 3 - 1, x1 + Math.max(Math.min(33, percent), 0) * third_width / 33 - 1, y + 3 - 1);
        }
        x1 = 232;
        for (i = 0; i < 3; ++i) {
            g.setColor(0);
            g.fillRect(x1 - i * (third_width + 2) - third_width, y, third_width, 3);
        }
        percent = Math.min(opponent.fame, 100);
        for (i = 0; i < 3; ++i) {
            if (i > 0) {
                percent -= 33;
            }
            x1 = 231 - i * (third_width + 2);
            g.setColor(266017);
            g.drawLine(x1, y, x1 - 33 * third_width / 33 + 1, y);
            for (j = 0; j < 1; ++j) {
                g.setColor(1449798);
                g.drawLine(x1, y + 1 + j, x1 - 33 * third_width / 33 + 1, y + 1 + j);
            }
            g.setColor(266017);
            g.drawLine(x1, y + 3 - 1, x1 - 33 * third_width / 33 + 1, y + 3 - 1);
            if (Math.max(Math.min(33, percent), 0) * third_width / 33 <= 1) continue;
            g.setColor(opponent.highlight_fame ? 761586 : 807093);
            g.drawLine(x1, y, x1 - Math.max(Math.min(33, percent), 0) * third_width / 33 + 1, y);
            g.setColor(opponent.highlight_fame ? 6285042 : 7318013);
            for (j = 0; j < 1; ++j) {
                g.drawLine(x1, y + 1 + j, x1 - Math.max(Math.min(33, percent), 0) * third_width / 33 + 1, y + 1 + j);
            }
            g.setColor(opponent.highlight_fame ? 761586 : 807093);
            g.drawLine(x1, y + 3 - 1, x1 - Math.max(Math.min(33, percent), 0) * third_width / 33 + 1, y + 3 - 1);
        }
    }

    public static void drawNumbers(Graphics g, int number_in, int x, int y) {
        int number = number_in;
        int digits = 1;
        while (number / 10 != 0) {
            number /= 10;
            ++digits;
        }
        number = number_in;
        for (int i = 0; i < digits; ++i) {
            int fact = 1;
            for (int j = 0; j < digits - i - 1; ++j) {
                fact *= 10;
            }
            numbers.setFrame(number / fact);
            numbers.setPosition(x + i * numbers.getWidth(), y);
            numbers.paint(g);
            number %= fact;
        }
    }

    public void drawDamageUps(Graphics g, Fighter player, Fighter opponent) {
        int color = 0;
        int x = 5;
        int add_x = 0;
        if (player.fameMultiplierChanged() && player.fame >= 34) {
            if (player.fame >= 67) {
                color = 1;
            }
            if (player.getDamageUpTime() < player.getMaxDamageUpTime() / 8) {
                add_x = -2 * damage_up[color].getWidth() + 2 * damage_up[color].getWidth() * player.getDamageUpTime() / (player.getMaxDamageUpTime() / 8);
            } else if (player.getDamageUpTime() > player.getMaxDamageUpTime() * 7 / 8) {
                add_x = -2 * damage_up[color].getWidth() + 2 * damage_up[color].getWidth() * (player.getMaxDamageUpTime() - player.getDamageUpTime()) / (player.getMaxDamageUpTime() / 8);
            }
            g.drawImage(damage_up[color], x + add_x, 30 + this.players[0].charName.getHeight() + 4 + jewel.getHeight(), 0);
        }
        color = 0;
        x = 235 - damage_up[0].getWidth();
        if (opponent.fameMultiplierChanged() && opponent.fame >= 34) {
            if (opponent.fame >= 67) {
                color = 1;
            }
            if (opponent.getDamageUpTime() < opponent.getMaxDamageUpTime() / 4) {
                add_x = -2 * damage_up[color].getWidth() + 2 * damage_up[color].getWidth() * opponent.getDamageUpTime() / (opponent.getMaxDamageUpTime() / 4);
            } else if (opponent.getDamageUpTime() > opponent.getMaxDamageUpTime() * 3 / 4) {
                add_x = -2 * damage_up[color].getWidth() + 2 * damage_up[color].getWidth() * (opponent.getMaxDamageUpTime() - opponent.getDamageUpTime()) / (opponent.getMaxDamageUpTime() / 4);
            }
            g.drawImage(damage_up[color], x - add_x, 30 + this.players[0].charName.getHeight() + 4 + jewel.getHeight(), 0);
        }
    }

    public void drawBorderHint(Graphics g) {
        if (this.players[0].position == 1 || this.players[1].position == 1) {
            border_arrow.setTransform(3);
            border_arrow.setPosition(5, 150 - border_arrow.getHeight() / 2);
            border_arrow.paint(g);
        }
        if (this.players[0].position == 7 || this.players[1].position == 7) {
            border_arrow.setTransform(0);
            border_arrow.setPosition(235 - border_arrow.getWidth(), 150 - border_arrow.getHeight() / 2);
            border_arrow.paint(g);
        }
    }

    private void renderFight(Graphics g) {
        this.calculateCameraPosition(false);
        g.setClip(0, 0, 240, 300);
        int[] playerpos = new int[2];
        for (int i = 0; i < playerpos.length; ++i) {
            playerpos[i] = this.players[i].animStartPosX;
            if (this.players[i].currentAnim != 2 && this.players[i].currentAnim != 1 && (this.players[i].currentAnim != 8 || this.players[i].fighterId == 5 || this.players[i].fighterId == 4) && this.players[i].currentAnim != 9 && this.players[i].currentAnim != 14) continue;
            if (!this.players[i].isFacingLeft) {
                if (this.players[i].currentAnim != 14 && this.players[i].animOffsetX[this.players[i].currentAnim][this.players[i].currentFrame] > 60) {
                    int n = i;
                    playerpos[n] = playerpos[n] + 60;
                    continue;
                }
                int n = i;
                playerpos[n] = playerpos[n] + this.players[i].animOffsetX[this.players[i].currentAnim][this.players[i].currentFrame];
                continue;
            }
            if (this.players[i].currentAnim != 14 && this.players[i].animOffsetX[this.players[i].currentAnim][this.players[i].currentFrame] > 60) {
                int n = i;
                playerpos[n] = playerpos[n] + -60;
                continue;
            }
            int n = i;
            playerpos[n] = playerpos[n] + -this.players[i].animOffsetX[this.players[i].currentAnim][this.players[i].currentFrame];
        }
        int gameCenter = (playerpos[0] + playerpos[1]) / 2;
        int x = -gameCenter % ground.getWidth();
        do {
            int y = 212;
            do {
                g.drawImage(ground, x, y, 20);
            } while ((y += ground.getHeight()) < 280);
        } while ((x += ground.getWidth()) < 240);
        x = this.cloudPosX / 100;
        do {
            g.drawImage(clouds, x, 0, 20);
        } while ((x += clouds.getWidth()) < 240);
        int fromImage = (this.backgroundCamerax - 120) / arenaBackground[0].getWidth();
        x = arenaBackground[0].getWidth() * fromImage - (this.backgroundCamerax - 120);
        do {
            if (fromImage < arenaBackground.length) {
                g.drawImage(arenaBackground[fromImage], x, 120, 36);
            }
            ++fromImage;
        } while ((x += arenaBackground[0].getWidth()) < 240);
        fromImage = (this.camerax - 120) / arenaImage[0].getWidth();
        x = arenaImage[0].getWidth() * fromImage - (this.camerax - 120);
        do {
            if (fromImage < arenaImage.length) {
                g.drawImage(arenaImage[fromImage], x, 212, 36);
            }
            ++fromImage;
        } while ((x += arenaImage[0].getWidth()) < 240);
        playerpos = new int[2];
        int i = this.players.length - 1;
        while (i >= 0) {
            playerpos[i] = this.players[i].animStartPosX;
            if (this.players[i].currentAnim == 8 && this.players[i].fighterId == 4 && this.players[i].currentFrame > 0 && this.players[i].currentFrame < 7) {
                if (!this.players[i].isFacingLeft) {
                    int n = i;
                    playerpos[n] = playerpos[n] + 30;
                } else {
                    int n = i;
                    playerpos[n] = playerpos[n] + -30;
                }
            } else if (this.players[i].currentAnim == 2 || this.players[i].currentAnim == 1 || this.players[i].currentAnim == 4 || this.players[i].currentAnim == 6 && this.players[i].fighterId != 5 || this.players[i].currentAnim == 7 || this.players[i].currentAnim == 8 && this.players[i].fighterId != 5 || this.players[i].currentAnim == 9 || this.players[i].currentAnim == 14 || this.players[i].currentAnim == 13 && this.players[i].fighterId == 6) {
                if (!this.players[i].isFacingLeft) {
                    int n = i;
                    playerpos[n] = playerpos[n] + this.players[i].animOffsetX[this.players[i].currentAnim][this.players[i].currentFrame];
                } else {
                    int n = i;
                    playerpos[n] = playerpos[n] + -this.players[i].animOffsetX[this.players[i].currentAnim][this.players[i].currentFrame];
                }
            }
            int n = i;
            playerpos[n] = playerpos[n] - gameCenter;
            int n2 = i--;
            playerpos[n2] = playerpos[n2] + 120;
        }
        g.drawImage(shadow, playerpos[1], 246, 3);
        g.drawImage(shadow, playerpos[0], 246, 3);
        for (i = this.players.length - 1; i >= 0; --i) {
            if (!this.players[i].isFacingLeft) {
                playerpos[i] = this.players[i].animStartPosX + this.players[i].animOffsetX[this.players[i].currentAnim][this.players[i].currentFrame] - this.players[i].animations[this.players[i].currentAnim][this.players[i].currentFrame].getWidth() / 2;
            } else {
                try {
                    playerpos[i] = this.players[i].animStartPosX - this.players[i].animOffsetX[this.players[i].currentAnim][this.players[i].currentFrame] - this.players[i].animations[this.players[i].currentAnim][this.players[i].currentFrame].getWidth() / 2;
                }
                catch (Exception e) {
                    System.out.println(this.players[i].fighterId);
                }
            }
            int n = i;
            playerpos[n] = playerpos[n] - gameCenter;
            int n3 = i;
            playerpos[n3] = playerpos[n3] + 120;
            if (!this.players[i].isAmazonThrowActive) continue;
            int from = playerpos[i] + this.players[i].animations[this.players[i].currentAnim][this.players[i].currentFrame].getWidth() / 2;
            if (this.players[i].isFacingLeft) {
                Fighter cfr_ignored_0 = this.players[i];
                Fighter.knife.setTransform(0);
            } else {
                Fighter cfr_ignored_1 = this.players[i];
                Fighter.knife.setTransform(2);
            }
            Fighter cfr_ignored_2 = this.players[i];
            Fighter.knife.setPosition(from + this.players[i].amazonThrowPositionX, 180);
            Fighter cfr_ignored_3 = this.players[i];
            Fighter.knife.paint(g);
            if (Math.abs(this.players[i].amazonThrowPositionX) <= 120) continue;
            this.players[i].isAmazonThrowActive = false;
        }
        this.players[1].draw(g, playerpos[1], 246);
        this.players[0].draw(g, playerpos[0], 246);
        if (this.players[0].currentAnim == 9 || this.players[1].currentAnim == 9) {
            this.drawSpecialLayer(g);
            if (this.isSpecialBarVisible) {
                Arena.drawSpecialMeter(g, this.specPercent / 100);
                if (this.isSpecStopped) {
                    String str = Gladiator2D.TEXT.getText(100);
                    switch (this.players[0].specialResult) {
                        case 1: {
                            str = Gladiator2D.TEXT.getText(101);
                            break;
                        }
                        case 0: {
                            str = Gladiator2D.TEXT.getText(102);
                            break;
                        }
                        case 2: {
                            str = Gladiator2D.TEXT.getText(103);
                        }
                    }
                    GladFont.setFont(1);
                    GladFont.drawString(str, 6, 242 - GladFont.getRowHeight(), 0);
                }
            }
        }
        SharedGraphics.drawFooter(g, null, null, "Menu");
        x = 0;
        do {
            g.drawImage(footerBorder, x, 280, 36);
        } while ((x += footerBorder.getWidth()) < 240);
        if (this.status != 7 && this.status != 6 && this.status != 8) {
            this.drawFightInterface(g);
            Arena.drawHitPoints(g, this.players[0].oldhealth, this.players[1].oldhealth, true);
            Arena.drawHitPoints(g, this.players[0].health, this.players[1].health, false);
            Arena.drawFame(g, this.players[0], this.players[1]);
            Arena.drawTime(g, this.roundTime / 33);
            Arena.drawWins(g, this.players[0], this.players[1]);
            this.drawBorderHint(g);
        }
        if (this.status != 3 && (this.players[0].fame != 0 || this.players[1].fame != 0)) {
            this.drawDamageUps(g, this.players[0], this.players[1]);
        }
    }

    public void initMenu() {
        this.ingame_menu = new SimpleMenu();
        int menu_len = 5;
        if (DataStore.g_game_mode == 4) {
            menu_len = 8;
            if (this.round >= 9) {
                menu_len = 7;
            }
        }
        MenuItem[] rootMenu = new MenuItem[menu_len];
        rootMenu[0] = new MenuItem(Gladiator2D.TEXT.getText(20), null);
        String[] stringArray = new String[2];
        stringArray[0] = Gladiator2D.TEXT.getText(27);
        stringArray[1] = Gladiator2D.TEXT.getText(28);
        rootMenu[1] = new MenuItem(Gladiator2D.TEXT.getText(26), stringArray);
        String[] stringArray2 = new String[2];
        stringArray2[0] = Gladiator2D.TEXT.getText(28);
        stringArray2[1] = Gladiator2D.TEXT.getText(27);
        rootMenu[2] = new MenuItem(Gladiator2D.TEXT.getText(29), stringArray2);
        if (DataStore.opt_vibration) {
            rootMenu[2].setToggleIndex(0);
        } else {
            rootMenu[2].setToggleIndex(1);
        }
        rootMenu[1].setToggleIndex(DataStore.opt_soundVolume);
        rootMenu[3] = new MenuItem(Gladiator2D.TEXT.getText(22), null);
        if (DataStore.g_game_mode == 4) {
            PAUSE_RESTART_LESSON = 4;
            if (this.round < 9) {
                PAUSE_SKIP_LESSON = 5;
                PAUSE_SELECT_LESSON = 6;
            } else {
                PAUSE_SKIP_LESSON = -1;
                PAUSE_SELECT_LESSON = 5;
            }
            PAUSE_QUIT = PAUSE_SELECT_LESSON + 1;
            rootMenu[Arena.PAUSE_RESTART_LESSON] = new MenuItem(Gladiator2D.TEXT.getText(119), null);
            if (PAUSE_SKIP_LESSON != -1) {
                rootMenu[Arena.PAUSE_SKIP_LESSON] = new MenuItem(Gladiator2D.TEXT.getText(120), null);
            }
            rootMenu[Arena.PAUSE_SELECT_LESSON] = new MenuItem(Gladiator2D.TEXT.getText(121), null);
        } else {
            PAUSE_QUIT = 4;
        }
        rootMenu[Arena.PAUSE_QUIT] = new MenuItem(Gladiator2D.TEXT.getText(117), null);
        this.ingame_menu.addMenu(0, null, rootMenu);
        if (DataStore.g_game_mode == 4) {
            MenuItem[] lesson_menu = new MenuItem[9];
            for (int i = 0; i < lesson_menu.length; ++i) {
                lesson_menu[i] = new MenuItem(Gladiator2D.TEXT.getText(169 + i), null);
            }
            this.ingame_menu.addMenu(1, new int[]{PAUSE_SELECT_LESSON}, lesson_menu);
        }
    }

    private void drawPauseMenu(Graphics g) {
        if (!this.showMsg) {
            SharedGraphics.drawTransparentPattern(g);
        }
        GladFont.setFont(0);
        if (!this.ingame_menu.currentMenuIsEmpty()) {
            int menu_top = 150 - this.ingame_menu.getCurrentLength() * 13 / 2;
            MainMenu.drawBox(g, this.margin_left, menu_top - 12, 240 - 2 * this.margin_left, 300 - 2 * (menu_top - 12) - 4);
            for (int i = 0; i < this.ingame_menu.getCurrentLength(); ++i) {
                String t = this.ingame_menu.getItemAt(i).getText();
                if (i == this.ingame_menu.getCurrentItem()) {
                    SharedGraphics.drawSelectionWing(g, true, -this.selection_mark_offset + 120 - GladFont.getStringWidth(t) / 2, menu_top + this.ingame_menu.getCurrentItem() * 13);
                    GladFont.drawString(t, 120, menu_top + i * 13 - GladFont.getRowHeight() / 2, 4);
                    SharedGraphics.drawSelectionWing(g, false, this.selection_mark_offset + 120 + GladFont.getStringWidth(t) / 2, menu_top + this.ingame_menu.getCurrentItem() * 13);
                    continue;
                }
                GladFont.drawString(t, 120, menu_top + i * 13 - GladFont.getRowHeight() / 2, 4);
            }
        }
        if (this.ingame_menu.getCurrentMenu() == 0 && (this.ingame_menu.getCurrentItem() == 1 || this.ingame_menu.getCurrentItem() == 2)) {
            SharedGraphics.drawFooter(g, Gladiator2D.TEXT.getText(44), "drawArrows()", Gladiator2D.TEXT.getText(6));
        } else {
            SharedGraphics.drawFooter(g, Gladiator2D.TEXT.getText(5), "drawArrows()", Gladiator2D.TEXT.getText(6));
        }
        if (this.showMsg) {
            SharedGraphics.drawTransparentPattern(g);
            this.choiceWindow.draw(g);
            SharedGraphics.drawFooter(g, Gladiator2D.TEXT.getText(5), "drawArrows()", Gladiator2D.TEXT.getText(6));
        }
        if (this.showBox) {
            if (this.box != null) {
                this.box.draw(g);
            }
            SharedGraphics.drawFooter(g, null, "drawArrows()", Gladiator2D.TEXT.getText(6));
        }
    }

    public static int getNumberWidth(int number) {
        int digits = 1;
        while (number / 10 != 0) {
            number /= 10;
            ++digits;
        }
        return digits * numbers.getWidth();
    }

    private void initLessonComment() {
        GladFont.setFont(0);
        this.tutorial_text_line = 0;
        this.status = 12;
        int width = 240 - this.margin_left - proximo.getWidth() - 6;
        this.tutorial_text = this.lesson_step == -1 ? GladFont.getLineArray(Gladiator2D.TEXT.getText(125), width) : (this.lesson_step == 3 ? GladFont.getLineArray(Gladiator2D.TEXT.getText(153), width) : GladFont.getLineArray(Gladiator2D.TEXT.getText(126 + this.lesson_step + (this.round - 1) * 3), width));
    }

    public void lessonTextNext() {
        this.text_display_time = 0;
        if (this.tutorial_text_line + 3 < this.tutorial_text.length) {
            this.tutorial_text_line += 3;
        } else if (this.lesson_step == 2 && this.round < 9 || this.lesson_step == 3) {
            this.status = 13;
            this.choiceWindow.set(Gladiator2D.TEXT.getText(157), true);
            this.showMsg = true;
        } else if (this.lesson_step == -1) {
            ++this.lesson_step;
            this.initLessonComment();
        } else if (this.lesson_step == 0) {
            ++this.lesson_step;
            this.initLessonComment();
            this.demo_step = 0;
            this.aiDemoLastShow = this.arenaTick;
            this.status = 14;
        } else if (this.lesson_step == 1) {
            ++this.lesson_step;
            this.initLessonComment();
            this.status = 11;
        } else if (this.lesson_step == 2) {
            ++this.lesson_step;
            this.initLessonComment();
        }
    }

    private void drawLessonComment(Graphics g) {
        int i;
        GladFont.setFont(0);
        int menu_top = 256 - GladFont.getRowHeight() * 3;
        MainMenu.drawBox(g, this.margin_left, menu_top, 240 - 2 * this.margin_left, 12 + GladFont.getRowHeight() * 3);
        int len = Math.min(3, this.tutorial_text.length - this.tutorial_text_line);
        this.output = new String[len];
        for (int i2 = 0; i2 < this.output.length; ++i2) {
            this.output[i2] = this.tutorial_text[this.tutorial_text_line + i2];
        }
        int noOfChars = this.text_display_time / 2;
        int charStartIndex = 0;
        for (i = 0; i < this.output.length; ++i) {
            if (noOfChars < this.output[i].length() + charStartIndex) {
                this.output[i] = this.output[i].substring(0, noOfChars - charStartIndex);
            }
            charStartIndex += this.output[i].length();
        }
        for (i = 0; i < this.output.length; ++i) {
            GladFont.drawString(this.output[i], proximo.getWidth(), menu_top + 6 + i * GladFont.getRowHeight() - 1);
        }
        g.drawImage(proximo, 0, 280 - proximo.getHeight() - footerBorder.getHeight(), 0);
    }

    public int getLessonTitleY() {
        return 30 + this.players[0].charName.getHeight() + 12;
    }

    private void drawLessonTitle() {
        GladFont.setFont(1);
        if (GladFont.getStringWidth(Gladiator2D.TEXT.getText(169 + this.round - 1)) <= 240) {
            GladFont.drawString(Gladiator2D.TEXT.getText(169 + this.round - 1), 120 - GladFont.getStringWidth(Gladiator2D.TEXT.getText(169 + this.round - 1)) / 2, this.getLessonTitleY());
        } else {
            String[] out = GladFont.getLineArray(Gladiator2D.TEXT.getText(169 + this.round - 1), 240);
            for (int i = 0; i < out.length; ++i) {
                GladFont.drawString(out[i], 120 - GladFont.getStringWidth(out[i]) / 2, this.getLessonTitleY() - GladFont.getRowHeight() / 2 + i * GladFont.getRowHeight());
            }
            Object var1_1 = null;
        }
    }

    public static void drawTutorialDPad(Graphics g, int lesson_id) {
        int tick;
        if ((tick = (int)(++tut_display_time / (long)TICK)) > 11) {
            tut_display_time -= (long)(11 * TICK);
            tick = 0;
        }
        GladFont.setFont(0);
        int text_width = Math.max(GladFont.getStringWidth(Gladiator2D.TEXT.getText(158)), GladFont.getStringWidth(Gladiator2D.TEXT.getText(159)));
        int box_left = 6;
        int box_top = 256 - 2 * tut_press.getHeight();
        int text_y_offset = 6;
        int but_y_offset = 0;
        int offset_x = 0;
        boolean force = false;
        if (box_left + text_width > 120 - tut_dpad.getWidth() / 2 - 1 || force) {
            int i;
            text_width = 120 - tut_dpad.getWidth() / 2 - 1 - box_left;
            String[] temp = GladFont.getLineArray(Gladiator2D.TEXT.getText(159), text_width + 5);
            text_width = 0;
            for (i = 0; i < temp.length; ++i) {
                if (GladFont.getStringWidth(temp[i]) <= text_width) continue;
                text_width = GladFont.getStringWidth(temp[i]);
            }
            if (120 - tut_star.getWidth() - tut_star.getWidth() / 2 < text_width + tut_button_hold.getWidth() + 24) {
                offset_x = 10 + text_width + tut_button_hold.getWidth() + 18 - (120 - tut_star.getWidth() - tut_star.getWidth() / 2);
            }
            MainMenu.drawBox(g, box_left, box_top, text_width + tut_button_hold.getWidth() + 18, Math.max(tut_button_hold.getHeight() * 2, GladFont.getRowHeight() * 2) + 18 + GladFont.getRowHeight());
            GladFont.drawString(Gladiator2D.TEXT.getText(158), box_left + 12 + tut_press.getWidth(), box_top + text_y_offset);
            for (i = 0; i < temp.length; ++i) {
                if (temp[i].charAt(0) == ' ') {
                    temp[i] = temp[i].substring(1);
                }
                GladFont.drawString(temp[i], box_left + 12 + tut_press.getWidth(), box_top + text_y_offset * 2 + tut_press.getHeight() + i * GladFont.getRowHeight());
            }
            temp = null;
        } else {
            MainMenu.drawBox(g, box_left, box_top, text_width + tut_button_hold.getWidth() + 18, Math.max(tut_button_hold.getHeight() * 2, GladFont.getRowHeight() * 2) + 18);
            GladFont.drawString(Gladiator2D.TEXT.getText(158), box_left + 12 + tut_press.getWidth(), box_top + 6);
            GladFont.drawString(Gladiator2D.TEXT.getText(159), box_left + 12 + tut_press.getWidth(), box_top + 12 + tut_press.getHeight());
        }
        g.drawImage(tut_press, box_left + 6, box_top + 6 + but_y_offset, 0);
        g.drawImage(tut_hold, box_left + 6, box_top + 12 + tut_press.getHeight() + but_y_offset, 0);
        int dpad_top = 274 - tut_dpad.getHeight();
        int dpad_left = 120 - tut_dpad.getWidth() / 2;
        int dpad_center_y = dpad_top + tut_dpad.getHeight() / 2;
        g.drawImage(tut_dpad, offset_x + dpad_left, dpad_top, 0);
        g.drawImage(tut_star, offset_x + 120 - tut_star.getWidth() - tut_star.getWidth() / 2, 294 - tut_star.getHeight(), 0);
        g.drawImage(tut_hash, offset_x + 120 + tut_star.getWidth() / 2, 294 - tut_star.getHeight(), 0);
        block10: for (int i = 0; i < tutorial_button_highlights[lesson_id].length; i += 2) {
            switch (tutorial_button_highlights[lesson_id][i + 1]) {
                case 0: {
                    if (tutorial_button_highlights[lesson_id][i] == 0) {
                        tut_arrow_hold.setTransform(0);
                        tut_arrow_hold.setPosition(offset_x + 120 - tut_arrow_hold.getWidth() / 2, dpad_top);
                        tut_arrow_hold.paint(g);
                        continue block10;
                    }
                    if ((lesson_id != 0 || tick >= 2) && lesson_id == 0) continue block10;
                    tut_arrow_press.setTransform(0);
                    tut_arrow_press.setPosition(offset_x + 120 - tut_arrow_press.getWidth() / 2, dpad_top);
                    tut_arrow_press.paint(g);
                    continue block10;
                }
                case 2: {
                    if (tutorial_button_highlights[lesson_id][i] == 0) {
                        tut_arrow_hold.setTransform(1);
                        tut_arrow_hold.setPosition(offset_x + 120 - tut_arrow_hold.getWidth() / 2, dpad_top + tut_dpad.getHeight() - tut_arrow_hold.getHeight());
                        tut_arrow_hold.paint(g);
                        continue block10;
                    }
                    tut_arrow_press.setTransform(1);
                    tut_arrow_press.setPosition(offset_x + 120 - tut_arrow_press.getWidth() / 2, dpad_top + tut_dpad.getHeight() - tut_arrow_press.getHeight());
                    if (lesson_id == 0 && tick >= 3 && tick <= 4 || lesson_id == 5 && tick > 1 && tick < 4 || lesson_id == 7 && tick < 4 || lesson_id != 0 && lesson_id != 5 && lesson_id != 7) {
                        tut_arrow_press.paint(g);
                    }
                    if (lesson_id != 5) continue block10;
                    tut_arrow_press.setTransform(1);
                    g.drawImage(tut_num2, offset_x + 120 - tut_arrow_press.getWidth() / 2, dpad_top + tut_dpad.getHeight() - tut_arrow_press.getHeight(), 3);
                    continue block10;
                }
                case 1: {
                    if (tutorial_button_highlights[lesson_id][i] == 0) {
                        tut_arrow_hold.setTransform(4);
                        tut_arrow_hold.setPosition(offset_x + dpad_left, dpad_center_y - tut_arrow_hold.getHeight() / 2);
                        tut_arrow_hold.paint(g);
                        continue block10;
                    }
                    tut_arrow_press.setTransform(4);
                    tut_arrow_press.setPosition(offset_x + dpad_left, dpad_center_y - tut_arrow_press.getHeight() / 2);
                    if (lesson_id == 0 && tick >= 6 && tick <= 7 || lesson_id == 5 && tick > 3 && tick < 6 || lesson_id != 0 && lesson_id != 5) {
                        tut_arrow_press.paint(g);
                    }
                    if (lesson_id != 5) continue block10;
                    tut_arrow_press.setTransform(4);
                    g.drawImage(tut_num3, offset_x + dpad_left, dpad_center_y - tut_arrow_press.getHeight() / 2, 3);
                    continue block10;
                }
                case 3: {
                    if (tutorial_button_highlights[lesson_id][i] == 0) {
                        tut_arrow_hold.setTransform(5);
                        tut_arrow_hold.setPosition(offset_x + dpad_left + tut_dpad.getWidth() - tut_arrow_hold.getWidth(), dpad_center_y - tut_arrow_hold.getHeight() / 2);
                        tut_arrow_hold.paint(g);
                        continue block10;
                    }
                    if (lesson_id == 0 && tick >= 9 && tick <= 10 || lesson_id == 7 && tick > 6 && tick < 10 || lesson_id == 4 && tick > 3 && tick < 6 || lesson_id != 0 && lesson_id != 7 && lesson_id != 4) {
                        tut_arrow_press.setTransform(5);
                        tut_arrow_press.setPosition(offset_x + dpad_left + tut_dpad.getWidth() - tut_arrow_press.getWidth(), dpad_center_y - tut_arrow_press.getHeight() / 2);
                        tut_arrow_press.paint(g);
                    }
                    if (lesson_id != 4) continue block10;
                    tut_arrow_press.setTransform(5);
                    g.drawImage(tut_num2, offset_x + dpad_left + tut_dpad.getWidth() - tut_arrow_press.getWidth(), dpad_center_y - tut_arrow_press.getHeight() / 2, 3);
                    continue block10;
                }
                case 5: {
                    if (tutorial_button_highlights[lesson_id][i] == 0) {
                        g.drawImage(tut_star_hold, offset_x + 120 - tut_star.getWidth() - tut_star.getWidth() / 2, 294 - tut_star.getHeight(), 0);
                        continue block10;
                    }
                    if (lesson_id == 3 && tick <= 2 || lesson_id == 4 && tick <= 2 || lesson_id == 5 && tick < 2 || lesson_id != 3 && lesson_id != 4 && lesson_id != 5) {
                        g.drawImage(tut_star_press, offset_x + 120 - tut_star.getWidth() - tut_star.getWidth() / 2, 294 - tut_star.getHeight(), 0);
                    }
                    if (lesson_id != 3 && lesson_id != 4 && lesson_id != 5) continue block10;
                    g.drawImage(tut_num1, offset_x + 120 - tut_star.getWidth() - tut_star.getWidth() / 2, 294 - tut_star.getHeight(), 3);
                    continue block10;
                }
                case 4: {
                    if (tutorial_button_highlights[lesson_id][i] == 0) {
                        if (lesson_id == 3 && tick > 2 && tick < 8 || lesson_id != 3) {
                            g.drawImage(tut_button_hold, offset_x + 120 - tut_button_press.getWidth() / 2, dpad_center_y - tut_button_press.getHeight() / 2, 0);
                        }
                        if (lesson_id != 3) continue block10;
                        g.drawImage(tut_num2, offset_x + 120 - tut_button_press.getWidth() / 2, dpad_center_y - tut_button_press.getHeight() / 2, 3);
                        continue block10;
                    }
                    if ((lesson_id != 2 || tick != 1 && tick != 3 && tick != 5) && lesson_id == 2) continue block10;
                    g.drawImage(tut_button_press, offset_x + 120 - tut_button_press.getWidth() / 2, dpad_center_y - tut_button_press.getHeight() / 2, 0);
                }
            }
        }
    }

    private void drawMask(Graphics g) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 10; ++j) {
                g.drawRGB(this.mask, 0, 32, i * 32, j * 32, 32, 32, true);
            }
        }
    }

    public void draw(Graphics g) {
        this.renderFight(g);
        GladFont.setFont(1);
        switch (this.status) {
            case 15: {
                GladFont.setFont(0);
                int x = 24;
                this.drawMask(g);
                if (this.fadeAlpha < 250) break;
                if (this.quote_text.length == 1) {
                    GladFont.drawLines(this.quote_text, 120, 150 - GladFont.getRowHeight() / 2 * this.quote_text.length, 4);
                    GladFont.drawString(this.quote_character, 120 - GladFont.getStringWidth(this.quote_text[0]) / 2 + GladFont.getStringWidth(" "), 150 + GladFont.getRowHeight() / 2 * (this.quote_text.length + 1));
                    break;
                }
                GladFont.drawLines(this.quote_text, x, 150 - GladFont.getRowHeight() / 2 * this.quote_text.length);
                GladFont.drawString(" " + this.quote_character, x, 150 + GladFont.getRowHeight() / 2 * (this.quote_text.length + 1));
                break;
            }
            case 8: {
                this.drawPauseMenu(g);
                break;
            }
            case 14: {
                this.drawLessonTitle();
                break;
            }
            case 9: 
            case 10: {
                if (this.showMsg) {
                    SharedGraphics.drawTransparentPattern(g);
                    GladFont.setFont(0);
                    if (this.choiceWindow != null) {
                        this.choiceWindow.draw(g);
                    }
                }
                SharedGraphics.drawFooter(g, Gladiator2D.TEXT.getText(5), null, null);
                break;
            }
            case 12: {
                this.drawLessonComment(g);
                this.drawLessonTitle();
                SharedGraphics.drawFooter(g, Gladiator2D.TEXT.getText(5), null, Gladiator2D.TEXT.getText(118));
                break;
            }
            case 11: {
                if (!this.players[0].isPerformingSpecial && !this.players[0].isPerformingSpecial) {
                    Arena.drawTutorialDPad(g, this.round - 1);
                }
            }
            case 13: {
                this.drawLessonTitle();
            }
            case 0: {
                if (!this.showMsg) break;
                SharedGraphics.drawTransparentPattern(g);
                if (this.choiceWindow == null) break;
                this.choiceWindow.draw(g);
                break;
            }
            case 5: {
                Arena.drawFightBox(g, this.margin_left, 150 - 2 * GladFont.getRowHeight() / 2 - 6, 240 - 2 * this.margin_left, 2 * GladFont.getRowHeight() + 12, 4653313, true, true);
                GladFont.drawString(Gladiator2D.TEXT.getText(109), 120 - GladFont.getStringWidth(Gladiator2D.TEXT.getText(109)) / 2, 150 - GladFont.getRowHeight());
                GladFont.drawString("0" + this.continue_time / 33, 120 - GladFont.getStringWidth("0" + this.continue_time / 33) / 2, 150);
                SharedGraphics.drawFooter(g, Gladiator2D.TEXT.getText(39), null, Gladiator2D.TEXT.getText(40));
                break;
            }
            case 3: {
                GladFont.setFont(0);
                Arena.drawFightBox(g, this.margin_left, 150 - GladFont.getRowHeight() / 2 - 6, 240 - 2 * this.margin_left, GladFont.getRowHeight() + 12, 4653313, true, true);
                GladFont.drawString(Gladiator2D.TEXT.getText(104) + ": ", 120 - GladFont.getStringWidth(Gladiator2D.TEXT.getText(104) + ": ") / 2, 150 - GladFont.getRowHeight() / 2 - 1);
                Arena.drawNumbers(g, this.displayed_fame, 120 + GladFont.getStringWidth(Gladiator2D.TEXT.getText(104) + ": ") / 2, 150 - GladFont.getRowHeight() / 2 - 1 + 2);
                SharedGraphics.drawFooter(g, Gladiator2D.TEXT.getText(5), null, null);
                break;
            }
            case 6: {
                GladFont.setFont(0);
                Arena.drawFightBox(g, this.margin_left, 6, 240 - 2 * this.margin_left, 2 * GladFont.getRowHeight() + 12, 4653313, true, true);
                GladFont.drawString(Gladiator2D.TEXT.getText(104) + ": ", 120 - GladFont.getStringWidth(Gladiator2D.TEXT.getText(104) + ": ") / 2, 11);
                Arena.drawNumbers(g, DataStore.g_total_fame, 120 + GladFont.getStringWidth(Gladiator2D.TEXT.getText(104) + ": ") / 2, 14);
                GladFont.drawString(Gladiator2D.TEXT.getText(105) + ": ", 120 - GladFont.getStringWidth(Gladiator2D.TEXT.getText(105) + ": ") / 2, 12 + GladFont.getRowHeight() - 1);
                Arena.drawNumbers(g, this.displayed_fame, 120 + GladFont.getStringWidth(Gladiator2D.TEXT.getText(105) + ": ") / 2, 12 + GladFont.getRowHeight() + 2);
                if (DataStore.g_total_fame <= 0) {
                    g.drawImage(defeat, 120 - defeat.getWidth() / 2, 150 - defeat.getHeight() / 2 - 1 - 75, 0);
                    GladFont.setFont(1);
                    GladFont.drawString(Gladiator2D.TEXT.getText(106), 120 - GladFont.getStringWidth(Gladiator2D.TEXT.getText(106)) / 2, 150 - GladFont.getRowHeight() / 2 - 75);
                    g.drawImage(hands[1], 0, 250, 36);
                } else if (this.displayed_fame == 0) {
                    GladFont.setFont(1);
                    Arena.drawFightBox(g, this.margin_left, 150 - GladFont.getRowHeight() / 2 - 6 - 75, 240 - 2 * this.margin_left, GladFont.getRowHeight() + 12, 4653313, true, true);
                    GladFont.drawString(Gladiator2D.TEXT.getText(107), 120 - GladFont.getStringWidth(Gladiator2D.TEXT.getText(107)) / 2, 150 - GladFont.getRowHeight() / 2 - 75);
                    g.drawImage(hands[0], 0, 250, 36);
                } else {
                    g.drawImage(hands[2], 0, 250, 36);
                }
                SharedGraphics.drawFooter(g, Gladiator2D.TEXT.getText(5), null, null);
                break;
            }
            case 2: {
                String text = "";
                if (this.players[0].health == this.players[1].health) {
                    Arena.drawFightBox(g, this.margin_left, 150 - GladFont.getRowHeight() / 2 - 6, 240 - 2 * this.margin_left, GladFont.getRowHeight() + 12, 4653313, true, true);
                    text = Gladiator2D.TEXT.getText(114);
                } else if (this.players[0].roundWons >= this.needed_wins) {
                    Arena.drawFightBox(g, this.margin_left, 150 - GladFont.getRowHeight() / 2 - 6, 240 - 2 * this.margin_left, GladFont.getRowHeight() + 12, 4653313, true, true);
                    text = Gladiator2D.TEXT.getText(110);
                } else if (this.players[1].roundWons >= this.needed_wins) {
                    g.drawImage(defeat, 120 - defeat.getWidth() / 2, 150 - defeat.getHeight() / 2 - 1, 0);
                    text = Gladiator2D.TEXT.getText(111);
                } else if (this.players[0].currentAnim == 13 || this.players[1].currentAnim == 13) {
                    text = "";
                } else {
                    Arena.drawFightBox(g, this.margin_left, 150 - GladFont.getRowHeight() / 2 - 6, 240 - 2 * this.margin_left, GladFont.getRowHeight() + 12, 4653313, true, true);
                    text = Gladiator2D.TEXT.getText(115);
                }
                GladFont.drawString(text, 120 - GladFont.getStringWidth(text) / 2, 150 - GladFont.getRowHeight() / 2);
                break;
            }
            case 7: {
                GladFont.setFont(0);
                this.output = new String[this.lines.length];
                for (int i = 0; i < this.lines.length; ++i) {
                    this.output[i] = this.lines[i];
                }
                int noOfChars = this.outro_time / 2;
                int charStartIndex = 0;
                for (int i = this.top_line_index; i < this.output.length; ++i) {
                    if (noOfChars < this.output[i].length() + charStartIndex) {
                        this.output[i] = this.output[i].substring(0, noOfChars - charStartIndex);
                    }
                    charStartIndex += this.output[i].length();
                }
                if (this.outro_step == 0) {
                    Arena.drawFightBox(g, 6, 6, 228, GladFont.getRowHeight() * (NBR_OF_LINES + 1) + 6, 3081228, true, true);
                    int add = 0;
                    for (int i = this.top_line_index; i < this.output.length && i < this.top_line_index + NBR_OF_LINES; ++i) {
                        add = 0;
                        if (this.top_line_index + NBR_OF_LINES > this.output.length) {
                            add = 100 * (this.top_line_index + NBR_OF_LINES - this.output.length) / 2;
                        }
                        GladFont.drawString(this.output[i], 120 - GladFont.getStringWidth(this.lines[i]) / 2, 12 + GladFont.getRowHeight() * (i - this.top_line_index) + GladFont.getRowHeight() * add / 100);
                        if (this.text_fully_displayed || i != this.output.length - 1 && i != this.top_line_index + NBR_OF_LINES - 1 || !this.output[i].equals(this.lines[i])) continue;
                        this.text_fully_displayed = true;
                    }
                } else if (this.outro_step == 1) {
                    Arena.drawFightBox(g, 6, 6, 228, GladFont.getRowHeight() * (NBR_OF_LINES + 1) + 6, 3081228, true, true);
                    GladFont.drawString(Gladiator2D.TEXT.getText(185) + ": ", 120 - GladFont.getStringWidth(Gladiator2D.TEXT.getText(185) + ": ") / 2 - Arena.getNumberWidth(DataStore.g_total_fame) / 2, 12 + GladFont.getRowHeight());
                    Arena.drawNumbers(g, DataStore.g_total_fame, 120 + GladFont.getStringWidth(Gladiator2D.TEXT.getText(185) + ": ") / 2 + Arena.getNumberWidth(DataStore.g_total_fame) / 2 - Arena.getNumberWidth(DataStore.g_total_fame), 14 + GladFont.getRowHeight());
                    if (this.new_record && System.currentTimeMillis() / 500L % 2L == 0L) {
                        GladFont.drawString(Gladiator2D.TEXT.getText(186).toUpperCase(), 120 - GladFont.getStringWidth(Gladiator2D.TEXT.getText(186).toUpperCase()) / 2, 12 + 5 * GladFont.getRowHeight() / 2);
                    }
                } else {
                    Arena.drawFightBox(g, 6, 6, 228, GladFont.getRowHeight() * (NBR_OF_LINES + 1) + 6, 3081228, true, true);
                    String rep = Gladiator2D.TEXT.getText(92);
                    if (this.reputation == 2) {
                        rep = Gladiator2D.TEXT.getText(93);
                    } else if (this.reputation == 3) {
                        rep = Gladiator2D.TEXT.getText(94);
                    }
                    rep = rep.toUpperCase();
                    int str_len = Math.max(GladFont.getStringWidth(Gladiator2D.TEXT.getText(187) + ": ") / 2, GladFont.getStringWidth(rep) / 2);
                    int len_diff = 0;
                    if (GladFont.getStringWidth(Gladiator2D.TEXT.getText(187) + ": ") < GladFont.getStringWidth(rep)) {
                        len_diff = GladFont.getStringWidth(rep) - GladFont.getStringWidth(Gladiator2D.TEXT.getText(187) + ": ");
                        GladFont.drawString(Gladiator2D.TEXT.getText(187) + ": ", 120 - str_len - awards[0].getWidth() / 2 - 3 + len_diff / 2, 12 + GladFont.getRowHeight());
                        GladFont.drawString(rep, 120 - str_len - awards[0].getWidth() / 2, 12 + 2 * GladFont.getRowHeight() + 2);
                    } else {
                        len_diff = GladFont.getStringWidth(Gladiator2D.TEXT.getText(187) + ": ") - GladFont.getStringWidth(rep);
                        GladFont.drawString(Gladiator2D.TEXT.getText(187) + ": ", 120 - str_len - awards[0].getWidth() / 2 - 3, 12 + GladFont.getRowHeight());
                        GladFont.drawString(rep, 120 - str_len - awards[0].getWidth() / 2 + len_diff / 2, 12 + 2 * GladFont.getRowHeight() + 2);
                    }
                    g.drawImage(awards[this.reputation - 1], 120 + str_len + awards[0].getWidth() / 2 + 6 - awards[0].getWidth(), 12 + GladFont.getRowHeight(), 0);
                }
                this.output = null;
                SharedGraphics.drawFooter(g, Gladiator2D.TEXT.getText(5), null, null);
                break;
            }
            case 1: {
                if (this.intro_time > 66) {
                    Arena.drawFightBox(g, this.margin_left, 150 - GladFont.getRowHeight() / 2 - 6, 240 - 2 * this.margin_left, GladFont.getRowHeight() + 12, 4653313, true, true);
                    if (DataStore.g_game_mode == 1) {
                        GladFont.drawString(Gladiator2D.TEXT.getText(112) + " " + this.round, 120 - GladFont.getStringWidth(Gladiator2D.TEXT.getText(112) + " " + this.round) / 2, 150 - GladFont.getRowHeight() / 2);
                        break;
                    }
                    if (DataStore.g_game_mode == 4) {
                        GladFont.drawString(Gladiator2D.TEXT.getText(178) + " " + this.round, 120 - GladFont.getStringWidth(Gladiator2D.TEXT.getText(178) + " " + this.round) / 2, 150 - GladFont.getRowHeight() / 2);
                        break;
                    }
                    GladFont.drawString(Gladiator2D.TEXT.getText(116) + " " + this.round, 120 - GladFont.getStringWidth(Gladiator2D.TEXT.getText(116) + " " + this.round) / 2, 150 - GladFont.getRowHeight() / 2);
                    break;
                }
                if (this.intro_time > 50 || DataStore.g_game_mode == 4) break;
                Arena.drawFightBox(g, this.margin_left, 150 - GladFont.getRowHeight() / 2 - 6, 240 - 2 * this.margin_left, GladFont.getRowHeight() + 12, 4653313, true, true);
                GladFont.drawString(Gladiator2D.TEXT.getText(113), 120 - GladFont.getStringWidth(Gladiator2D.TEXT.getText(113)) / 2, 150 - GladFont.getRowHeight() / 2);
                break;
            }
            case 4: {
                Arena.drawFightBox(g, this.margin_left, 150 - 2 * GladFont.getRowHeight() / 2 - 6, 240 - 2 * this.margin_left, 2 * GladFont.getRowHeight() + 12, 4653313, true, true);
                GladFont.drawString(Gladiator2D.TEXT.getText(106), 120 - GladFont.getStringWidth(Gladiator2D.TEXT.getText(106)) / 2, 150 - GladFont.getRowHeight());
                GladFont.setFont(0);
                GladFont.drawString(Gladiator2D.TEXT.getText(108) + ": " + (this.round - 1), 120 - GladFont.getStringWidth(Gladiator2D.TEXT.getText(108) + ": " + (this.round - 1)) / 2, 150);
                SharedGraphics.drawFooter(g, Gladiator2D.TEXT.getText(5), null, null);
            }
        }
    }

    public void saveGame() {
        DataStore.resume_time = this.roundTime;
        DataStore.resume_round = this.round;
        DataStore.resume_char_health = this.players[0].health;
        DataStore.resume_opponent_health = this.players[1].health;
        DataStore.resume_char_fame = this.players[0].fame;
        DataStore.resume_opponent_fame = this.players[1].fame;
        DataStore.resume_char_wins = this.players[0].roundWons;
        DataStore.resume_opponent_wins = this.players[1].roundWons;
        DataStore.resume_game_mode = DataStore.g_game_mode;
        DataStore.resume_current_fight = DataStore.g_current_fight;
        DataStore.resume_char_id = DataStore.playerChar;
        DataStore.resume_opponent_id = DataStore.opponentChar;
        DataStore.resume_total_fame = DataStore.g_total_fame;
        DataStore.resume_difficulty = DataStore.difficulty;
        DataStore.saveLastGame(DataStore.g_game_mode);
    }

    private void loadSpecificFightData() {
        if (DataStore.resume_time != -1) {
            this.roundTime = DataStore.resume_time;
        }
        if (this.roundTime > DataStore.round_time[DataStore.g_timeLimit]) {
            this.roundTime = DataStore.round_time[DataStore.g_timeLimit];
        }
        if (DataStore.resume_round != -1) {
            this.round = DataStore.resume_round;
        }
        if (DataStore.resume_char_health != -1) {
            this.players[0].health = DataStore.resume_char_health;
        }
        if (DataStore.resume_opponent_health != -1) {
            this.players[1].health = DataStore.resume_opponent_health;
        }
        if (DataStore.resume_char_fame != -1) {
            this.players[0].setFame(DataStore.resume_char_fame, false);
        }
        if (DataStore.resume_opponent_fame != -1) {
            this.players[1].setFame(DataStore.resume_opponent_fame, false);
        }
        if (DataStore.resume_char_wins != -1) {
            this.players[0].roundWons = DataStore.resume_char_wins;
        }
        if (DataStore.resume_opponent_wins != -1) {
            this.players[1].roundWons = DataStore.resume_opponent_wins;
        }
    }

    static {
        PAUSE_QUIT = 4;
        PAUSE_SKIP_LESSON = -1;
        PAUSE_RESTART_LESSON = -1;
        PAUSE_SELECT_LESSON = -1;
        tutorial_button_highlights = new int[][]{{1, 1, 1, 3, 1, 2}, {1, 4}, {1, 4}, {0, 4, 1, 5}, {1, 5, 1, 3}, {1, 5, 1, 2, 1, 1}, {0, 1}, {1, 3, 1, 2}, {1, 0}};
        TICK = 6;
    }
}

