/*
 * Decompiled with CFR 0.152.
 */
import com.bsg.nokiacolor.BSCanvas;
import com.nokia.mid.sound.Sound;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GoldenWarrior5Canvas
extends BSCanvas {
    private byte[][] HSOffset = new byte[][]{{0, -2, 0, 0, 1, 0, 0}, {0, -1, 0, 0, -1, 0, 0}};
    private int StatusBarOffset;
    private int OptionsLocation;
    private Image backbuffer;
    private Graphics backsurface;
    private Image[] Player;
    private Image[][] MonsterGraphics;
    private Image[] tileset;
    private Image[] statictileset;
    private Image[] Numbers;
    private Image Options;
    private Image KeyGraphic;
    private Image endScreen;
    private Image heart;
    private int[][] ScanDoor = new int[][]{{-1, 0}, {1, 0}, {0, -1}, {0, 1}};
    private int[][] backimages;
    private int[][] frontimages;
    private byte[][][] map;
    private byte[][] movedirections;
    private byte[][] monsterdata;
    private int HalfWidth = this.getWidth() / 2;
    private int HalfHeight = this.getHeight() / 2;
    private int OffsetX;
    private int OffsetY;
    private boolean FirstMove;
    private EnvironmentThread GameThread;
    private Vector ActiveMonsters = new Vector();
    private int[] HealthColours = new int[]{0, 0xFF0000, 0xFF0000, 255, 65280, 65280};
    private int UserX = 9;
    private int UserY = 9;
    private int UserHealth;
    private String ScoreString;
    private int PrevUX;
    private int PrevUY;
    private int PrevS;
    private int KeyPressed = -1;
    private byte UserDirection = 0;
    private int UserScreen = 0;
    private boolean Ducking = false;
    private int Jumping = 0;
    private int Falling = 0;
    private int BeenHit = 0;
    private int Hitting = 0;
    private boolean DamagingHit = false;
    private boolean CarryingKey = false;
    private boolean Invulnerable;
    private int TimeBonus;
    private int Lives;
    private int UserFrame = 0;
    private int GameOver = 0;
    private int ScrollText;
    private boolean EndTextSetup = false;
    private int TextDisplayLength;
    private int TextSleepTimer;
    private Vector levelStatus;
    private Vector cv = new Vector(5);
    private Vector kpv = new Vector(5);
    private int mcl = 5;
    private Object[] Sounds = new Object[3];

    public GoldenWarrior5Canvas() {
        this.levelStatus = new Vector();
        try {
            this.Sounds[0] = new Sound(this.loadSound("/sound2.snd"), 1);
            this.Sounds[1] = new Sound(this.loadSound("/sounda.snd"), 1);
            this.Sounds[2] = new Sound(this.loadSound("/scream.snd"), 1);
            this.backbuffer = Image.createImage((int)90, (int)63);
            this.backsurface = this.backbuffer.getGraphics();
            this.OffsetX = (this.getWidth() - this.backbuffer.getWidth()) / 2;
            this.OffsetY = (this.getHeight() - this.backbuffer.getHeight()) / 2;
            this.tileset = new Image[18];
            this.Player = new Image[12];
            this.MonsterGraphics = new Image[1][8];
            this.statictileset = new Image[4];
            int n = 0;
            while (n < this.statictileset.length) {
                this.statictileset[n] = Image.createImage((String)("/e" + n + ".png"));
                ++n;
            }
            this.MonsterGraphics[0][0] = Image.createImage((String)"/m00.png");
            this.MonsterGraphics[0][1] = Image.createImage((String)"/m01.png");
            this.MonsterGraphics[0][2] = Image.createImage((String)"/m02.png");
            this.MonsterGraphics[0][3] = Image.createImage((String)"/m03.png");
            this.MonsterGraphics[0][4] = Image.createImage((String)"/m04.png");
            this.MonsterGraphics[0][5] = Image.createImage((String)"/m05.png");
            this.MonsterGraphics[0][6] = Image.createImage((String)"/m06.png");
            this.MonsterGraphics[0][7] = Image.createImage((String)"/m07.png");
            int n2 = 0;
            while (n2 < this.tileset.length) {
                this.tileset[n2] = Image.createImage((String)("/" + n2 + ".png"));
                ++n2;
            }
            int n3 = 0;
            while (n3 < 12) {
                this.Player[n3] = Image.createImage((String)("/c" + n3 + ".png"));
                ++n3;
            }
            this.endScreen = Image.createImage((String)"/castle.png");
            Image image = Image.createImage((String)"/StatusBar.png");
            this.Options = Image.createImage((int)32, (int)8);
            Graphics graphics = this.Options.getGraphics();
            graphics.drawImage(image, -30, 0, 0x10 | 4);
            this.Numbers = new Image[10];
            int n4 = 0;
            while (n4 < 10) {
                this.Numbers[n4] = Image.createImage((int)3, (int)8);
                graphics = this.Numbers[n4].getGraphics();
                graphics.drawImage(image, -(n4 * 3), 0, 0x10 | 4);
                ++n4;
            }
            this.KeyGraphic = Image.createImage((String)"/key-icon.png");
            this.heart = Image.createImage((String)"/heart.png");
        }
        catch (Exception exception) {
            System.out.println("error");
        }
        this.addCheatSequence(0, new int[]{49, 50, 57, 56, 48});
        this.addCheatSequence(1, new int[]{50, 56, 53, 53, 48});
        this.addCheatSequence(2, new int[]{52, 52, 54, 54, 53});
        this.addCheatSequence(3, new int[]{42, 52, 48, 57, 35});
        this.addCheatSequence(4, new int[]{48, 48, 50, 48, 56});
    }

    public byte[] loadSound(String string) {
        try {
            DataInputStream dataInputStream = new DataInputStream(((Object)((Object)this)).getClass().getResourceAsStream(string));
            byte[] byArray = new byte[dataInputStream.readShort()];
            int n = 0;
            while (n < byArray.length) {
                byArray[n] = dataInputStream.readByte();
                ++n;
            }
            dataInputStream.close();
            return byArray;
        }
        catch (Exception exception) {
            System.out.println("problem");
            return null;
        }
    }

    public void addCheatSequence(int n, int[] nArray) {
        this.cv.addElement(new int[][]{{n}, nArray});
    }

    protected int getCheat(int n) {
        int n2 = -1;
        this.kpv.addElement(new Integer(n));
        Object[] objectArray = new Integer[this.kpv.size()];
        this.kpv.copyInto(objectArray);
        int n3 = 0;
        while (n3 < this.cv.size()) {
            int[][] nArray = (int[][])this.cv.elementAt(n3);
            if (nArray[1].length <= objectArray.length) {
                n2 = nArray[0][0];
                int n4 = 0;
                while (n4 < nArray[1].length) {
                    if (nArray[1][n4] != (Integer)objectArray[n4]) {
                        n2 = -1;
                    }
                    ++n4;
                }
                if (n2 != -1) {
                    this.kpv.removeAllElements();
                    n3 = this.cv.size();
                }
            }
            ++n3;
        }
        if (this.kpv.size() >= this.mcl) {
            this.kpv.removeElementAt(0);
        }
        return n2;
    }

    private void loadLevel(Gauge gauge) {
        try {
            this.GameOver = 0;
            DataInputStream dataInputStream = new DataInputStream(((Object)((Object)this)).getClass().getResourceAsStream("/level"));
            int n = dataInputStream.readInt();
            this.map = new byte[n][7][10];
            this.backimages = new int[n][];
            this.frontimages = new int[n][];
            this.movedirections = new byte[n][4];
            this.monsterdata = new byte[n][];
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4;
                int n5;
                int n6 = dataInputStream.readInt();
                int n7 = 0;
                while (n7 < 4) {
                    this.movedirections[n2][n7] = dataInputStream.readByte();
                    ++n7;
                }
                int n8 = 0;
                while (n8 < 7) {
                    n5 = 0;
                    while (n5 < 10) {
                        this.map[n2][n8][n5] = dataInputStream.readByte();
                        if (this.map[n2][n8][n5] == 1) {
                            this.map[n2][n8][n5] = -1;
                        } else if (this.map[n2][n8][n5] == 3) {
                            this.map[n2][n8][n5] = -2;
                        } else if (this.map[n2][n8][n5] == 6) {
                            this.map[n2][n8][n5] = -3;
                        }
                        ++n5;
                    }
                    ++n8;
                }
                n5 = dataInputStream.readShort();
                this.backimages[n2] = new int[n5 * 3];
                int n9 = 0;
                while (n9 < n5) {
                    n4 = dataInputStream.readShort();
                    n3 = dataInputStream.readShort();
                    short s = dataInputStream.readShort();
                    this.backimages[n2][n9 * 3] = s;
                    this.backimages[n2][n9 * 3 + 1] = n4;
                    this.backimages[n2][n9 * 3 + 2] = n3;
                    ++n9;
                }
                n5 = dataInputStream.readShort();
                this.frontimages[n2] = new int[n5 * 3];
                n4 = 0;
                while (n4 < n5) {
                    this.frontimages[n2][n4 * 3 + 1] = dataInputStream.readShort();
                    this.frontimages[n2][n4 * 3 + 2] = dataInputStream.readShort();
                    this.frontimages[n2][n4 * 3] = dataInputStream.readShort();
                    ++n4;
                }
                n5 = dataInputStream.readShort();
                this.monsterdata[n2] = new byte[n5 * 3];
                n3 = 0;
                while (n3 < n5) {
                    this.monsterdata[n2][n3 * 3] = dataInputStream.readByte();
                    this.monsterdata[n2][n3 * 3 + 1] = dataInputStream.readByte();
                    this.monsterdata[n2][n3 * 3 + 2] = dataInputStream.readByte();
                    ++n3;
                }
                ++n2;
            }
            dataInputStream.close();
        }
        catch (Exception exception) {}
    }

    public void startGame(int n, Gauge gauge) {
        this.UserDirection = 0;
        this.Jumping = 0;
        this.Falling = 0;
        this.BeenHit = 0;
        this.Hitting = 0;
        this.UserFrame = 0;
        this.levelStatus.removeAllElements();
        this.Lives = 5;
        this.UserX = 18;
        this.UserY = 36;
        this.PrevUX = 72;
        this.PrevUY = 36;
        this.Invulnerable = false;
        this.ScrollText = -1;
        this.GameOver = 0;
        this.UserDirection = 1;
        this.UserFrame = 2;
        this.UserScreen = 0;
        this.score = 0;
        this.TimeBonus = 6000;
        this.loadLevel(gauge);
        this.UserHealth = 5;
        this.CarryingKey = false;
        this.DamagingHit = false;
        this.ScoreString = this.ExtendString("" + this.score, 4);
        this.DrawBackGround();
        this.SetupMonsters();
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
    }

    public void nextLevel(Gauge gauge) {
    }

    public byte[] saveGame(Gauge gauge) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(this.TimeBonus);
            dataOutputStream.writeByte(this.UserScreen);
            dataOutputStream.writeInt(this.UserX);
            dataOutputStream.writeInt(this.UserY);
            dataOutputStream.writeByte(this.UserHealth);
            dataOutputStream.writeByte(this.Lives);
            dataOutputStream.writeByte(this.Jumping);
            dataOutputStream.writeByte(this.Falling);
            dataOutputStream.writeByte(this.BeenHit);
            dataOutputStream.writeByte(this.Hitting);
            dataOutputStream.writeBoolean(this.CarryingKey);
            dataOutputStream.writeBoolean(this.DamagingHit);
            dataOutputStream.writeInt(this.score);
            dataOutputStream.writeByte(this.UserDirection);
            dataOutputStream.writeInt(this.PrevUX);
            dataOutputStream.writeInt(this.PrevUY);
            dataOutputStream.writeInt(this.PrevS);
            dataOutputStream.writeShort(this.levelStatus.size());
            int n = 0;
            while (n < this.levelStatus.size()) {
                ((OutputStream)dataOutputStream).write((byte[])this.levelStatus.elementAt(n));
                ++n;
            }
            dataOutputStream.writeShort(this.ActiveMonsters.size());
            int n2 = 0;
            while (n2 < this.ActiveMonsters.size()) {
                ((OutputStream)dataOutputStream).write((byte[])this.ActiveMonsters.elementAt(n2));
                ++n2;
            }
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void loadGame(byte[] byArray, Gauge gauge) {
        this.levelStatus.removeAllElements();
        this.ActiveMonsters.removeAllElements();
        this.Invulnerable = false;
        this.ScrollText = -1;
        this.loadLevel(gauge);
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            this.TimeBonus = dataInputStream.readInt();
            this.UserScreen = dataInputStream.readByte();
            this.UserX = dataInputStream.readInt();
            this.UserY = dataInputStream.readInt();
            this.UserHealth = dataInputStream.readByte();
            this.Lives = dataInputStream.readByte();
            this.Jumping = dataInputStream.readByte();
            this.Falling = dataInputStream.readByte();
            this.BeenHit = dataInputStream.readByte();
            this.Hitting = dataInputStream.readByte();
            this.CarryingKey = dataInputStream.readBoolean();
            this.DamagingHit = dataInputStream.readBoolean();
            this.score = dataInputStream.readInt();
            this.UserDirection = dataInputStream.readByte();
            this.PrevUX = dataInputStream.readInt();
            this.PrevUY = dataInputStream.readInt();
            this.PrevS = dataInputStream.readInt();
            this.ScoreString = this.ExtendString("" + this.score, 4);
            int n = dataInputStream.readShort();
            int n2 = 0;
            while (n2 < n) {
                byte[] byArray2 = new byte[3];
                dataInputStream.read(byArray2, 0, 3);
                this.levelStatus.addElement(byArray2);
                this.map[byArray2[0]][byArray2[1]][byArray2[2]] = 0;
                ++n2;
            }
            n = dataInputStream.readShort();
            int n3 = 0;
            while (n3 < n) {
                byte[] byArray3 = new byte[7];
                dataInputStream.read(byArray3, 0, 7);
                this.ActiveMonsters.addElement(byArray3);
                ++n3;
            }
            this.DrawBackGround();
            dataInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
    }

    protected void showNotify() {
        if (!this.EndTextSetup) {
            this.TextSleepTimer = 1000 / Integer.parseInt(this.langT[6]);
            Font font = this.getFont(this.langA[1]);
            this.TextDisplayLength = this.getWidth() / font.stringWidth(" ") * 3 / 2;
            int n = this.getWidth() / 2 / font.stringWidth(" ");
            int n2 = 0;
            while (n2 < n) {
                this.langT[1] = " " + this.langT[1] + " ";
                ++n2;
            }
            this.EndTextSetup = true;
            System.gc();
        }
        if (this.KEY_OPTIONS == -6) {
            this.StatusBarOffset = this.getWidth() - 61;
            this.OptionsLocation = 0;
        } else if (this.KEY_OPTIONS == -7) {
            this.StatusBarOffset = 0;
            this.OptionsLocation = this.getWidth() - 32;
        }
        this.FirstMove = false;
        if (this.GameThread == null || this.GameThread.DieNow) {
            this.GameThread = new EnvironmentThread();
        }
    }

    protected void hideNotify() {
        if (this.GameThread != null) {
            this.GameThread.DieNow = true;
        }
    }

    protected void keyPressed(int n) {
        if (this.GameOver == 1 | this.GameOver == 4) {
            return;
        }
        if (this.GameOver == 2) {
            if (this.ScrollText < 0) {
                this.UnifiedMethod(10, null);
            }
            return;
        }
        if (this.GameOver == 3) {
            this.UnifiedMethod(102, null);
            return;
        }
        if (n == this.KEY_OPTIONS) {
            this.commandListener.commandAction(BSCanvas.DISPLAY_MENU, (Displayable)this);
            return;
        }
        if (this.paused) {
            int n2 = this.getCheat(n);
            if (n2 == 0) {
                this.Lives = 9;
            } else if (n2 == 1) {
                this.UserHealth = 5;
            } else if (n2 == 3) {
                this.CarryingKey = true;
            } else if (n2 == 4) {
                this.UserX = 45;
                this.UserY = 9;
                this.PrevUX = 45;
                this.PrevUY = 9;
                this.UserScreen = 26;
                this.DrawBackGround();
                this.SetupMonsters();
            }
            this.UnifiedMethod(-1, null);
            return;
        }
        this.FirstMove = true;
        int n3 = this.getGameAction(n);
        if (this.BeenHit == 0 && this.Hitting == 0) {
            if (n3 == 2 || n == 52) {
                this.KeyPressed = 3;
            } else if (n3 == 1 || n == 50) {
                this.KeyPressed = 0;
            } else if (n3 == 5 || n == 54) {
                this.KeyPressed = 1;
            } else if (n3 == 6 || n == 56) {
                this.KeyPressed = 2;
            } else if (n3 == 8 || n == 53) {
                this.KeyPressed = 4;
            } else if (n == 48) {
                this.KeyPressed = 5;
            } else if (n == 49) {
                this.KeyPressed = 6;
            }
        }
    }

    protected void keyReleased(int n) {
        this.KeyPressed = -1;
    }

    public synchronized void UnifiedMethod(int n, Object object) {
        if (n == 10) {
            if (this.GameThread.DieNow) {
                this.GameThread = new EnvironmentThread();
            }
        } else {
            if (n == -1) {
                this.repaint();
                return;
            }
            if (n == 2) {
                if (this.Ducking && this.KeyPressed != 5) {
                    this.UserY -= 9;
                    this.Ducking = false;
                    this.UserFrame = 0;
                }
                if (this.KeyPressed == 6) {
                    if (this.CarryingKey) {
                        int n2;
                        int n3;
                        int n4 = this.UserX % 9;
                        int n5 = this.UserY % 9;
                        if (n4 == 0 && n5 == 0 && (this.TestGrid((n3 = this.UserX / 9) - 1, n2 = this.UserY / 9) == -2 || this.TestGrid(n3 + 1, n2) == -2)) {
                            Vector<int[]> vector = new Vector<int[]>();
                            int n6 = n3;
                            if (this.TestGrid(n3 - 1, n2) == -2) {
                                vector.addElement(new int[]{n3 - 1, n2});
                                --n6;
                            } else {
                                vector.addElement(new int[]{n3 + 1, n2});
                                ++n6;
                            }
                            this.TestForDoor(n6, n2, -1, -1, vector);
                            int n7 = 0;
                            while (n7 < vector.size()) {
                                int[] nArray = (int[])vector.elementAt(n7);
                                this.map[this.UserScreen][nArray[1]][nArray[0]] = 0;
                                this.levelStatus.addElement(new byte[]{(byte)this.UserScreen, (byte)nArray[1], (byte)nArray[0]});
                                ++n7;
                            }
                            this.vibrate(50, 500);
                            this.DrawBackGround();
                            this.CarryingKey = false;
                        }
                    }
                } else if (this.KeyPressed == 4) {
                    if (this.Hitting == 0) {
                        this.Hitting = 3;
                        this.DamagingHit = true;
                    }
                } else if (this.KeyPressed == 1) {
                    this.UserX += 3;
                    this.UserDirection = 1;
                    this.UserFrame = this.UserFrame == 2 ? 3 : 2;
                    if (this.TestTR(this.UserX, this.UserY) < 0 || this.TestBR(this.UserX, this.UserY) < 0 || this.TestMR(this.UserX, this.UserY) < 0) {
                        this.UserX -= 3;
                    }
                } else if (this.KeyPressed == 3) {
                    this.UserX -= 3;
                    this.UserDirection = 0;
                    this.UserFrame = this.UserFrame == 0 ? 1 : 0;
                    if (this.TestTL(this.UserX, this.UserY) < 0 || this.TestBL(this.UserX, this.UserY) < 0 || this.TestML(this.UserX, this.UserY) < 0) {
                        this.UserX += 3;
                    }
                } else if (this.KeyPressed == 0) {
                    if (this.TestTL(this.UserX, this.UserY) == 2 || this.TestTR(this.UserX, this.UserY) == 2 || this.TestBL(this.UserX, this.UserY) == 2 || this.TestBR(this.UserX, this.UserY) == 2) {
                        this.Falling = 0;
                        this.Jumping = 0;
                        this.UserY -= 3;
                        if (this.TestTL(this.UserX, this.UserY) < 0 || this.TestTR(this.UserX, this.UserY) < 0 || this.TestBL(this.UserX, this.UserY) < 0 || this.TestBR(this.UserX, this.UserY) < 0) {
                            this.UserY += 3;
                        }
                        this.UserFrame = this.UserFrame == 6 ? 7 : 6;
                        this.LockToGrid();
                        return;
                    }
                    if (this.Falling == 0 && this.Jumping == 0) {
                        this.KeyPressed = -1;
                        this.Jumping = 7;
                    }
                } else if (this.KeyPressed == 2 && (this.TestTL(this.UserX, this.UserY) == 2 || this.TestTR(this.UserX, this.UserY) == 2 || this.TestBL(this.UserX, this.UserY) == 2 || this.TestBR(this.UserX, this.UserY) == 2 || this.TestBBR(this.UserX, this.UserY) == 2 || this.TestBBL(this.UserX, this.UserY) == 2)) {
                    this.Falling = 0;
                    this.Jumping = 0;
                    this.UserY += 3;
                    if (this.TestTL(this.UserX, this.UserY) < 0 || this.TestTR(this.UserX, this.UserY) < 0 || this.TestBL(this.UserX, this.UserY) < 0 || this.TestBR(this.UserX, this.UserY) < 0) {
                        this.UserY -= 3;
                    }
                    this.UserFrame = this.UserFrame == 6 ? 7 : 6;
                    this.LockToGrid();
                }
            } else if (n == 3) {
                if (this.Hitting != 0) {
                    --this.Hitting;
                    if (this.Hitting == 0) {
                        this.UserFrame = this.UserDirection == 0 ? 0 : 2;
                    }
                }
                if (this.Jumping > 0) {
                    this.UserY -= this.Jumping;
                    int n8 = this.UserX % 9;
                    int n9 = this.UserY % 9;
                    if (n8 == 0) {
                        if (this.TestTL(this.UserX, this.UserY) < 0) {
                            this.UserY += 9 - n9;
                            this.Jumping = 0;
                            return;
                        }
                    } else if (this.TestTL(this.UserX, this.UserY) < 0 || this.TestTR(this.UserX, this.UserY) < 0) {
                        this.UserY += 9 - n9;
                        this.Jumping = 0;
                        return;
                    }
                    --this.Jumping;
                    if (this.KeyPressed == 0) {
                        this.KeyPressed = -1;
                    }
                } else if (this.Falling > 0) {
                    this.UserY += this.Falling;
                    int n10 = this.UserX % 9;
                    int n11 = this.UserY % 9;
                    if (n10 == 0) {
                        if (this.TestBL(this.UserX, this.UserY) < 0) {
                            this.Falling = 0;
                            this.UserY -= n11;
                            return;
                        }
                    } else if (this.TestBL(this.UserX, this.UserY) < 0 || this.TestBR(this.UserX, this.UserY) < 0) {
                        this.Falling = 0;
                        this.UserY -= n11;
                        return;
                    }
                    ++this.Falling;
                    if (this.Falling > 8) {
                        this.Falling = 8;
                    }
                } else if (this.BeenHit != 0) {
                    this.UserX += this.BeenHit;
                    int n12 = this.UserX % 9;
                    if (this.BeenHit < 0) {
                        if (this.TestTL(this.UserX, this.UserY) < 0 || this.TestBL(this.UserX, this.UserY) < 0 || this.TestML(this.UserX, this.UserY) < 0) {
                            this.UserX += 9 - n12;
                        }
                        ++this.BeenHit;
                    } else {
                        if (this.TestTR(this.UserX, this.UserY) < 0 || this.TestBR(this.UserX, this.UserY) < 0 || this.TestMR(this.UserX, this.UserY) < 0) {
                            this.UserX -= n12;
                        }
                        --this.BeenHit;
                    }
                } else {
                    int n13 = this.UserX % 9;
                    if (n13 == 0) {
                        if (this.TestBL(this.UserX, this.UserY) > -1 && this.TestTL(this.UserX, this.UserY) != 2 && this.TestBBL(this.UserX, this.UserY) > -1) {
                            this.Falling = 1;
                        }
                    } else if (this.TestBL(this.UserX, this.UserY) > -1 && this.TestBR(this.UserX, this.UserY) > -1 && this.TestTL(this.UserX, this.UserY) != 2 && this.TestTR(this.UserX, this.UserY) != 2 && this.TestBBL(this.UserX, this.UserY) > -1 && this.TestBBR(this.UserX, this.UserY) > -1) {
                        this.Falling = 1;
                    }
                }
            } else if (n == 4) {
                if (this.UserY > 60) {
                    this.UserY = 0;
                    this.UserScreen = this.movedirections[this.UserScreen][1];
                    this.DrawBackGround();
                    this.SetupMonsters();
                    this.PrevUX = this.UserX;
                    this.PrevUY = this.UserY;
                } else if (this.UserY < -12) {
                    this.UserY = 54;
                    this.UserScreen = this.movedirections[this.UserScreen][0];
                    this.DrawBackGround();
                    this.SetupMonsters();
                    this.PrevUX = this.UserX;
                    this.PrevUY = this.UserY;
                } else if (this.UserX < -7) {
                    this.UserX = 87;
                    this.modifyForBeingHit(0);
                    this.UserScreen = this.movedirections[this.UserScreen][2];
                    this.DrawBackGround();
                    this.SetupMonsters();
                    this.PrevUX = this.UserX;
                    this.PrevUY = this.UserY;
                } else if (this.UserX > 88) {
                    this.UserX = -6;
                    this.modifyForBeingHit(1);
                    this.UserScreen = this.movedirections[this.UserScreen][3];
                    this.DrawBackGround();
                    this.SetupMonsters();
                    this.PrevUX = this.UserX;
                    this.PrevUY = this.UserY;
                }
            } else if (n == 5) {
                int n14 = 0;
                while (n14 < this.ActiveMonsters.size()) {
                    byte[] byArray = (byte[])this.ActiveMonsters.elementAt(n14);
                    boolean bl = false;
                    if (byArray[5] <= 0) {
                        if (byArray[5] < -8) {
                            this.playSound(this.Sounds[2]);
                            this.ActiveMonsters.removeElementAt(n14);
                            --n14;
                        } else {
                            byArray[5] = (byte)(byArray[5] - 1);
                        }
                    } else {
                        bl = true;
                        if (byArray[0] == 0) {
                            if (byArray[3] == 0) {
                                byArray[1] = (byte)(byArray[1] - byArray[6]);
                                if (this.TestTL(byArray[1], byArray[2]) < 0 || this.TestBL(byArray[1], byArray[2]) < 0 || this.TestBBL(byArray[1], byArray[2]) == 0) {
                                    byArray[1] = (byte)(byArray[1] + byArray[6]);
                                    byArray[3] = 1;
                                }
                            } else {
                                byArray[1] = (byte)(byArray[1] + byArray[6]);
                                if (this.TestTR(byArray[1], byArray[2]) < 0 || this.TestBR(byArray[1], byArray[2]) < 0 || this.TestBBR(byArray[1], byArray[2]) == 0) {
                                    byArray[1] = (byte)(byArray[1] - byArray[6]);
                                    byArray[3] = 0;
                                }
                            }
                        }
                    }
                    if (bl) {
                        byArray[4] = byArray[4] == 0 ? (byte)1 : 0;
                    }
                    ++n14;
                }
            } else if (n == 6) {
                int n15 = 0;
                while (n15 < this.ActiveMonsters.size()) {
                    byte[] byArray = (byte[])this.ActiveMonsters.elementAt(n15);
                    if (this.Hitting != 0 && this.DamagingHit) {
                        int n16;
                        int n17;
                        if (this.UserDirection == 0) {
                            n17 = this.UserX - (byArray[1] + 9);
                            n16 = Math.abs(this.UserY - byArray[2]);
                            if (byArray[5] > 0) {
                                if (n17 < 5 && n16 < 12 && n17 > 0) {
                                    byArray[5] = (byte)(byArray[5] - 1);
                                    this.DamagingHit = false;
                                } else {
                                    this.TestMonster(byArray);
                                }
                            }
                        } else {
                            n17 = byArray[1] - this.UserX;
                            n16 = Math.abs(this.UserY - byArray[2]);
                            if (byArray[5] > 0) {
                                if (n17 < 14 && n16 < 12 && n17 > 0) {
                                    byArray[5] = (byte)(byArray[5] - 1);
                                    this.DamagingHit = false;
                                } else {
                                    this.TestMonster(byArray);
                                }
                            }
                        }
                    } else if (byArray[5] > 0) {
                        this.TestMonster(byArray);
                    }
                    ++n15;
                }
            } else if (n == 7) {
                int n18 = this.UserX % 9;
                if (n18 == 0) {
                    if (this.TestBBL(this.UserX, this.UserY) == -3) {
                        this.ReduceUserHealth();
                    } else if (this.TestBL(this.UserX, this.UserY) == 4) {
                        this.score += 10;
                        this.ScoreString = this.ExtendString("" + this.score, 4);
                        int n19 = this.UserX / 9;
                        int n20 = (this.UserY + 17) / 9;
                        this.map[this.UserScreen][n20][n19] = 0;
                        this.levelStatus.addElement(new byte[]{(byte)this.UserScreen, (byte)n20, (byte)n19});
                        this.playSound(this.Sounds[1]);
                        this.DrawBackGround();
                    } else if (this.TestBL(this.UserX, this.UserY) == 5) {
                        if (!this.CarryingKey) {
                            int n21 = this.UserX / 9;
                            int n22 = (this.UserY + 17) / 9;
                            this.map[this.UserScreen][n22][n21] = 0;
                            this.levelStatus.addElement(new byte[]{(byte)this.UserScreen, (byte)n22, (byte)n21});
                            this.playSound(this.Sounds[1]);
                            this.DrawBackGround();
                            this.CarryingKey = true;
                        }
                    } else if (this.TestTL(this.UserX, this.UserY) == 7) {
                        this.GameOver = 2;
                        this.score += this.TimeBonus;
                    }
                } else if (this.TestBBL(this.UserX, this.UserY) == -3 || this.TestBBR(this.UserX, this.UserY) == -3) {
                    this.ReduceUserHealth();
                } else if (this.TestBL(this.UserX, this.UserY) == 4) {
                    this.score += 10;
                    this.ScoreString = this.ExtendString("" + this.score, 4);
                    int n23 = this.UserX / 9;
                    int n24 = (this.UserY + 17) / 9;
                    this.map[this.UserScreen][n24][n23] = 0;
                    this.levelStatus.addElement(new byte[]{(byte)this.UserScreen, (byte)n24, (byte)n23});
                    this.playSound(this.Sounds[1]);
                    this.DrawBackGround();
                } else if (this.TestBR(this.UserX, this.UserY) == 4) {
                    this.score += 10;
                    this.ScoreString = this.ExtendString("" + this.score, 4);
                    int n25 = (this.UserX + 8) / 9;
                    int n26 = (this.UserY + 17) / 9;
                    this.map[this.UserScreen][n26][n25] = 0;
                    this.levelStatus.addElement(new byte[]{(byte)this.UserScreen, (byte)n26, (byte)n25});
                    this.playSound(this.Sounds[1]);
                    this.DrawBackGround();
                } else if (this.TestBL(this.UserX, this.UserY) == 5) {
                    if (!this.CarryingKey) {
                        int n27 = this.UserX / 9;
                        int n28 = (this.UserY + 17) / 9;
                        this.map[this.UserScreen][n28][n27] = 0;
                        this.levelStatus.addElement(new byte[]{(byte)this.UserScreen, (byte)n28, (byte)n27});
                        this.playSound(this.Sounds[1]);
                        this.DrawBackGround();
                        this.CarryingKey = true;
                    }
                } else if (this.TestBR(this.UserX, this.UserY) == 5) {
                    if (!this.CarryingKey) {
                        int n29 = (this.UserX + 8) / 9;
                        int n30 = (this.UserY + 17) / 9;
                        this.map[this.UserScreen][n30][n29] = 0;
                        this.levelStatus.addElement(new byte[]{(byte)this.UserScreen, (byte)n30, (byte)n29});
                        this.DrawBackGround();
                        this.CarryingKey = true;
                    }
                } else if (this.TestTL(this.UserX, this.UserY) == 7 || this.TestTR(this.UserX, this.UserY) == 7) {
                    this.GameOver = 2;
                    this.score += this.TimeBonus;
                }
            } else if (n == 101) {
                this.commandListener.commandAction(BSCanvas.GAME_ENDED, (Displayable)this);
            } else if (n == 102) {
                ++this.GameOver;
                this.GameThread.DieNow = true;
                this.GameThread = new EnvironmentThread();
            }
        }
    }

    private void modifyForBeingHit(int n) {
        if (this.BeenHit != 0) {
            this.UserX += this.HSOffset[n][Math.abs(this.BeenHit)];
        }
    }

    private void TestMonster(byte[] byArray) {
        int n = Math.abs(this.UserX - byArray[1]);
        int n2 = Math.abs(this.UserY - byArray[2]);
        if (n < 9 && n2 < 18) {
            this.BeenHit = this.UserX < byArray[1] ? -6 : 6;
            this.KeyPressed = -1;
            this.Jumping = 0;
            this.Falling = 0;
            byArray[5] = (byte)(byArray[5] - 1);
            this.ReduceUserHealth();
        }
    }

    private void TestForDoor(int n, int n2, int n3, int n4, Vector vector) {
        int n5;
        Vector<int[]> vector2 = new Vector<int[]>();
        int n6 = 0;
        while (n6 < 4) {
            n5 = n + this.ScanDoor[n6][0];
            int n7 = n2 + this.ScanDoor[n6][1];
            if ((n5 != n3 || n7 != n4) && this.TestGrid(n5, n7) == -2) {
                vector2.addElement(new int[]{n5, n7});
            }
            ++n6;
        }
        n5 = 0;
        while (n5 < vector2.size()) {
            int[] nArray = (int[])vector2.elementAt(n5);
            Vector<int[]> vector3 = new Vector<int[]>();
            vector3.addElement(nArray);
            this.TestForDoor(nArray[0], nArray[1], n, n2, vector3);
            int n8 = 0;
            while (n8 < vector3.size()) {
                vector.addElement(vector3.elementAt(n8));
                ++n8;
            }
            ++n5;
        }
    }

    private void ReduceUserHealth() {
        if (this.Invulnerable) {
            return;
        }
        --this.UserHealth;
        if (this.UserHealth == 0) {
            --this.Lives;
            if (this.Lives == 0) {
                this.vibrate(50, 500);
                this.GameThread.DieNow = true;
                this.GameOver = 1;
                this.GameThread = new EnvironmentThread();
            } else {
                this.UserX = this.PrevUX;
                this.UserY = this.PrevUY;
                this.UserHealth = 5;
                this.DamagingHit = false;
                this.BeenHit = 0;
                this.DrawBackGround();
                this.SetupMonsters();
                this.FirstMove = false;
                this.GameThread.DieNow = true;
                this.GameThread = new EnvironmentThread();
            }
        }
    }

    private void LockToGrid() {
        if (this.UserY % 3 != 0) {
            int n = this.UserY % 3;
            this.UserY -= n;
        }
    }

    private int TestGrid(int n, int n2) {
        if (n > -1 && n < 10 && n2 > -1 && n2 < 7) {
            return this.map[this.UserScreen][n2][n];
        }
        return 0;
    }

    private int TestBBL(int n, int n2) {
        int n3 = n / 9;
        int n4 = (n2 + 18) / 9;
        if (n3 > -1 && n3 < 10 && n4 > -1 && n4 < 7) {
            return this.map[this.UserScreen][n4][n3];
        }
        return 0;
    }

    private int TestBBR(int n, int n2) {
        int n3 = (n + 8) / 9;
        int n4 = (n2 + 18) / 9;
        if (n3 > -1 && n3 < 10 && n4 > -1 && n4 < 7) {
            return this.map[this.UserScreen][n4][n3];
        }
        return 0;
    }

    private int TestTL(int n, int n2) {
        int n3 = n / 9;
        int n4 = n2 / 9;
        if (n3 > -1 && n3 < 10 && n4 > -1 && n4 < 7) {
            return this.map[this.UserScreen][n4][n3];
        }
        return 0;
    }

    private int TestTR(int n, int n2) {
        int n3 = (n + 8) / 9;
        int n4 = n2 / 9;
        if (n3 > -1 && n3 < 10 && n4 > -1 && n4 < 7) {
            return this.map[this.UserScreen][n4][n3];
        }
        return 0;
    }

    private int TestBL(int n, int n2) {
        int n3 = n / 9;
        int n4 = (n2 + 17) / 9;
        if (n3 > -1 && n3 < 10 && n4 > -1 && n4 < 7) {
            return this.map[this.UserScreen][n4][n3];
        }
        return 0;
    }

    private int TestBR(int n, int n2) {
        int n3 = (n + 8) / 9;
        int n4 = (n2 + 17) / 9;
        if (n3 > -1 && n3 < 10 && n4 > -1 && n4 < 7) {
            return this.map[this.UserScreen][n4][n3];
        }
        return 0;
    }

    private int TestML(int n, int n2) {
        int n3 = n / 9;
        int n4 = (n2 + 8) / 9;
        if (n3 > -1 && n3 < 10 && n4 > -1 && n4 < 7) {
            return this.map[this.UserScreen][n4][n3];
        }
        return 0;
    }

    private int TestMR(int n, int n2) {
        int n3 = (n + 8) / 9;
        int n4 = (n2 + 8) / 9;
        if (n3 > -1 && n3 < 10 && n4 > -1 && n4 < 7) {
            return this.map[this.UserScreen][n4][n3];
        }
        return 0;
    }

    private void SetupMonsters() {
        this.ActiveMonsters.removeAllElements();
        byte[][] byArrayArray = new byte[][]{{0, 0, 1, 4}, {0, 1, 1, 4}, {0, 0, 1, 4}, {0, 1, 1, 4}, {0, 0, 1, 4}, {0, 1, 1, 4}, {0, 0, 1, 4}, {0, 1, 1, 4}, {0, 0, 1, 4}, {0, 1, 1, 4}};
        int n = 0;
        while (n < this.monsterdata[this.UserScreen].length / 3) {
            byte by = this.monsterdata[this.UserScreen][n * 3 + 2];
            this.ActiveMonsters.addElement(new byte[]{byArrayArray[by][0], this.monsterdata[this.UserScreen][n * 3 + 0], this.monsterdata[this.UserScreen][n * 3 + 1], byArrayArray[by][1], 0, byArrayArray[by][2], byArrayArray[by][3]});
            ++n;
        }
    }

    private void DrawBackGround() {
        this.backsurface.setColor(0xFFFFFF);
        this.backsurface.fillRect(0, 0, this.backbuffer.getWidth(), this.backbuffer.getHeight());
        int n = 0;
        while (n < this.backimages[this.UserScreen].length / 3) {
            this.backsurface.drawImage(this.tileset[this.backimages[this.UserScreen][n * 3]], this.backimages[this.UserScreen][n * 3 + 1], this.backimages[this.UserScreen][n * 3 + 2], 20);
            ++n;
        }
        int n2 = 0;
        while (n2 < 7) {
            int n3 = 0;
            while (n3 < 10) {
                if (this.map[this.UserScreen][n2][n3] > 2 && this.map[this.UserScreen][n2][n3] != 7) {
                    this.backsurface.drawImage(this.statictileset[this.map[this.UserScreen][n2][n3] - 3], n3 * 9, n2 * 9, 20);
                } else if (this.map[this.UserScreen][n2][n3] == -3) {
                    this.backsurface.drawImage(this.statictileset[3], n3 * 9, n2 * 9, 20);
                } else if (this.map[this.UserScreen][n2][n3] == -2) {
                    this.backsurface.drawImage(this.statictileset[0], n3 * 9, n2 * 9, 20);
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void paint(Graphics graphics) {
        int n;
        graphics.setColor(0);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.GameOver == 2 || this.GameOver == 3 || this.GameOver == 4) {
            graphics.setClip(0, 0, this.getWidth(), this.getHeight());
            graphics.drawImage(this.endScreen, this.HalfWidth, this.HalfHeight, 1 | 2);
            if (this.ScrollText >= 0 && this.GameOver == 2) {
                graphics.setFont(this.getFont(this.langA[1]));
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(0, 0, this.getWidth(), graphics.getFont().getHeight() + 1);
                graphics.setColor(0);
                int n2 = this.ScrollText + this.TextDisplayLength;
                if (n2 >= this.langT[1].length()) {
                    n2 = this.langT[1].length();
                }
                graphics.drawString(this.langT[1].substring(this.ScrollText, n2), 0, 1, 0x10 | 4);
            } else if (this.GameOver == 3) {
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(0, 0, this.getWidth(), graphics.getFont().getHeight() + 1);
                graphics.setColor(0);
                graphics.setFont(this.getFont(this.langA[3]));
                graphics.drawString(this.langT[3], 1, 1, 0x10 | 4);
            } else if (this.GameOver == 4) {
                graphics.setColor(0);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics.setColor(0xFFFFFF);
                graphics.setFont(this.getFont(this.langA[4]));
                graphics.drawString(this.langT[4], this.HalfWidth, 5, 0x10 | 1);
                graphics.drawString("" + this.TimeBonus, this.HalfWidth, 20, 0x10 | 1);
                graphics.setFont(this.getFont(this.langA[5]));
                graphics.drawString(this.langT[5], this.HalfWidth, 40, 0x10 | 1);
                graphics.drawString("" + this.score, this.HalfWidth, 55, 0x10 | 1);
            }
            return;
        }
        graphics.drawImage(this.backbuffer, this.OffsetX, this.OffsetY, 0x10 | 4);
        if (this.Hitting != 0) {
            n = 0;
            if (this.Hitting < 2) {
                n = 1;
            }
            if (this.UserDirection == 0) {
                graphics.drawImage(this.Player[8 + n], this.UserX + this.OffsetX - 5, this.UserY + this.OffsetY, 0x10 | 4);
            } else {
                graphics.drawImage(this.Player[10 + n], this.UserX + this.OffsetX, this.UserY + this.OffsetY, 0x10 | 4);
            }
        } else {
            graphics.drawImage(this.Player[this.UserFrame], this.UserX + this.OffsetX, this.UserY + this.OffsetY, 0x10 | 4);
        }
        n = 0;
        while (n < this.ActiveMonsters.size()) {
            byte[] byArray = (byte[])this.ActiveMonsters.elementAt(n);
            if (byArray[5] < 0) {
                graphics.drawImage(this.MonsterGraphics[0][-byArray[5] / 3 + 4], byArray[1] + this.OffsetX, byArray[2] + this.OffsetY, 0x10 | 4);
            } else {
                graphics.drawImage(this.MonsterGraphics[0][byArray[4] + byArray[3] * 2], byArray[1] + this.OffsetX, byArray[2] + this.OffsetY, 0x10 | 4);
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < this.frontimages[this.UserScreen].length / 3) {
            graphics.drawImage(this.tileset[this.frontimages[this.UserScreen][n3 * 3]], this.frontimages[this.UserScreen][n3 * 3 + 1] + this.OffsetX, this.frontimages[this.UserScreen][n3 * 3 + 2] + this.OffsetY, 0x10 | 4);
            ++n3;
        }
        graphics.setColor(0);
        graphics.fillRect(0, 57, 96, 8);
        int n4 = 0;
        while (n4 < this.ScoreString.length()) {
            graphics.drawImage(this.Numbers[this.ScoreString.charAt(n4) - 48], n4 * 5 + this.StatusBarOffset, 57, 0x10 | 4);
            ++n4;
        }
        graphics.setColor(this.HealthColours[this.UserHealth]);
        int n5 = 0;
        while (n5 < this.UserHealth) {
            graphics.fillRect(20 + n5 * 4 + this.StatusBarOffset, 58, 3, 6);
            ++n5;
        }
        graphics.drawImage(this.heart, 40 + this.StatusBarOffset, 57, 0x10 | 4);
        graphics.drawImage(this.Numbers[this.Lives], 48 + this.StatusBarOffset, 57, 0x10 | 4);
        graphics.drawImage(this.Options, this.OptionsLocation, 57, 0x10 | 4);
        if (this.CarryingKey) {
            graphics.drawImage(this.KeyGraphic, 53 + this.StatusBarOffset, 57, 0x10 | 4);
        }
        if (this.GameOver == 1) {
            graphics.setFont(this.getFont(this.langA[2]));
            this.drawText(graphics, this.langT[2], this.getWidth() / 2, this.getHeight() / 2);
        }
        if (this.paused) {
            graphics.setFont(this.getFont(this.langA[0]));
            this.drawText(graphics, this.langT[0], this.getWidth() / 2, this.getHeight() / 2);
        }
    }

    public void drawText(Graphics graphics, String string, int n, int n2) {
        Font font = graphics.getFont();
        int n3 = font.stringWidth(string);
        int n4 = font.getHeight();
        graphics.setColor(0xFFCC33);
        graphics.fillRect(n - n3 / 2 - 1, n2 - 2, n3 + 1, n4 + 1);
        graphics.setColor(0);
        graphics.drawString(string, n, n2, 0x10 | 1);
    }

    private String ExtendString(String string, int n) {
        while (string.length() < n) {
            string = "0" + string;
        }
        return string;
    }

    private class EnvironmentThread
    extends Thread {
        public boolean DieNow = false;

        public EnvironmentThread() {
            this.start();
        }

        public void run() {
            int n = 100;
            while (!GoldenWarrior5Canvas.this.FirstMove) {
            }
            if (GoldenWarrior5Canvas.this.GameOver == 1) {
                GoldenWarrior5Canvas.this.UnifiedMethod(-1, null);
                while (GoldenWarrior5Canvas.this.GameOver > 0) {
                    try {
                        Thread.sleep(6000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    GoldenWarrior5Canvas.this.GameOver--;
                }
                this.DieNow = true;
                GoldenWarrior5Canvas.this.UnifiedMethod(101, null);
                return;
            }
            if (GoldenWarrior5Canvas.this.GameOver == 2) {
                GoldenWarrior5Canvas.this.playSound(GoldenWarrior5Canvas.this.Sounds[0]);
                GoldenWarrior5Canvas.this.ScrollText = 0;
                while (GoldenWarrior5Canvas.this.ScrollText < GoldenWarrior5Canvas.this.langT[1].length()) {
                    try {
                        GoldenWarrior5Canvas.this.UnifiedMethod(-1, null);
                        Thread.sleep(GoldenWarrior5Canvas.this.TextSleepTimer);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    GoldenWarrior5Canvas.this.ScrollText++;
                }
                this.DieNow = true;
                GoldenWarrior5Canvas.this.GameOver++;
                GoldenWarrior5Canvas.this.UnifiedMethod(-1, null);
                return;
            }
            if (GoldenWarrior5Canvas.this.GameOver == 4) {
                try {
                    GoldenWarrior5Canvas.this.UnifiedMethod(-1, null);
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                GoldenWarrior5Canvas.this.UnifiedMethod(101, null);
                this.DieNow = true;
                return;
            }
            while (true) {
                if (GoldenWarrior5Canvas.this.paused) {
                    this.DieNow = true;
                }
                if (this.DieNow) {
                    return;
                }
                GoldenWarrior5Canvas.this.UnifiedMethod(2, null);
                GoldenWarrior5Canvas.this.UnifiedMethod(3, null);
                GoldenWarrior5Canvas.this.UnifiedMethod(4, null);
                GoldenWarrior5Canvas.this.UnifiedMethod(5, null);
                GoldenWarrior5Canvas.this.UnifiedMethod(6, null);
                GoldenWarrior5Canvas.this.UnifiedMethod(7, null);
                if (GoldenWarrior5Canvas.this.GameOver == 2) {
                    GoldenWarrior5Canvas.this.UnifiedMethod(-1, null);
                    this.DieNow = true;
                    try {
                        Thread.sleep(10000L);
                        GoldenWarrior5Canvas.this.UnifiedMethod(10, null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                if (GoldenWarrior5Canvas.this.TimeBonus > 0) {
                    GoldenWarrior5Canvas.this.TimeBonus--;
                }
                GoldenWarrior5Canvas.this.UnifiedMethod(-1, null);
                try {
                    Thread.sleep(n);
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }
}

